/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.predimensionhelper;

import kd.fi.bcm.business.dimension.model.AbstractDimensionMemTree;
import kd.fi.bcm.business.dimension.model.AccountMemTree;
import kd.fi.bcm.business.dimension.model.AuditTrailMemTree;
import kd.fi.bcm.business.dimension.model.ChangeTypeMemTree;
import kd.fi.bcm.business.dimension.model.CurrencyMemTree;
import kd.fi.bcm.business.dimension.model.DataSortMemTree;
import kd.fi.bcm.business.dimension.model.DataTypeMemTree;
import kd.fi.bcm.business.dimension.model.EntityMemTree;
import kd.fi.bcm.business.dimension.model.InternalCompanyMemTree;
import kd.fi.bcm.business.dimension.model.MetricMemTree;
import kd.fi.bcm.business.dimension.model.MultiGAAPMemTree;
import kd.fi.bcm.business.dimension.model.MyCompanyMemTree;
import kd.fi.bcm.business.dimension.model.PeriodMemTree;
import kd.fi.bcm.business.dimension.model.ProcessMemTree;
import kd.fi.bcm.business.dimension.model.ProjectMemTree;
import kd.fi.bcm.business.dimension.model.ScenarioMemTree;
import kd.fi.bcm.business.dimension.model.UserDefinedMemTree;
import kd.fi.bcm.business.dimension.model.VersionMemTree;
import kd.fi.bcm.business.dimension.model.YearMemTree;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class DimensionXmlFactory {
    public static String getXmlName(String dimensionnum, ApplicationTypeEnum app) {
        String prefix = null;
        String endfix = "_insert.xml";
        if (ApplicationTypeEnum.EB == app) {
            prefix = "/xml/eb/";
        } else if (ApplicationTypeEnum.CM == app) {
            prefix = "/xml/cm/";
        } else if (ApplicationTypeEnum.RPT == app) {
            prefix = "/xml/rpt/";
        } else if (ApplicationTypeEnum.BGBD == app) {
            prefix = "/xml/bgbd/";
        } else if (ApplicationTypeEnum.BGMD == app) {
            prefix = "/xml/bgmd/";
        }
        return prefix + dimensionnum + endfix;
    }

    public static String getXlsxName(String dimensionnum, ApplicationTypeEnum app) {
        String prefix = null;
        String endfix = "_insert.xml";
        if (ApplicationTypeEnum.EB == app) {
            prefix = "/xml/eb/";
        } else if (ApplicationTypeEnum.CM == app) {
            prefix = "/xml/cm/";
        } else if (ApplicationTypeEnum.RPT == app) {
            prefix = "/xml/rpt/";
        } else if (ApplicationTypeEnum.BGBD == app) {
            prefix = "/xml/bgbd/";
        } else if (ApplicationTypeEnum.BGMD == app) {
            prefix = "/xml/bgmd/";
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimensionnum)) {
            endfix = "_insert.xlsx";
        } else if ("Account_express".equals(dimensionnum)) {
            endfix = ".xlsx";
        }
        return prefix + dimensionnum + endfix;
    }

    public static AbstractDimensionMemTree getXmlTreemodel(String dimensionName) {
        if (SysDimensionEnum.Account.getNumber().equals(dimensionName)) {
            return new AccountMemTree();
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimensionName)) {
            return new EntityMemTree();
        }
        if (SysDimensionEnum.Year.getNumber().equals(dimensionName)) {
            return new YearMemTree();
        }
        if (SysDimensionEnum.Period.getNumber().equals(dimensionName)) {
            return new PeriodMemTree();
        }
        if (SysDimensionEnum.Scenario.getNumber().equals(dimensionName)) {
            return new ScenarioMemTree();
        }
        if (SysDimensionEnum.Process.getNumber().equals(dimensionName)) {
            return new ProcessMemTree();
        }
        if (SysDimensionEnum.Currency.getNumber().equals(dimensionName)) {
            return new CurrencyMemTree();
        }
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimensionName)) {
            return new AuditTrailMemTree();
        }
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimensionName)) {
            return new ChangeTypeMemTree();
        }
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimensionName)) {
            return new InternalCompanyMemTree();
        }
        if (SysDimensionEnum.MultiGAAP.getNumber().equals(dimensionName)) {
            return new MultiGAAPMemTree();
        }
        if (SysDimensionEnum.Version.getNumber().equals(dimensionName)) {
            return new VersionMemTree();
        }
        if (SysDimensionEnum.Project.getNumber().equals(dimensionName)) {
            return new ProjectMemTree();
        }
        if (SysDimensionEnum.BusinessPartner.getNumber().equals(dimensionName)) {
            return new UserDefinedMemTree();
        }
        if (SysDimensionEnum.MultiBook.getNumber().equals(dimensionName)) {
            return new UserDefinedMemTree();
        }
        if (SysDimensionEnum.DataType.getNumber().equals(dimensionName)) {
            return new DataTypeMemTree();
        }
        if (SysDimensionEnum.DataSort.getNumber().equals(dimensionName)) {
            return new DataSortMemTree();
        }
        if (SysDimensionEnum.MyCompany.getNumber().equals(dimensionName)) {
            return new MyCompanyMemTree();
        }
        if (SysDimensionEnum.Metric.getNumber().equals(dimensionName)) {
            return new MetricMemTree();
        }
        return null;
    }
}

