/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.predimensionhelper;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleAllocateServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleCatalogServiceHelper;
import kd.fi.bcm.business.check.helper.CheckTmplCatalogServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.interfaces.IDimensionComponent;
import kd.fi.bcm.business.dimension.interfaces.IInitSpecialEntityTree;
import kd.fi.bcm.business.dimension.interfaces.IInitSpecialTree;
import kd.fi.bcm.business.dimension.interfaces.ISaveTreeAndOlap;
import kd.fi.bcm.business.dimension.model.AbstractDimensionMemTree;
import kd.fi.bcm.business.dimension.model.DataTypeMemTree;
import kd.fi.bcm.business.dimension.model.Dimension;
import kd.fi.bcm.business.dimension.predimensionhelper.DimensionXmlFactory;
import kd.fi.bcm.business.dimension.sharemember.AddNewShareMemberUtil;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateCatalogServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PreDimensionUtil {
    private DynamicObject model;
    private String dimensionnumber;
    private String xlsxpath;
    private String xmlpath;
    private Object dimension;
    private ApplicationTypeEnum app;
    private Map<String, Map<String, String>> map;
    private boolean needCreateOlap = true;
    private List<String> dimensionNums = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.InternalCompany.getNumber()});
    private String protypeModel;

    public PreDimensionUtil(DynamicObject model, ApplicationTypeEnum app) {
        if (!ConfigServiceHelper.getGlobalBoolParam("P005")) {
            this.dimensionNums.add(SysDimensionEnum.AuditTrail.getNumber());
            this.dimensionNums.add(SysDimensionEnum.ChangeType.getNumber());
        }
        this.protypeModel = null;
        this.model = model;
        this.app = app;
        this.needCreateOlap = true;
    }

    public PreDimensionUtil(DynamicObject model, ApplicationTypeEnum app, boolean needCreateOlap) {
        if (!ConfigServiceHelper.getGlobalBoolParam("P005")) {
            this.dimensionNums.add(SysDimensionEnum.AuditTrail.getNumber());
            this.dimensionNums.add(SysDimensionEnum.ChangeType.getNumber());
        }
        this.protypeModel = null;
        this.model = model;
        this.app = app;
        this.needCreateOlap = needCreateOlap;
    }

    public PreDimensionUtil(DynamicObject model, String dimensionnumber, String xmlpath, ApplicationTypeEnum app) {
        if (!ConfigServiceHelper.getGlobalBoolParam("P005")) {
            this.dimensionNums.add(SysDimensionEnum.AuditTrail.getNumber());
            this.dimensionNums.add(SysDimensionEnum.ChangeType.getNumber());
        }
        this.protypeModel = null;
        this.model = model;
        this.dimensionnumber = dimensionnumber;
        this.xmlpath = xmlpath;
        this.app = app;
    }

    public List<IDimensionComponent> resolveDimemTrees() {
        if (this.model.getDataEntityType().getProperties().containsKey((Object)"isspptmycompany") && this.model.getBoolean("isspptmycompany")) {
            this.dimensionNums.add(SysDimensionEnum.MyCompany.getNumber());
        }
        ArrayList<IDimensionComponent> roots = new ArrayList<IDimensionComponent>();
        if (this.model.getBoolean("isspptmultrule")) {
            this.dimensionNums.add(SysDimensionEnum.MultiGAAP.getNumber());
        }
        if (this.model.getBoolean("isspptdatasort")) {
            this.dimensionNums.add(SysDimensionEnum.DataSort.getNumber());
        }
        if (ApplicationTypeEnum.RPT == this.app) {
            String defineddim = this.model.getString("defineddim");
            if (defineddim.contains("1")) {
                this.dimensionNums.add(SysDimensionEnum.Project.getNumber());
            }
            if (defineddim.contains("2")) {
                this.dimensionNums.add(SysDimensionEnum.BusinessPartner.getNumber());
            }
            if (defineddim.contains("3")) {
                this.dimensionNums.add(SysDimensionEnum.MultiBook.getNumber());
            }
        }
        try {
            this.map = PreDimensionUtil.resolveMapping();
            for (String e : this.dimensionNums) {
                String xlsxaddress;
                String address = DimensionXmlFactory.getXmlName(e, this.app);
                this.xlsxpath = xlsxaddress = DimensionXmlFactory.getXlsxName(e, this.app);
                this.xmlpath = address;
                this.resolveDimension();
                if ("Account".equals(e)) {
                    AbstractDimensionMemTree root = this.resolveDimemXlsxTree();
                    roots.add(root);
                    continue;
                }
                AbstractDimensionMemTree treemodel = DimensionXmlFactory.getXmlTreemodel(e);
                this.protypeModel = ObjectSerialUtil.toByteSerialized((Object)treemodel);
                IDimensionComponent root = this.createTrees();
                roots.add(root);
            }
        }
        catch (Exception e) {
            String s = String.format(ResManager.loadKDString((String)"\u8bfb\u53d6xml\u6216\u8005\u6784\u9020\u6811\u5f62\u5bf9\u8c61\u9519\u8bef: %s", (String)"PreDimensionUtil_2", (String)"fi-bcm-business", (Object[])new Object[0]), ThrowableHelper.printError((Throwable)e));
            throw new KDBizException(s);
        }
        return roots;
    }

    public void afterModelSaveBGMD(List<IDimensionComponent> dimemtrees) {
        for (IDimensionComponent dc : dimemtrees) {
            if (dc instanceof IInitSpecialTree) {
                ((IInitSpecialTree)((Object)dc)).initSpecialTrees();
            }
            if (!(dc instanceof ISaveTreeAndOlap)) continue;
            ((ISaveTreeAndOlap)((Object)dc)).actionSaveTreeMemAndOlap(this.needCreateOlap);
        }
        TemplateCatalogServiceHelper.setDefaultRootNode(this.model, -1L);
        BizRuleCatalogServiceHelper.setDefaultNode(this.model, this.app);
    }

    public void afterModelSave(List<IDimensionComponent> dimemtrees) {
        if (this.needCreateOlap && dimemtrees.size() != 1 && !(dimemtrees.get(0) instanceof DataTypeMemTree)) {
            OlapServiceHelper.createCubeSchemes(this.model);
        }
        for (IDimensionComponent dc : dimemtrees) {
            if (ApplicationTypeEnum.RPT == this.app && dc instanceof IInitSpecialEntityTree) {
                ((IInitSpecialEntityTree)((Object)dc)).initSpecialEntityTrees();
            }
            if (dc instanceof IInitSpecialTree) {
                ((IInitSpecialTree)((Object)dc)).initSpecialTrees();
            }
            if (dc instanceof ISaveTreeAndOlap) {
                ((ISaveTreeAndOlap)((Object)dc)).actionSaveTreeMemAndOlap(this.needCreateOlap);
            }
            if (!"bcm_processmembertree".equalsIgnoreCase(dc.getDynaEntityname())) continue;
            QFilter modelFilter = new QFilter("model", "=", (Object)this.model.getLong("id"));
            QFilter rptFilter = new QFilter("number", "=", (Object)"Rpt");
            QFilter tarptFilter = new QFilter("number", "=", (Object)"TARPT");
            DynamicObject RptMemberID = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, rptFilter});
            DynamicObject RptMember = BusinessDataServiceHelper.loadSingleFromCache((Object)RptMemberID.get("id"), (String)"bcm_processmembertree");
            DynamicObject TarptMember = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id,level,longnumber", (QFilter[])new QFilter[]{modelFilter, tarptFilter});
            AddNewShareMemberUtil.addNewProcessShareMember(RptMember, TarptMember);
            QFilter dimFilter = new QFilter("number", "=", (Object)SysDimensionEnum.Process.getNumber());
            DynamicObject dimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{modelFilter, dimFilter});
            long dimensionId = dimension.getLong("id");
            ShareNodeStructSyncHelper.resyncShareNodeStructure("bcm_processmembertree", this.model.getLong("id"), dimensionId);
        }
        PreDimensionUtil.checkAndSetScenario(this.model);
        PreDimensionUtil.presetSPConfig(this.model);
        TemplateCatalogServiceHelper.setDefaultRootNode(this.model, -1L);
        BizRuleCatalogServiceHelper.setDefaultNode(this.model, this.app);
        CslSchemeServiceHelper.setDefaultNode(this.model, this.app);
        if (ApplicationTypeEnum.CM == this.app) {
            this.presetSCConfig(this.model);
        }
        if (ApplicationTypeEnum.RPT == this.app) {
            this.presetAccountExpress(this.model.getLong("id"));
        }
        if (!ConfigServiceHelper.getGlobalBoolParam("P005")) {
            TemplateServiceHelper.setDefaultTemplate(this.model, this.app);
        }
        BizRuleAllocateServiceHelper.preDefaultRecord(this.model, this.app);
        CheckTmplCatalogServiceHelper.setDefaultRootNode(this.model.getLong("id"), -1L);
        this.setRateAccountsMergefalse(this.model.getLong("id"));
        this.checkDefaultPermissionClass(this.model.getLong("id"));
    }

    private void presetSCConfig(DynamicObject model) {
        QFilter qf = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter qfSc = new QFilter("level", "=", (Object)2);
        DynamicObject[] scenecslschemes = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"scenecslscheme", (QFilter[])new QFilter[]{qf, qfSc});
        if (scenecslschemes.length <= 0) {
            return;
        }
        QFilter qfCsl1 = new QFilter("number", "!=", (Object)"DefaultRateScheme");
        QFilter qfCsl2 = new QFilter("nodetype", "=", (Object)"1");
        DynamicObjectCollection csls = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{qf, qfCsl1, qfCsl2});
        if (CollectionUtils.isEmpty((Collection)csls)) {
            return;
        }
        DynamicObjectCollection scDys = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = scenecslschemes[0].getDynamicObjectCollection("scenecslscheme").getDynamicObjectType();
        for (DynamicObject scenecslscheme : scenecslschemes) {
            csls.forEach(ele -> {
                DynamicObject dy = new DynamicObject(dynamicObjectType);
                dy.set("pkid", (Object)GlobalIdUtil.genGlobalLongId());
                dy.set("fbasedataid", (Object)ele.getLong("id"));
                scDys.add((Object)dy);
            });
            scenecslscheme.getDynamicObjectCollection("scenecslscheme").addAll((Collection)scDys);
            scDys.clear();
        }
        SaveServiceHelper.save((DynamicObject[])scenecslschemes);
    }

    private void checkDefaultPermissionClass(long modelId) {
        QFBuilder range = new QFBuilder("model", "=", (Object)modelId);
        range.add("number", "=", (Object)"Default");
        if (!QueryServiceHelper.exists((String)"bcm_permissionclass", (QFilter[])range.toArray())) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permissionclass");
            dyn.set("model", (Object)modelId);
            dyn.set("number", (Object)"Default");
            dyn.set("remark", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u6743\u9650\u7c7b", (String)"PermissionClassFormPlugin_3", (String)"fi-bcm-formplugin"));
            dyn.set("modifier", (Object)RequestContext.get().getUserId());
            dyn.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
    }

    private void setRateAccountsMergefalse(long modelid) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelid);
        qfilter.and("accounttype", "=", (Object)AccountTypeEnum.EXCHANGERATE.index);
        DynamicObject[] rateAccounts = BusinessDataServiceHelper.load((String)"bcm_accountmembertree", (String)"isparticipmerge", (QFilter[])new QFilter[]{qfilter});
        for (int i = 0; i < rateAccounts.length; ++i) {
            rateAccounts[i].set("isparticipmerge", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])rateAccounts);
    }

    public static void presetSPConfig(DynamicObject model) {
        boolean isDay = model.getBoolean("isdetailtoday");
        boolean isMonth = model.getBoolean("isdetailtomonth");
        boolean isToqrt = model.getBoolean("isdetailtoqrt");
        boolean isHalfYear = model.getBoolean("isdetailtohalfyear");
        if (isMonth || isToqrt || isHalfYear || isDay) {
            DynamicObject[] scenarios;
            long modelId = model.getLong("id");
            QFBuilder qfBuilder = new QFBuilder();
            if (isMonth) {
                qfBuilder.add(new QFilter("number", "like", (Object)"M_M%"));
            }
            if (isToqrt) {
                if (qfBuilder.size() == 0) {
                    qfBuilder.add(new QFilter("number", "like", (Object)"Q_Q%"));
                } else {
                    qfBuilder = qfBuilder.or(new QFilter("number", "like", (Object)"Q_Q%"));
                }
            }
            if (isHalfYear) {
                if (qfBuilder.size() == 0) {
                    qfBuilder.add(new QFilter("number", "like", (Object)"HF_HF%"));
                } else {
                    qfBuilder.or(new QFilter("number", "like", (Object)"HF_HF%"));
                }
            }
            if (isDay) {
                if (qfBuilder.size() == 0) {
                    qfBuilder.add(new QFilter("number", "like", (Object)"YD_D%"));
                } else {
                    qfBuilder = qfBuilder.or(new QFilter("number", "like", (Object)"YD_D%"));
                }
            }
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])qfBuilder.add(modelFilter).toArray(), (String)"number");
            HashMap<String, List<Long>> scenarioMapCache = PreDimensionUtil.getScenarioMapCache(periods);
            qfBuilder.clear();
            ArrayList<String> numbers = new ArrayList<String>(3);
            if (isMonth) {
                numbers.add(ScenarioMemberEnum.MRPT.number);
            }
            if (isToqrt) {
                numbers.add(ScenarioMemberEnum.QRPT.number);
            }
            if (isHalfYear) {
                numbers.add(ScenarioMemberEnum.SRPT.number);
            }
            if (isDay) {
                numbers.add(ScenarioMemberEnum.YDRPT.number);
            }
            qfBuilder.add(new QFilter("model", "=", (Object)modelId)).add(new QFilter("number", "in", numbers));
            for (DynamicObject scenario : scenarios = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"id,number,sceneperiod", (QFilter[])qfBuilder.toArray())) {
                String number = scenario.getString("number");
                List<Long> ids = scenarioMapCache.get(number);
                DynamicObjectCollection collection = PreDimensionUtil.createScenePeriodCollection(ids, scenario.getDynamicObjectCollection("sceneperiod").getDynamicObjectType());
                scenario.set("sceneperiod", (Object)collection);
            }
            SaveServiceHelper.save((DynamicObject[])scenarios);
        }
    }

    private static DynamicObjectCollection createScenePeriodCollection(List<Long> periodIds, DynamicObjectType type) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        periodIds.forEach(p -> {
            DynamicObject dy = new DynamicObject(type);
            dy.set("fbasedataid", p);
            collection.add((Object)dy);
        });
        return collection;
    }

    private static HashMap<String, List<Long>> getScenarioMapCache(DynamicObjectCollection periods) {
        HashMap<String, List<Long>> scenarioMapCache = new HashMap<String, List<Long>>();
        ArrayList mRptColl = new ArrayList();
        ArrayList qRptColl = new ArrayList();
        ArrayList hfRptColl = new ArrayList();
        ArrayList ydRptColl = new ArrayList();
        periods.forEach(p -> {
            Long id = p.getLong("id");
            String number = p.getString("number");
            if (number.startsWith("M_M")) {
                mRptColl.add(id);
            } else if (number.startsWith("Q_Q")) {
                qRptColl.add(id);
            } else if (number.startsWith("HF_HF")) {
                hfRptColl.add(id);
            } else if (number.startsWith("YD_D")) {
                ydRptColl.add(id);
            }
        });
        if (mRptColl.size() > 0) {
            scenarioMapCache.put(ScenarioMemberEnum.MRPT.number, mRptColl);
        }
        if (qRptColl.size() > 0) {
            scenarioMapCache.put(ScenarioMemberEnum.QRPT.number, qRptColl);
        }
        if (hfRptColl.size() > 0) {
            scenarioMapCache.put(ScenarioMemberEnum.SRPT.number, hfRptColl);
        }
        if (ydRptColl.size() > 0) {
            scenarioMapCache.put(ScenarioMemberEnum.YDRPT.number, ydRptColl);
        }
        return scenarioMapCache;
    }

    public IDimensionComponent resolveDimemTree() throws Exception {
        this.resolveDimension();
        AbstractDimensionMemTree treemodel = DimensionXmlFactory.getXmlTreemodel(this.dimensionnumber);
        this.protypeModel = ObjectSerialUtil.toByteSerialized((Object)treemodel);
        IDimensionComponent root = this.createTrees();
        return root;
    }

    private IDimensionComponent createTrees() throws Exception {
        SAXReader reader = new SAXReader();
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(this.xmlpath);){
            Document document = reader.read(resourceAsStream);
            Element node = document.getRootElement();
            Iterator iter = node.elementIterator();
            Element RootElement = null;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                if ("dimension".equals(element.getName())) continue;
                RootElement = element;
                break;
            }
            AbstractDimensionMemTree roottreemodel = this.getTreeModel();
            if (RootElement != null) {
                this.initNode(RootElement, roottreemodel, new HashMap<String, AbstractDimensionMemTree>());
            }
            AbstractDimensionMemTree abstractDimensionMemTree = roottreemodel;
            return abstractDimensionMemTree;
        }
    }

    private void initNode(Element rootElement, AbstractDimensionMemTree MemTree, Map<String, AbstractDimensionMemTree> alltrees) throws Exception {
        if (rootElement.getParent().isRootElement()) {
            this.setDimensionTreeValue(rootElement, MemTree, null);
            alltrees.put(MemTree.getName() + MemTree.getNumber(), MemTree);
        }
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            AbstractDimensionMemTree benshen = this.getTreeModel();
            Element parentelement = element.getParent();
            String parent_key = parentelement.attribute("name").getValue() + parentelement.attribute("number").getValue();
            AbstractDimensionMemTree parent = alltrees.get(parent_key);
            this.setDimensionTreeValue(element, benshen, parent);
            alltrees.put(benshen.getName() + benshen.getNumber(), benshen);
            this.initNode(element, null, alltrees);
        }
    }

    private void setDimensionTreeValue(Element element, AbstractDimensionMemTree ziji, AbstractDimensionMemTree parent) throws Exception {
        List list = element.attributes();
        HashMap<String, Field> fileds = new HashMap<String, Field>();
        for (Class<?> clazz = ziji.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] classfields;
            for (Field field : classfields = clazz.getDeclaredFields()) {
                fileds.put(field.getName(), field);
            }
        }
        for (Attribute attribute : list) {
            Map<String, String> chidMap = this.map.get(attribute.getName());
            if (chidMap != null) {
                Field field;
                String value = chidMap.get(attribute.getText());
                field = (Field)fileds.get(attribute.getName());
                ReflectionUtils.makeAccessible((Field)field);
                field.set(ziji, value);
                continue;
            }
            Field field = (Field)fileds.get(attribute.getName());
            ReflectionUtils.makeAccessible((Field)field);
            field.set(ziji, attribute.getText());
        }
        if (parent != null) {
            ziji.setLevel(parent.getLevel() + 1);
            ziji.setDseq(parent.getChildren().size() + 1);
            ziji.setLongnumber(parent.getLongnumber() + '!' + ziji.getNumber());
            ziji.setParent(parent.getId());
            parent.setIsleaf(false);
            parent.getChildren().add(ziji);
        } else {
            ziji.setLongnumber(ziji.getNumber());
        }
    }

    private void resolveDimension() throws Exception {
        SAXReader reader = new SAXReader();
        Dimension dimension = null;
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(this.xmlpath);){
            Document document = reader.read(resourceAsStream);
            Element node = document.getRootElement();
            Iterator iter = node.elementIterator();
            Element RootElement = null;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                if (!"dimension".equals(element.getName())) continue;
                RootElement = element;
                dimension = new Dimension(this.model);
                List list = RootElement.attributes();
                for (Attribute attribute : list) {
                    Map<String, String> chidMap = this.map.get(attribute.getName());
                    if (chidMap != null) {
                        String value = chidMap.get(attribute.getText()).trim();
                        Field field = dimension.getClass().getDeclaredField(attribute.getName());
                        ReflectionUtils.makeAccessible((Field)field);
                        field.set(dimension, value);
                        continue;
                    }
                    Field field = dimension.getClass().getDeclaredField(attribute.getName());
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(dimension, attribute.getText().trim());
                }
                break;
            }
        }
        if (dimension != null) {
            this.dimensionnumber = dimension.getNumber();
            this.dimension = dimension.initToDyna();
        }
    }

    private AbstractDimensionMemTree getTreeModel() throws Exception {
        AbstractDimensionMemTree treemodel = (AbstractDimensionMemTree)ObjectSerialUtil.deSerializedBytes((String)this.protypeModel);
        treemodel.setDimension(this.dimension);
        treemodel.setModel(this.model);
        return treemodel;
    }

    public static Map<String, Map<String, String>> resolveMapping() throws Exception {
        SAXReader reader = new SAXReader();
        HashMap<String, Map<String, String>> rootmap = new HashMap<String, Map<String, String>>();
        try (InputStream resourceAsStream = PreDimensionUtil.class.getResourceAsStream("/xml/mapping/dimension_mapping.xml");){
            Document document = reader.read(resourceAsStream);
            Element node = document.getRootElement();
            Iterator iter = node.elementIterator();
            Element RootElement = null;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                if ("propertites".equals(element.getName())) continue;
                RootElement = element;
                String rootMappingName = RootElement.attributeValue("type");
                Map<String, String> map = PreDimensionUtil.creatMap(RootElement, rootmap);
                rootmap.put(rootMappingName, map);
            }
        }
        return rootmap;
    }

    private static Map<String, String> creatMap(Element rootElement, Map<String, Map<String, String>> rootmap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rootElement.getParent().isRootElement()) {
            rootmap.put(rootElement.attributeValue("type"), map);
        }
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            Element parentelement = element.getParent();
            String parent_key = parentelement.attribute("type").getValue();
            Map<String, String> childmap = rootmap.get(parent_key);
            PreDimensionUtil.setMapValue(element, rootmap, childmap);
            rootmap.put(parent_key, childmap);
            PreDimensionUtil.creatMap(element, rootmap);
        }
        return map;
    }

    private static void setMapValue(Element element, Map<String, Map<String, String>> rootmap, Map<String, String> childmap) {
        childmap.put(element.attributeValue("name"), element.attributeValue("index"));
        if (rootmap != null) {
            rootmap.put(element.getParent().attributeValue("type"), childmap);
        }
    }

    private void getAllNoShareNodeObject(AbstractDimensionMemTree roottreemodel, Map<String, AbstractDimensionMemTree> allMemTree) {
        List<AbstractDimensionMemTree> memTree = roottreemodel.getChildren();
        for (AbstractDimensionMemTree DimensionMemTree : memTree) {
            if (!ResManager.loadKDString((String)"\u5171\u4eab", (String)"PreDimensionUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]).equals(DimensionMemTree.getAggoprt())) {
                allMemTree.put(DimensionMemTree.getNumber(), DimensionMemTree);
            }
            this.getAllNoShareNodeObject(DimensionMemTree, allMemTree);
        }
    }

    private void dealShare(Map<String, AbstractDimensionMemTree> allMemTree, AbstractDimensionMemTree roottreemodel) {
        List<AbstractDimensionMemTree> memTree = roottreemodel.getChildren();
        for (AbstractDimensionMemTree DimensionMemTree : memTree) {
            if (ResManager.loadKDString((String)"\u5171\u4eab", (String)"PreDimensionUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]).equals(DimensionMemTree.getAggoprt())) {
                AbstractDimensionMemTree shareMemTree = allMemTree.get(DimensionMemTree.getNumber());
                DimensionMemTree.setCopyfrom(shareMemTree.getId());
            }
            this.dealShare(allMemTree, DimensionMemTree);
        }
    }

    public AbstractDimensionMemTree resolveDimemXlsxTree() throws Exception {
        AbstractDimensionMemTree treemodel = DimensionXmlFactory.getXmlTreemodel(this.dimensionnumber);
        this.protypeModel = ObjectSerialUtil.toByteSerialized((Object)treemodel);
        try (InputStream in = this.getClass().getResourceAsStream(this.xlsxpath);){
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(in);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
            XSSFRow attribute = xssfSheet.getRow(0);
            int lastLine = xssfSheet.getLastRowNum();
            HashMap<String, AbstractDimensionMemTree> tree = new HashMap<String, AbstractDimensionMemTree>(lastLine);
            ArrayList<String> attributeList = new ArrayList<String>(attribute.getLastCellNum());
            for (int col = 0; col < attribute.getLastCellNum(); ++col) {
                String ce = attribute.getCell(col).toString();
                if (!ce.equals("Parent")) {
                    ce = ce.substring(ce.indexOf(40) + 1, ce.indexOf(41));
                }
                attributeList.add(ce);
            }
            HashMap<String, Field> fileds = new HashMap<String, Field>();
            for (int i = 1; i <= lastLine; ++i) {
                AbstractDimensionMemTree MemTree = this.getTreeModel();
                for (Class<?> clazz = MemTree.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                    Field[] classfields;
                    for (Field field : classfields = clazz.getDeclaredFields()) {
                        fileds.put(field.getName(), field);
                    }
                }
                XSSFRow rowData = xssfSheet.getRow(i);
                String number = null;
                for (int j = 0; j < attributeList.size(); ++j) {
                    String cellValue;
                    String colname = (String)attributeList.get(j);
                    String string = cellValue = rowData.getCell(j) == null ? null : rowData.getCell(j).toString().trim();
                    if (cellValue == null) continue;
                    if (!"Parent".equals(colname)) {
                        Map<String, String> chidMap;
                        if ("number".equals(colname)) {
                            number = cellValue;
                        }
                        if ((chidMap = this.map.get(colname)) != null) {
                            String value = chidMap.get(cellValue);
                            Field field = (Field)fileds.get(colname);
                            ReflectionUtils.makeAccessible((Field)field);
                            field.set(MemTree, value);
                            continue;
                        }
                        Field fie = (Field)fileds.get(colname);
                        ReflectionUtils.makeAccessible((Field)fie);
                        fie.set(MemTree, cellValue);
                        continue;
                    }
                    AbstractDimensionMemTree parent = (AbstractDimensionMemTree)tree.get(cellValue);
                    if (parent != null) {
                        MemTree.setLevel(parent.getLevel() + 1);
                        MemTree.setDseq(parent.getChildren().size() + 1);
                        MemTree.setLongnumber(parent.getLongnumber() + '!' + MemTree.getNumber());
                        MemTree.setParent(parent.getId());
                        parent.setIsleaf(false);
                        parent.getChildren().add(MemTree);
                        continue;
                    }
                    MemTree.setLongnumber(MemTree.getNumber());
                }
                tree.put(number, MemTree);
                fileds.clear();
            }
            AbstractDimensionMemTree abstractDimensionMemTree = (AbstractDimensionMemTree)tree.get("Account");
            return abstractDimensionMemTree;
        }
    }

    private void presetAccountExpress(long modelId) {
        HashMap<String, DynamicObject> data = new HashMap<String, DynamicObject>();
        ArrayList<String> attributeList = new ArrayList<String>();
        String xlsxaddress = DimensionXmlFactory.getXlsxName("Account_express", this.app);
        try (InputStream in = this.getClass().getResourceAsStream(xlsxaddress);
             XSSFWorkbook book = new XSSFWorkbook(in);){
            XSSFSheet xssfSheet = book.getSheetAt(0);
            XSSFRow attribute = xssfSheet.getRow(0);
            int lastLine = xssfSheet.getLastRowNum();
            for (int col = 0; col < attribute.getLastCellNum(); ++col) {
                String ce = attribute.getCell(col).toString();
                ce = ce.substring(ce.indexOf(40) + 1, ce.indexOf(41));
                attributeList.add(ce);
            }
            for (int i = 1; i <= lastLine; ++i) {
                XSSFRow rowData = xssfSheet.getRow(i);
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_accountmembertree");
                for (int j = 0; j < attributeList.size(); ++j) {
                    dy.set((String)attributeList.get(j), rowData.getCell(j) == null ? null : rowData.getCell(j).toString());
                }
                data.put(dy.getString("number"), dy);
            }
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        QFilter modelf = new QFilter("model", "=", (Object)modelId);
        QFilter numberf = new QFilter("number", "in", (Object)data.keySet().toArray(new String[0]));
        Object[] olds = BusinessDataServiceHelper.load((String)"bcm_accountmembertree", (String)"simplename,dataresource,accttableid,acctformula", (QFilter[])new QFilter[]{modelf, numberf});
        attributeList.removeIf(item -> item.equals("number") || item.equals("name"));
        Arrays.asList(olds).forEach(item -> {
            DynamicObject dy = (DynamicObject)data.get(item.getString("number"));
            attributeList.forEach(col -> item.set(col, dy.get(col)));
        });
        if (olds.length > 0) {
            SaveServiceHelper.save((IDataEntityType)olds[0].getDynamicObjectType(), (Object[])olds);
        }
    }

    public static void checkAndSetScenario(DynamicObject model) {
        QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter qFilter2 = new QFilter("number", "=", (Object)"MRpt");
        DynamicObject tempMemberDy = QueryServiceHelper.queryOne((String)"bcm_scenemember", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter2});
        if (Objects.isNull(tempMemberDy)) {
            return;
        }
        long memberid = tempMemberDy.getLong("id");
        long id = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter2}).getLong("id");
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberid, (String)"bcm_scenemember");
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_scenemembertree");
        int seq = 1;
        if (model.getBoolean("isdetailtoqrt")) {
            LocaleString qRpt = ResManager.getLocaleString((String)"\u5b63\u62a5", (String)"Scenario_QRpt", (String)"fi-bcm-business");
            PreDimensionUtil.createScenarioMember(member, dot, ++seq, "QRpt", qRpt, model);
        }
        if (model.getBoolean("isdetailtohalfyear")) {
            LocaleString sRpt = ResManager.getLocaleString((String)"\u534a\u5e74\u62a5", (String)"Scenario_SRpt", (String)"fi-bcm-business");
            PreDimensionUtil.createScenarioMember(member, dot, ++seq, "SRpt", sRpt, model);
        }
        if (model.getBoolean("isdetailtoday")) {
            LocaleString ydRpt = ResManager.getLocaleString((String)"\u65e5\u62a5", (String)"Scenario_YDRpt", (String)"fi-bcm-business");
            PreDimensionUtil.createScenarioMember(member, dot, ++seq, "YDRpt", ydRpt, model);
        }
    }

    private static void createScenarioMember(DynamicObject member, DynamicObject memberTree, int seq, String number, LocaleString name, DynamicObject model) {
        QFilter mFilter = new QFilter("model", "=", (Object)memberTree.getLong("model.id"));
        QFilter pFilter = new QFilter("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])new QFilter[]{mFilter, pFilter})) {
            return;
        }
        long temp = DBServiceHelper.genGlobalLongId();
        DynamicObject HFrptMember = (DynamicObject)OrmUtils.clone((Object)member, (IDataEntityType)member.getDataEntityType(), (boolean)true, (boolean)true);
        HFrptMember.set("id", (Object)temp);
        HFrptMember.set("number", (Object)number);
        HFrptMember.set("name", (Object)name);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{HFrptMember});
        DynamicObject HFrpt = (DynamicObject)OrmUtils.clone((Object)memberTree, (IDataEntityType)memberTree.getDataEntityType(), (boolean)true, (boolean)true);
        HFrpt.set("id", (Object)DBServiceHelper.genGlobalLongId());
        HFrpt.set("number", (Object)number);
        HFrpt.set("name", (Object)name);
        HFrpt.set("longnumber", (Object)memberTree.getString("longnumber").replace("MRpt", number));
        HFrpt.set("dseq", (Object)(++seq));
        HFrpt.set("member", (Object)HFrptMember);
        HFrpt.set("issysmember", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{HFrpt});
        OlapServiceHelper.createMember(model.getString("number"), "Scenario", number, HFrpt.getInt("aggoprt"), HFrpt.getString("parent.number"));
    }

    public static void createDifProcess(IFormView view, long modelId) {
        DynamicObject[] docs;
        QFilter mFilter = new QFilter("model", "=", (Object)modelId);
        QFilter storageFilter = new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.getOIndex());
        if (QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])new QFilter[]{mFilter, PreDimensionUtil.getNumberFilter("DIF")})) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u5dee\u989d\u6210\u5458\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"PreDimensionUtil_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject tempMember = QueryServiceHelper.queryOne((String)"bcm_processmember", (String)"id", (QFilter[])new QFilter[]{mFilter, PreDimensionUtil.getNumberFilter("TCF")});
        DynamicObject tempMemberTree = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id", (QFilter[])new QFilter[]{mFilter, PreDimensionUtil.getNumberFilter("TCF")});
        if (Objects.isNull(tempMember) || Objects.isNull(tempMemberTree)) {
            return;
        }
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)tempMember.getLong("id"), (String)"bcm_processmember");
        DynamicObject difMember = (DynamicObject)OrmUtils.clone((Object)member, (IDataEntityType)member.getDataEntityType(), (boolean)true, (boolean)true);
        difMember.set("id", (Object)DBServiceHelper.genGlobalLongId());
        difMember.set("number", (Object)"DIF");
        difMember.set("name", (Object)new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u5dee\u989d", (String)"PreDimensionUtil_6", (String)"fi-bcm-business", (Object[])new Object[0])));
        difMember.set("createtime", (Object)TimeServiceHelper.now());
        difMember.set("creator", (Object)RequestContext.get().getCurrUserId());
        difMember.set("modifier", (Object)RequestContext.get().getCurrUserId());
        difMember.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObject memberTree = BusinessDataServiceHelper.loadSingle((Object)tempMemberTree.getLong("id"), (String)"bcm_processmembertree");
        DynamicObject difMemberTree = (DynamicObject)OrmUtils.clone((Object)memberTree, (IDataEntityType)memberTree.getDataEntityType(), (boolean)true, (boolean)true);
        difMemberTree.set("id", (Object)DBServiceHelper.genGlobalLongId());
        difMemberTree.set("number", (Object)"DIF");
        difMemberTree.set("name", (Object)new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u5dee\u989d", (String)"PreDimensionUtil_6", (String)"fi-bcm-business", (Object[])new Object[0])));
        difMemberTree.set("longnumber", (Object)"Process!DIF");
        difMemberTree.set("dseq", (Object)(difMemberTree.getInt("dseq") + 1));
        difMemberTree.set("issysmember", (Object)DimMemTypeEnum.SYSMEM.getIndex());
        difMemberTree.set("createtime", (Object)TimeServiceHelper.now());
        difMemberTree.set("creator", (Object)RequestContext.get().getCurrUserId());
        difMemberTree.set("modifier", (Object)RequestContext.get().getCurrUserId());
        difMemberTree.set("modifytime", (Object)TimeServiceHelper.now());
        difMemberTree.set("member", (Object)difMember);
        QFilter levelFilter = new QFilter("level", "=", (Object)memberTree.getInt("level"));
        QFilter seqFilter = new QFilter("dseq", ">", (Object)memberTree.getInt("dseq"));
        for (DynamicObject doc : docs = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"dseq", (QFilter[])new QFilter[]{mFilter, levelFilter, seqFilter})) {
            doc.set("dseq", (Object)(doc.getInt("dseq") + 1));
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{difMember});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{difMemberTree});
                if (docs.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])docs);
                }
                PreDimensionUtil.createShareMember(modelId, "ERpt", AggOprtEnum.ADD.getSign(), 1);
                PreDimensionUtil.createShareMember(modelId, "SRPT", AggOprtEnum.SUBSTRACT.getSign(), 2);
                ShareNodeStructSyncHelper.resyncShareNodeStructure("bcm_processmembertree", modelId, memberTree.getLong("dimension.id"));
                OlapServiceHelper.createMember(MemberReader.findModelNumberById((Object)modelId), DimTypesEnum.PROCESS.getNumber(), "DIF", difMemberTree.getInt("aggoprt"), difMemberTree.getString("parent.number"));
                DynamicComputingServiceHelper.repairModelByDim(MemberReader.findModelNumberById((Object)modelId), DimTypesEnum.PROCESS.getNumber(), false);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5408\u5e76\u5dee\u989d\u6210\u5458\u751f\u6210\u6210\u529f\u3002", (String)"PreDimensionUtil_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static void createShareMember(long modelId, String number, String agg, int seq) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)"DIF"));
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Long sourceId = MemberReader.findProcessMemberByNum((String)modelNum, (String)number).getId();
        DynamicObject shareMember = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)"bcm_processmembertree");
        shareMember.set("aggoprt", (Object)agg);
        shareMember.set("dseq", (Object)seq);
        DynamicObject difMember = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id,level,longnumber", (QFilter[])filter.toArray());
        AddNewShareMemberUtil.addNewProcessShareMember(shareMember, difMember);
    }

    private static QFilter getNumberFilter(String number) {
        return new QFilter("number", "=", (Object)number);
    }
}

