/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.struct;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bcm.business.dimension.struct.BareTreeNode;
import kd.fi.bcm.business.dimension.struct.StructHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class BareTree {
    private static final Log LOG = LogFactory.getLog(BareTree.class);
    private Map<String, DynamicObject> idIndex;
    private Map<String, List<String>> pChildMap;
    private Map<String, ITreeNode<DynamicObject>> idNodeIndex;
    private Map<String, List<ITreeNode<DynamicObject>>> aliasNodeIndex = new HashMap<String, List<ITreeNode<DynamicObject>>>(16);
    private Set<String> _usedIds = new HashSet<String>(16);
    private BareTreeNode root;
    private volatile Function<DynamicObject, String> extractIdF = x -> x.getString("id");
    private volatile Function<DynamicObject, String> extractNameF = x -> x.getString("number");
    private volatile Function<DynamicObject, String> extractParentIdF = x -> Objects.isNull(x.get("parent")) ? "" : (x.get("parent") instanceof Long ? x.getString("parent") : x.getDynamicObject("parent").getString("id"));

    public BareTree(Collection<DynamicObject> members) {
        Objects.requireNonNull(members, "parameter members is null");
        this.idIndex = new HashMap<String, DynamicObject>(members.size());
        this.pChildMap = new HashMap<String, List<String>>(16);
        ArrayList possibleTreeRoots = new ArrayList(2);
        members.stream().forEach(x -> {
            String id = this.extractIdF.apply((DynamicObject)x);
            if (this.idIndex.containsKey(id)) {
                LOG.info("there is duplicated member id " + id + " in current provided data, would be skipped.");
                return;
            }
            this.idIndex.put(id, (DynamicObject)x);
            String parentId = this.extractParentIdF.apply((DynamicObject)x);
            if (StringUtils.isEmpty((CharSequence)parentId)) {
                possibleTreeRoots.add(id);
            } else {
                if (Objects.isNull(this.pChildMap.get(parentId))) {
                    this.pChildMap.put(parentId, new ArrayList(4));
                }
                this.pChildMap.get(parentId).add(id);
            }
        });
        if (possibleTreeRoots.isEmpty()) {
            throw new IllegalStateException("can not find the root member from given members.");
        }
        List possibleTrees = possibleTreeRoots.stream().map(rootId -> {
            DynamicObject rootValue = this.idIndex.get(rootId);
            BareTreeNode rootNode = new BareTreeNode(String.valueOf(rootId), this.extractNameF.apply(rootValue), rootValue);
            this._usedIds.add((String)rootId);
            this.buildChild(rootNode);
            return rootNode;
        }).collect(Collectors.toList());
        if (possibleTreeRoots.size() == 1) {
            this.root = (BareTreeNode)possibleTrees.get(0);
        } else {
            List subTreeCoverNodeCnts = possibleTrees.stream().map(x -> {
                AtomicInteger nodeCnt = new AtomicInteger(0);
                this.preTravel((ITreeNode<DynamicObject>)x, n -> nodeCnt.incrementAndGet());
                return nodeCnt.get();
            }).collect(Collectors.toList());
            int maxNodeCnt = (Integer)Collections.max(subTreeCoverNodeCnts);
            for (int i = 0; i < possibleTrees.size(); ++i) {
                if ((Integer)subTreeCoverNodeCnts.get(i) != maxNodeCnt) continue;
                this.root = (BareTreeNode)possibleTrees.get(i);
            }
        }
        this.idNodeIndex = new HashMap<String, ITreeNode<DynamicObject>>(this.idIndex.size());
        this.preTravelByConsumer(x -> {
            this.idNodeIndex.put(x.getId(), (ITreeNode<DynamicObject>)x);
            String alias = x.getName();
            if (Objects.isNull(this.aliasNodeIndex.get(alias))) {
                this.aliasNodeIndex.put(alias, new ArrayList(2));
            }
            this.aliasNodeIndex.get(alias).add((ITreeNode<DynamicObject>)x);
        });
    }

    private void preTravelByConsumer(Consumer<ITreeNode<DynamicObject>> consumer) {
        this.preTravel(consumer);
    }

    public void preTravel(Consumer<ITreeNode<DynamicObject>> consumer) {
        this.preTravel(this.root, consumer);
    }

    public void preTravel(ITreeNode<DynamicObject> node, Consumer<ITreeNode<DynamicObject>> consumer) {
        consumer.accept(node);
        for (ITreeNode<DynamicObject> child : node.getChildren()) {
            this.preTravel2(child, consumer);
        }
    }

    public void preTravel2(ITreeNode<DynamicObject> node, Consumer<ITreeNode<DynamicObject>> consumer) {
        consumer.accept(node);
        for (ITreeNode<DynamicObject> child : node.getChildren()) {
            this.preTravel(child, consumer);
        }
    }

    public void postTravel(Consumer<ITreeNode<DynamicObject>> consumer) {
        this._postTravel(this.root, consumer);
    }

    public Optional<ITreeNode<DynamicObject>> getNodeById(String id) {
        return Optional.ofNullable(this.idNodeIndex.get(id));
    }

    public List<ITreeNode<DynamicObject>> getNodeByAlias(String alias) {
        return this.aliasNodeIndex.getOrDefault(alias, Collections.EMPTY_LIST);
    }

    private void _postTravel(ITreeNode<DynamicObject> node, Consumer<ITreeNode<DynamicObject>> consumer) {
        for (ITreeNode<DynamicObject> child : node.getChildren()) {
            this._postTravel(child, consumer);
        }
        consumer.accept(node);
    }

    private void buildChild(BareTreeNode parentNode) {
        List<String> childIds = this.pChildMap.getOrDefault(parentNode.getId(), Collections.EMPTY_LIST);
        for (String cid : childIds) {
            if (!this._usedIds.add(cid)) continue;
            DynamicObject nodeValue = this.idIndex.get(cid);
            BareTreeNode node = new BareTreeNode(cid, this.extractNameF.apply(nodeValue), nodeValue);
            parentNode.addChild(node);
            this.buildChild(node);
        }
    }

    private void buildIndexForNewNode(ITreeNode<DynamicObject> newNode) {
        Objects.requireNonNull(newNode);
        String nodeId = newNode.getId();
        String parentNodeId = newNode.getParent().getId();
        this.idIndex.put(nodeId, newNode.getData());
        if (!this.pChildMap.containsKey(parentNodeId)) {
            this.pChildMap.put(parentNodeId, new ArrayList(8));
        }
        this.pChildMap.get(parentNodeId).add(nodeId);
        String nodeName = newNode.getName();
        if (!this.aliasNodeIndex.containsKey(nodeName)) {
            this.aliasNodeIndex.put(nodeName, new ArrayList(8));
        }
        this.aliasNodeIndex.get(nodeName).add(newNode);
        this.idNodeIndex.put(nodeId, newNode);
    }

    public List<ITreeNode<DynamicObject>> listSharedNodesByAlias(String specificAlias) {
        return this.getNodeByAlias(specificAlias).stream().filter(x -> StructHelper.isShareType((DynamicObject)x.getData())).collect(Collectors.toList());
    }

    public Optional<StructSyncResult> syncShareStructure(ITreeNode<DynamicObject> sourceTreeNode) {
        String sourceAlias = sourceTreeNode.getData().getString("number");
        List<ITreeNode<DynamicObject>> mirrorSharedNodes = this.listSharedNodesByAlias(sourceAlias);
        if (mirrorSharedNodes.isEmpty()) {
            return Optional.empty();
        }
        StructSyncResult combineSyncResult = new StructSyncResult();
        mirrorSharedNodes.stream().forEach(sharedMirrorNode -> combineSyncResult.merge(this.syncShareStructure(sourceTreeNode, (ITreeNode<DynamicObject>)sharedMirrorNode)));
        return Optional.of(combineSyncResult);
    }

    private StructSyncResult syncShareStructure(ITreeNode<DynamicObject> sourceTreeNode, ITreeNode<DynamicObject> mirrorSharedNode) {
        Preconditions.checkState((Objects.nonNull(sourceTreeNode) && !StructHelper.isShareType(sourceTreeNode.getData()) ? 1 : 0) != 0, (Object)"the source node must be not null and not be shared type.");
        Preconditions.checkState((Objects.nonNull(mirrorSharedNode) && StructHelper.isShareType(mirrorSharedNode.getData()) ? 1 : 0) != 0, (Object)"the mirror node must be not null and be shared type.");
        StructSyncResult structSyncResult = new StructSyncResult();
        if (sourceTreeNode != null && mirrorSharedNode != null) {
            Preconditions.checkState((boolean)StructHelper.getNumber(sourceTreeNode.getData()).equals(StructHelper.getNumber(mirrorSharedNode.getData())), (Object)"the mirror node must be the same number with source node");
            HashMap sourceToMirrorId = new HashMap(16);
            this.preTravel(mirrorSharedNode, mnode -> {
                if (StructHelper.isShareType((DynamicObject)mnode.getData())) {
                    Long mid = ((DynamicObject)mnode.getData()).getLong("id");
                    String sourceId = StructHelper.getSourceId((DynamicObject)mnode.getData());
                    if (!sourceToMirrorId.containsKey(sourceId)) {
                        sourceToMirrorId.put(sourceId, new HashSet(2));
                    }
                    ((Set)sourceToMirrorId.get(sourceId)).add(String.valueOf(mid));
                }
            });
            HashBiMap definedSourceToMirrorId = HashBiMap.create();
            definedSourceToMirrorId.put((Object)sourceTreeNode.getId(), (Object)mirrorSharedNode.getId());
            this.preTravel(sourceTreeNode, arg_0 -> this.lambda$syncShareStructure$10(sourceTreeNode, sourceToMirrorId, (BiMap)definedSourceToMirrorId, structSyncResult, arg_0));
        }
        return structSyncResult;
    }

    public ITreeNode<DynamicObject> getRootNode() {
        return this.root;
    }

    public int computeLevelSpan(ITreeNode<DynamicObject> sourceTreeNode) {
        int currentLevel = sourceTreeNode.getData().getInt("level");
        AtomicInteger maxLevel = new AtomicInteger(currentLevel);
        this.preTravel(sourceTreeNode, x -> {
            int _level = ((DynamicObject)x.getData()).getInt("level");
            if (_level < maxLevel.get()) {
                maxLevel.set(_level);
            }
        });
        return maxLevel.get() - currentLevel;
    }

    private /* synthetic */ void lambda$syncShareStructure$10(ITreeNode sourceTreeNode, Map sourceToMirrorId, BiMap definedSourceToMirrorId, StructSyncResult structSyncResult, ITreeNode snode) {
        if (sourceTreeNode == snode) {
            return;
        }
        String sourceId = !StructHelper.isShareType((DynamicObject)snode.getData()) ? snode.getId() : StructHelper.getSourceId((DynamicObject)snode.getData());
        ITreeNode _snodeParent = snode.getParent();
        String sourceParentSourceId = !StructHelper.isShareType((DynamicObject)_snodeParent.getData()) ? _snodeParent.getId() : StructHelper.getSourceId((DynamicObject)_snodeParent.getData());
        Set possibleMirrorIds = sourceToMirrorId.getOrDefault(sourceId, Collections.EMPTY_SET);
        Function<String, String> mirrorParentMatchFunc = mirrorId -> {
            ITreeNode<DynamicObject> possibleMirrorNode = this.idNodeIndex.get(mirrorId);
            ITreeNode<DynamicObject> _mirrorParent = possibleMirrorNode.getParent();
            return !StructHelper.isShareType(_mirrorParent.getData()) ? _mirrorParent.getId() : StructHelper.getSourceId(_mirrorParent.getData());
        };
        Optional<String> mirrorNodeId = possibleMirrorIds.stream().filter(id -> sourceParentSourceId.equals(mirrorParentMatchFunc.apply((String)id))).findFirst();
        if (!mirrorNodeId.isPresent()) {
            String mirrorParentId = (String)definedSourceToMirrorId.get((Object)_snodeParent.getId());
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)mirrorParentId), (Object)"logic error");
            Long newId = DBServiceHelper.genGlobalLongId();
            DynamicObject newMember = (DynamicObject)OrmUtils.clone(snode.getData(), (IDataEntityType)((DynamicObject)snode.getData()).getDataEntityType(), (boolean)true, (boolean)true);
            ITreeNode<DynamicObject> mirrorParent = this.getNodeById(mirrorParentId).get();
            newMember.set("id", (Object)newId);
            newMember.set("storagetype", (Object)StorageTypeEnum.SHARE.index);
            newMember.set("parent", (Object)mirrorParent.getData());
            newMember.set("copyfrom", (Object)this.idNodeIndex.get(sourceId).getData());
            newMember.set("level", (Object)(mirrorParent.getData().getInt("level") + 1));
            newMember.set("modifytime", (Object)new Date());
            newMember.set("longnumber", (Object)(mirrorParent.getData().getString("longnumber") + "!" + ((DynamicObject)snode.getData()).getString("number")));
            newMember.set("isleaf", (Object)((DynamicObject)snode.getData()).getBoolean("isleaf"));
            DynamicObject parentMember = mirrorParent.getData();
            parentMember.set("isleaf", (Object)false);
            structSyncResult.addNewMember(parentMember);
            structSyncResult.addNewMember(newMember);
            BareTreeNode newNode = new BareTreeNode(newId.toString(), this.extractNameF.apply(newMember), newMember, mirrorParent);
            this.buildIndexForNewNode(newNode);
            if (!sourceToMirrorId.containsKey(sourceId)) {
                sourceToMirrorId.put(sourceId, new HashSet(2));
            }
            ((Set)sourceToMirrorId.get(sourceId)).add(String.valueOf(newId));
            definedSourceToMirrorId.put((Object)snode.getId(), (Object)String.valueOf(newId));
        } else {
            if (!sourceToMirrorId.containsKey(sourceId)) {
                sourceToMirrorId.put(sourceId, new HashSet(2));
            }
            ((Set)sourceToMirrorId.get(sourceId)).add(mirrorNodeId.get());
            definedSourceToMirrorId.forcePut((Object)snode.getId(), (Object)mirrorNodeId.get());
        }
    }

    public static class StructSyncResult {
        private final Set<DynamicObject> newMembers = new HashSet<DynamicObject>(16);
        private final Set<DynamicObject> delMembers = new HashSet<DynamicObject>(16);

        public void merge(StructSyncResult anotherResult) {
            if (Objects.nonNull(anotherResult)) {
                this.newMembers.addAll(anotherResult.getNewMembers());
                this.delMembers.addAll(anotherResult.getDelMembers());
            }
        }

        public void addNewMember(DynamicObject newMember) {
            this.newMembers.add(newMember);
        }

        public void addDelMember(DynamicObject delMember) {
            this.delMembers.add(delMember);
        }

        public Set<DynamicObject> getNewMembers() {
            return this.newMembers;
        }

        public Set<DynamicObject> getDelMembers() {
            return this.delMembers;
        }
    }
}

