/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.struct;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.struct.BareTree;
import kd.fi.bcm.business.dimension.struct.StructHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class ShareNodeStructSyncHelper {
    protected static final Log LOG = LogFactory.getLog(ShareNodeStructSyncHelper.class);
    private static final List<String> NEED_SYNC_DIMS = Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Process.getNumber());
    private static final Set<String> IC_STORAGE_TYPE_UPDATE_MEMBER = ImmutableSet.of((Object)"ICEntity", (Object)"ICOEntity");

    public static void optimizeResyncShareNodeStructure(List<DynamicObject> newMembers, long modelId, long dimensionId) {
        if (CollectionUtils.isEmpty(newMembers)) {
            return;
        }
        DynamicObjectType entityType = (DynamicObjectType)newMembers.get(0).getDataEntityType();
        Object[] ids = newMembers.stream().map(x -> x.getPkValue()).collect(Collectors.toList()).toArray(new Object[0]);
        DynamicObject[] members = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)entityType);
        if (Objects.nonNull(members) && members.length > 0) {
            List<DynamicObject> nonShareMems = Arrays.stream(members).filter(x -> !StructHelper.isShareType(x)).collect(Collectors.toList());
            List shareMems = Arrays.stream(members).filter(x -> StructHelper.isShareType(x)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shareMems) || ShareNodeStructSyncHelper.isParentExistShare(nonShareMems, modelId, dimensionId)) {
                ShareNodeStructSyncHelper.resyncShareNodeStructure(entityType.getName(), modelId, dimensionId);
            }
        }
    }

    private static boolean isParentExistShare(List<DynamicObject> storeMems, long modelId, long dimensionId) {
        if (CollectionUtils.isEmpty(storeMems)) {
            return false;
        }
        List parentIds = storeMems.stream().map(x -> x.getLong("parent.id")).collect(Collectors.toList());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("dimension.id", "=", (Object)dimensionId);
        qfBuilder.add("copyfrom.id", "in", parentIds);
        return QueryServiceHelper.exists((String)storeMems.get(0).getDynamicObjectType().getName(), (QFilter[])qfBuilder.toArray());
    }

    public static void resyncShareNodeStructureForAllDimensions(long modelId) {
        DynamicObjectCollection dimCollection = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, memberform", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "in", NEED_SYNC_DIMS)});
        BatchProcessHelper.handle((List)dimCollection, dim -> {
            ShareNodeStructSyncHelper.resyncShareNodeStructure(dim.getString("memberform"), modelId, dim.getLong("id"));
            return null;
        }, (Integer)180);
    }

    public static void resyncShareNodeStructure(String entityName, long modelId, long dimensionId) {
        try {
            List<DynamicObject> allMembers = StructHelper.listAllMembers(entityName, modelId, dimensionId);
            final BareTree tree = new BareTree(allMembers);
            BareTree.StructSyncResult combineSyncResult = new BareTree.StructSyncResult();
            ArrayList nonShareButSharedNodes = new ArrayList(16);
            tree.preTravel(tree.getRootNode(), node -> {
                if (!StructHelper.isShareType((DynamicObject)node.getData()) && !node.getChildren().isEmpty() && tree.listSharedNodesByAlias(((DynamicObject)node.getData()).getString("number")).size() > 0) {
                    nonShareButSharedNodes.add(node);
                }
            });
            Collections.sort(nonShareButSharedNodes, new Comparator<ITreeNode<DynamicObject>>(){

                @Override
                public int compare(ITreeNode<DynamicObject> o1, ITreeNode<DynamicObject> o2) {
                    return Integer.compare(tree.computeLevelSpan(o1), tree.computeLevelSpan(o2));
                }
            });
            nonShareButSharedNodes.forEach(storageNode -> {
                Optional<BareTree.StructSyncResult> singleNodeSyncResult = tree.syncShareStructure((ITreeNode<DynamicObject>)storageNode);
                if (singleNodeSyncResult.isPresent()) {
                    combineSyncResult.merge(singleNodeSyncResult.get());
                }
            });
            ShareNodeStructSyncHelper.handleSyncResult(combineSyncResult);
            HashSet updateDysSet = new HashSet(128);
            Map<String, DynamicObject> rootNumberDataMap = ShareNodeStructSyncHelper.getOrgViewRootMap(tree);
            tree.preTravel(x -> {
                DynamicObject data = (DynamicObject)x.getData();
                if (CollectionUtils.isEmpty(x.getChildren()) && !data.getBoolean("isleaf")) {
                    data.set("isleaf", (Object)true);
                    updateDysSet.add(data);
                } else if (!CollectionUtils.isEmpty(x.getChildren()) && data.getBoolean("isleaf")) {
                    data.set("isleaf", (Object)false);
                    updateDysSet.add(data);
                }
                if ("bcm_entitymembertree".equalsIgnoreCase(entityName) && !"Entity".equals(data.getString("number")) && rootNumberDataMap != null) {
                    long cslschemeIdNew;
                    String longNumber = data.getString("longnumber");
                    String rootNumberBelong = longNumber.split("!")[1];
                    long cslschemeIdOld = data.getLong("cslscheme_id");
                    if (cslschemeIdOld != (cslschemeIdNew = ((DynamicObject)rootNumberDataMap.get(rootNumberBelong)).getLong("cslscheme_id"))) {
                        data.set("cslscheme", (Object)cslschemeIdNew);
                        updateDysSet.add(data);
                    }
                }
            });
            ArrayList<DynamicObject> updateDys = new ArrayList<DynamicObject>(128);
            updateDys.addAll(updateDysSet);
            ShareNodeStructSyncHelper.batchUpdateMemberProp(updateDys);
            OlapServiceHelper.clearDimMemberCache(MemberReader.findModelNumberById((Object)modelId), MemberReader.getDimensionNumById((long)dimensionId));
        }
        catch (Exception e) {
            LOG.error("bcm_dimension_struct_full_sync failed to sync share member structure error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void batchUpdateMemberProp(List<DynamicObject> updateMembers) {
        if (CollectionUtils.isEmpty(updateMembers)) {
            return;
        }
        DynamicObjectType objectType = updateMembers.get(0).getDynamicObjectType();
        int batchSize = 999;
        ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
        for (int i = 0; i < updateMembers.size(); ++i) {
            batch.add(updateMembers.get(i));
            if (batch.size() < batchSize) continue;
            BusinessDataWriter.update((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
            batch.clear();
        }
        if (!batch.isEmpty()) {
            BusinessDataWriter.update((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
            batch.clear();
        }
    }

    private static void handleSyncResult(BareTree.StructSyncResult syncResult) {
        Objects.requireNonNull(syncResult, "parameter syncResult is null");
        if (!syncResult.getNewMembers().isEmpty()) {
            DynamicObject[] newMembers = syncResult.getNewMembers().toArray(new DynamicObject[0]);
            DynamicObject newMember = newMembers[0];
            DynamicObjectType objectType = newMember.getDynamicObjectType();
            long modelId = newMember.getDynamicObject("model").getLong("id");
            long dimId = newMember.getDynamicObject("dimension").getLong("id");
            int batchSize = 999;
            ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
            for (int i = 0; i < newMembers.length; ++i) {
                batch.add(newMembers[i]);
                if (batch.size() < batchSize) continue;
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                DimensionServiceHelper.syncCustomValuesOfMembers(modelId, dimId, objectType.getName(), batch);
                batch.clear();
            }
            if (!batch.isEmpty()) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                DimensionServiceHelper.syncCustomValuesOfMembers(modelId, dimId, objectType.getName(), batch);
                batch.clear();
            }
        }
        if (!syncResult.getDelMembers().isEmpty()) {
            for (DynamicObject delObj : syncResult.getDelMembers()) {
                LOG.info(String.format("bcm_dimension_struct_full_sync remove node: %s %s", delObj.getLong("id"), delObj.getString("longnumber")));
            }
            BusinessDataWriter.delete((IDataEntityType)syncResult.getDelMembers().toArray(new DynamicObject[0])[0].getDynamicObjectType(), (Object[])syncResult.getDelMembers().stream().map(x -> x.getLong("id")).collect(Collectors.toList()).toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, DynamicObject> getOrgViewRootMap(BareTree tree) {
        List<ITreeNode<DynamicObject>> level1s = tree.getRootNode().getChildren();
        if (level1s.size() < 1) {
            return null;
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        for (ITreeNode<DynamicObject> level1 : level1s) {
            map.put(level1.getData().getString("number"), level1.getData());
        }
        return map;
    }

    public static void syncICNodeStorageType(long modelId, long dimensionId) {
        DynamicObject[] dys;
        String entityName = "bcm_icmembertree";
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter dimensionQf = new QFilter("dimension.id", "=", (Object)dimensionId);
        QFilter numberQf = new QFilter("number", "in", IC_STORAGE_TYPE_UPDATE_MEMBER);
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)entityName, (String)"id,number, isleaf, storagetype, model.number, dimension.number", (QFilter[])new QFilter[]{modelQf, dimensionQf, numberQf})) {
            QFilter parentQf = new QFilter("parent.id", "=", (Object)dy.getLong("id"));
            if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{modelQf, dimensionQf, parentQf})) {
                dy.set("isleaf", (Object)"0");
                dy.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
                continue;
            }
            dy.set("isleaf", (Object)"1");
            dy.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.update((DynamicObject[])dys);
                for (DynamicObject dy : dys) {
                    MemberStorageTypes type = MemberStorageTypes.DynamicCalc;
                    if (dy.getBoolean("isleaf")) {
                        type = MemberStorageTypes.Stored;
                    }
                    OlapServiceHelper.alterMemberStorageType(dy.getString("model.number"), dy.getString("dimension.number"), dy.getString("number"), type);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

