/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.ICache;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;

public class AccountMemberUtil {
    public static final List<String> dimMapNumbers = Collections.unmodifiableList(Arrays.asList(DimTypesEnum.CHANGETYPE.getNumber(), DimTypesEnum.INTERCOMPANY.getNumber(), DimTypesEnum.DATASORT.getNumber(), DimTypesEnum.MULTIGAAP.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()));
    public static final List<String> dimMapEntityIds = Collections.unmodifiableList(Arrays.asList("bcm_changetypemembertree", "bcm_icmembertree", "bcm_datasortmembertree", "bcm_rulemembertree", "bcm_audittrialmembertree", "bcm_userdefinedmembertree"));

    public static boolean allowAddNew(String key, String selectMemberId, String model) {
        int lastUserdefinedRate;
        boolean flag = true;
        QFilter fid = new QFilter("id", "=", (Object)LongUtil.toLong((Object)selectMemberId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)"number,parent.number", (QFilter[])new QFilter[]{fid});
        if ("baritemaddsub".equals(key)) {
            if (dynamicObject != null && "ExchangeRate".equalsIgnoreCase(dynamicObject.getString("parent.number"))) {
                flag = false;
            }
            if (dynamicObject != null && "ExchangeRate".equalsIgnoreCase(dynamicObject.getString("number")) && AccountMemberUtil.getLastUserdefinedRate(model) >= 10) {
                flag = false;
            }
        } else if ("baritemaddlevel".equals(key) && (lastUserdefinedRate = AccountMemberUtil.getLastUserdefinedRate(model)) >= 10 && dynamicObject != null && "ExchangeRate".equalsIgnoreCase(dynamicObject.getString("parent.number"))) {
            flag = false;
        }
        return flag;
    }

    public static int getLastUserdefinedRate(String model) {
        Integer number = 0;
        String preset = "UserdefinedRate";
        QFilter notPreset = new QFilter("number", "<>", (Object)preset);
        QFilter pnumf = new QFilter("parent.number", "=", (Object)"ExchangeRate");
        QFilter numf = new QFilter("number", "like", (Object)(preset + "%"));
        QFilter modelf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)model));
        QFilter[] filters = new QFilter[]{notPreset, pnumf, numf, modelf};
        DynamicObjectCollection last = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number", (QFilter[])filters, (String)"id desc", (int)1);
        number = last == null || last.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(((DynamicObject)last.get(0)).getString("number").replace(preset, ""));
        return number;
    }

    public static Map<String, Set<Long>> getAccountDimValMap(Long accountId, Long modelId) {
        HashMap<String, Set<Long>> dimValMap = new HashMap<String, Set<Long>>();
        if (accountId == null) {
            return dimValMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)accountId)};
        String sel = "dm_entry.dm_dim.number number,dm_entry.dm_dim.membermodel membermodel,dm_entry.dm_val val";
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)sel, (QFilter[])filters);
        for (DynamicObject entry : dync) {
            HashSet<Long> dimVals = new HashSet<Long>();
            String number = entry.getString("number");
            String entityId = entry.getString("membermodel");
            String valStr = entry.getString("val");
            if (StringUtils.isEmpty((String)valStr)) continue;
            List list = SerializationUtils.fromJsonStringToList((String)valStr, Map.class);
            for (Object o : list) {
                Map map = (Map)o;
                long pid = map.get("pid") == null ? 0L : (StringUtils.isEmpty((String)((String)map.get("pid")).trim()) ? 0L : Long.parseLong(((String)map.get("pid")).trim()));
                dimVals.addAll(AccountMemberUtil.queryMemberDetails(entityId, String.valueOf(modelId), pid, Long.parseLong((String)map.get("id")), Integer.parseInt((String)map.get("scope"))));
            }
            dimValMap.put(number, dimVals);
        }
        return dimValMap;
    }

    private static Set<String> queryMemberNumberDetails(String entity, String modelid, long pid, long mid, String mnum, int range) {
        HashSet<String> set = new HashSet<String>();
        if (pid == 0L) {
            set.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange(entity, mid, mnum, range, modelid, DetailTypeEnum.OTHERS));
        } else {
            set.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number(entity, mid, mnum, range, modelid, DetailTypeEnum.OTHERS));
        }
        return set;
    }

    private static Set<Long> queryMemberDetails(String entity, String modelid, long pid, long mid, int range) {
        HashSet<Long> set = new HashSet<Long>();
        if (pid == 0L) {
            set.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange(entity, mid, range, modelid, DetailTypeEnum.OTHERS));
        } else {
            set.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange(entity, mid, range, modelid, DetailTypeEnum.OTHERS));
        }
        return set;
    }

    public static Map<String, Set<Long>> getAccountDimValMapWithCache(Long accId, long modelId, IPageCache pageCache) {
        if (pageCache == null) {
            return AccountMemberUtil.getAccountDimValMapWithParent(accId, modelId);
        }
        String key = String.join((CharSequence)"-", "dimvalmap", String.valueOf(accId), String.valueOf(modelId));
        String str = pageCache.get(key);
        if (str != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)str);
        }
        Map<String, Set<Long>> accountDimValMap = AccountMemberUtil.getAccountDimValMapWithParent(accId, modelId);
        String s = SerializationUtils.serializeToBase64(accountDimValMap);
        pageCache.put(key, s);
        return accountDimValMap;
    }

    public static Map<String, Set<Long>> getAccountDimValMapWithGlobalCache(long accId, long modelId) {
        ICache cache = GlobalCacheServiceHelper.getDimMemberCache();
        String key = AccountMemberUtil.getGlobalKey(accId, modelId);
        Map orLoad = (Map)cache.getOrLoad(key, () -> AccountMemberUtil.getAccountDimValMapWithParent(accId, modelId));
        return orLoad;
    }

    public static Map<String, Set<String>> getAccountDimValNumberMapWithGlobalCache(long accId, long modelId) {
        ICache cache = GlobalCacheServiceHelper.getDimMemberCache();
        String key = AccountMemberUtil.getGlobalKey(accId, modelId) + "number";
        Map orLoad = (Map)cache.getOrLoad(key, () -> AccountMemberUtil.getAccountDimValNumberMapWithParent(accId, modelId));
        return orLoad;
    }

    public static Map<String, Set<String>> getNoParentAccountDimValNumberMapWithGlobalCache(long accId, long modelId) {
        ICache cache = GlobalCacheServiceHelper.getDimMemberCache();
        String key = AccountMemberUtil.getGlobalKey(accId, modelId) + "number_NoParent";
        Map orLoad = (Map)cache.getOrLoad(key, () -> AccountMemberUtil.getAccountDimValNumberMap(accId, modelId));
        return orLoad;
    }

    public static Map<String, Set<String>> getAccountDimValNumberMapWithParent(Long accId, long modelId) {
        Map<String, Set<String>> accountDimValMap = AccountMemberUtil.getAccountDimValNumberMap(accId, modelId);
        for (Map.Entry<String, Set<String>> entry : accountDimValMap.entrySet()) {
            Set<String> value = entry.getValue();
            Set<String> parentVals = AccountMemberUtil.getAllParentNumbers(entry.getKey(), value, modelId);
            value.addAll(parentVals);
        }
        return accountDimValMap;
    }

    public static Map<String, Set<String>> getAccountDimValNumberMap(Long accountId, Long modelId) {
        HashMap<String, Set<String>> dimValMap = new HashMap<String, Set<String>>();
        if (accountId == null) {
            return dimValMap;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)accountId)};
        String sel = "dm_entry.dm_dim.number number,dm_entry.dm_dim.membermodel membermodel,dm_entry.dm_val val,number number1";
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)sel, (QFilter[])filters);
        for (DynamicObject entry : dync) {
            HashSet<String> dimVals = new HashSet<String>();
            String number = entry.getString("number");
            String entityId = entry.getString("membermodel");
            String valStr = entry.getString("val");
            if (StringUtils.isEmpty((String)valStr)) continue;
            List list = SerializationUtils.fromJsonStringToList((String)valStr, Map.class);
            for (Object o : list) {
                Map map = (Map)o;
                long pid = map.get("pid") == null ? 0L : (StringUtils.isEmpty((String)((String)map.get("pid")).trim()) ? 0L : Long.parseLong(((String)map.get("pid")).trim()));
                dimVals.addAll(AccountMemberUtil.queryMemberNumberDetails(entityId, String.valueOf(modelId), pid, Long.parseLong((String)map.get("id")), (String)map.get("number"), Integer.parseInt((String)map.get("scope"))));
            }
            dimValMap.put(number, dimVals);
        }
        return dimValMap;
    }

    public static void rmvAccDimValMapGlobalCache(long accId, long modelId) {
        ICache cache = GlobalCacheServiceHelper.getDimMemberCache();
        String key = AccountMemberUtil.getGlobalKey(accId, modelId);
        cache.invalidateStartsWithKey(key);
    }

    private static String getGlobalKey(long accId, long modelId) {
        return String.join((CharSequence)"-", "global-dimvalmap", String.valueOf(accId), String.valueOf(modelId));
    }

    public static Map<String, Set<Long>> getAccountDimValMapWithParent(Long accId, long modelId) {
        Map<String, Set<Long>> accountDimValMap = AccountMemberUtil.getAccountDimValMap(accId, modelId);
        for (Map.Entry<String, Set<Long>> entry : accountDimValMap.entrySet()) {
            Set<Long> value = entry.getValue();
            Set<Long> parentVals = AccountMemberUtil.getAllParentIds(entry.getKey(), value, modelId);
            value.addAll(parentVals);
        }
        return accountDimValMap;
    }

    private static Set<String> getAllParentNumbers(String key, Set<String> value, long modelId) {
        HashSet<String> parentIds = new HashSet<String>();
        String entityId = DimensionServiceHelper.getDimMembEntityNumByDimNum(key);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (entityId.equals("bcm_userdefinedmembertree")) {
            filter.and(new QFilter("dimension.number", "=", (Object)key));
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection ds = QueryServiceHelper.query((String)entityId, (String)"id,number,parent.number", (QFilter[])filters, null);
        Map<String, String> map = AccountMemberUtil.getNumberParentMap(ds);
        for (String id : value) {
            AccountMemberUtil.getParentNumber(id, parentIds, map);
        }
        return parentIds;
    }

    private static Set<Long> getAllParentIds(String key, Set<Long> value, long modelId) {
        Map<Long, Long> map;
        HashSet<Long> parentIds = new HashSet<Long>();
        String entityId = DimensionServiceHelper.getDimMembEntityNumByDimNum(key);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (entityId.equals("bcm_userdefinedmembertree")) {
            filter.and(new QFilter("dimension.number", "=", (Object)key));
        }
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("getAllParentIds." + key), (String)entityId, (String)"id,parent", (QFilter[])filters, null);){
            map = AccountMemberUtil.getIdParentMap(ds);
        }
        for (Long id : value) {
            AccountMemberUtil.getParentId(id, parentIds, map);
        }
        return parentIds;
    }

    private static void getParentId(Long id, Set<Long> parentIds, Map<Long, Long> map) {
        boolean add;
        Long parentId = map.get(id);
        if (parentId != 0L && (add = parentIds.add(parentId))) {
            AccountMemberUtil.getParentId(parentId, parentIds, map);
        }
    }

    public static Map<Long, Long> getIdParentMap(DataSet orgDataSet) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (Row row : orgDataSet) {
            Long id = row.getLong("id");
            Long parent = row.getLong("parent");
            result.put(id, parent);
        }
        return result;
    }

    private static void getParentNumber(String number, Set<String> parentNumbers, Map<String, String> map) {
        boolean add;
        String parentNumber = map.get(number);
        if (StringUtils.isNotEmpty((String)parentNumber) && (add = parentNumbers.add(parentNumber))) {
            AccountMemberUtil.getParentNumber(parentNumber, parentNumbers, map);
        }
    }

    public static Map<String, String> getNumberParentMap(DynamicObjectCollection orgDataSet) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (DynamicObject row : orgDataSet) {
            String id = row.getString("number");
            String parent = row.getString("parent.number");
            result.put(id, parent);
        }
        return result;
    }

    public static Map<Long, Set<Long>> getParentChildrenMap(DataSet orgDataSet) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        for (Row row : orgDataSet) {
            Long id = row.getLong("id");
            Long parent = row.getLong("parent");
            result.putIfAbsent(id, new HashSet());
            result.compute(parent, (k, v) -> {
                if (v == null) {
                    HashSet<Long> leaf = new HashSet<Long>();
                    leaf.add(id);
                    return leaf;
                }
                v.add(id);
                return v;
            });
        }
        return result;
    }

    public static void updateDimMapMember(Set<String> memberIds, Long dimId, Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection accountDys = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id", (QFilter[])qf.toArray());
        Set ids = accountDys.stream().map(x -> x.getString("id")).collect(Collectors.toSet());
        String sql = String.format("select fentryid, fval from t_bcm_structofaccount_dm where fid in (%s) and fdim = %s", String.join((CharSequence)",", ids), dimId);
        DataSet rows = DB.queryDataSet((String)"select_account_dim_map", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        HashMap<Long, String> upMap = new HashMap<Long, String>(16);
        while (rows.hasNext()) {
            Row next = rows.next();
            String dimVal = next.getString("fval");
            if (!StringUtils.isNotEmpty((String)dimVal)) continue;
            List list = SerializationUtils.fromJsonStringToList((String)dimVal, Map.class);
            Iterator iterator = list.iterator();
            ArrayList<LinkedHashMap> remaindData = new ArrayList<LinkedHashMap>(10);
            while (iterator.hasNext()) {
                LinkedHashMap dimMpped = (LinkedHashMap)iterator.next();
                if (memberIds.contains(dimMpped.get("id"))) continue;
                remaindData.add(dimMpped);
            }
            dimVal = remaindData.size() > 0 ? SerializationUtils.toJsonString(remaindData) : "";
            upMap.put(next.getLong("fentryid"), dimVal);
        }
        if (upMap.size() > 0) {
            Iterator iterator = upMap.entrySet().iterator();
            ArrayList<Object[]> params = new ArrayList<Object[]>(upMap.size());
            while (iterator.hasNext()) {
                Object[] param = new Object[2];
                Map.Entry next = iterator.next();
                param[0] = next.getValue();
                param[1] = next.getKey();
                params.add(param);
            }
            String upSql = "update t_bcm_structofaccount_dm set fval = ? where fentryid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)upSql, params);
        }
    }
}

