/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.entity.EntityBizRecord;
import kd.fi.bcm.common.cache.entity.EntityChangeRecord;
import kd.fi.bcm.common.cache.entity.EntityNameRecord;
import kd.fi.bcm.common.enums.ChangeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class EntityVersioningUtil {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, EntityVersioningUtil.class);

    public static List<Long> filterOrgsByMergeStruct(FilterOrgStructParam param, List<DynamicObject> orgs) {
        ArrayList<Long> removeNodes = new ArrayList<Long>();
        if (orgs.isEmpty()) {
            return removeNodes;
        }
        String keyId = EntityVersioningUtil.getOrgKey("id", param.getFrom());
        String keyNumber = EntityVersioningUtil.getOrgKey("number", param.getFrom());
        String keyName = EntityVersioningUtil.getOrgKey("name", param.getFrom());
        boolean isMergeInfoStruct = ConfigServiceHelper.getBoolParam(param.getModelId(), "isMergeInfoStruct");
        if (ConfigServiceHelper.getBoolParam(param.getModelId(), "isNewEntityVersion") || isMergeInfoStruct) {
            Map<Long, String> effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, orgs.stream().map(p -> p.getLong(keyId)).collect(Collectors.toList()));
            DataEntityPropertyCollection properties = orgs.get(0).getDataEntityType().getProperties();
            boolean canUpdateName = properties.containsKey((Object)"name") || properties.containsKey((Object)"entity") || properties.containsKey((Object)"org");
            orgs.removeIf(org -> {
                long orgId = org.getLong(keyId);
                if (effectiveOrg.containsKey(orgId)) {
                    if (canUpdateName) {
                        EntityVersioningUtil.updateSuitableOrgName(org, (String)effectiveOrg.get(orgId), keyNumber, keyName);
                    }
                    return false;
                }
                removeNodes.add(orgId);
                return true;
            });
        } else {
            orgs.forEach(org -> removeNodes.add(org.getLong("id")));
            Map<Long, String> orgChanged = EntityVersioningUtil.filterOrgsByVersion(orgs, param.getModelId(), param.getYearNum(), param.getPeriodId(), MemberReader.getEntChangeRecs((String)MemberReader.findModelNumberById((Object)param.getModelId()), (Collection)orgs.stream().map(p -> p.getLong(keyId)).collect(Collectors.toList())), param.getFrom(), param);
            removeNodes.removeAll(orgChanged.keySet());
        }
        return removeNodes;
    }

    public static Map<Long, String> filterEffectiveOrgByMergeStruct(FilterOrgStructParam param, Collection<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map entChangeRecMap = MemberReader.getEntChangeRecs((String)MemberReader.findModelNumberById((Object)param.getModelId()), orgIds);
        boolean isMergeInfoStruct = ConfigServiceHelper.getBoolParam(param.getModelId(), "isMergeInfoStruct");
        if (ConfigServiceHelper.getBoolParam(param.getModelId(), "isNewEntityVersion") || isMergeInfoStruct) {
            param.setCheckStructInfo(isMergeInfoStruct & param.isCheckStructInfo());
            return EntityVersioningUtil.filterOrgsByVersionNew(param, entChangeRecMap);
        }
        String modelNum = MemberReader.findModelNumberById((Object)param.getModelId());
        List<DynamicObject> doc = orgIds.stream().map(e -> {
            IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)e);
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            dy.set("id", e);
            dy.set("number", (Object)orgNode.getNumber());
            return dy;
        }).collect(Collectors.toList());
        return EntityVersioningUtil.filterOrgsByVersion(doc, param.getModelId(), param.getYearNum(), param.getPeriodId(), entChangeRecMap, param.getFrom(), param);
    }

    public static Map<Long, String> filterOrgsByVersionNew(FilterOrgStructParam param, Map<Long, EntityChangeRecord> entChangeRecMap) {
        Date lastDate;
        if (entChangeRecMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> effectiveOrgMap = new HashMap<Long, String>(entChangeRecMap.size());
        long modelId = param.getModelId();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        long sceneId = param.getSceneId();
        String yearNum = param.getYearNum();
        long periodId = param.getPeriodId();
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)yearNum);
        Long yearId = yearNode.getId();
        int from = param.getFrom();
        boolean isCheckStructInfo = param.isCheckStructInfo();
        boolean isCalDayArchitect = param.specialLastDate() != null;
        Date[] datePair = PeriodUtils.calcStartAndEndDate((long)modelId, (String)yearNum, (long)periodId);
        Date firstDate = datePair[0];
        Date date = lastDate = isCalDayArchitect ? new Date(param.specialLastDate().getYear(), param.specialLastDate().getMonth(), param.specialLastDate().getDate()) : datePair[1];
        if (firstDate == null || lastDate == null) {
            return effectiveOrgMap;
        }
        Table<String, String, Boolean> allMerge = InvestServiceHelper.getMergeStructInfoSetting(modelId, sceneId, yearId, periodId);
        Map<String, ChangeTypeModel> bizChanges = InvestServiceHelper.getInvChangetypeModel(modelId);
        Comparator<EntityBizRecord> bizchangeComparator = Comparator.comparing(EntityBizRecord::getBizEffDate, Comparator.nullsLast(Date::compareTo));
        Comparator<EntityNameRecord> namechangeComparator = Comparator.comparing(EntityNameRecord::getNameEffDate, Comparator.nullsLast(Date::compareTo));
        HashBasedTable effRecordDictionary = HashBasedTable.create();
        entChangeRecMap.forEach((arg_0, arg_1) -> EntityVersioningUtil.lambda$filterOrgsByVersionNew$9(modelNum, effectiveOrgMap, bizchangeComparator, namechangeComparator, firstDate, lastDate, bizChanges, allMerge, from, isCheckStructInfo, isCalDayArchitect, modelId, param, (Table)effRecordDictionary, arg_0, arg_1));
        EntityVersioningUtil.dealNonEffectiveChildren(modelId, entChangeRecMap.keySet(), effectiveOrgMap.keySet(), (Table<String, Long, EntityBizRecord>)effRecordDictionary, param.isAutoDelChild());
        EntityVersioningUtil.sortEffRecordDictionary((Table<String, Long, EntityBizRecord>)effRecordDictionary, param);
        return effectiveOrgMap;
    }

    private static void sortEffRecordDictionary(Table<String, Long, EntityBizRecord> effRecordDictionary, FilterOrgStructParam param) {
        if (!param.isOpenSortedDictionary() || effRecordDictionary.isEmpty()) {
            return;
        }
        Map<String, ChangeTypeModel> bizChanges = InvestServiceHelper.getInvChangetypeModel(param.getModelId());
        int offset = (int)Math.pow(10.0, bizChanges.size() / 10 + 1);
        Comparator bizeffComparator = (e1, e2) -> {
            Date c1Date = ((EntityBizRecord)e1.getValue()).getBizEffDate();
            Date c2Date = ((EntityBizRecord)e2.getValue()).getBizEffDate();
            if (c1Date == null && c2Date == null) {
                return 0;
            }
            if (c1Date == null) {
                return -1;
            }
            if (c2Date == null) {
                return 1;
            }
            return c1Date.compareTo(c2Date);
        };
        effRecordDictionary.rowMap().forEach((orgNum, groupMap) -> {
            Date curDate = null;
            int curDseq = 0;
            List groupList = groupMap.entrySet().stream().sorted(bizeffComparator.reversed()).collect(Collectors.toList());
            for (Map.Entry kv : groupList) {
                ChangeTypeModel changeType;
                Date bizeffdate = ((EntityBizRecord)kv.getValue()).getBizEffDate();
                String bizType = ((EntityBizRecord)kv.getValue()).getChangType();
                if (curDate == null || !curDate.equals(bizeffdate)) {
                    ++curDseq;
                    curDate = bizeffdate;
                }
                if ((changeType = (ChangeTypeModel)bizChanges.get(bizType)) == null) continue;
                param.getSortedDictionary().put(orgNum, kv.getKey(), (Object)(curDseq * offset + changeType.seq()));
            }
        });
    }

    public static Map<String, Set<Long>> sortOrgByChangeType(String modelNum, String mergeNum, Collection<Long> effectOrg, Table<String, Long, Integer> sortedDictionary) {
        Collection realEffectOrg;
        if (CollectionUtil.isEmpty(effectOrg) || sortedDictionary == null || sortedDictionary.isEmpty()) {
            return new HashMap<String, Set<Long>>();
        }
        HashMap<String, Set<Long>> sortedOrgMap = new HashMap<String, Set<Long>>(16);
        if (mergeNum == null) {
            realEffectOrg = effectOrg;
        } else {
            String mergeNumSeparator = "!" + mergeNum + "!";
            realEffectOrg = effectOrg.stream().filter(orgId -> BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgId).getLongNumber().contains(mergeNumSeparator)).collect(Collectors.toSet());
        }
        if (mergeNum != null && sortedDictionary.containsRow((Object)mergeNum) && !sortedDictionary.row((Object)mergeNum).isEmpty()) {
            sortedOrgMap.put(mergeNum, new HashSet(sortedDictionary.row((Object)mergeNum).keySet()));
        }
        for (String memNum : sortedDictionary.rowKeySet()) {
            Set sortedOrgSet;
            Map resultMap = sortedDictionary.row((Object)memNum);
            if (resultMap.isEmpty()) continue;
            if (resultMap.size() == 1) {
                if (resultMap.keySet().stream().noneMatch(realEffectOrg::contains)) continue;
                sortedOrgSet = resultMap.keySet();
            } else {
                sortedOrgSet = resultMap.entrySet().stream().filter(p -> realEffectOrg.contains(p.getKey())).sorted((p1, p2) -> {
                    int result = Integer.compare((Integer)p1.getValue(), (Integer)p2.getValue());
                    if (result == 0) {
                        IDNumberTreeNode p2Node;
                        IDNumberTreeNode p1Node = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)((Long)p1.getKey()));
                        Map p1ParentMap = (Map)BcmThreadCache.get((Object)"initParentOrgs", (Object)mergeNum, p1.getKey(), () -> TreeStructureServiceHelper.initParentOrgs(p1Node, mergeNum, new HashMap<String, IDNumberTreeNode>(3)));
                        IDNumberTreeNode p2ParNode = p2Node = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)((Long)p2.getKey()));
                        do {
                            IDNumberTreeNode p1ParNode;
                            if ((p1ParNode = (IDNumberTreeNode)p1ParentMap.get((p2ParNode = p2ParNode.getParent()).getNumber())) == null) continue;
                            Integer p1Prior = (Integer)sortedDictionary.get((Object)p1ParNode.getNumber(), (Object)p1ParNode.getId());
                            Integer p2Prior = (Integer)sortedDictionary.get((Object)p2ParNode.getNumber(), (Object)p2ParNode.getId());
                            result = Integer.compare(p1Prior == null ? 0 : p1Prior, p2Prior == null ? 0 : p2Prior);
                        } while (result == 0 && !p2ParNode.getNumber().equals("Entity") && !p2ParNode.getNumber().equals(mergeNum));
                        result = result == 0 ? Integer.compare(p1Node.getLevel(), p2Node.getLevel()) : result;
                    }
                    return result;
                }).map(Map.Entry::getKey).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
            }
            if (CollectionUtil.isEmpty(sortedOrgSet)) continue;
            sortedOrgMap.put(memNum, sortedOrgSet);
        }
        return sortedOrgMap;
    }

    private static Boolean queryDefaultMergeStruct(Table<String, String, Boolean> allMerge, int from, String pOrgNumber, String orgNumber) {
        Boolean isMergeStruct = (Boolean)allMerge.get((Object)pOrgNumber, (Object)orgNumber);
        if (isMergeStruct != null && from == FilterOrgStructParam.FROM_MERGESTRUCT) {
            return Boolean.TRUE;
        }
        return Boolean.TRUE.equals(isMergeStruct);
    }

    private static boolean isSuitableRecord(Date effDate, Date expDate, Date firstDate, Date lastDate) {
        if (firstDate == null || lastDate == null) {
            return false;
        }
        return effDate == null || EntityVersioningUtil.isBetweenDateRange(effDate, expDate, lastDate);
    }

    public static void dealNonEffectiveChildren(long modelId, Collection<Long> orgList, Collection<Long> effectiveOrg, Table<String, Long, EntityBizRecord> effRecordDictionary, boolean isAutoDelChild) {
        if (!isAutoDelChild) {
            return;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        new ArrayList<Long>(orgList).forEach(orgId -> {
            if (!effectiveOrg.contains(orgId) && orgList.contains(orgId)) {
                BcmThreadCache.findNodeById((String)modelNumber, (String)"Entity", (long)orgId).getAllChildren().forEach(child -> {
                    orgList.remove(child.getId());
                    effectiveOrg.remove(child.getId());
                    effRecordDictionary.remove((Object)child.getNumber(), (Object)child.getId());
                });
            }
        });
    }

    public static Map<Long, DynamicObject> getEffectiveOrgNameByPY(List<FilterOrgStructParam> params, List<Long> orgIds) {
        FilterOrgStructParam param = EntityVersioningUtil.getLatestPY(params);
        Map<Long, String> id2Names = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, orgIds);
        QFilter qFilter = new QFilter("id", "in", id2Names.keySet());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,simplename,isleaf", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject org : doc) {
            org.set("name", (Object)id2Names.get(org.getLong("id")));
        }
        return doc.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
    }

    public static FilterOrgStructParam getLatestPY(List<FilterOrgStructParam> params) {
        FilterOrgStructParam latestParam = null;
        Date lastDate = null;
        if (params.isEmpty()) {
            return null;
        }
        List<Long> periodIds = params.stream().map(m -> m.getPeriodId()).collect(Collectors.toList());
        DynamicObject[] periods = EntityVersioningUtil.getSPeriods(periodIds);
        if (periods.length == 0) {
            return null;
        }
        Map<Long, DynamicObject> id2Dys = Arrays.asList(periods).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (FilterOrgStructParam param : params) {
            DynamicObject model = EntityVersioningUtil.getModelFilter(param.getModelId());
            Date endDate = EntityVersioningUtil.getFilterDay(false, model, param.getYearNum(), id2Dys.get(param.getPeriodId()));
            if (lastDate == null) {
                lastDate = endDate;
                latestParam = param;
                continue;
            }
            if (lastDate.compareTo(endDate) >= 0) continue;
            lastDate = endDate;
            latestParam = param;
        }
        return latestParam;
    }

    private static Boolean isSpecialRightOrgVersion(long modelId, Date firstDate, Date bizEffDate, ChangeTypeModel bizCt, int from, Boolean isEffectiveOrg) {
        String bizCtStr = bizCt.getRealChangeType();
        if (from == FilterOrgStructParam.FROM_CHECKELIM) {
            if (OrgBizChangeTypeEnum.liquidationDisposal.getValue().equals(bizCtStr) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(bizCtStr)) {
                String checkOrgDisposal = ConfigServiceHelper.getStringParam(modelId, "isCheckOrgDisposal");
                if ("1".equals(checkOrgDisposal)) {
                    return false;
                }
                if ("0".equals(checkOrgDisposal) || "".equals(checkOrgDisposal) ? firstDate.compareTo(bizEffDate) > 0 : "2".equals(checkOrgDisposal) && DateTimeUtils.getYear((Date)firstDate) - DateTimeUtils.getYear((Date)bizEffDate) > 0) {
                    return false;
                }
            }
        } else if (from == FilterOrgStructParam.FROM_REPORT_SAME && OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(bizCtStr) && firstDate.compareTo(bizEffDate) > 0) {
            return false;
        }
        return isEffectiveOrg;
    }

    private static void updateSuitableOrgName(DynamicObject org, String name, String keyNumber, String keyName) {
        if ("Entity".equals(org.getString(keyNumber))) {
            return;
        }
        if (name != null) {
            org.set(keyName, (Object)name);
        }
    }

    private static boolean isRightOrgVersion(Date firstDate, Date bizEffDate, ChangeTypeModel bizCt, boolean isCalDayArchitect) {
        if (bizEffDate == null) {
            return true;
        }
        String bizCtStr = bizCt.getRealChangeType();
        if (OrgBizChangeTypeEnum.disable.getValue().equals(bizCtStr)) {
            return false;
        }
        if ((ChangeEnum.Disable.getIndex().equals(bizCt.change()) || OrgBizChangeTypeEnum.newSetMergeDisable.getValue().equals(bizCtStr)) && (isCalDayArchitect || firstDate.compareTo(bizEffDate) > 0)) {
            return false;
        }
        return !ChangeEnum.Decrease.getIndex().equals(bizCt.change()) || !isCalDayArchitect && DateTimeUtils.getYear((Date)firstDate) - DateTimeUtils.getYear((Date)bizEffDate) <= 0;
    }

    public static DynamicObjectCollection queryFYFirstDay(Object modelId) {
        String selectFields = "startfy,beginyearofmonth,beginperiod";
        QFilter filter1 = new QFilter("id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_model", (String)selectFields, (QFilter[])filters);
        return dcs;
    }

    public static String checkModelDate(Object modelId, Date date) {
        DynamicObjectCollection dcs = EntityVersioningUtil.queryFYFirstDay(modelId);
        if (dcs != null && dcs.size() == 1) {
            String startfy = ((DynamicObject)dcs.get(0)).getString("startfy");
            String beginyearofmonth = ((DynamicObject)dcs.get(0)).getString("beginyearofmonth");
            String beginperiod = ((DynamicObject)dcs.get(0)).getString("beginperiod");
            int fyyear = Integer.parseInt(startfy) + 1996;
            int fymonth = Integer.parseInt(beginperiod);
            if (FyEnum.PRE.index.equals(beginyearofmonth)) {
                --fyyear;
            }
            LocalDate ld = LocalDate.of(fyyear, fymonth, 1);
            ZoneId zd = ZoneId.systemDefault();
            ZonedDateTime zdt = ld.atStartOfDay(zd);
            Date modelEffDate = Date.from(zdt.toInstant());
            if (date == null || date.compareTo(modelEffDate) < 0) {
                String strfymonth = "";
                strfymonth = fymonth < 10 ? "0" + fymonth : String.valueOf(fymonth);
                return String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u4e0d\u53ef\u65e9\u4e8e%1$s-%2$s-01\u3002", (String)"EntityVersioningUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]), fyyear, strfymonth);
            }
        }
        return "";
    }

    private static String getOrgKey(String key, int from) {
        String prefix = from == FilterOrgStructParam.FROM_COMMON ? "" : (from == FilterOrgStructParam.FROM_REPORT ? "entity." : (from == FilterOrgStructParam.FROM_CHECK ? "org." : (from == FilterOrgStructParam.FROM_TASK ? "entity." : "")));
        return prefix + key;
    }

    public static DynamicObjectCollection getOrgCollection(String entityName, QFilter[] filters, String orderBys) {
        DynamicObjectCollection coll = new DynamicObjectCollection();
        coll.addAll(BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,name,number,parent.id,isleaf,storagetype,orgcode,currency", (QFilter[])filters, (String)orderBys).values());
        return coll;
    }

    @Deprecated
    public static void filterVersionOrgTree(List<DynamicObject> orgTree, long modelId, long yearId, long periodId, long sceneId) {
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((Long)modelId, (Long)yearId);
        FilterOrgStructParam param = new FilterOrgStructParam((long)LongUtil.toLong((Object)modelId), sceneId, yearNode.getNumber(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(param, orgTree);
    }

    private static boolean isBetweenDateRange(Date start, Date end, Date date) {
        start.setHours(0);
        start.setMinutes(0);
        start.setSeconds(0);
        if (end != null) {
            end.setHours(0);
            end.setMinutes(0);
            end.setSeconds(0);
        }
        return start.compareTo(date) <= 0 && (end == null || end.compareTo(date) >= 0);
    }

    private static DynamicObject getOrgBizInfo(long orgId, long modelId, long yearId, long periodId) {
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId);
        Date[] datePair = PeriodUtils.calcStartAndEndDateTime((long)modelId, (String)yearNode.getNumber(), (long)periodId);
        Date firstDate = datePair[0];
        Date lastDate = datePair[1];
        if (firstDate == null || lastDate == null) {
            return null;
        }
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, name, bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)}, (String)"bizchangerds.seq, namechangerds.seq");
        for (DynamicObject rec : allData) {
            String name = rec.getString("namechangerds.namerds");
            Date bizeffdate = rec.getDate("bizchangerds.bizeffdate");
            if (bizeffdate == null || name == null) {
                return null;
            }
            Date bizexpdate = rec.getDate("bizchangerds.bizexpdate");
            Date nameeffdate = rec.getDate("namechangerds.nameeffdate");
            Date nameexpdate = rec.getDate("namechangerds.nameexpdate");
            if (bizeffdate.compareTo(lastDate) > 0 || bizexpdate != null && bizexpdate.compareTo(lastDate) < 0 || nameeffdate.compareTo(lastDate) > 0 || nameexpdate != null && nameexpdate.compareTo(lastDate) < 0) continue;
            return rec;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
    }

    public static String getEffOrgName(DynamicObject org, long modelId, long yearId, long periodId) {
        DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(org.getLong("id"), modelId, yearId, periodId);
        if (orgBizInfo != null) {
            DataEntityPropertyCollection properties = orgBizInfo.getDataEntityType().getProperties();
            if (properties != null && properties.containsKey((Object)"name")) {
                return orgBizInfo.getString("namechangerds.namerds");
            }
            return orgBizInfo.getString("name");
        }
        return "";
    }

    public static String getEffOrgNameByOrgId(long orgId, long modelId, long yearId, long periodId) {
        DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(orgId, modelId, yearId, periodId);
        if (orgBizInfo != null) {
            DataEntityPropertyCollection properties = orgBizInfo.getDataEntityType().getProperties();
            if (properties != null && properties.containsKey((Object)"name")) {
                return orgBizInfo.getString("namechangerds.namerds");
            }
            return orgBizInfo.getString("name");
        }
        return "";
    }

    public static DynamicObject getModelFilter(Object modelId) {
        return (DynamicObject)ThreadCache.get((Object)(modelId + "EntityVersioningUtil"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(modelId.toString()), (String)"bcm_model", (String)"id, beginyearofmonth"));
    }

    public static DynamicObject getPeriodFilter(Object periodId) {
        return (DynamicObject)ThreadCache.get((Object)(periodId + "EntityVersioningUtil"), () -> BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, number,effmonth, effday, expmonth, expday,dseq", (QFilter[])new QFilter("id", "=", (Object)ConvertUtil.convertObjToLong(periodId)).toArray()));
    }

    public static DynamicObject[] getSPeriods(Collection<Long> periodIds) {
        return BusinessDataServiceHelper.load((String)"bcm_periodmembertree", (String)"id,number,effmonth, effday, expmonth, expday,dseq", (QFilter[])new QFilter("id", "in", periodIds).toArray());
    }

    public static DynamicObject[] getPeriods(Object modelId) {
        return BusinessDataServiceHelper.load((String)"bcm_periodmembertree", (String)"id, number,effmonth, effday, expmonth, expday,dseq", (QFilter[])new QFilter("model", "=", modelId).toArray());
    }

    public static Map<Long, DynamicObject> mapIdPeriod2Entity(Object modelId) {
        DynamicObject[] periods = EntityVersioningUtil.getPeriods(modelId);
        return Arrays.stream(periods).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public static Date getFilterDay(boolean isFirst, DynamicObject modelDo, String yearNum, DynamicObject periodDo) {
        int year = 0;
        try {
            year = Integer.parseInt(yearNum.substring(2));
            String beginyearofmonth = modelDo.getString("beginyearofmonth");
            if (FyEnum.PRE.index.equals(beginyearofmonth)) {
                --year;
            }
            int month = 0;
            int day = 0;
            if (isFirst) {
                month = periodDo.getInt("effmonth");
                day = periodDo.getInt("effday");
            } else {
                month = periodDo.getInt("expmonth");
                day = periodDo.getInt("expday");
            }
            return EntityVersioningUtil.getFilterDay(year, month, day);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date getFilterDay(int year, int month, int day) {
        try {
            String yearMonth = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month));
            String dateStr = yearMonth.concat("-").concat(day < 10 ? "0" + day : String.valueOf(day));
            try {
                return DateTimeUtils.parseDate((String)dateStr);
            }
            catch (ParseException e) {
                if (day == 29) {
                    dateStr = yearMonth.concat("-").concat(String.valueOf(--day));
                }
                return DateTimeUtils.parseDate((String)dateStr);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String checkChangetype(DynamicObjectCollection records, Object orgId, long modelId) {
        DynamicObjectCollection docs;
        DynamicObject oldRecord;
        if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (Object)orgId) && (oldRecord = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bcm_entitymembertree")) != null && (docs = oldRecord.getDynamicObjectCollection("bizchangerds")).size() == records.size()) {
            boolean needCheck = false;
            for (int i = 0; i < docs.size(); ++i) {
                if (((DynamicObject)docs.get(i)).getString("changetype").equals(((DynamicObject)records.get(i)).getString("changetype"))) continue;
                needCheck = true;
            }
            if (!needCheck) {
                return "";
            }
        }
        for (int i = records.size() - 1; i >= 0; --i) {
            String changetype = ((DynamicObject)records.get(i)).getString("changetype");
            if (i > 0) {
                if (((DynamicObject)records.get(i)).getLong("id") != 0L) continue;
                String beforeChangetype = ((DynamicObject)records.get(i - 1)).getString("changetype");
                if ((beforeChangetype.equals(OrgBizChangeTypeEnum.initNewlyAdded.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.mergerNewlyAdded.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.newAdd.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.newSetMergeEnable.getValue())) && (changetype.equals(OrgBizChangeTypeEnum.initNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.mergerNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newAdd.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newSetMergeEnable.getValue())) || EntityVersioningUtil.checkDefinedChangetype(beforeChangetype, changetype, modelId, "add")) {
                    return String.format(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u548c\u4e0a\u4e00\u6761\u8bb0\u5f55\u540c\u4e3a\u65b0\u589e\u7c7b\u578b\u3002", (String)"EntityVersioningUtil_2", (String)"fi-bcm-business", (Object[])new Object[0]), i + 1), new Object[0]);
                }
                if ((beforeChangetype.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()) || beforeChangetype.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue())) && (changetype.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue())) || EntityVersioningUtil.checkDefinedChangetype(beforeChangetype, changetype, modelId, "disposal")) {
                    return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u548c\u4e0a\u4e00\u6761\u8bb0\u5f55\u540c\u4e3a\u5904\u7f6e\u7c7b\u578b\u3002", (String)"EntityVersioningUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]), i + 1);
                }
                if (!beforeChangetype.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue())) continue;
                return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u201c\u6e05\u7b97\u540e\u91cd\u65b0\u56de\u8d2d\u65b0\u589e\u201d\u3002", (String)"EntityVersioningUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]), i + 1);
            }
            if (EntityVersioningUtil.isNewTypes(changetype, modelId)) continue;
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u9996\u6761\u8bb0\u5f55\u7684\u53d8\u66f4\u7c7b\u578b\u53ef\u9009\u9879\u4ec5\u4e3a\u201c\u7cfb\u7edf\u4e0a\u7ebf\u521d\u59cb\u5316\u65b0\u589e\u201d\u3001\u201c\u65b0\u8bbe\u5408\u5e76\u53d8\u66f4\u542f\u7528\u201d\uff0c\u4ee5\u53ca\u5408\u5e76\u8303\u56f4\u53d8\u52a8\u4e3a\u201c\u65b0\u589e\u201d\u7684\u4e1a\u52a1\u53d8\u66f4\u7c7b\u578b\u3002", (String)"EntityVersioningUtil_6", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static boolean isNewTypes(String code, long modelId) {
        Map<String, ChangeTypeModel> results = InvestServiceHelper.getInvChangetypeModel(modelId);
        Set ctNums = results.values().stream().filter(x -> !x.isdefault() && "1".equals(x.change())).map(x -> x.number()).collect(Collectors.toSet());
        return code.equals(OrgBizChangeTypeEnum.initNewlyAdded.getValue()) || code.equals(OrgBizChangeTypeEnum.newAdd.getValue()) || code.equals(OrgBizChangeTypeEnum.mergerNewlyAdded.getValue()) || code.equals(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue()) || code.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue()) || code.equals(OrgBizChangeTypeEnum.newSetMergeEnable.getValue()) || ctNums.contains(code);
    }

    public static boolean checkDefinedChangetype(String beforeChangetype, String changetype, long modelId, String flag) {
        Map<String, ChangeTypeModel> results = InvestServiceHelper.getInvChangetypeModel(modelId);
        if (results != null && results.size() >= 2) {
            String beforeChange = results.get(beforeChangetype).change();
            if (OrgBizChangeTypeEnum.initNewlyAdded.getValue().equals(beforeChangetype) || OrgBizChangeTypeEnum.newSetMergeEnable.getValue().equals(beforeChangetype)) {
                beforeChange = ChangeEnum.Increase.getIndex();
            }
            if (OrgBizChangeTypeEnum.newSetMergeDisable.getValue().equals(beforeChangetype) || ChangeEnum.Disable.getIndex().equals(beforeChange)) {
                beforeChange = ChangeEnum.Decrease.getIndex();
            }
            String change = results.get(changetype).change();
            if (OrgBizChangeTypeEnum.initNewlyAdded.getValue().equals(changetype) || OrgBizChangeTypeEnum.newSetMergeEnable.getValue().equals(changetype)) {
                change = ChangeEnum.Increase.getIndex();
            }
            if (OrgBizChangeTypeEnum.newSetMergeDisable.getValue().equals(changetype) || ChangeEnum.Disable.getIndex().equals(change)) {
                change = ChangeEnum.Decrease.getIndex();
            }
            if ("add".equals(flag) && ChangeEnum.Increase.getIndex().equals(beforeChange) && ChangeEnum.Increase.getIndex().equals(change)) {
                return true;
            }
            return "disposal".equals(flag) && ChangeEnum.Decrease.getIndex().equals(beforeChange) && ChangeEnum.Decrease.getIndex().equals(change);
        }
        return false;
    }

    public static boolean checkChildrenIsLiquidation(Object orgId) {
        QFilter filter = new QFilter("parent", "=", orgId);
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,bizchangerds.changetype", (QFilter[])new QFilter[]{filter}, (String)"dseq, bizchangerds.seq desc");
        ArrayList<String> isLiquidationList = new ArrayList<String>(10);
        ArrayList<String> notLiquidationList = new ArrayList<String>(10);
        for (DynamicObject tmp : children) {
            if (isLiquidationList.contains(tmp.getString("id")) || notLiquidationList.contains(tmp.getString("id"))) continue;
            if (tmp.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || tmp.getString("bizchangerds.changetype").equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue())) {
                isLiquidationList.add(tmp.getString("id"));
                continue;
            }
            notLiquidationList.add(tmp.getString("id"));
        }
        return notLiquidationList.size() > 0;
    }

    public static boolean checkParentIsLiquidation(Object orgId) {
        if ("0".equals(orgId.toString())) {
            return false;
        }
        QFilter filter = new QFilter("id", "=", orgId);
        DynamicObjectCollection parent = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"parent.number,parent.bizchangerds.changetype", (QFilter[])new QFilter[]{filter}, (String)"parent.bizchangerds.seq desc");
        if (parent.size() > 0) {
            DynamicObject lastRecord = (DynamicObject)parent.get(0);
            String changeType = lastRecord.getString("parent.bizchangerds.changetype");
            return !"Entity".equals(lastRecord.getString("parent.number")) && (OrgBizChangeTypeEnum.liquidationDisposal.getValue().equals(changeType) || OrgBizChangeTypeEnum.sameControlDisposal.getValue().equals(changeType));
        }
        return false;
    }

    public static Date getModelBeginDate(Object modelId) {
        return (Date)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("getModelBeginDate-" + modelId), () -> {
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,startfy,beginperiod,beginyearofmonth", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)modelId))});
            if (model == null) {
                return null;
            }
            return EntityVersioningUtil.getModelBeginDate(model);
        });
    }

    public static Date getModelBeginDate(DynamicObject model) {
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"EntityVersioningUtil_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        int firstYear = model.getInt("startfy") + 1997 - 1;
        int firstMonth = model.getInt("beginperiod");
        String beginYearType = model.getString("beginyearofmonth");
        if (FyEnum.PRE.index.equals(beginYearType)) {
            --firstYear;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, firstYear);
        cal.set(2, firstMonth - 1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Map<String, String> getOrgNameByFYAndPeriod(String cube, List<String> orgnums, String fy, String period, Long scenarioId) {
        String key = cube + fy + period + scenarioId;
        Map<String, String> res = (Map<String, String>)ThreadCache.get((Object)key, () -> EntityVersioningUtil.loadOrgNames(cube, orgnums, fy, period, scenarioId));
        if (res.keySet().containsAll(orgnums)) {
            return res;
        }
        res = EntityVersioningUtil.loadOrgNames(cube, orgnums, fy, period, scenarioId);
        ThreadCache.put((Object)key, res);
        return res;
    }

    public static Map<Long, String> getOrgNameByFYAndPeriodById(String cube, Long orgId, String fy, String period, Long scenarioId) {
        String key = cube + fy + period + scenarioId + "base";
        Map<Long, String> res = (Map<Long, String>)ThreadCache.get((Object)key, () -> EntityVersioningUtil.loadOrgNamesById(cube, orgId, fy, period, scenarioId));
        if (res.containsKey(orgId)) {
            return res;
        }
        res = EntityVersioningUtil.loadOrgNamesById(cube, orgId, fy, period, scenarioId);
        ThreadCache.put((Object)key, res);
        return res;
    }

    private static Map<String, String> loadOrgNames(String cube, List<String> orgnums, String fy, String period, Long scenarioId) {
        long modelId = MemberReader.findModelIdByNum((String)cube);
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.and("number", "in", orgnums);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,name,number", (QFilter[])qb.toArray());
        ArrayList<DynamicObject> docs = new ArrayList<DynamicObject>(Arrays.asList(objs));
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, (long)scenarioId, fy, (long)MemberReader.findPeriodMemberByNum((String)cube, (String)period).getId());
        EntityVersioningUtil.filterOrgsByMergeStruct(param, docs);
        HashMap<String, String> names = new HashMap<String, String>();
        docs.forEach(o -> names.put(o.getString("number"), o.getLocaleString("name").getLocaleValue()));
        return names;
    }

    private static Map<Long, String> loadOrgNamesById(String cube, long orgId, String fy, String period, Long scenarioId) {
        long modelId = MemberReader.findModelIdByNum((String)cube);
        QFBuilder qb = new QFBuilder();
        qb.add("model", "=", (Object)modelId);
        qb.and("id", "=", (Object)orgId);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,name,number", (QFilter[])qb.toArray());
        ArrayList<DynamicObject> docs = new ArrayList<DynamicObject>(Arrays.asList(objs));
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, (long)scenarioId, fy, (long)MemberReader.findPeriodMemberByNum((String)cube, (String)period).getId());
        EntityVersioningUtil.filterOrgsByMergeStruct(param, docs);
        HashMap<Long, String> names = new HashMap<Long, String>();
        docs.forEach(o -> names.put(o.getLong("id"), o.getLocaleString("name").getLocaleValue()));
        return names;
    }

    public static List<Long> getOrgsByVersion(long modelId, long sceneId, String yearNum, long periodId, List<Long> orgids) {
        HashSet<Long> orgsets = new HashSet<Long>();
        for (long orgid : orgids) {
            ArrayList<Long> pids = new ArrayList<Long>();
            EntityVersioningUtil.fixOrgTreeIds(MemberReader.findEntityMemberById((Long)modelId, (Long)orgid), pids);
            orgsets.addAll(pids);
        }
        ArrayList<Long> orgList = new ArrayList<Long>(orgsets);
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, sceneId, yearNum, periodId);
        Map<Long, String> effectiveOrg = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, orgList);
        orgList.removeAll(effectiveOrg.keySet());
        return orgList;
    }

    private static void fixOrgTreeIds(IDNumberTreeNode org, List<Long> pids) {
        if (DimTypesEnum.ENTITY.getNumber().equals(org.getNumber())) {
            return;
        }
        pids.add(org.getId());
        if (org.getParent() != null) {
            EntityVersioningUtil.fixOrgTreeIds(org.getParent(), pids);
        }
    }

    public static List<Long> getNameChangedOrg(long modelId) {
        DynamicObjectCollection allData = EntityVersioningUtil.queryNameChangedOrg(modelId);
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (DynamicObject tmp : allData) {
            idList.add(tmp.getLong("id"));
        }
        return idList;
    }

    public static DynamicObjectCollection queryNameChangedOrg(long modelId) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("namechangerds.nameexpdate", "is not null", null);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])qf.toArray());
        return orgs;
    }

    public static List<Long> filterVersionOrgTreeNodes(Map<Long, IDNumberTreeNode> orgTree, long modelId, Long sceneId, String yearNum, long periodId) {
        FilterOrgStructParam param = new FilterOrgStructParam(modelId, (long)sceneId, yearNum, periodId);
        Set<Long> orgIds = orgTree.keySet();
        Map<Long, String> filterEffectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(param, new ArrayList<Long>(orgIds));
        ArrayList<Long> removeNodes = new ArrayList<Long>(orgTree.size());
        orgIds.removeIf(p -> {
            if (filterEffectiveOrgMap.containsKey(p)) {
                EntityVersioningUtil.cacheOrgNameOnThread(p, (String)filterEffectiveOrgMap.get(p));
                EntityVersioningUtil.cacheOrgNameOnThread1(((IDNumberTreeNode)orgTree.get(p)).getNumber(), (String)filterEffectiveOrgMap.get(p));
                return false;
            }
            removeNodes.add((Long)p);
            return true;
        });
        return removeNodes;
    }

    public static Map<Long, String> getRealOrgNameOnThread() {
        return (Map)ThreadCache.get((Object)"orgrealnames", HashMap::new);
    }

    private static void cacheOrgNameOnThread(Long id, String name) {
        ((HashMap)ThreadCache.get((Object)"orgrealnames", HashMap::new)).put(id, name);
    }

    private static void cacheOrgNameOnThread1(String number, String name) {
        ((HashMap)ThreadCache.get((Object)"orgrealnames", HashMap::new)).put(number, name);
    }

    private static void cacheOrgNum2SimpleNumOnThread(String number, String simple) {
        if (StringUtils.isNotEmpty((CharSequence)number) && StringUtils.isNotEmpty((CharSequence)simple)) {
            ((HashMap)ThreadCache.get((Object)"orgNum2Simple", HashMap::new)).put(number, simple);
        }
    }

    public static Map<String, String> getNum2SimpleOnThread() {
        return (Map)ThreadCache.get((Object)"orgNum2Simple", HashMap::new);
    }

    private static String oldBizChangedType(String changetype) {
        switch (changetype) {
            case "2": 
            case "3": 
            case "5": 
            case "8": {
                changetype = "1";
                break;
            }
            case "4": 
            case "6": {
                changetype = "2";
                break;
            }
            default: {
                changetype = "0";
            }
        }
        return changetype;
    }

    @Deprecated
    private static Map<Long, String> filterOrgsByVersion(List<DynamicObject> doc, long modelId, String yearNum, long periodId, Map<Long, EntityChangeRecord> changeRecords, int from, FilterOrgStructParam param) {
        IDNumberTreeNode orgNode;
        Date lastDate;
        HashMap<Long, String> effectiveOrgMap = new HashMap<Long, String>(16);
        if (changeRecords.isEmpty()) {
            doc.clear();
            return effectiveOrgMap;
        }
        Date[] datePair = PeriodUtils.calcStartAndEndDate((long)modelId, (String)yearNum, (long)periodId);
        Date firstDate = datePair[0];
        Date date = lastDate = param.specialLastDate() == null ? datePair[1] : param.specialLastDate();
        if (firstDate == null || lastDate == null) {
            return effectiveOrgMap;
        }
        Map<String, ChangeTypeModel> bizChanges = InvestServiceHelper.getInvChangetypeModel(modelId);
        if (bizChanges == null || bizChanges.isEmpty()) {
            log.error("EntityVersioningUtil.filterVersionOrgTreeNodes()\uff1abizChanges is null");
            throw new KDBizException("entity bizchangerds is null");
        }
        String modelNumber = MemberReader.findModelNumberById((Object)param.getModelId());
        HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
        HashSet<Long> existSet = new HashSet<Long>(10);
        HashSet<Long> toDel = new HashSet<Long>(10);
        HashMap effBizRecMap = new HashMap(16);
        String checkOrgDisposal = ConfigServiceHelper.getStringParam(modelId, "isCheckOrgDisposal");
        HashBasedTable effRecordDictionary = HashBasedTable.create();
        for (Map.Entry<Long, EntityChangeRecord> entry : changeRecords.entrySet()) {
            long l = entry.getKey();
            orgNode = BcmThreadCache.findNodeById((String)modelNumber, (String)"Entity", (long)entry.getKey());
            if (CollectionUtil.isEmpty((Collection)entry.getValue().getBizChangeRecordList()) || CollectionUtil.isEmpty((Collection)entry.getValue().getNameRecordList())) {
                existSet.add(l);
                nameMap.put(l, orgNode.getName());
                continue;
            }
            entry.getValue().recordForEach(arg_0 -> EntityVersioningUtil.lambda$filterOrgsByVersion$36(orgNode, existSet, l, nameMap, toDel, lastDate, bizChanges, firstDate, from, checkOrgDisposal, effBizRecMap, param, (Table)effRecordDictionary, arg_0));
            if (!effBizRecMap.containsKey(l) || !existSet.add(l)) continue;
            List nameRecordList = entry.getValue().getNameRecordList();
            EntityNameRecord entityNameRecord = (EntityNameRecord)nameRecordList.get(nameRecordList.size() - 1);
            nameMap.put(l, entityNameRecord.getName());
            try {
                EntityVersioningUtil.cacheOrgNum2SimpleNumOnThread(orgNode.getNumber(), entityNameRecord.getSimpleName());
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            if (!param.isOpenSortedDictionary()) continue;
            effRecordDictionary.put((Object)orgNode.getNumber(), (Object)l, effBizRecMap.get(l));
        }
        HashSet<String> toDelInNotLeafLongNumbers = new HashSet<String>(16);
        for (Map.Entry<Long, EntityChangeRecord> entry : changeRecords.entrySet()) {
            IDNumberTreeNode node;
            Long recId = entry.getKey();
            orgNode = BcmThreadCache.findNodeById((String)modelNumber, (String)"Entity", (long)entry.getKey());
            String longNumber = orgNode.getLongNumber();
            if (!toDelInNotLeafLongNumbers.add(longNumber) || !toDel.contains(recId) && existSet.contains(recId) || orgNode.isLeaf() || (node = MemberReader.findEntityMemberById((String)modelNumber, (Long)recId)) == null) continue;
            for (IDNumberTreeNode child : node.getAllChildren()) {
                toDel.add(child.getId());
                effRecordDictionary.remove((Object)child.getNumber(), (Object)child.getId());
            }
        }
        String string = EntityVersioningUtil.getOrgKey("id", from);
        doc.removeIf(o -> {
            Long orgId = o.getLong(keyId);
            return toDel.contains(orgId) || !existSet.contains(orgId);
        });
        if (doc.isEmpty()) {
            return effectiveOrgMap;
        }
        EntityVersioningUtil.sortEffRecordDictionary((Table<String, Long, EntityBizRecord>)effRecordDictionary, param);
        DataEntityPropertyCollection dataEntityPropertyCollection = doc.get(0).getDataEntityType().getProperties();
        if (!(dataEntityPropertyCollection.containsKey((Object)"name") || dataEntityPropertyCollection.containsKey((Object)"entity") || dataEntityPropertyCollection.containsKey((Object)"org"))) {
            return effectiveOrgMap;
        }
        String keyNumber = EntityVersioningUtil.getOrgKey("number", from);
        String keyName = EntityVersioningUtil.getOrgKey("name", from);
        for (DynamicObject o2 : doc) {
            Long id = o2.getLong(string);
            String name1 = (String)nameMap.get(id);
            if (from == FilterOrgStructParam.FROM_COMMON && "Entity".equals(o2.getString(keyNumber))) {
                effectiveOrgMap.put(id, name1);
                continue;
            }
            if (name1 == null) continue;
            o2.set(keyName, (Object)name1);
            effectiveOrgMap.put(id, name1);
        }
        return effectiveOrgMap;
    }

    public static DynamicObjectCollection filterOrgsByVersion(DynamicObjectCollection doc, FilterOrgStructParam param) {
        if (doc.isEmpty()) {
            return doc;
        }
        long modelId = param.getModelId();
        long periodId = param.getPeriodId();
        String yearNum = param.getYearNum();
        Date[] datePair = PeriodUtils.calcStartAndEndDate((long)modelId, (String)yearNum, (long)periodId);
        Date firstDate = datePair[0];
        Date lastDate = datePair[1];
        if (firstDate == null || lastDate == null) {
            return new DynamicObjectCollection();
        }
        Map<String, ChangeTypeModel> bizChanges = InvestServiceHelper.getInvChangetypeModel(modelId);
        if (CollectionUtils.isEmpty(bizChanges.values())) {
            log.error("EntityVersioningUtil.filterVersionOrgTreeNodes()\uff1abizChanges is null");
            throw new KDBizException("entity bizchangerds is null");
        }
        HashSet<Long> toDel = new HashSet<Long>();
        Iterator iterator = doc.iterator();
        DynamicObjectCollection suitMembers = new DynamicObjectCollection();
        HashMap<Long, DynamicObject> effBizRecs = new HashMap<Long, DynamicObject>(16);
        while (iterator.hasNext()) {
            ChangeTypeModel bizCtModel;
            DynamicObject rec2 = (DynamicObject)iterator.next();
            long recId = rec2.getLong("id");
            String name = rec2.getString("name");
            Date bizEffDate = rec2.getDate("bizchangerds.bizeffdate");
            if (bizEffDate == null || name == null) {
                suitMembers.add((Object)rec2);
                continue;
            }
            Date bizExpDate = rec2.getDate("bizchangerds.bizexpdate");
            Date nameEffDate = rec2.getDate("namechangerds.nameeffdate");
            Date nameExpDate = rec2.getDate("namechangerds.nameexpdate");
            if (!EntityVersioningUtil.isBetweenDateRange(bizEffDate, bizExpDate, lastDate) || (bizCtModel = bizChanges.get(rec2.getString("bizchangerds.changetype"))) == null) continue;
            String bizCt = bizCtModel.getRealChangeType();
            if (bizCt.equals(OrgBizChangeTypeEnum.disable.getValue())) {
                toDel.add(recId);
                continue;
            }
            String changeType = bizCtModel.change();
            if ("2".equals(changeType) && DateTimeUtils.getYear((Date)firstDate) - DateTimeUtils.getYear((Date)bizEffDate) > 0) {
                toDel.add(recId);
                continue;
            }
            if (bizCt.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue()) && firstDate.compareTo(bizEffDate) > 0) {
                toDel.add(recId);
                continue;
            }
            effBizRecs.put(recId, rec2);
            if (nameEffDate == null || nameEffDate.compareTo(lastDate) > 0 || nameExpDate != null && nameExpDate.compareTo(lastDate) < 0) continue;
            suitMembers.add((Object)rec2);
        }
        Set ids = suitMembers.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        Iterator effMemsIt = effBizRecs.entrySet().iterator();
        while (effMemsIt.hasNext()) {
            Map.Entry next = effMemsIt.next();
            if (!ids.contains(next.getKey())) continue;
            effMemsIt.remove();
        }
        if (effBizRecs.size() > 0) {
            effBizRecs.forEach((k, v) -> {
                Optional<Object> dyOp = doc.stream().filter(x -> x.getLong("id") == k.longValue()).sorted(Comparator.comparing(x -> ((DynamicObject)x).getDate("namechangerds.nameeffdate").getTime()).reversed()).findFirst();
                if (dyOp.isPresent()) {
                    v.set("name", (Object)((DynamicObject)dyOp.get()).getString("name"));
                    suitMembers.add(v);
                }
            });
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        HashSet toDelInNotLeafLongNumbers = new HashSet();
        HashSet childIds = new HashSet(10);
        suitMembers.forEach(rec -> {
            IDNumberTreeNode node;
            Long recId = rec.getLong("id");
            String longNumber = rec.getString("longNumber");
            if (toDelInNotLeafLongNumbers.add(longNumber) && toDel.contains(recId) && !rec.getBoolean("isleaf") && (node = MemberReader.findEntityMemberById((String)modelNumber, (Long)recId)) != null) {
                for (IDNumberTreeNode child : node.getAllChildren()) {
                    childIds.add(child.getId());
                }
            }
        });
        suitMembers.removeIf(o -> {
            Long orgId = o.getLong("id");
            return childIds.contains(orgId);
        });
        return suitMembers;
    }

    private static /* synthetic */ void lambda$filterOrgsByVersion$36(IDNumberTreeNode orgNode, Set existSet, long recId, Map nameMap, Set toDel, Date lastDate, Map bizChanges, Date firstDate, int from, String checkOrgDisposal, Map effBizRecMap, FilterOrgStructParam param, Table effRecordDictionary, Pair item) {
        EntityBizRecord bizRec = (EntityBizRecord)item.p1;
        EntityNameRecord nameRec = (EntityNameRecord)item.p2;
        String name = nameRec.getName();
        String number = orgNode.getNumber();
        Date bizEffDate = bizRec.getBizEffDate();
        if (bizEffDate == null || name == null) {
            existSet.add(recId);
            nameMap.put(recId, orgNode.getName());
            return;
        }
        if (existSet.contains(recId) || toDel.contains(recId)) {
            return;
        }
        Date bizExpDate = bizRec.getBizExpDate();
        Date nameEffDate = nameRec.getNameEffDate();
        Date nameExpDate = nameRec.getNameExpDate();
        if (EntityVersioningUtil.isBetweenDateRange(bizEffDate, bizExpDate, lastDate)) {
            ChangeTypeModel bizCtModel = (ChangeTypeModel)bizChanges.get(bizRec.getChangType());
            if (bizCtModel == null) {
                return;
            }
            String bizCt = bizCtModel.getRealChangeType();
            if (bizCt.equals(OrgBizChangeTypeEnum.disable.getValue())) {
                toDel.add(recId);
                return;
            }
            String changeType = bizCtModel.change();
            if (ChangeEnum.Decrease.getIndex().equals(changeType) && DateTimeUtils.getYear((Date)firstDate) - DateTimeUtils.getYear((Date)bizEffDate) > 0) {
                toDel.add(recId);
                return;
            }
            if (from == FilterOrgStructParam.FROM_CHECKELIM && (bizCt.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || bizCt.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()))) {
                if ("1".equals(checkOrgDisposal)) {
                    toDel.add(recId);
                    return;
                }
                if ("0".equals(checkOrgDisposal) || "".equals(checkOrgDisposal)) {
                    if (firstDate.compareTo(bizEffDate) > 0) {
                        toDel.add(recId);
                        return;
                    }
                } else if ("2".equals(checkOrgDisposal) && DateTimeUtils.getYear((Date)firstDate) - DateTimeUtils.getYear((Date)bizEffDate) > 0) {
                    toDel.add(recId);
                    return;
                }
            }
            if (from == FilterOrgStructParam.FROM_REPORT_SAME && bizCt.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()) && firstDate.compareTo(bizEffDate) > 0) {
                toDel.add(recId);
                return;
            }
            if ((ChangeEnum.Disable.getIndex().equals(changeType) || bizCt.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue())) && firstDate.compareTo(bizEffDate) > 0) {
                toDel.add(recId);
                return;
            }
            effBizRecMap.put(recId, bizRec);
            if (nameEffDate != null && nameEffDate.compareTo(lastDate) <= 0 && (nameExpDate == null || nameExpDate.compareTo(lastDate) >= 0)) {
                existSet.add(recId);
                nameMap.put(recId, name);
                try {
                    EntityVersioningUtil.cacheOrgNum2SimpleNumOnThread(number, nameRec.getSimpleName());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                if (param.isOpenSortedDictionary()) {
                    effRecordDictionary.put((Object)number, (Object)recId, (Object)bizRec);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$filterOrgsByVersionNew$9(String modelNum, Map effectiveOrgMap, Comparator bizchangeComparator, Comparator namechangeComparator, Date firstDate, Date lastDate, Map bizChanges, Table allMerge, int from, boolean isCheckStructInfo, boolean isCalDayArchitect, long modelId, FilterOrgStructParam param, Table effRecordDictionary, Long orgId, EntityChangeRecord changeRecord) {
        LinkedList entityBizRecords = new LinkedList(changeRecord.getBizChangeRecordList());
        LinkedList entityNameRecords = new LinkedList(changeRecord.getNameRecordList());
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNum, (String)"Entity", (long)orgId);
        if (CollectionUtil.isEmpty(entityBizRecords) || CollectionUtil.isEmpty(entityNameRecords)) {
            effectiveOrgMap.put(orgId, IDNumberTreeNode.NotFoundTreeNode == orgNode ? null : orgNode.getName());
            return;
        }
        entityBizRecords.sort(bizchangeComparator);
        entityNameRecords.sort(namechangeComparator);
        Optional<EntityBizRecord> bizRecordOpt = entityBizRecords.stream().filter(e -> EntityVersioningUtil.isSuitableRecord(e.getBizEffDate(), e.getBizExpDate(), firstDate, lastDate)).findFirst();
        Optional<Object> nameRecordOpt = entityNameRecords.stream().filter(e -> EntityVersioningUtil.isSuitableRecord(e.getNameEffDate(), e.getNameExpDate(), firstDate, lastDate)).findFirst();
        if (!nameRecordOpt.isPresent()) {
            nameRecordOpt = Optional.ofNullable(entityNameRecords.get(entityNameRecords.size() - 1));
        }
        EntityBizRecord defBizRecord = bizRecordOpt.orElseGet(() -> (EntityBizRecord)entityBizRecords.get(0));
        EntityNameRecord defNameRecord = nameRecordOpt.orElseGet(() -> (EntityNameRecord)entityNameRecords.get(0));
        ChangeTypeModel bizCt = (ChangeTypeModel)bizChanges.get(defBizRecord.getChangType());
        String name = defNameRecord.getName();
        if (bizCt == null) {
            effectiveOrgMap.put(orgId, name);
        } else {
            String number = IDNumberTreeNode.NotFoundTreeNode == orgNode ? "" : orgNode.getNumber();
            String parentNumber = IDNumberTreeNode.NotFoundTreeNode == orgNode.getParent() || orgNode.getParent() == null ? "" : orgNode.getParent().getNumber();
            Boolean isMergeStruct = EntityVersioningUtil.queryDefaultMergeStruct((Table<String, String, Boolean>)allMerge, from, parentNumber, number);
            Boolean isEffectiveOrg = isCheckStructInfo && isMergeStruct != false;
            if (bizRecordOpt.isPresent() && nameRecordOpt.isPresent()) {
                Date bizEffDate = defBizRecord.getBizEffDate();
                isEffectiveOrg = isEffectiveOrg != false || EntityVersioningUtil.isRightOrgVersion(firstDate, bizEffDate, bizCt, isCalDayArchitect);
                isEffectiveOrg = EntityVersioningUtil.isSpecialRightOrgVersion(modelId, firstDate, bizEffDate, bizCt, from, isEffectiveOrg);
            }
            if (isEffectiveOrg.booleanValue()) {
                try {
                    EntityVersioningUtil.cacheOrgNum2SimpleNumOnThread(number, defNameRecord.getSimpleName());
                }
                catch (Exception e2) {
                    log.error((Throwable)e2);
                }
                effectiveOrgMap.put(orgId, name);
                if (param.isOpenSortedDictionary()) {
                    effRecordDictionary.put((Object)number, (Object)orgId, (Object)defBizRecord);
                }
            }
        }
    }
}

