/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

public class ModelDataClearUtils {
    private static WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelDataClearUtils.class);
    private static final String[] modelTypes = new String[]{"BillFormModel", "BaseFormModel"};
    private static final List<String> ignoreEntitys = Arrays.asList("bcm_checkrecord_inh", "bcm_epmclient_info", "bcm_invcasepagedimrun", "bcm_tdp_datacenter");

    public static Set<String> getAllEntityTable() {
        QFBuilder qf = new QFBuilder("bizappid.number", "=", (Object)ApplicationTypeEnum.CM.getAppnum());
        qf.add("id", "like", (Object)"bcm_%");
        qf.add("id", "not like", (Object)"bcm_eb_%");
        qf.add("id", "not in", (Object)new String[]{"bcm_currencytmpl", "bcm_analysischart", "bcm_analysischartaccount", "bcm_analysisthemetype"});
        qf.add("modeltype", "in", (Object)modelTypes);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_entityobject", (String)"id", (QFilter[])qf.toArray());
        HashSet<String> tableEntitys = new HashSet<String>();
        for (DynamicObject dy : doc) {
            tableEntitys.add(dy.getString("id"));
        }
        return tableEntitys;
    }

    public static void clearModelData(long modelId) {
        ModelDataClearUtils.clearModels(modelId);
    }

    public static void clearModels(Object ... modelId) {
        Set<String> forms = ModelDataClearUtils.getAllEntityTable();
        QFilter filter = null;
        for (String entity : forms) {
            if (ignoreEntitys.contains(entity)) continue;
            if (!"bcm_icmembertree".equals(entity)) {
                try {
                    String table = EntityMetadataCache.getDataEntityType((String)entity).getAlias();
                    if (StringUtils.isEmpty((String)entity) || !DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)table)) continue;
                    DataEntityPropertyCollection dy = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
                    List modelList = dy.stream().filter(x -> x instanceof BasedataProp && ((BasedataProp)x).getBaseEntityId().equals("bcm_model") && StringUtils.isNotEmpty((String)x.getAlias())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(modelList)) {
                        filter = new QFilter(((IDataEntityProperty)modelList.get(0)).getName(), "in", (Object)modelId);
                    } else if (dy.get((Object)"taskcatalog.model") != null) {
                        filter = new QFilter("taskcatalog.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"template.model") != null) {
                        filter = new QFilter("template.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"noteinfo.model") != null) {
                        filter = new QFilter("noteinfo.model", "in", (Object)modelId);
                    } else if (dy.get((Object)"modelid") != null) {
                        filter = new QFilter("modelid", "in", (Object)modelId);
                    } else if (dy.get((Object)"issueid") != null) {
                        filter = new QFilter("issueid", "in", (Object)modelId);
                    } else if (dy.get((Object)"guidemenuids.model") != null) {
                        filter = new QFilter("guidemenuids.model", "in", (Object)modelId);
                    } else if ("bcm_rateplanscenes".equals(entity)) {
                        filter = new QFilter("scene.model", "in", (Object)modelId);
                    } else {
                        QFilter qf;
                        DynamicObjectCollection modelNums;
                        if (!"bcm_extenddata".equals(entity) && !"bcm_extenddata_bus".equals(entity) || (modelNums = QueryServiceHelper.query((String)"bcm_model", (String)"id, shownumber", (QFilter[])(qf = new QFilter("id", "in", (Object)modelId)).toArray())) == null || modelNums.isEmpty()) continue;
                        Set shownumbers = modelNums.stream().map(x -> x.getString("shownumber")).collect(Collectors.toSet());
                        filter = new QFilter("modelnumber", "in", shownumbers);
                    }
                    LOG.info(String.format("model_transfer_rollback clear data: %s, begin", entity));
                    DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{filter});
                }
                catch (Exception e) {
                    LOG.error(String.format("model_transfer_rollback clear data: %s, error", entity), (Throwable)e);
                }
                continue;
            }
            try {
                List mIds = Arrays.stream(modelId).map(x -> String.valueOf(x)).collect(Collectors.toList());
                String modelStr = String.join((CharSequence)",", mIds);
                String sql = "delete from t_bcm_structoficentity where fmodelid in (" + modelStr + ")";
                LOG.info("model_transfer_rollback clear data: t_bcm_structoficentity, begin");
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql);
                String sql_l = "delete from t_bcm_structoficentity_l where fid in (select fid from t_bcm_structoficentity where fmodelid in (" + modelStr + "))";
                LOG.info("model_transfer_rollback clear data: t_bcm_structoficentity_l, begin");
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql_l);
            }
            catch (Exception e) {
                LOG.error("model_transfer_rollback clear data: t_bcm_structoficentity, error", (Throwable)e);
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_model"), (Object[])modelId);
    }

    public static void deleteModel(long modelId) {
        Object[] objs = new Object[]{modelId};
        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_model"), (Object[])objs);
    }

    public static void reMoveCatalogCache(String catalog) {
        AppCache.get((String)"_bcm.").remove(catalog);
        GlobalCacheServiceHelper.invalidateAnyCache((CacheTypeEnum)CacheTypeEnum.CommonCache);
        MQMessagePublisherServiceHelper.publishClearAllCacheByType(CacheTypeEnum.CommonCache);
    }

    public static void clearCubes(DynamicObjectCollection numbers) {
        numbers.iterator().forEachRemaining(obj -> {
            String cubeName = obj.getString("number");
            if (OlapServiceHelper.isExistCube(cubeName)) {
                OlapServiceHelper.dropCubeSchemes(cubeName);
            }
        });
    }

    public static void deleteEpbsTableDatas(DynamicObject[] dys, List<String> entitys) {
        QFilter filter = null;
        Set<Object> modelIds = Arrays.stream(dys).map(x -> x.getPkValue()).collect(Collectors.toSet());
        if (modelIds.size() == 0) {
            return;
        }
        for (String entity : entitys) {
            String table = EntityMetadataCache.getDataEntityType((String)entity).getAlias();
            if (StringUtils.isEmpty((String)entity) || !DB.exitsTable((DBRoute)BCMConstant.EPM, (String)table)) continue;
            if ("epbs_preset_param".equals(entity)) {
                ModelDataClearUtils.updateEpbsParams(entity, modelIds);
                continue;
            }
            DataEntityPropertyCollection dy = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
            List modelList = dy.stream().filter(x -> x instanceof BasedataProp && ((BasedataProp)x).getBaseEntityId().equals("bcm_model") && StringUtils.isNotEmpty((String)x.getAlias())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(modelList)) continue;
            filter = new QFilter(((IDataEntityProperty)modelList.get(0)).getName(), "in", modelIds);
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{filter});
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"epbs_model"), (Object[])modelIds.toArray(new Object[0]));
    }

    private static void updateEpbsParams(String entity, Set<Object> modelIds) {
        QFilter qf = new QFilter("entryentity.model", "in", modelIds);
        DynamicObjectCollection paramDys = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])qf.toArray());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)paramDys)) {
            return;
        }
        Set ids = paramDys.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        QFilter qf1 = new QFilter("id", "in", ids);
        qf1.and("entryentity.model", "in", modelIds);
        DynamicObjectCollection saveDys = QueryServiceHelper.query((String)entity, (String)"entryentity.id", (QFilter[])qf1.toArray());
        if (saveDys.size() > 0) {
            Set entryIds = saveDys.stream().map(x -> x.getString("entryentity.id")).collect(Collectors.toSet());
            String entryTable = ((EntityType)EntityMetadataCache.getDataEntityType((String)"epbs_preset_param").getAllEntities().get("entryentity")).getAlias();
            StringBuilder sbIds = new StringBuilder(100);
            for (String pk : entryIds) {
                sbIds.append(pk);
                sbIds.append(",");
            }
            sbIds.replace(sbIds.length() - 1, sbIds.length(), "");
            String sql = "delete from " + entryTable + " where fentryid in (" + sbIds + ");";
            DB.execute((DBRoute)DBRoute.of((String)CloudTypeEnum.EPM.name()), (String)sql);
        }
    }
}

