/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.dimension.util;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ModelUtil {
    @SDKMark
    public static ApplicationTypeEnum queryApp(IFormView view) {
        ApplicationTypeEnum application = ApplicationTypeEnum.CM;
        String appnumber = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appnumber)) {
            return application;
        }
        return ApplicationTypeEnum.getEnumByNumber((String)appnumber);
    }

    public static QFilter getModelQfilterByApp(IFormView view) {
        ApplicationTypeEnum application = ModelUtil.queryApp(view);
        QFilter qcf = new QFilter("ReportType", "=", (Object)application.getOIndex());
        switch (application) {
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                break;
            }
            case IEP: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex());
                break;
            }
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex());
                break;
            }
            case BGC: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
        }
        return qcf;
    }

    public static boolean isFirstYear(Long modelId, Long currentYearId) {
        DynamicObject yearObject = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"dseq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentYearId)});
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dseq", "<", yearObject.get("dseq")).and("number", "like", (Object)"FY%");
        DynamicObjectCollection beforeYears = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"dseq desc", (int)1);
        return CollectionUtils.isEmpty((Collection)beforeYears);
    }
}

