/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.disclosure;

import java.util.ArrayList;
import kd.fi.bcm.business.disclosure.model.BCMMemberTreeNode;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class BCMMemberHelper {
    public static BCMMemberTreeNode findMemberByNumber(String modelNum, String dimNum, String number) {
        IDNumberTreeNode treeNode = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
        if (treeNode == null || treeNode == IDNumberTreeNode.NotFoundTreeNode) {
            return null;
        }
        return BCMMemberHelper.convertTo(treeNode, true, true);
    }

    private static BCMMemberTreeNode convertTo(IDNumberTreeNode treeNode, boolean parent, boolean children) {
        BCMMemberTreeNode parentMember;
        if (treeNode == null || treeNode == IDNumberTreeNode.NotFoundTreeNode) {
            return null;
        }
        BCMMemberTreeNode newBcmMember = new BCMMemberTreeNode();
        newBcmMember.setId(treeNode.getId());
        newBcmMember.setNumber(treeNode.getNumber());
        newBcmMember.setName(treeNode.getName());
        newBcmMember.setLongNumber(treeNode.getLongNumber());
        newBcmMember.setdSeq(treeNode.getdSeq());
        newBcmMember.setLevel(treeNode.getLevel());
        newBcmMember.setLeaf(treeNode.isLeaf());
        newBcmMember.setShare(treeNode.isShare());
        if (parent && (parentMember = BCMMemberHelper.convertTo(treeNode.getParent(), false, false)) != null) {
            newBcmMember.setParent(parentMember);
        }
        if (children) {
            ArrayList<BCMMemberTreeNode> childList = new ArrayList<BCMMemberTreeNode>(treeNode.getChildren().size());
            for (IDNumberTreeNode child : treeNode.getChildren()) {
                BCMMemberTreeNode childMember = BCMMemberHelper.convertTo(child, false, false);
                if (childMember == null) continue;
                childList.add(childMember);
            }
            newBcmMember.setChildren(childList);
        }
        return newBcmMember;
    }
}

