/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.disclosure;

import com.google.common.collect.HashMultimap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.map.MultiKeyMap;

public class DatasetServiceHelper {
    public static final String ORG_RELA_SIGN = "_";

    public static String getDimMembEntityNumByDimNum(String dimNum, Boolean isbcm) {
        switch (dimNum.toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                if (isbcm.booleanValue()) {
                    return "bcm_entitymembertree";
                }
                return "epm_entitymembertree";
            }
            case "account": {
                if (isbcm.booleanValue()) {
                    return "bcm_accountmembertree";
                }
                return "epm_accountmembertree";
            }
            case "year": {
                if (isbcm.booleanValue()) {
                    return "bcm_fymembertree";
                }
                return "epm_yearmembertree";
            }
            case "period": {
                if (isbcm.booleanValue()) {
                    return "bcm_periodmembertree";
                }
                return "epm_periodmembertree";
            }
            case "budgetperiod": {
                return "epm_bperiodmembertree";
            }
            case "scenario": {
                if (isbcm.booleanValue()) {
                    return "bcm_scenemembertree";
                }
                return "epm_scenemembertree";
            }
            case "process": {
                if (isbcm.booleanValue()) {
                    return "bcm_processmembertree";
                }
                return "epm_processmembertree";
            }
            case "currency": {
                if (isbcm.booleanValue()) {
                    return "bcm_currencymembertree";
                }
                return "epm_currencymembertree";
            }
            case "audittrail": {
                if (isbcm.booleanValue()) {
                    return "bcm_audittrialmembertree";
                }
                return "epm_audittrialmembertree";
            }
            case "changetype": {
                if (isbcm.booleanValue()) {
                    return "bcm_changetypemembertree";
                }
                return "epm_changetypemembertree";
            }
            case "internalcompany": {
                if (isbcm.booleanValue()) {
                    return "bcm_icmembertree";
                }
                return "epm_icmembertree";
            }
            case "multigaap": {
                return "bcm_rulemembertree";
            }
            case "version": {
                if (isbcm.booleanValue()) {
                    return "bcm_eb_versionmembertree";
                }
                return "epm_versionmembertree";
            }
            case "datatype": {
                if (isbcm.booleanValue()) {
                    return "eb_datetypemembertree";
                }
                return "epm_datatypemembertree";
            }
            case "datasort": {
                return "bcm_datasortmembertree";
            }
            case "mycompany": {
                return "bcm_mycompanymembertree";
            }
            case "metric": {
                if (isbcm.booleanValue()) {
                    return "epm_metricmembertree";
                }
                return "eb_metricmembertree";
            }
            case "extends": {
                return "bcm_structofextend";
            }
            case "bperiod": {
                return "epm_bperiodmembertree";
            }
        }
        if (isbcm.booleanValue()) {
            return "bcm_userdefinedmembertree";
        }
        return "epm_userdefinedmembertree";
    }

    public static MultiKeyMap getmenberNameMap(HashMultimap<String, String> dim2MembMap, String modelNum) {
        Map dim2members = dim2MembMap.asMap();
        MultiKeyMap map = new MultiKeyMap();
        QFilter modelqf = new QFilter("number", "=", (Object)modelNum);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id,number", (QFilter[])modelqf.toArray());
        for (Map.Entry data : dim2members.entrySet()) {
            String entity = DatasetServiceHelper.getDimMembEntityNumByDimNum((String)data.getKey(), true);
            DynamicObject dim = QueryDimensionServiceHelper.getDMDimByNumber((String)data.getKey(), model.getLong("id"), "bcm_dimension");
            QFBuilder qf = new QFBuilder("number", "in", data.getValue());
            qf.and("dimension", "=", (Object)dim.getLong("id"));
            qf.and("model", "=", (Object)model.getLong("id"));
            DynamicObjectCollection allmembers = QueryServiceHelper.query((String)entity, (String)"id,number,name", (QFilter[])qf.toArray());
            allmembers.forEach(s -> map.put(data.getKey(), (Object)s.getString("number"), (Object)s.getString("name")));
        }
        return map;
    }
}

