/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.disclosure.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.disclosure.enums.FormulaExceptionEnum;
import kd.fi.bcm.business.disclosure.model.DataSetResult;
import org.apache.poi.ss.formula.functions.T;

public class DataSetArrangeUtil {
    public void sort(String isPositiveSequence, List<DataSetResult> dataSetResults) {
        if (CollectionUtils.isEmpty(dataSetResults) || dataSetResults.size() < 2) {
            return;
        }
        if (dataSetResults.get(0).getOrderList().size() == 0) {
            return;
        }
        boolean isPositive = "1".equals(isPositiveSequence);
        Collections.sort(dataSetResults, (dataSetResult1, dataSetResult2) -> {
            List<String> orderList1 = dataSetResult1.getOrderList();
            List<String> orderList2 = dataSetResult2.getOrderList();
            int compareRes = 0;
            for (int i = 0; i < orderList1.size(); ++i) {
                compareRes = orderList1.get(i).compareTo(orderList2.get(i));
                if (compareRes == 0) continue;
                if (isPositive) {
                    return compareRes;
                }
                return 0 - compareRes;
            }
            return compareRes;
        });
    }

    public List<DataSetResult> groupbySum(List<DataSetResult> dataSetResults) {
        HashMap<String, DataSetResult> dataSetMap = new HashMap<String, DataSetResult>();
        String key = null;
        for (DataSetResult dataSetResult : dataSetResults) {
            key = this.getGroupKey(dataSetResult.getGroupList());
            if (dataSetMap.containsKey(key)) {
                this.addMeasure((DataSetResult)dataSetMap.get(key), dataSetResult);
                continue;
            }
            dataSetMap.put(key, dataSetResult);
        }
        return Lists.newArrayList(dataSetMap.values());
    }

    public List<DataSetResult> groupbyAvg(List<DataSetResult> dataSetResults) {
        return null;
    }

    public List<DataSetResult> groupbyMax(List<DataSetResult> dataSetResults) {
        return null;
    }

    public List<DataSetResult> groupbyMin(List<DataSetResult> dataSetResults) {
        return null;
    }

    private void addMeasure(DataSetResult dataSetResultSelf, DataSetResult dataSetResultAdd) {
        List<String> measureListSelf = dataSetResultSelf.getMeasureList();
        List<String> measureListAdd = dataSetResultAdd.getMeasureList();
        String measureStr = null;
        try {
            for (int i = 0; i < measureListSelf.size(); ++i) {
                measureStr = measureListSelf.get(i);
                BigDecimal bd = new BigDecimal(measureStr);
                measureListSelf.set(i, bd.add(new BigDecimal(measureListAdd.get(i))).toString());
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(FormulaExceptionEnum.MEASURE_NOT_NUMBER.getName(), measureStr));
        }
    }

    private String getGroupKey(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            sb.append(str);
        }
        return sb.toString();
    }

    public <T> T getResultByDataSet(List<String> selectAttrList, List<DataSetResult> dataSets, Integer top, List<String> measureAttrList) {
        LinkedList result = new LinkedList();
        LinkedHashMap<String, String> map = null;
        DataSetResult dataSetResult = null;
        List<String> groupList = null;
        List<String> measureList = null;
        for (int i = 0; i < dataSets.size(); ++i) {
            int j;
            dataSetResult = dataSets.get(i);
            groupList = dataSetResult.getGroupList();
            measureList = dataSetResult.getMeasureList();
            map = new LinkedHashMap<String, String>(16);
            for (j = 0; j < groupList.size(); ++j) {
                map.put(selectAttrList.get(j), groupList.get(j));
            }
            for (j = 0; j < measureList.size(); ++j) {
                map.put(measureAttrList.get(j), measureList.get(j));
            }
            result.add(map);
            top = top - 1;
            if (top == 0) break;
        }
        return (T)result;
    }

    public List<DataSetResult> turnDataSetFromObject(T t) {
        return null;
    }
}

