/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.disclosure.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.fi.bcm.business.disclosure.model.CurrencyDto;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;

public class DmCurrencyUtil {
    private static final String DC = "DC";
    private static final String EC = "EC";
    private static final String PC = "PC";
    private static final List<String> presetCurrencys = Lists.newArrayList((Object[])new String[]{"DC", "EC", "PC"});
    public static final String ORG_RELA_SIGN = "_";
    private static final List<String> presetProcess = Lists.newArrayList((Object[])new String[]{"CCTotal", "CCADJ", "CC", "EJE", "PRPT", "CADJ", "ARPT", "ADJ", "Rpt", "IRpt", "RAdj"});
    private static final List<String> changeentityprocess = Lists.newArrayList((Object[])new String[]{"ERpt", "EIRpt", "ERAdj", "Rpt", "IRpt", "RAdj"});

    public static MultiKeyMap handleECDC(String cubeNumber, List<String> entitys, List<String> currencys, List<String> processs, Boolean bpall) {
        MultiKeyMap currencyresult = new MultiKeyMap();
        String[] myentitys = entitys.toArray(new String[0]);
        HashSet<String> addOrgs = new HashSet<String>(entitys.size());
        if (currencys.contains(DC) && bpall == Boolean.TRUE) {
            for (String s : entitys) {
                if (!s.contains(ORG_RELA_SIGN)) continue;
                int index = s.indexOf(ORG_RELA_SIGN);
                addOrgs.add(s.substring(index + 1));
            }
        }
        entitys.addAll(addOrgs);
        for (int i = 0; i < myentitys.length; ++i) {
            if (processs.size() == 0 && bpall == Boolean.FALSE) {
                processs.add("");
            }
            for (String process : processs) {
                String enetitynumber = myentitys[i];
                HashSet<Object> mycurency = new HashSet<Object>(currencys.size());
                for (String currencynumber : currencys) {
                    enetitynumber = myentitys[i];
                    IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)cubeNumber, (String)enetitynumber);
                    if (PC.equalsIgnoreCase(currencynumber) && !enetitynumber.contains(ORG_RELA_SIGN) || presetProcess.contains(process) && DC.equalsIgnoreCase(currencynumber) && !enetitynumber.contains(ORG_RELA_SIGN)) continue;
                    if (presetCurrencys.contains(currencynumber.toUpperCase())) {
                        Pair<String, String> transCur = TransMemberUtil.transOrgAndCurbyOrgId(cubeNumber, (long)entityNode.getId(), process, currencynumber, 0L, 0L);
                        if (transCur != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)transCur.p2))) {
                            mycurency.add(transCur.p2);
                        }
                    } else {
                        mycurency.add(currencynumber);
                    }
                    if (!changeentityprocess.contains(process) || !DC.equalsIgnoreCase(currencynumber) || !enetitynumber.contains(ORG_RELA_SIGN)) continue;
                    enetitynumber = entityNode.getNumber();
                    entitys.set(i, enetitynumber);
                }
                Object c = currencyresult.get((Object)enetitynumber, (Object)process);
                if (Objects.nonNull(c)) {
                    mycurency.addAll((Collection)c);
                }
                if (mycurency.size() <= 0) continue;
                currencyresult.put((Object)enetitynumber, (Object)process, mycurency);
            }
        }
        return currencyresult;
    }

    public static List<CurrencyDto> convertTo(MultiKeyMap<String, Object> multiKeyMap) {
        ArrayList<CurrencyDto> dtoList = new ArrayList<CurrencyDto>(multiKeyMap.size());
        for (Map.Entry entry : multiKeyMap.entrySet()) {
            CurrencyDto currencyDto = new CurrencyDto();
            currencyDto.setEntity((String)((MultiKey)entry.getKey()).getKey(0));
            currencyDto.setProcess((String)((MultiKey)entry.getKey()).getKey(1));
            currencyDto.setCurrencyList((Set)entry.getValue());
            dtoList.add(currencyDto);
        }
        return dtoList;
    }
}

