/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.exchangeRate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.ctx.RateFormulaProvider;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.util.QCfilterUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.PeriodTypeEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ExchageRateServiceHelper {
    private static Map<String, String> columns = new HashMap<String, String>();
    private static Map<String, String> fieldMapping;

    public static void saveExchangeRate(List<Pair<String, String>> pairs, DynamicObject row, String property, BigDecimal rate, String modelNumber) {
        SaveCommandInfo info = new SaveCommandInfo();
        ExchageRateServiceHelper.addFiexdDimension(info, pairs);
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String[] dimKey = new String[]{DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.CURRENCY.getNumber()};
        info.setDimensions(dimKey);
        String[] rowDomain = new String[]{columns.get(property), row.getDynamicObject("source").getString("number"), row.getDynamicObject("target").getString("number")};
        CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        cellSets.set(rowDomain, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)rate);
        OlapServiceHelper.saveData(info, cellSets, modelNumber);
    }

    public static void saveExchangeRate4Rows(List<Pair<String, String>> pairs, List<DynamicObject> rows, String property, String modelNumber, boolean isDelete, Set<String> sceneNumbers, OlapSourceEnum sourceEnum) {
        if (rows.isEmpty()) {
            return;
        }
        SaveCommandInfo info = new SaveCommandInfo();
        ExchageRateServiceHelper.addFiexdDimension(info, pairs);
        String account = columns.get(property);
        account = account == null ? property : account;
        info.addfixedDimension(new String[]{DimTypesEnum.ACCOUNT.getNumber(), account});
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommandUtil.addSourceMeasure((String)modelNumber, (CommandInfo)info, (OlapSourceEnum)sourceEnum);
        ArrayList dimKeys = Lists.newArrayList((Object[])new String[]{DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.SCENARIO.getNumber()});
        info.setDimensions(dimKeys.toArray(new String[0]));
        CellSet cellSets = new CellSet(dimKeys.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (String scenenum : sceneNumbers) {
            for (DynamicObject row : rows) {
                ArrayList rowDomain = Lists.newArrayList();
                if (StringUtils.isEmpty((CharSequence)row.getString("source.number")) || StringUtils.isEmpty((CharSequence)row.getString("target.number"))) continue;
                rowDomain.add(row.getString("source.number"));
                rowDomain.add(row.getString("target.number"));
                rowDomain.add(scenenum);
                if (isDelete) {
                    cellSets.set(rowDomain.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                    continue;
                }
                cellSets.set(rowDomain.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)row.getBigDecimal(property.toLowerCase(Locale.ENGLISH)).setScale(15, RoundingMode.HALF_UP));
            }
        }
        OlapServiceHelper.saveData(info, cellSets, modelNumber, false);
    }

    private static void addFiexdDimension(SaveCommandInfo info, List<Pair<String, String>> pairs) {
        for (Pair<String, String> t : pairs) {
            info.addfixedDimension(new String[]{(String)t.p1, (String)t.p2});
        }
    }

    public static void delExchangeRatePlanFilter(QFilter filter, String membermodel) {
        if (filter == null) {
            return;
        }
        if ("bcm_entitymembertree".equals(membermodel)) {
            filter.and(new QFilter("isexchangerate", "=", (Object)"0"));
        } else if ("bcm_eb_versionmember".equals(membermodel)) {
            filter.and(new QFilter("isactual", "!=", (Object)"1"));
        } else if ("bcm_eb_versionmembertree".equals(membermodel)) {
            // empty if block
        }
    }

    public static boolean ifOrgHaveChildExceptExc(Object id) {
        boolean isFalse = false;
        QFBuilder qf = new QFBuilder();
        qf.add("parent", "=", id);
        qf.add("isexchangerate", "=", (Object)isFalse);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])qf.toArray());
        return obj != null;
    }

    public static Map<String, IDNumberTreeNode> getUserdefinedrateAccount(long modelId) {
        IDNumberTreeNode accountNode;
        if (modelId != 0L && (accountNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"Account", (String)"ExchangeRate")) != IDNumberTreeNode.NotFoundTreeNode) {
            return accountNode.getBaseTreeNode().getChildren().stream().filter(e -> ExchageRateServiceHelper.isuserdefinedAcct(e.getNumber())).collect(Collectors.toMap(k -> k.getNumber(), v -> v));
        }
        return Collections.emptyMap();
    }

    public static boolean isuserdefinedAcct(String acctNumber) {
        if ("BOYUserdefinedRate".equals(acctNumber) || "UserdefinedRate".equals(acctNumber)) {
            return false;
        }
        return acctNumber.startsWith("BOYUserdefinedRate") || acctNumber.startsWith("UserdefinedRate");
    }

    public static boolean isuserdefinedAcctWithIgnoreCase(String acctNumber) {
        if ("BOYUserdefinedRate".equalsIgnoreCase(acctNumber) || "UserdefinedRate".equalsIgnoreCase(acctNumber)) {
            return false;
        }
        return acctNumber.startsWith("BOYUserdefinedRate".toLowerCase(Locale.ENGLISH)) || acctNumber.startsWith("UserdefinedRate".toLowerCase(Locale.ENGLISH));
    }

    public static Set<String> getUserdefinedrateAccountIgnoreCase(long modelId) {
        return (Set)ThreadCache.get((Object)("getUserdefinedrateAccountIgnoreCase" + modelId), () -> ExchageRateServiceHelper.getUserdefinedrateAccount(modelId).keySet().stream().map(e -> e.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet()));
    }

    public static Map<String, String> getUserdefinedrateNum2NameIgnoreCase(long modelId) {
        return (Map)ThreadCache.get((Object)("getUserdefinedrateNum2NameIgnoreCase" + modelId), () -> ExchageRateServiceHelper.getUserdefinedrateAccount(modelId).values().stream().collect(Collectors.toMap(k -> k.getNumber().toLowerCase(Locale.ENGLISH), v -> v.getName(), (v1, v2) -> v1)));
    }

    public static ResultBox calcaluateRateFormula(FixedItem ctx) {
        QFilter qFilter = new QFilter("model", "=", (Object)ctx.getModelId());
        qFilter.and("status", "=", (Object)"1");
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_rateformula").getAllFields().keySet();
        DynamicObject[] ratesconfig = BusinessDataServiceHelper.load((String)"bcm_rateformula", (String)String.join((CharSequence)",", fields), (QFilter[])qFilter.toArray(), (String)"executionorder,id");
        ResultBox result = ResultBox.of();
        if (ratesconfig.length == 0) {
            return result;
        }
        CalContext calctx = new CalContext(ctx.getModelNum(), ctx.getModelId(), ctx.getFyId(), ctx.getPeriodId(), ctx.getScenarioId());
        CalculateService calculateService = new CalculateService(calctx);
        RateFormulaProvider provider = new RateFormulaProvider(calctx);
        calculateService.get_ctx().setExternalDataProvider(provider);
        Set<String> ratefields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        DynamicObjectCollection writeRateSchemas = ExchageRateServiceHelper.getWriteRateSchema(ctx.getModelId());
        Map<Long, String> writeEntityId2Numbers = writeRateSchemas.stream().collect(Collectors.toMap(s -> s.getLong("id"), s -> s.getString("number")));
        Map<String, Long> writeEntityNumbers2Id = writeRateSchemas.stream().collect(Collectors.toMap(s -> s.getString("number"), s -> s.getLong("id")));
        Set<String> openPeriodOrgs = new HashSet<String>(writeEntityId2Numbers.values());
        if (ConfigServiceHelper.getBoolParam(ctx.getModelId(), "CM012")) {
            openPeriodOrgs = PeriodSettingHelper.batchSelectPeriodStatusOpen(ctx.getModelId(), new HashSet<String>(writeEntityId2Numbers.values()), ctx.getScenarioId(), ctx.getFyId(), ctx.getPeriodId(), "datastatus");
        }
        Set<Long> openPeriodIds = openPeriodOrgs.stream().map(s -> (Long)writeEntityNumbers2Id.get(s)).collect(Collectors.toSet());
        HashSet<String> nowriteNumbers = new HashSet<String>(writeEntityId2Numbers.values());
        nowriteNumbers.removeAll(openPeriodOrgs);
        Map<Object, DynamicObject> data = ExchageRateServiceHelper.getExchangeRateData(ctx, "0", openPeriodIds, ratefields);
        if (data.size() == 0) {
            return result;
        }
        Map<Long, List<DynamicObject>> entity2rates = data.values().stream().collect(Collectors.groupingBy(s -> s.getLong("entity.id")));
        HashMap<Long, List<DynamicObject>> sortedRates = new HashMap<Long, List<DynamicObject>>(entity2rates.size());
        entity2rates.forEach((a, b) -> sortedRates.put((Long)a, b.stream().sorted(Comparator.comparing(s -> s.getLong("fromid"))).collect(Collectors.toList())));
        provider.setOriginData(sortedRates);
        HashSet changedEntityIds = new HashSet(entity2rates.size());
        HashSet changeCols = new HashSet(16);
        Arrays.stream(ratesconfig).forEach(realconfig -> {
            Long entityId = realconfig.getLong("entity.id");
            String entityNum = realconfig.getString("entity.number");
            if (LongUtil.isvalidLong((Object)entityId)) {
                if (nowriteNumbers.contains(entityNum)) {
                    result.add(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e2d\u6c47\u7387\u7ec4\u7ec7\u201c%1$s\u201d\u671f\u95f4\u5173\u95ed\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"ExchageRateServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum));
                    return;
                }
                calctx.setProperty("orgId", entityId);
                changedEntityIds.add(entityId);
            } else {
                result.add(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e2d\u6c47\u7387\u7ec4\u7ec7\u201c%1$s\u201d\u671f\u95f4\u5173\u95ed\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"ExchageRateServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", nowriteNumbers)));
                calctx.setProperty("orgId", 0L);
                changedEntityIds.addAll(openPeriodIds);
            }
            if (LongUtil.isvalidLong((Object)entityId) && !openPeriodIds.contains(entityId)) {
                return;
            }
            List<DynamicObject> mainData = provider.getMainData();
            String formula = realconfig.getString("formula");
            String account = realconfig.getString("account.number");
            String realnumber = ExchangeRateShareSceneHelper.getRealRateNumber(account);
            changeCols.add(realnumber);
            for (DynamicObject cur : mainData) {
                if (StringUtils.isNotEmpty((CharSequence)cur.getString("triangle"))) continue;
                BigDecimal val = cur.getBigDecimal(realnumber);
                int precison = RateFormulaProvider.getPrecision(cur);
                try {
                    if (!StringUtils.isEmpty((CharSequence)formula)) {
                        provider.setCurobj(cur);
                        val = calculateService.singleCalculate(formula);
                        if (val instanceof Exception) {
                            throw new Exception(((Exception)((Object)val)).getMessage());
                        }
                    } else {
                        val = null;
                    }
                }
                catch (Exception e) {
                    String info = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u201c%1$s\u201d,\u79d1\u76ee\u201c%2$s\u201d,\u539f\u503c\u4e3a\u201c%3$s\u201d\u65f6\u62a5\u9519,\u9519\u8bef\u4fe1\u606f\uff1a\u201c%4$s\u201d\u3002", (String)"ExchageRateServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), formula, account, val, e.getMessage());
                    result.addError(info);
                    val = cur.getBigDecimal(realnumber);
                }
                if (val == null || !NumberUtils.isNumber((String)((Object)val).toString())) continue;
                BigDecimal newval = new BigDecimal(((Object)val).toString());
                BigDecimal realval = newval.setScale(precison, RoundingMode.HALF_UP);
                cur.set(realnumber, (Object)realval);
                DynamicObject mutual = provider.getMutualObj(cur.getLong("id"));
                ExchageRateServiceHelper.updateMutual(mutual, realnumber, realval);
            }
        });
        provider.getOriginData().forEach((k, v) -> {
            if (!changedEntityIds.contains(k)) {
                return;
            }
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)k);
            FixedItem savectx = FixedItem.newOne(ctx.getModel(), ctx.getScenario(), ctx.getFy(), ctx.getPeriod(), SimpleItem.newOne(k, entityNode.getNumber()));
            try {
                SaveServiceHelper.update((DynamicObject[])v.toArray(new DynamicObject[0]));
                ExchangeRateShareSceneHelper.calcTriangleRate(savectx);
                ExchangeRateShareSceneHelper.saveOlap4Rows(v, false, ctx, Lists.newArrayList((Iterable)changeCols), OlapSourceEnum.S1);
            }
            catch (Exception e) {
                String info = String.format(ctx.getInfo() + e.getMessage(), new Object[0]);
                result.addError(info);
            }
        });
        result.setData((Object)changedEntityIds.stream().map(s -> (String)writeEntityId2Numbers.get(s)).collect(Collectors.joining(",")));
        return result;
    }

    private static void updateMutual(DynamicObject mutual, String realnumber, BigDecimal val) {
        if (mutual == null) {
            return;
        }
        int precison = RateFormulaProvider.getPrecision(mutual);
        if (val == null) {
            mutual.set(realnumber, null);
        } else if (val.compareTo(BigDecimal.ZERO) == 0) {
            mutual.set(realnumber, (Object)BigDecimal.ZERO);
        } else {
            mutual.set(realnumber, (Object)BigDecimal.ONE.divide(val, precison, RoundingMode.HALF_UP));
        }
    }

    private static Map<Object, DynamicObject> getExchangeRateData(FixedItem ctx, String type, Set<Long> writeEntityIds, Collection<String> ratefields) {
        HashMap<Object, DynamicObject> data = new HashMap<Object, DynamicObject>(8);
        Long modelId = ctx.getModelId();
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)modelNum, (String)ctx.getScenarioNum());
        HashSet<Long> unShareIds = new HashSet<Long>(writeEntityIds);
        Set<Long> shareIds = ExchangeRateShareSceneHelper.getRateShareIdsApplyScene(writeEntityIds, node.getId());
        if (shareIds.size() > 0) {
            Map data1 = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", ratefields), (QFilter[])ExchageRateServiceHelper.getQfilter(ctx, type, shareIds, Boolean.TRUE).toArray());
            data1.forEach((k, v) -> data.put(k, (DynamicObject)v));
        }
        unShareIds.removeAll(shareIds);
        if (writeEntityIds.size() > 0) {
            Map data2 = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", ratefields), (QFilter[])ExchageRateServiceHelper.getQfilter(ctx, type, unShareIds, Boolean.FALSE).toArray());
            data2.forEach((k, v) -> data.put(k, (DynamicObject)v));
        }
        return data;
    }

    private static QFBuilder getQfilter(FixedItem ctx, String type, Set<Long> writeEntityIds, Boolean isshare) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)ctx.getModelId());
        if (isshare.booleanValue()) {
            qfBuilder.and(new QFBuilder("scene", "=", (Object)0L));
        } else {
            qfBuilder.and(new QFBuilder("scene", "=", (Object)ctx.getScenarioId()));
        }
        QFBuilder fyandperiod = QCfilterUtils.getFyAndPeriodFilter(String.valueOf(ctx.getModelId()), String.valueOf(ctx.getFyId()), String.valueOf(ctx.getPeriodId()), type);
        qfBuilder.and(fyandperiod);
        qfBuilder.and(new QFBuilder("entity", "in", writeEntityIds));
        return qfBuilder;
    }

    private static DynamicObjectCollection getWriteRateSchema(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("isexchangerate", "=", (Object)true));
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (!adminUserBol) {
            ArrayListMultimap<String, Long> tmplPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_entitymembertree", String.valueOf(modelId), RequestContext.get().getUserId());
            HashSet ids = new HashSet(16);
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
            ids.addAll(tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()));
            qFilter.and("id", "not in", ids);
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,longnumber,level,parent.id as parent_id,issharescene", (QFilter[])qFilter.toArray(), (String)"level, id");
        return dcs;
    }

    public static ResultBox sysImportRate(FixedItem context, Table<String, String, Map<String, BigDecimal>> signedtable) {
        ResultBox box = ResultBox.of();
        if (signedtable.isEmpty()) {
            return box;
        }
        Map<String, String> rateImportFieldMapping = ExchageRateServiceHelper.getRateImportFieldMapping(context.getModelId());
        Set targetFieldSet = rateImportFieldMapping.keySet().stream().map(ExchageRateServiceHelper::getRateAccountField).collect(Collectors.toSet());
        String searchFields = "id,source,target,mutual,precision,fromid,triangle,eseq,modifier,modifytime," + String.join((CharSequence)",", targetFieldSet);
        DynamicObject[] currentRates = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)searchFields, (QFilter[])new QFilter[]{ExchageRateServiceHelper.getFilter(context, false)}, (String)"eseq");
        Set sourceNumber = signedtable.rowKeySet();
        Set targetNumber = signedtable.columnKeySet();
        QFilter sourceQF = new QFilter("number", "in", (Object)sourceNumber).and("model", "=", (Object)context.getModelId());
        QFilter targetQF = new QFilter("number", "in", (Object)targetNumber).and("model", "=", (Object)context.getModelId());
        Map source = BusinessDataServiceHelper.loadFromCache((String)"bcm_processmembertree", (QFilter[])sourceQF.toArray());
        Map target = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (QFilter[])targetQF.toArray());
        HashMap sourceNumber2Dy = new HashMap(source.size());
        HashMap targetNumber2Dy = new HashMap(target.size());
        source.values().forEach(s -> sourceNumber2Dy.put(s.getString("number"), s));
        target.values().forEach(s -> targetNumber2Dy.put(s.getString("number"), s));
        Long sceneId = context.getScenarioId();
        DynamicObject scene = null;
        if (LongUtil.isvalidLong((Object)sceneId)) {
            scene = BusinessDataServiceHelper.loadSingle((Object)sceneId, (String)"bcm_scenemembertree");
        }
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)context.getEntityId(), (String)"bcm_entitymembertree");
        DynamicObject fy = BusinessDataServiceHelper.loadSingle((Object)context.getFyId(), (String)"bcm_fymembertree");
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)context.getPeriodId(), (String)"bcm_periodmembertree");
        int length = currentRates.length;
        ArrayList<DynamicObject> updateRates = new ArrayList<DynamicObject>(length);
        ArrayList<DynamicObject> waitAddRates = new ArrayList<DynamicObject>(length);
        HashBasedTable datatable = HashBasedTable.create();
        HashMap id2Dy = new HashMap(length);
        int maxSeq = length > 0 ? currentRates[length - 1].getInt("eseq") + 1 : 1;
        Arrays.stream(currentRates).forEach(arg_0 -> ExchageRateServiceHelper.lambda$sysImportRate$24((Table)datatable, id2Dy, arg_0));
        HashMap<Long, DynamicObject> updateDys = new HashMap<Long, DynamicObject>(length);
        ArrayList<DynamicObject> resetMutualDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject[] data : signedtable.cellSet()) {
            Long updateRowId = (Long)datatable.get(data.getRowKey(), data.getColumnKey());
            if (LongUtil.isvalidLong((Object)updateRowId)) {
                DynamicObject changedObj = (DynamicObject)id2Dy.get(updateRowId);
                if (changedObj == null) continue;
                updateDys.put(updateRowId, changedObj);
                for (String rateAccountNumber : rateImportFieldMapping.keySet()) {
                    if (rateAccountNumber.startsWith("BOY") && !ConfigServiceHelper.getBoolParam(context.getModelId(), "CM009")) continue;
                    String rateAccountField = ExchageRateServiceHelper.getRateAccountField(rateAccountNumber);
                    changedObj.set(rateAccountField, (Object)((BigDecimal)((Map)data.getValue()).get(rateAccountNumber)).setScale(15, RoundingMode.HALF_UP));
                }
                changedObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                changedObj.set("modifytime", (Object)TimeServiceHelper.now());
                if (changedObj.getBoolean("mutual")) {
                    long fromId = changedObj.getLong("fromid");
                    changedObj.set("mutual", (Object)Boolean.FALSE);
                    changedObj.set("fromid", (Object)0L);
                    DynamicObject resetDy = (DynamicObject)id2Dy.get(fromId);
                    if (fromId > 0L && !updateDys.containsKey(fromId) && resetDy != null) {
                        resetDy.set("mutual", (Object)Boolean.FALSE);
                        resetDy.set("fromid", (Object)0L);
                        resetDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        resetDy.set("modifytime", (Object)TimeServiceHelper.now());
                        resetMutualDys.add(resetDy);
                    }
                }
                updateRates.add(changedObj);
                continue;
            }
            waitAddRates.add(ExchageRateServiceHelper.generateRowData(context.getModelId(), scene, entity, fy, period, (DynamicObject)sourceNumber2Dy.get(data.getRowKey()), (DynamicObject)targetNumber2Dy.get(data.getColumnKey()), (Map)data.getValue(), rateImportFieldMapping, maxSeq));
            ++maxSeq;
        }
        ArrayList<DynamicObject> triangleUpateSeq = new ArrayList<DynamicObject>(length);
        for (DynamicObject obj : currentRates) {
            if (StringUtils.isEmpty((CharSequence)obj.getString("triangle"))) continue;
            DynamicObject updateDy = (DynamicObject)updateDys.get(obj.getLong("id"));
            if (updateDy != null) {
                updateDy.set("eseq", (Object)maxSeq);
            } else {
                obj.set("eseq", (Object)maxSeq);
                triangleUpateSeq.add(obj);
            }
            ++maxSeq;
        }
        ArrayList<DynamicObject> allrates = new ArrayList<DynamicObject>();
        allrates.addAll(updateRates);
        allrates.addAll(waitAddRates);
        try (TXHandle tx = TX.required((String)"bcm_sysImportExchangeRatePlan");){
            try {
                SaveServiceHelper.save((DynamicObject[])waitAddRates.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject[])updateRates.toArray(new DynamicObject[0]));
                if (!resetMutualDys.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])resetMutualDys.toArray(new DynamicObject[0]));
                }
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                op.setVariableValue("currentUserId", "false");
                SaveServiceHelper.update((DynamicObject[])triangleUpateSeq.toArray(new DynamicObject[0]), (OperateOption)op);
                ExchangeRateShareSceneHelper.saveOlap4Rows(allrates, false, context, Lists.newArrayList(targetFieldSet), OlapSourceEnum.M1);
            }
            catch (Exception e) {
                tx.markRollback();
                box.addError(e.getMessage());
            }
        }
        return box;
    }

    public static DynamicObject generateRowData(Long modelId, DynamicObject scene, DynamicObject entity, DynamicObject fy, DynamicObject period, DynamicObject source, DynamicObject target, Map<String, BigDecimal> importDataMap, Map<String, String> rateImportFieldMapping, int seq) {
        DynamicObject rate = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
        rate.set("source", (Object)source);
        rate.set("target", (Object)target);
        rate.set("model", (Object)modelId);
        rate.set("entity", (Object)entity);
        rate.set("scene", (Object)scene);
        rate.set("fy", (Object)fy);
        rate.set("period", (Object)period);
        for (String rateAccountNumber : rateImportFieldMapping.keySet()) {
            if (rateAccountNumber.startsWith("BOY") && !ConfigServiceHelper.getBoolParam(modelId, "CM009")) continue;
            String rateAccountField = ExchageRateServiceHelper.getRateAccountField(rateAccountNumber);
            rate.set(rateAccountField, (Object)importDataMap.get(rateAccountNumber).setScale(15, RoundingMode.HALF_UP));
        }
        rate.set("modifier", (Object)RequestContext.get().getCurrUserId());
        rate.set("modifytime", (Object)TimeServiceHelper.now());
        rate.set("eseq", (Object)seq);
        rate.set("precision", (Object)15);
        return rate;
    }

    public static QFilter getFilter(FixedItem context, boolean isLastPeriod) {
        QFilter[] qfs;
        QFilter filter = null;
        Long modelid = context.getModelId();
        Long entityId = context.getEntityId();
        IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)context.getModelNum(), (String)context.getScenarioNum());
        Long sceneId = node.getId();
        Long yearId = context.getFyId();
        Long periodId = context.getPeriodId();
        if (modelid == 0L || yearId == 0L || periodId == 0L) {
            return new QFilter("1", "=", (Object)0L);
        }
        filter = new QFilter("model", "=", (Object)modelid);
        filter = ExchangeRateShareSceneHelper.isInRateShare(entityId.toString(), sceneId.toString()) != false ? filter.and(new QFilter("scene", "=", (Object)0L)) : filter.and(new QFilter("scene", "=", (Object)sceneId));
        String type = PeriodTypeEnum.CURRENT.getIndex();
        if (isLastPeriod) {
            type = PeriodTypeEnum.PRE.getIndex();
        }
        QFBuilder builder = QCfilterUtils.getFyAndPeriodFilter(modelid.toString(), yearId.toString(), periodId.toString(), type);
        for (QFilter qf : qfs = builder.toArray()) {
            filter.and(qf);
        }
        if (LongUtil.isvalidLong((Object)entityId)) {
            filter = filter.and(new QFilter("entity", "=", (Object)entityId));
        }
        return filter;
    }

    public static Map<String, String> getRateImportFieldMapping(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection settingList = QueryServiceHelper.query((String)"bcm_ratefieldsetting", (String)"sourcefield,rateaccount.number", (QFilter[])filter.toArray());
        return settingList.stream().collect(Collectors.toMap(v -> v.getString("rateaccount.number"), v -> v.getString("sourcefield")));
    }

    public static String getRateAccountField(String RateAccountNumber) {
        String field = fieldMapping.get(RateAccountNumber);
        if (field == null) {
            return RateAccountNumber.toLowerCase();
        }
        return field;
    }

    private static /* synthetic */ void lambda$sysImportRate$24(Table datatable, Map id2Dy, DynamicObject s) {
        datatable.put((Object)s.getString("source.number"), (Object)s.getString("target.number"), (Object)s.getLong("id"));
        id2Dy.put(s.getLong("id"), s);
    }

    static {
        columns.put("beginyear", (String)PresetConstant.ACCOUNT_MEMS.get(2));
        columns.put("periodend", (String)PresetConstant.ACCOUNT_MEMS.get(3));
        columns.put("average", (String)PresetConstant.ACCOUNT_MEMS.get(4));
        columns.put("userdefine", (String)PresetConstant.ACCOUNT_MEMS.get(5));
        columns.put("boyaveragerate", (String)PresetConstant.ACCOUNT_MEMS.get(6));
        columns.put("boyuserdefinedrate", (String)PresetConstant.ACCOUNT_MEMS.get(7));
        fieldMapping = new HashMap<String, String>(16);
        fieldMapping.put("BOYRate", "beginyear");
        fieldMapping.put("ClosingRate", "periodend");
        fieldMapping.put("AverageRate", "average");
        fieldMapping.put("UserdefinedRate", "userdefine");
    }
}

