/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.exchangeRate;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class ExchangeRateCopyServiceHelper {
    private static final String MODEL = "model";
    private static final String SCENE = "scene";
    private static final String FY = "fy";
    private static final String PERIOD = "period";
    private static final String SYSTEM_TYPE = "fi-bcm-business";

    public static ResultBox copyData(FixedItem srcctx, FixedItem tgtctx) {
        ResultBox result = ResultBox.of();
        Long modelId = srcctx.getModelId();
        Long entityId = srcctx.getEntityId();
        Long originfyId = srcctx.getFyId();
        Long originperiodId = srcctx.getPeriodId();
        Long targetfyId = tgtctx.getFyId();
        Long targetperiodId = tgtctx.getPeriodId();
        if (modelId == 0L || entityId == 0L || targetfyId == 0L || targetperiodId == 0L || originfyId == 0L || originperiodId == 0L) {
            result.addError(ResManager.loadKDString((String)"\u4f53\u7cfb\u8d22\u5e74\u6c47\u7387\u7ec4\u7ec7\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRateCopy_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return result;
        }
        Long targentSceneId = tgtctx.getScenarioId();
        Long sourceSceneId = srcctx.getScenarioId();
        boolean isUpdateRate = ConfigServiceHelper.getBoolParam(modelId, "CM009");
        if (originfyId.compareTo(targetfyId) == 0 && originperiodId.compareTo(targentSceneId) == 0) {
            result.addError(ResManager.loadKDString((String)"\u6e90\u548c\u76ee\u6807\u4e0d\u80fd\u76f8\u540c\u3002", (String)"ExchangeRateCopy_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return result;
        }
        CloneUtils clone = new CloneUtils(true, true);
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.add(SCENE, "=", (Object)sourceSceneId);
        qfBuilder.add(FY, "=", (Object)originfyId);
        qfBuilder.add(PERIOD, "=", (Object)originperiodId);
        qfBuilder.add("entity", "=", (Object)entityId);
        qfBuilder.add("triangle", "=", (Object)" ");
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        Map originRatesMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"eseq");
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(originRatesMap.size());
        DynamicObject fyobj = BusinessDataServiceHelper.loadSingle((Object)targetfyId, (String)"bcm_fymembertree");
        DynamicObject periodobj = BusinessDataServiceHelper.loadSingle((Object)targetperiodId, (String)"bcm_periodmembertree");
        ArrayList coupled = new ArrayList(originRatesMap.size());
        ArrayList<Pair> addCoupledKeys = new ArrayList<Pair>(coupled.size());
        ArrayList<String> addKeys = new ArrayList<String>(coupled.size());
        originRatesMap.forEach((k, v) -> {
            Long formid = v.getLong("fromid");
            if (!StringUtils.isEmpty((CharSequence)v.getString("triangle")) || StringUtils.isEmpty((CharSequence)v.getString("source.number")) || StringUtils.isEmpty((CharSequence)v.getString("target.number"))) {
                return;
            }
            if (formid != 0L) {
                Pair data = new Pair(originRatesMap.get(k), originRatesMap.get(formid));
                coupled.add(data);
            }
        });
        for (Object data : coupled) {
            Pair myrate = (Pair)data;
            DynamicObject master = (DynamicObject)myrate.p2;
            DynamicObject mutual = (DynamicObject)myrate.p1;
            Long id = GlobalIdUtil.genGlobalLongId();
            DynamicObject newMasterRate = (DynamicObject)clone.clone((IDataEntityBase)master);
            newMasterRate.set(FY, (Object)fyobj);
            newMasterRate.set(PERIOD, (Object)periodobj);
            newMasterRate.set(SCENE, targentSceneId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)targentSceneId, (String)"bcm_scenemembertree"));
            newMasterRate.set("id", (Object)id);
            String masterKey = master.getString("source.number") + "|" + master.getString("target.number");
            if (!isUpdateRate) {
                ExchangeRateCopyServiceHelper.resetBeginRateCols(modelId, newMasterRate);
            }
            objs.add(newMasterRate);
            DynamicObject newMutualRate = (DynamicObject)clone.clone((IDataEntityBase)mutual);
            newMutualRate.set(FY, (Object)fyobj);
            newMutualRate.set(PERIOD, (Object)periodobj);
            newMutualRate.set("fromid", (Object)id);
            newMutualRate.set(SCENE, targentSceneId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)targentSceneId, (String)"bcm_scenemembertree"));
            String mutualKey = mutual.getString("source.number") + "|" + mutual.getString("target.number");
            addCoupledKeys.add(new Pair((Object)mutualKey, (Object)masterKey));
            objs.add(newMutualRate);
            if (!isUpdateRate) {
                ExchangeRateCopyServiceHelper.resetBeginRateCols(modelId, newMutualRate);
            }
            originRatesMap.remove(master.getLong("id"));
            originRatesMap.remove(mutual.getLong("id"));
        }
        for (DynamicObject rate : originRatesMap.values()) {
            if (!StringUtils.isEmpty((CharSequence)rate.getString("triangle")) || StringUtils.isEmpty((CharSequence)rate.getString("source.number")) || StringUtils.isEmpty((CharSequence)rate.getString("target.number"))) continue;
            DynamicObject newRate = (DynamicObject)clone.clone((IDataEntityBase)rate);
            newRate.set(FY, (Object)fyobj);
            newRate.set(PERIOD, (Object)periodobj);
            newRate.set(SCENE, targentSceneId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)targentSceneId, (String)"bcm_scenemembertree"));
            if (!isUpdateRate) {
                ExchangeRateCopyServiceHelper.resetBeginRateCols(modelId, newRate);
            }
            addKeys.add(newRate.getString("source.number") + "|" + newRate.getString("target.number"));
            objs.add(newRate);
        }
        qfBuilder.clear();
        qfBuilder.and(MODEL, "=", (Object)modelId);
        qfBuilder.add(SCENE, "=", (Object)targentSceneId);
        qfBuilder.add(FY, "=", (Object)targetfyId);
        qfBuilder.add(PERIOD, "=", (Object)targetperiodId);
        qfBuilder.add("entity", "=", (Object)entityId);
        Map existRateMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"eseq");
        Set<Long> needRemoveIds = ExchangeRateCopyServiceHelper.getRemoveExsitRates(existRateMap, objs, isUpdateRate);
        qfBuilder.clear();
        qfBuilder.and("id", "in", needRemoveIds);
        List<DynamicObject> needRemoveObjs = existRateMap.values().stream().filter(s -> needRemoveIds.contains(s.getLong("id"))).collect(Collectors.toList());
        List removeKeys = needRemoveObjs.stream().map(s -> s.getString("source.number") + "|" + s.getString("target.number")).collect(Collectors.toList());
        List sortedRateKeys = existRateMap.values().stream().filter(s -> StringUtils.isEmpty((CharSequence)s.getString("triangle"))).sorted(Comparator.comparing(s -> s.getLong("eseq"))).map(s -> s.getString("source.number") + "|" + s.getString("target.number")).collect(Collectors.toList());
        ArrayList<Object> sortedKeys = new ArrayList<Object>(sortedRateKeys.size());
        for (String currenKey : sortedRateKeys) {
            if (removeKeys.contains(currenKey)) {
                Optional<Pair> key = addCoupledKeys.stream().filter(s -> currenKey.equals(s.p2) || currenKey.equals(s.p1)).findFirst();
                if (key.isPresent()) {
                    sortedKeys.add(key.get().p2);
                    sortedKeys.add(key.get().p1);
                    continue;
                }
                if (!addKeys.contains(currenKey)) continue;
                sortedKeys.add(currenKey);
                continue;
            }
            sortedKeys.add(currenKey);
        }
        List<String> realSortedKeys = sortedKeys.stream().distinct().collect(Collectors.toList());
        Set currentObjs = objs.stream().map(s -> s.getString("source.number") + "|" + s.getString("target.number")).collect(Collectors.toSet());
        List<DynamicObject> updateObjs = existRateMap.values().stream().filter(s -> {
            String key = s.getString("source.number") + "|" + s.getString("target.number");
            return !currentObjs.contains(key) && !removeKeys.contains(key);
        }).collect(Collectors.toList());
        objs.addAll(updateObjs);
        ExchangeRateCopyServiceHelper.setListOrder(realSortedKeys, objs);
        objs.removeAll(updateObjs);
        try (TXHandle tx = TX.required((String)"ExchangeRatePlanCopy");){
            try {
                DeleteServiceHelper.delete((String)"bcm_exchagerate", (QFilter[])qfBuilder.toArray());
                SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[0]));
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                op.setVariableValue("currentUserId", "false");
                SaveServiceHelper.update((DynamicObject[])updateObjs.toArray(new DynamicObject[0]), (OperateOption)op);
                ExchangeRateShareSceneHelper.calcTriangleRate(tgtctx);
                ExchangeRateShareSceneHelper.saveOlap4Rows(needRemoveObjs, true, tgtctx, null, OlapSourceEnum.M1);
                ExchangeRateShareSceneHelper.saveOlap4Rows(objs, false, tgtctx, null, OlapSourceEnum.M1);
                OperationLogUtil.writeOperationLog(OpItemEnum.COPY.getName(), String.format("%1$s%2$s", ExchangeRateCopyServiceHelper.getDetailLogMsg(srcctx, tgtctx), ResultStatusEnum.SUCCESS.getName()), tgtctx.getModelId(), "bcm_exchagerate");
            }
            catch (Throwable e) {
                tx.markRollback();
                result.addError(e.getMessage());
                OperationLogUtil.writeOperationLog(OpItemEnum.COPY.getName(), String.format("%1$s%2$s", ExchangeRateCopyServiceHelper.getDetailLogMsg(srcctx, tgtctx), ResultStatusEnum.FAIL.getName()), tgtctx.getModelId(), "bcm_exchagerate");
            }
        }
        ExchangeQueryHelper.clearRateCache(new BaseData(tgtctx));
        return result;
    }

    public static void setListOrder(List<String> orderRegulation, List<DynamicObject> targetList) {
        Collections.sort(targetList, (o1, o2) -> {
            int io1 = orderRegulation.indexOf(o1.getString("source.number") + "|" + o1.getString("target.number"));
            int io2 = orderRegulation.indexOf(o2.getString("source.number") + "|" + o2.getString("target.number"));
            if (io1 != -1) {
                io1 = targetList.size() - io1;
            }
            if (io2 != -1) {
                io2 = targetList.size() - io2;
            }
            return io2 - io1;
        });
        int i = 0;
        for (DynamicObject object : targetList) {
            object.set("eseq", (Object)i);
            ++i;
        }
    }

    public static void deleteExchangeRate(FixedItem ctx) {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)ctx.getModelId());
        Long entityId = ctx.getEntityId();
        if (ExchangeRateShareSceneHelper.isOpenRateShare(entityId.toString()).booleanValue()) {
            qfBuilder.add(SCENE, "=", (Object)0L);
        } else {
            qfBuilder.add(SCENE, "=", (Object)ctx.getScenarioId());
        }
        qfBuilder.add(FY, "=", (Object)ctx.getFyId());
        qfBuilder.add(PERIOD, "=", (Object)ctx.getPeriodId());
        qfBuilder.add("entity", "=", (Object)entityId);
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        Map originRatesMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray());
        Set originIds = originRatesMap.keySet();
        List<DynamicObject> originObjs = originRatesMap.values().stream().collect(Collectors.toList());
        try (TXHandle tx = TX.required((String)"ExchangeRatePlanDelete");){
            try {
                QFilter idf = new QFilter("id", "in", originIds);
                ExchangeRateShareSceneHelper.saveOlap4Rows(originObjs, true, ctx, null, OlapSourceEnum.M1);
            }
            catch (Throwable e) {
                tx.markRollback();
                OperationLogUtil.writeOperationLog(OpItemEnum.DELETE.getName(), String.format("%1$s%2$s", ExchangeRateCopyServiceHelper.getDetailLogMsg(ctx), ResultStatusEnum.FAIL.getName()), ctx.getModelId(), "bcm_exchagerate");
            }
        }
    }

    private static String getDetailLogMsg(FixedItem srcctx, FixedItem tgtctx) {
        return String.format(ResManager.loadKDString((String)"%1$s\u6765\u6e90\u4e8e\u590d\u5236\u6c47\u7387%2$s", (String)"ExchangeRateCopy_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), ExchangeRateCopyServiceHelper.getDetailLogMsg(srcctx), ExchangeRateCopyServiceHelper.getDetailLogMsg(tgtctx));
    }

    private static String getDetailLogMsg(FixedItem ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.getScenarioNum());
        sb.append(" ");
        sb.append(ctx.getFyNum());
        sb.append(" ");
        sb.append(ctx.getPeriodNum());
        sb.append(" ");
        sb.append(ctx.getEntityNum());
        return sb.toString();
    }

    private static Set<Long> getRemoveExsitRates(Map<Object, DynamicObject> existRates, List<DynamicObject> copyedrates, Boolean isUpdateRate) {
        HashSet<Long> needRemoveIds = new HashSet<Long>(copyedrates.size());
        ArrayList coupled = new ArrayList(existRates.size());
        existRates.forEach((k, v) -> {
            String sourceNumber = v.getString("source.number");
            String targetNumber = v.getString("target.number");
            if (!StringUtil.isEmpty((CharSequence)v.getString("triangle")) || StringUtils.isEmpty((CharSequence)sourceNumber) || StringUtils.isEmpty((CharSequence)targetNumber)) {
                needRemoveIds.add(v.getLong("id"));
            } else {
                Optional<DynamicObject> existObj = copyedrates.stream().filter(s -> s.getString("source.number").equals(sourceNumber) && s.getString("target.number").equals(targetNumber)).findFirst();
                if (existObj.isPresent()) {
                    needRemoveIds.add(v.getLong("id"));
                    if (!isUpdateRate.booleanValue()) {
                        ExchangeRateCopyServiceHelper.getBeginRateCols(v.getLong("model.id")).stream().forEach(s -> v.set(s, ((DynamicObject)existObj.get()).get(s)));
                    }
                }
            }
        });
        existRates.forEach((k, v) -> {
            Long formid = v.getLong("fromid");
            if (formid != 0L && StringUtils.isEmpty((CharSequence)v.getString("triangle"))) {
                coupled.add(new Pair((Object)v.getLong("id"), (Object)formid));
            }
        });
        coupled.forEach(s -> {
            if (needRemoveIds.contains(s.p1)) {
                needRemoveIds.add((Long)s.p2);
            } else if (needRemoveIds.contains(s.p2)) {
                needRemoveIds.add((Long)s.p1);
            }
        });
        return needRemoveIds;
    }

    public static void resetBeginRateCols(Long modelId, DynamicObject obj) {
        ExchangeRateCopyServiceHelper.getBeginRateCols(modelId).stream().forEach(s -> obj.set(s, (Object)BigDecimal.ZERO));
    }

    public static Set<String> getBeginRateCols(Long modelId) {
        return (Set)ThreadCache.get((Object)(modelId + "beginYearRateCols"), () -> {
            DynamicObjectCollection allRateColumns = ExchangeRateShareSceneHelper.getAllRateAccount(modelId);
            ArrayList beginCols = Lists.newArrayList((Object[])new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate"});
            Set unCols = allRateColumns.stream().map(s -> ExchangeRateShareSceneHelper.getRealRateNumber(s.getString("number"))).filter(s -> beginCols.stream().anyMatch(k -> s.startsWith((String)k))).collect(Collectors.toSet());
            return unCols;
        });
    }
}

