/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.exchangeRate;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.ModelServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchageRateServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateCopyServiceHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.graph.DGraph;
import kd.fi.bcm.common.graph.Edge;
import kd.fi.bcm.common.graph.ListDGraph;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.map.MultiKeyMap;

public class ExchangeRateShareSceneHelper {
    private static final String SYSTEM_TYPE = "fi-bcm-business";
    private static String[] rateColumns4Olap = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "periodend", "average", "userdefine"};
    private static String[] rateColumns = new String[]{"beginyear", "boyaveragerate", "boyuserdefinedrate", "boyuserdefinedrate1", "boyuserdefinedrate2", "boyuserdefinedrate3", "boyuserdefinedrate4", "boyuserdefinedrate5", "boyuserdefinedrate6", "boyuserdefinedrate7", "boyuserdefinedrate8", "boyuserdefinedrate9", "boyuserdefinedrate10", "periodend", "average", "userdefine", "userdefinedrate1", "userdefinedrate2", "userdefinedrate3", "userdefinedrate4", "userdefinedrate5", "userdefinedrate6", "userdefinedrate7", "userdefinedrate8", "userdefinedrate9", "userdefinedrate10"};

    public static Boolean isOpenRateShare(String entityId) {
        return (Boolean)ThreadCache.get((Object)("issharescene" + entityId), () -> {
            Long id = LongUtil.toLong((Object)entityId);
            if (id == 0L) {
                return Boolean.FALSE;
            }
            QFBuilder qf = new QFBuilder("id", "=", (Object)id);
            DynamicObject rateplan = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"issharescene", (QFilter[])qf.toArray());
            return rateplan.getBoolean("issharescene");
        });
    }

    public static Boolean isInRateShare(String entityId, String sceneId) {
        return (Boolean)ThreadCache.get((Object)("rateinsharescene" + entityId + "_" + sceneId), () -> {
            Long id = LongUtil.toLong((Object)entityId);
            if (id == 0L || id == -1L) {
                return Boolean.FALSE;
            }
            QFBuilder qf = new QFBuilder("id", "=", (Object)id);
            DynamicObject rateplan = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"issharescene", (QFilter[])qf.toArray());
            Boolean issharescene = rateplan.getBoolean("issharescene");
            if (issharescene.booleanValue()) {
                QFBuilder myqf = new QFBuilder("rateplan", "=", (Object)id);
                myqf.add(new QFilter("scene", "=", (Object)LongUtil.toLong((Object)sceneId)));
                return QueryServiceHelper.exists((String)"bcm_rateplanscenes", (QFilter[])myqf.toArray());
            }
            return Boolean.FALSE;
        });
    }

    public static DynamicObjectCollection getShareScenes(Long entityId) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("ratesharesceneobjs" + entityId), () -> {
            DynamicObject rateplan = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)"bcm_entitymembertree");
            Boolean issharescene = rateplan.getBoolean("issharescene");
            if (issharescene.booleanValue()) {
                QFBuilder qf = new QFBuilder("rateplan", "=", (Object)entityId);
                Map result = BusinessDataServiceHelper.loadFromCache((String)"bcm_rateplanscenes", (String)"id,rateplan,scene", (QFilter[])qf.toArray());
                return result.values().stream().map(s -> s.getDynamicObject("scene")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            }
            return new DynamicObjectCollection();
        });
    }

    public static Set<Long> getRateShareSceneIds(Long entityId) {
        return (Set)ThreadCache.get((Object)("ratesharesceneids" + entityId), () -> {
            DynamicObjectCollection scenes = ExchangeRateShareSceneHelper.getShareScenes(entityId);
            return scenes.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
        });
    }

    public static Map<Long, Set<Long>> getRateShareSceneIds(Collection<Long> entityIds) {
        HashMap<Long, Set<Long>> entity2Scenes = new HashMap<Long, Set<Long>>(entityIds.size());
        QFBuilder qf = new QFBuilder("id", "in", entityIds);
        DynamicObjectCollection rateplans = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,issharescene", (QFilter[])qf.toArray());
        Set shareIds = rateplans.stream().filter(s -> s.getBoolean("issharescene")).map(v -> v.getLong("id")).collect(Collectors.toSet());
        QFBuilder myqf = new QFBuilder("rateplan", "in", shareIds);
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bcm_rateplanscenes", (String)"id,rateplan,scene", (QFilter[])myqf.toArray());
        Map<Long, List<DynamicObject>> data = result.values().stream().collect(Collectors.groupingBy(s -> s.getLong("rateplan.id")));
        data.forEach((k, v) -> entity2Scenes.put((Long)k, v.stream().map(s -> s.getLong("scene.id")).collect(Collectors.toSet())));
        return entity2Scenes;
    }

    public static Map<Long, Set<Long>> getRateShare2ApplySceneInPeriod(Set<Long> entityIds, Long periodId) {
        Map<Long, Set<Long>> entity2Scenes = ExchangeRateShareSceneHelper.getRateShareSceneIds(entityIds);
        Set<Long> allSceneIds = entity2Scenes.values().stream().flatMap(sc -> sc.stream()).collect(Collectors.toSet());
        Set<Long> validSceneIds = ExchangeRateShareSceneHelper.getApplySceneIds(allSceneIds, periodId);
        for (Map.Entry<Long, Set<Long>> kv : entity2Scenes.entrySet()) {
            Set<Long> curValue = kv.getValue();
            curValue.retainAll(validSceneIds);
            kv.setValue(curValue);
        }
        return entity2Scenes;
    }

    public static Set<Long> getRateShare2ApplySceneInPeriod(Long entityId, Long periodId) {
        Map<Long, Set<Long>> data = ExchangeRateShareSceneHelper.getRateShare2ApplySceneInPeriod(Sets.newHashSet((Object[])new Long[]{entityId}), periodId);
        Set<Long> curSceneIds = data.get(entityId);
        if (curSceneIds != null && !curSceneIds.isEmpty()) {
            return curSceneIds;
        }
        return new HashSet<Long>();
    }

    public static HashMap<Long, Set<Long>> getRateShareScenePeriodIds(String entityId, String yearNumber) {
        Set<Long> sceneIds = ExchangeRateShareSceneHelper.getRateShareSceneIds(LongUtil.toLong((Object)entityId));
        HashMap<Long, Set<Long>> periodIds = new HashMap<Long, Set<Long>>(8);
        QFilter filter = new QFilter("id", "in", sceneIds);
        DynamicObject[] dot = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filter.toArray());
        Arrays.stream(dot).forEach(s -> {
            Long sceneId = s.getLong("id");
            DynamicObjectCollection sceneperiod = s.getDynamicObjectCollection("sceneperiod");
            Set<Long> periods = sceneperiod.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            QFilter qflter = new QFilter("id", "in", periods).and("isadjust", "=", (Object)"1");
            DynamicObjectCollection adjusts = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isadjust,useyear", (QFilter[])new QFilter[]{qflter}, (String)"dseq");
            Map<Long, String> adjmap = adjusts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("useyear")));
            ExchangeRateShareSceneHelper.filterValidPeriods(yearNumber, periods, adjmap);
            periodIds.put(sceneId, periods);
        });
        return periodIds;
    }

    public static Set<Long> getScenePeriodIds(String sceneId, String yearNumber) {
        QFilter filter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)sceneId));
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filter.toArray());
        DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
        Set<Long> periods = sceneperiod.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        QFilter qflter = new QFilter("id", "in", periods).and("isadjust", "=", (Object)"1");
        DynamicObjectCollection adjusts = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,isadjust,useyear", (QFilter[])new QFilter[]{qflter}, (String)"dseq");
        Map<Long, String> adjmap = adjusts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("useyear")));
        ExchangeRateShareSceneHelper.filterValidPeriods(yearNumber, periods, adjmap);
        return periods;
    }

    private static void filterValidPeriods(String fynumber, Set<Long> ps, Map<Long, String> adjmap) {
        HashSet noPeriod = new HashSet(ps.size());
        adjmap.forEach((k, v) -> {
            if (!v.contains(fynumber)) {
                noPeriod.add(k);
            }
        });
        ps.removeAll(noPeriod);
    }

    public static Set<Long> getApplySceneIds(Set<Long> sceneIds, Long periodId) {
        QFilter filter = new QFilter("id", "in", sceneIds);
        DynamicObject[] dot = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filter.toArray());
        return Arrays.stream(dot).filter(s -> {
            DynamicObjectCollection sceneperiod = s.getDynamicObjectCollection("sceneperiod");
            return sceneperiod.stream().anyMatch(p -> Objects.equals(periodId.toString(), p.getDynamicObject("fbasedataid").getString("id")));
        }).map(s -> s.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getRateShareIdsApplyScene(Collection<Long> entityIds, Long sceneId) {
        Map<Long, Set<Long>> entity2Scenes = ExchangeRateShareSceneHelper.getRateShareSceneIds(entityIds);
        HashSet<Long> result = new HashSet<Long>(entityIds);
        result.removeIf(s -> {
            Set scene = (Set)entity2Scenes.get(s);
            if (scene != null && scene.contains(sceneId)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        return result;
    }

    public static void clearCommonCacheForRateOrgShareSceneNumberByModelId(long modelId) {
        CacheGenFactory.getCommonCache().invalidateByKey("RateOrgShareSceneNumber" + modelId);
    }

    public static void saveOlap4Rows(List<DynamicObject> rows, boolean isDelete, FixedItem ctx, Object updateCol, OlapSourceEnum sourceEnum) {
        ApplicationTypeEnum app;
        Pair rule;
        if (rows == null || rows.size() == 0) {
            return;
        }
        List<String> allRateColumnsOlap = ExchangeRateShareSceneHelper.getAllrateColumns(ctx.getModelId(), rateColumns4Olap);
        if (updateCol instanceof List) {
            allRateColumnsOlap = new ArrayList<String>((Collection)updateCol);
        }
        String modelNumber = ctx.getModelNum();
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        Pair scenePair = Pair.onePair((Object)DimTypesEnum.SCENARIO.getNumber(), (Object)ctx.getScenarioNum());
        Pair fyPair = Pair.onePair((Object)DimTypesEnum.YEAR.getNumber(), (Object)ctx.getFyNum());
        Pair periodPair = Pair.onePair((Object)DimTypesEnum.PERIOD.getNumber(), (Object)ctx.getPeriodNum());
        Pair entityPair = Pair.onePair((Object)DimTypesEnum.ENTITY.getNumber(), (Object)ctx.getEntityNum());
        Pair interCompany = Pair.onePair((Object)DimTypesEnum.INTERCOMPANY.getNumber(), PresetConstant.INTERNALCOMPANY_MEMS.get(2));
        pairs.add(scenePair);
        pairs.add(fyPair);
        pairs.add(periodPair);
        pairs.add(entityPair);
        if (MemberReader.isExistDimension((String)modelNumber, (String)PresetConstant.AUDITTRIAL_DIM)) {
            Pair at = Pair.onePair((Object)DimTypesEnum.AUDITTRIAL.getNumber(), (Object)"ATNone");
            pairs.add(at);
        }
        if (MemberReader.isExistDimension((String)modelNumber, (String)PresetConstant.CHANGETYPE_DIM)) {
            Pair ct = Pair.onePair((Object)DimTypesEnum.CHANGETYPE.getNumber(), PresetConstant.CHANGETYPE_MEMS.get(1));
            pairs.add(ct);
        }
        pairs.add(interCompany);
        if (MemberReader.isExistDimension((String)modelNumber, (String)PresetConstant.RULE_DIM)) {
            rule = Pair.onePair((Object)DimTypesEnum.MULTIGAAP.getNumber(), PresetConstant.RULE_MEMS.get(1));
            pairs.add(rule);
        }
        if (MemberReader.isExistDimension((String)modelNumber, (String)PresetConstant.DATASORT_DIM)) {
            rule = Pair.onePair((Object)DimTypesEnum.DATASORT.getNumber(), (Object)"Actual");
            pairs.add(rule);
        }
        if (MemberReader.isExistDimension((String)modelNumber, (String)PresetConstant.MYCOMPANY_DIM)) {
            rule = Pair.onePair((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MCNone");
            pairs.add(rule);
        }
        if ((app = ModelServiceHelper.getModelApp(ctx.getModelId())) == ApplicationTypeEnum.RPT || app == ApplicationTypeEnum.UNRPT || app == ApplicationTypeEnum.PUB) {
            QFilter modelFilter = new QFilter("id", "=", (Object)ctx.getModelId());
            DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"bcm_model", (String)"isspptmultrule, isspptdatasort, defineddim", (QFilter[])new QFilter[]{modelFilter});
            String defineddim = modelDyn.getString("defineddim");
            if (defineddim.contains("1")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.Project.getNumber(), (Object)(SysDimensionEnum.Project.getShortnumber() + "None")));
            }
            if (defineddim.contains("2")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.BusinessPartner.getNumber(), (Object)(SysDimensionEnum.BusinessPartner.getShortnumber() + "None")));
            }
            if (defineddim.contains("3")) {
                pairs.add(Pair.onePair((Object)SysDimensionEnum.MultiBook.getNumber(), (Object)(SysDimensionEnum.MultiBook.getShortnumber() + "None")));
            }
        }
        List<DynamicObject> userDefines = QueryDimensionServiceHelper.getUserDefineDim(ctx.getModelId());
        HashSet dimIDs = new HashSet(16);
        userDefines.forEach(u -> dimIDs.add(u.getLong("id")));
        QFilter dimFilter = new QFilter("dimension", "in", dimIDs);
        QFilter modelFilter4Define = new QFilter("model", "=", (Object)ctx.getModelId());
        QFilter levelFilter = new QFilter("level", "=", (Object)2);
        QFilter isSysFilter = new QFilter("ISSYSMEMBER", "=", (Object)1);
        QFilter numberFilter = new QFilter("number", "like", (Object)"%None");
        DynamicObjectCollection dimMembers = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"dimension,number", (QFilter[])new QFilter[]{modelFilter4Define, dimFilter, numberFilter, levelFilter, isSysFilter});
        HashMap<Long, String> dimMap = new HashMap<Long, String>(16);
        for (DynamicObject member : dimMembers) {
            Long dimID = member.getLong("dimension");
            String number = member.getString("number");
            dimMap.put(dimID, number);
        }
        userDefines.forEach(u -> {
            Long dimID = u.getLong("id");
            String dimNumber = u.getString("number");
            Pair userDefineP = Pair.onePair((Object)dimNumber, dimMap.get(dimID));
            pairs.add(userDefineP);
        });
        Optional<Pair> entity = pairs.stream().filter(s -> DimTypesEnum.ENTITY.getNumber().equals(s.p1)).findFirst();
        Optional<Pair> scene = pairs.stream().filter(s -> DimTypesEnum.SCENARIO.getNumber().equals(s.p1)).findFirst();
        Optional<Pair> period = pairs.stream().filter(s -> DimTypesEnum.PERIOD.getNumber().equals(s.p1)).findFirst();
        HashSet<String> sceneNumbers = new HashSet<String>(8);
        if (!(entity.isPresent() && scene.isPresent() && period.isPresent())) {
            return;
        }
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)((String)entity.get().p2));
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNumber, (String)((String)period.get().p2));
        Boolean isShareScene = Boolean.FALSE;
        if (ctx.getScenarioId() == 0L) {
            pairs.remove(scene.get());
            isShareScene = Boolean.TRUE;
            Set<Long> sceneIds = ExchangeRateShareSceneHelper.getRateShare2ApplySceneInPeriod(entityNode.getId(), periodNode.getId());
            sceneIds.forEach(s -> {
                IDNumberTreeNode curScene = MemberReader.findScenaMemberById((String)modelNumber, (Long)s);
                if (IDNumberTreeNode.NotFoundTreeNode != curScene) {
                    sceneNumbers.add(curScene.getNumber());
                }
            });
        } else {
            sceneNumbers.add((String)scene.get().p2);
            pairs.remove(scene.get());
        }
        for (String property : allRateColumnsOlap) {
            ExchageRateServiceHelper.saveExchangeRate4Rows(pairs, rows, property, modelNumber, isDelete, sceneNumbers, sourceEnum);
        }
    }

    public static List<String> getAllrateColumns(Long modelId, String[] rateColumns) {
        DynamicObjectCollection defineDyc = ExchangeRateShareSceneHelper.getAllRateAccount(modelId);
        ArrayList<String> allRateColumns = new ArrayList<String>(Arrays.asList(rateColumns == null ? new String[]{} : rateColumns));
        if (defineDyc != null && defineDyc.size() > 0) {
            allRateColumns.addAll(defineDyc.stream().map(item -> ExchangeRateShareSceneHelper.getRealRateNumber(item.getString("number")).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()));
        }
        return allRateColumns.stream().distinct().collect(Collectors.toList());
    }

    public static String getRealRateNumber(String rateNumber) {
        String result = rateNumber.toLowerCase(Locale.ENGLISH);
        switch (rateNumber) {
            case "ClosingRate": {
                result = "periodend";
                break;
            }
            case "AverageRate": {
                result = "average";
                break;
            }
            case "UserdefinedRate": {
                result = "userdefine";
                break;
            }
            case "BOYRate": {
                result = "beginyear";
                break;
            }
            case "BOYAverageRate": {
                result = "boyaveragerate";
                break;
            }
            case "BOYUserdefinedRate": {
                result = "boyuserdefinedrate";
            }
        }
        return result;
    }

    public static DynamicObjectCollection getAllRateAccount(Long modelId) {
        if (modelId == 0L) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("parent.number", "=", (Object)"ExchangeRate");
        filter.and("accounttype", "=", (Object)AccountTypeEnum.EXCHANGERATE.index);
        DynamicObjectCollection defineDyc = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id,name,number", (QFilter[])filter.toArray());
        return defineDyc;
    }

    public static DynamicObjectCollection getUserDefinedRateAccount(Long modelId) {
        if (modelId == 0L) {
            return new DynamicObjectCollection();
        }
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        QFilter pnumf = new QFilter("parent.number", "=", (Object)"ExchangeRate");
        QFilter isSysFilter = new QFilter("issysmember", "=", (Object)0);
        DynamicObjectCollection defineDyc = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"id,name,number", (QFilter[])new QFilter[]{filter1, pnumf, isSysFilter});
        return defineDyc;
    }

    public static ResultBox calcTriangleRate(FixedItem fixedItem) {
        ResultBox result = ResultBox.of();
        QFilter filter = new QFilter("model", "=", (Object)fixedItem.getModelId());
        DynamicObject[] triangleBaseInfos = BusinessDataServiceHelper.load((String)"bcm_trianglebaseinfo", (String)"source,target", (QFilter[])filter.toArray(), (String)"sort");
        if (triangleBaseInfos == null || triangleBaseInfos.length == 0) {
            return result;
        }
        for (DynamicObject triangleBaseInfo : triangleBaseInfos) {
            ExchangeRateShareSceneHelper.doTriangleTran(fixedItem, triangleBaseInfo, result);
        }
        return result;
    }

    private static void doTriangleTran(FixedItem fixedItem, DynamicObject triangleBaseInfo, ResultBox result) {
        Long sourceid = triangleBaseInfo.getLong("source_id");
        DynamicObject sourceProcess = BusinessDataServiceHelper.loadSingle((Object)sourceid, (String)"bcm_processmembertree", (String)"id,lockcurr");
        String sourcenumber = triangleBaseInfo.getString("source.number");
        String targetnumber = triangleBaseInfo.getString("target.number");
        HashMap filedsMap = Maps.newHashMap();
        filedsMap.put("source", sourcenumber);
        filedsMap.put("target", targetnumber);
        List<DynamicObject> defineRate = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
        DynamicObject originObj = null;
        if (defineRate.size() > 0) {
            originObj = defineRate.get(0);
        }
        if (sourceProcess.getDynamicObject("lockcurr") != null) {
            String lockcurrNumber = sourceProcess.getString("lockcurr.number");
            filedsMap.clear();
            filedsMap.put("source", sourcenumber);
            filedsMap.put("target", lockcurrNumber);
            List<DynamicObject> lockRate1 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
            filedsMap.clear();
            filedsMap.put("source", lockcurrNumber);
            filedsMap.put("target", targetnumber);
            List<DynamicObject> lockRate2 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
            if (lockRate1.size() == 0 || lockRate2.size() == 0) {
                result.addError(String.format(ResManager.loadKDString((String)"%1$s->%2$s\u4e2d\u95f4\u5e01\u5df2\u9501\u5b9a%3$s\uff0c\u65e0\u53ef\u7528\u6c47\u7387\u6570\u636e\u3002", (String)"ExchangeRateShareSceneHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), sourcenumber, targetnumber, lockcurrNumber));
                return;
            }
            ExchangeRateShareSceneHelper.insertTriangleRate(fixedItem, lockRate1.get(0), lockRate2.get(0), sourcenumber, targetnumber, true, originObj);
        } else {
            Optional<DynamicObject> notTraigle;
            if (defineRate.size() > 0 && (notTraigle = defineRate.stream().filter(s -> StringUtils.isEmpty((String)s.getString("triangle"))).findFirst()).isPresent()) {
                result.addError(String.format(ResManager.loadKDString((String)"%1$s\u5230%2$s\u5df2\u7ecf\u5b58\u5728\u6c47\u7387\uff0c\u975e\u9501\u5b9a\u4e0d\u8986\u76d6\u3002", (String)"ExchangeRateShareSceneHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), sourcenumber, targetnumber));
                return;
            }
            HashMap<String, String> source = new HashMap<String, String>(1);
            source.put("source", sourcenumber);
            HashMap<String, String> target = new HashMap<String, String>(1);
            target.put("target", targetnumber);
            List<String> mediumnumbers = ExchangeRateShareSceneHelper.getMediumNum(ExchangeRateShareSceneHelper.getSourceRate(source, fixedItem), ExchangeRateShareSceneHelper.getSourceRate(target, fixedItem), sourcenumber, targetnumber);
            if (mediumnumbers == null || mediumnumbers.isEmpty()) {
                return;
            }
            if (mediumnumbers.size() == 1) {
                String mediumnum = mediumnumbers.get(0);
                filedsMap = Maps.newHashMap();
                filedsMap.put("source", sourcenumber);
                filedsMap.put("target", mediumnum);
                List<DynamicObject> rate1 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
                filedsMap.clear();
                filedsMap.put("source", mediumnum);
                filedsMap.put("target", targetnumber);
                List<DynamicObject> rate2 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
                if (rate1.size() == 0 || rate2.size() == 0) {
                    return;
                }
                ExchangeRateShareSceneHelper.insertTriangleRate(fixedItem, rate1.get(0), rate2.get(0), sourcenumber, targetnumber, false, originObj);
            } else {
                QFilter modelFilter = new QFilter("model", "=", (Object)fixedItem.getModelId());
                QFilter sourceFilter = new QFilter("parent.number", "=", (Object)"TCF");
                QFilter numberFilter = new QFilter("number", "in", mediumnumbers);
                QFilter priorityFilter = new QFilter("priority", ">", (Object)0);
                QFilter currencyFilter = modelFilter.and(sourceFilter).and(numberFilter).and(priorityFilter);
                DynamicObject[] currencys = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,name,number,priority", (QFilter[])new QFilter[]{currencyFilter}, (String)"priority asc", (int)1);
                if (currencys == null || currencys.length == 0) {
                    result.addError(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u4e2d\u95f4\u5e01\u6c47\u7387\uff0c\u4f46\u6ca1\u6709\u6307\u5b9a\u4f18\u5148\u7ea7\u3002", (String)"ExchangeRateShareSceneHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                String mediumnum = currencys[0].getString("number");
                filedsMap = Maps.newHashMap();
                filedsMap.put("source", sourcenumber);
                filedsMap.put("target", mediumnum);
                List<DynamicObject> rate1 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
                filedsMap.clear();
                filedsMap.put("source", mediumnum);
                filedsMap.put("target", targetnumber);
                List<DynamicObject> rate2 = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
                if (rate1.size() == 0 || rate2.size() == 0) {
                    return;
                }
                ExchangeRateShareSceneHelper.insertTriangleRate(fixedItem, rate1.get(0), rate2.get(0), sourcenumber, targetnumber, false, originObj);
            }
        }
    }

    private static void insertTriangleRate(FixedItem fixedItem, DynamicObject rate, DynamicObject rate2, String sourcenumber, String targetnumber, boolean lock, DynamicObject originObj) {
        Long modelId = fixedItem.getModelId();
        boolean isUpdateRate = ConfigServiceHelper.getBoolParam(modelId, "CM009");
        DynamicObject rateRevert = ExchangeRateShareSceneHelper.getReversionRow(fixedItem, rate);
        DynamicObject rateRevert2 = ExchangeRateShareSceneHelper.getReversionRow(fixedItem, rate2);
        int precision = Math.max(rate.getInt("precision"), rate2.getInt("precision"));
        CloneUtils clone = new CloneUtils(true, true);
        DynamicObject rowObj = (DynamicObject)clone.clone((IDataEntityBase)rate);
        rowObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        rowObj.set("eseq", (Object)ExchangeRateShareSceneHelper.getNextSeq(rate.getLong("model.id"), rate.getLong("scene.id"), rate.getLong("fy.id"), rate.getLong("period.id"), rate.getLong("entity.id")));
        rowObj.set("source", (Object)BusinessDataServiceHelper.loadSingle((String)"bcm_processmembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)fixedItem.getModelId()), new QFilter("number", "=", (Object)sourcenumber)}));
        rowObj.set("target", (Object)BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)targetnumber)}));
        List<String> allRateColumns = ExchangeRateShareSceneHelper.getAllrateColumns(modelId, rateColumns);
        for (String property : allRateColumns) {
            if (rate.getLong("fromid") != 0L && rateRevert != null && rate2.getLong("fromid") != 0L && rateRevert2 != null) {
                rowObj.set(property, (Object)(rateRevert.getBigDecimal(property).compareTo(BigDecimal.ZERO) == 0 || rateRevert2.getBigDecimal(property).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimal.ONE.divide(rateRevert.getBigDecimal(property).multiply(rateRevert2.getBigDecimal(property)), precision, RoundingMode.HALF_UP)));
                continue;
            }
            if (rate.getLong("fromid") == 0L && rate2.getLong("fromid") != 0L && rateRevert2 != null) {
                rowObj.set(property, (Object)(rateRevert2.getBigDecimal(property).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : rate.getBigDecimal(property).divide(rateRevert2.getBigDecimal(property), precision, RoundingMode.HALF_UP)));
                continue;
            }
            if (rate2.getLong("fromid") == 0L && rate.getLong("fromid") != 0L && rateRevert != null) {
                rowObj.set(property, (Object)(rateRevert.getBigDecimal(property).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : rate2.getBigDecimal(property).divide(rateRevert.getBigDecimal(property), precision, RoundingMode.HALF_UP)));
                continue;
            }
            rowObj.set(property, (Object)rate.getBigDecimal(property).multiply(rate2.getBigDecimal(property)).setScale(precision, RoundingMode.HALF_UP));
        }
        if (!isUpdateRate) {
            ExchangeRateCopyServiceHelper.resetBeginRateCols(modelId, rowObj);
        }
        rowObj.set("precision", (Object)precision);
        rowObj.set("mutual", (Object)Boolean.FALSE);
        rowObj.set("triangle", (Object)(rate.getDynamicObject("source").getString("number") + " -> " + rate.getDynamicObject("target").getString("number") + " -> " + rate2.getDynamicObject("target").getString("number")));
        rowObj.set("fromid", (Object)0L);
        if (originObj != null) {
            rowObj.set("id", (Object)originObj.getLong("id"));
            if (!isUpdateRate) {
                ExchangeRateCopyServiceHelper.getBeginRateCols(modelId).stream().forEach(s -> rowObj.set(s, originObj.get(s)));
            }
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            updateList.add(rowObj);
            long fromId = originObj.getLong("fromid");
            if (lock && (fromId > 0L || originObj.getBoolean("mutual"))) {
                DynamicObject reversionRow = ExchangeRateShareSceneHelper.getReversionRow(fixedItem, originObj);
                if (reversionRow != null) {
                    reversionRow.set("mutual", (Object)Boolean.FALSE);
                    reversionRow.set("fromid", (Object)0L);
                }
                updateList.add(reversionRow);
            }
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rowObj});
        }
        ExchangeRateShareSceneHelper.saveOlap4Rows(Collections.singletonList(rowObj), Boolean.FALSE, fixedItem, null, OlapSourceEnum.S1);
    }

    private static List<String> getMediumNum(List<DynamicObject> sourceDynamics, List<DynamicObject> targetDynamics, String srcCurrencyNum, String cvtCurrencyNum) {
        HashSet nodeSet = new HashSet(10);
        sourceDynamics.forEach(dy -> {
            nodeSet.add(((DynamicObject)dy.get("source")).getString("number"));
            nodeSet.add(((DynamicObject)dy.get("target")).getString("number"));
        });
        targetDynamics.forEach(dy -> {
            nodeSet.add(((DynamicObject)dy.get("source")).getString("number"));
            nodeSet.add(((DynamicObject)dy.get("target")).getString("number"));
        });
        ListDGraph currDG = new ListDGraph();
        for (String number : nodeSet) {
            currDG.add((Object)number);
        }
        sourceDynamics.forEach(arg_0 -> ExchangeRateShareSceneHelper.lambda$getMediumNum$35((DGraph)currDG, arg_0));
        targetDynamics.forEach(arg_0 -> ExchangeRateShareSceneHelper.lambda$getMediumNum$36((DGraph)currDG, arg_0));
        return currDG.visit((Object)srcCurrencyNum, (Object)cvtCurrencyNum);
    }

    private static List<DynamicObject> getSourceRate(Map<String, String> field2value, FixedItem fixedItem) {
        DynamicObject[] rates;
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)fixedItem.getModelId());
        qfBuilder.add("scene", "=", (Object)fixedItem.getScenarioId());
        qfBuilder.add("fy", "=", (Object)fixedItem.getFyId());
        qfBuilder.add("period", "=", (Object)fixedItem.getPeriodId());
        qfBuilder.add("entity", "=", (Object)fixedItem.getEntityId());
        field2value.forEach((k, v) -> qfBuilder.add(k + ".number", "=", v));
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        for (DynamicObject temprate : rates = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray())) {
            if (temprate.getDynamicObject("source") == null || temprate.getDynamicObject("target") == null) continue;
            result.add(temprate);
        }
        return result;
    }

    private static DynamicObject getReversionRow(FixedItem fixedItem, DynamicObject rate) {
        HashMap filedsMap = Maps.newHashMap();
        filedsMap.put("source", rate.getDynamicObject("target").getString("number"));
        filedsMap.put("target", rate.getDynamicObject("source").getString("number"));
        List<DynamicObject> defineRate = ExchangeRateShareSceneHelper.getSourceRate(filedsMap, fixedItem);
        if (defineRate.size() == 0) {
            return null;
        }
        return defineRate.get(0);
    }

    public static int getNextSeq(Long modelId, Long sceneId, Long fyId, Long periodId, Long entityId) {
        return ((AtomicInteger)ThreadCache.get((Object)("seq@" + sceneId + fyId + periodId + entityId), () -> {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).add("scene", "=", (Object)sceneId).add("fy", "=", (Object)fyId).add("period", "=", (Object)periodId).add("entity", "=", (Object)entityId);
            DynamicObjectCollection eseqAscList = QueryServiceHelper.query((String)"bcm_exchagerate", (String)"id, eseq", (QFilter[])qfBuilder.toArray(), (String)"eseq desc", (int)1);
            Integer seq = eseqAscList != null && eseqAscList.size() > 0 ? ((DynamicObject)eseqAscList.get(0)).getInt("eseq") : 0;
            return new AtomicInteger(seq != null ? seq + 1 : 0);
        })).getAndIncrement();
    }

    public static Boolean checkRateSharePeriodSceneOpen(Long modelId, Long rateSchemaId, Long scenId, Long fyId, Long periodId) {
        if (!ConfigServiceHelper.getBoolParam(modelId, "CM012")) {
            return Boolean.TRUE;
        }
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((Long)modelId, (Long)rateSchemaId);
        if (!ExchangeRateShareSceneHelper.isInRateShare(rateSchemaId.toString(), scenId.toString()).booleanValue()) {
            return PeriodSettingHelper.checkPeriodStatus(modelId, enode.getNumber(), scenId, fyId, periodId, "datastatus");
        }
        Set<Long> shareScenes = ExchangeRateShareSceneHelper.getRateShareSceneIds(rateSchemaId);
        Set<Long> validScenes = ExchangeRateShareSceneHelper.getApplySceneIds(shareScenes, periodId);
        Map<String, Boolean> isOpenMap = PeriodSettingHelper.batchCheckPeriodStatus2(modelId, Sets.newHashSet((Object[])new String[]{enode.getNumber()}), validScenes, Sets.newHashSet((Object[])new Long[]{fyId}), Sets.newHashSet((Object[])new Long[]{periodId}), "datastatus");
        MultiKeyMap orgSceneMap = new MultiKeyMap();
        isOpenMap.forEach((k, v) -> {
            String[] keys = k.split("\\;");
            orgSceneMap.put((Object)keys[0], (Object)keys[1], v);
        });
        if (ExchangeRateShareSceneHelper.getIsAllSceneOpen((MultiKeyMap<String, Boolean>)orgSceneMap, enode.getNumber(), validScenes).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Set<Long> checkRatePeriodSceneOpen(Long modelId, Set<Long> rateSchemaIds, Long sceneId, Long fyId, Long periodId) {
        if (!ConfigServiceHelper.getBoolParam(modelId, "CM012")) {
            return rateSchemaIds;
        }
        HashSet<Long> openIds = new HashSet<Long>(rateSchemaIds.size());
        HashMap orgId2Num = new HashMap(rateSchemaIds.size());
        rateSchemaIds.stream().forEach(s -> {
            IDNumberTreeNode orgnode = MemberReader.findEntityMemberById((Long)modelId, (Long)s);
            if (IDNumberTreeNode.NotFoundTreeNode != orgnode) {
                orgId2Num.put(orgnode.getId(), orgnode.getNumber());
            }
        });
        Map<String, Boolean> isOpenMap = PeriodSettingHelper.batchCheckPeriodStatus2(modelId, Sets.newHashSet(orgId2Num.values()), Sets.newHashSet((Object[])new Long[]{sceneId}), Sets.newHashSet((Object[])new Long[]{fyId}), Sets.newHashSet((Object[])new Long[]{periodId}), "datastatus");
        MultiKeyMap orgSceneMap = new MultiKeyMap();
        isOpenMap.forEach((k, v) -> {
            String[] keys = k.split("\\;");
            orgSceneMap.put((Object)keys[0], (Object)keys[1], v);
        });
        rateSchemaIds.forEach(s -> {
            String orgNum = (String)orgId2Num.get(s);
            if (ExchangeRateShareSceneHelper.getIsAllSceneOpen((MultiKeyMap<String, Boolean>)orgSceneMap, orgNum, Sets.newHashSet((Object[])new Long[]{sceneId})).booleanValue()) {
                openIds.add((Long)s);
            }
        });
        return openIds;
    }

    private static Boolean getIsAllSceneOpen(MultiKeyMap<String, Boolean> orgSceneMap, String orgNum, Set<Long> sceneIds) {
        for (Long sceneId : sceneIds) {
            if (((Boolean)orgSceneMap.get((Object)orgNum, (Object)sceneId.toString())).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean hasWritePermInAllScene(Long modelId, Long entityId, Long sceneId, Long periodId) {
        IDNumberTreeNode snode = MemberReader.findScenaMemberById((Long)modelId, (Long)sceneId);
        if (ExchangeRateShareSceneHelper.isInRateShare(entityId.toString(), sceneId.toString()).booleanValue()) {
            Set<Long> shareScenes = ExchangeRateShareSceneHelper.getRateShareSceneIds(entityId);
            if (LongUtil.isvalidLong((Object)periodId)) {
                shareScenes = ExchangeRateShareSceneHelper.getApplySceneIds(shareScenes, periodId);
            }
            return !shareScenes.stream().anyMatch(s -> !PermissionServiceImpl.getInstance(modelId).hasWritePerm(snode.getDimId(), (Long)s));
        }
        return PermissionServiceImpl.getInstance(modelId).hasWritePerm(snode.getDimId(), sceneId);
    }

    private static /* synthetic */ void lambda$getMediumNum$36(DGraph currDG, DynamicObject dy) {
        currDG.add(new Edge((Object)((DynamicObject)dy.get("source")).getString("number"), (Object)((DynamicObject)dy.get("target")).getString("number")));
    }

    private static /* synthetic */ void lambda$getMediumNum$35(DGraph currDG, DynamicObject dy) {
        currDG.add(new Edge((Object)((DynamicObject)dy.get("source")).getString("number"), (Object)((DynamicObject)dy.get("target")).getString("number")));
    }
}

