/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.exchangeRate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;

public class RateSchemeServiceHelper {
    private static final String NO_RATE_ROOT = "RateEntity";

    public static OrgTreeNode buildLeftTree(DynamicObjectCollection datas, TreeView tree, String showType) {
        OrgTreeNode root = RateSchemeServiceHelper.getOrgTree(datas, showType);
        if (root == null) {
            return new OrgTreeNode("", "");
        }
        root = (OrgTreeNode)TreeBuilder.setOpen(root);
        root.SetIsOpened(true);
        TreeModel<OrgTreeNode> treemodel = new TreeModel<OrgTreeNode>(root);
        treemodel.buildEntryTree(tree);
        return root;
    }

    public static OrgTreeNode getOrgTree(DynamicObjectCollection rootNodeList, String showType) {
        return RateSchemeServiceHelper.getOrgRoot(rootNodeList, showType);
    }

    private static OrgTreeNode getOrgRoot(DynamicObjectCollection rootNodeList, String showType) {
        HashMap<String, List<DynamicObject>> nodeMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject node : rootNodeList) {
            String parentId = node.getString("parent_id");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)nodeMap.get(parentId);
            if (NO_RATE_ROOT.equals(node.getString("number"))) {
                node.set("parent_id", (Object)0L);
                parentId = "0";
            }
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                nodeMap.put(parentId, list);
            }
            list.add(node);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (DynamicObject)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        return RateSchemeServiceHelper.createNode(rootNode, null, nodeMap, showType);
    }

    private static OrgTreeNode createNode(DynamicObject map, OrgTreeNode parentNode, Map<String, List<DynamicObject>> nodeMap, String showType) {
        String id = map.getString("id");
        String name = map.getString("name");
        String number = map.getString("number");
        Boolean isshare = map.getBoolean("issharescene");
        String formatName = RateSchemeServiceHelper.formatDisplayName(showType, name, number, isshare);
        OrgTreeNode curNode = new OrgTreeNode(id, formatName, number);
        List<DynamicObject> list = nodeMap.get(id);
        curNode.SetIsOpened(true);
        if (parentNode != null) {
            curNode.setParent(parentNode);
            parentNode.addChild(curNode);
        }
        if (list != null) {
            for (DynamicObject dnm : list) {
                RateSchemeServiceHelper.createNode(dnm, curNode, nodeMap, showType);
            }
        }
        return curNode;
    }

    public static String formatDisplayName(String showType, String name, String number, Boolean isshare) {
        StringBuilder formatName = new StringBuilder();
        switch (showType = StringUtils.isEmpty((String)showType) ? "3" : showType) {
            case "1": {
                formatName.append(number);
                break;
            }
            case "2": {
                formatName.append(name);
                break;
            }
            case "3": {
                formatName.append(number);
                formatName.append(" ");
                formatName.append(name);
            }
        }
        if (isshare.booleanValue()) {
            formatName.append(ResManager.loadKDString((String)"(\u5171\u4eab)", (String)"RateSchemeServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return formatName.toString();
    }
}

