/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportExecute {
    private static final int ROW_SIZE = 50000;
    private Map<Long, DynamicObject> srcDimmembMap = new HashMap<Long, DynamicObject>(16);
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);
    private String formId;

    private StringBuilder creatRangeStr(String value, String range) {
        StringBuilder str1 = new StringBuilder();
        switch (range) {
            case "10": {
                str1.append(value).append(";");
                break;
            }
            case "20": {
                str1.append("Child(").append(value).append(");");
                break;
            }
            case "30": {
                str1.append("Ichild(").append(value).append(");");
                break;
            }
            case "40": {
                str1.append("Descendant(").append(value).append(");");
                break;
            }
            case "50": {
                str1.append("Hierarchy(").append(value).append(");");
                break;
            }
            case "60": {
                str1.append("Sibling(").append(value).append(");");
                break;
            }
            case "70": {
                str1.append("Isibling(").append(value).append(");");
                break;
            }
            case "90": {
                str1.append("Base(").append(value).append(");");
                break;
            }
        }
        return str1;
    }

    private String getCombination(JSONArray dmvalJsom) {
        StringBuilder strBu = new StringBuilder();
        dmvalJsom.forEach(o -> {
            if (o != null) {
                JSONObject dObject = (JSONObject)o;
                String number = (String)dObject.get((Object)"number");
                String scope = (String)dObject.get((Object)"scope");
                strBu.append((CharSequence)this.creatRangeStr(number, scope));
            }
        });
        return strBu.length() == 0 ? null : strBu.substring(0, strBu.length() - 1);
    }

    public String exportDimMemberMapping(String routeAppId, String formId, Long modelId, Long schemeId, Long template, String extendData) throws IOException {
        this.formId = formId;
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, extendData);
        if (format == null) {
            return null;
        }
        int rowIndex = 3;
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter schemeModel = new QFilter("scheme", "=", (Object)schemeId);
        QFilter[] qFilter = null;
        qFilter = new QFilter[]{filterModel, schemeModel};
        StringBuilder selectFields = new StringBuilder(String.join((CharSequence)",", format.fields));
        if (!format.next.isEmpty()) {
            for (ExportWriterFormat entryEntity : format.next) {
                selectFields.append(",entryentity.id,entryentity.tagfieldselect,entryentity.periodselect,entryentity.").append(String.join((CharSequence)",entryentity.", entryEntity.fields));
            }
        }
        String name = extendData.substring(0, extendData.lastIndexOf("imp"));
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.load((String)name, (String)selectFields.toString(), (QFilter[])qFilter);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        for (DynamicObject dimMapping : arrDimMapping) {
            DynamicObjectCollection entry = dimMapping.getDynamicObjectCollection("entryentity");
            for (Object entryRow : entry) {
                entryIdSet.add(entryRow.getLong("id"));
            }
        }
        QFilter entryIdFilter = new QFilter("dimmembentry", "in", entryIdSet);
        String selectEntryFields = "id,dimmembentry,srcdimmemb,srcdimmembnumber,tagdimmemb,tagdimmembnumber,relation";
        DynamicObjectCollection entryMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)selectEntryFields, (QFilter[])new QFilter[]{entryIdFilter}, (String)"srcdimmembnumber");
        HashMap<Long, List> rowsMap = new HashMap<Long, List>(16);
        HashSet<Long> tagDimmembIds = new HashSet<Long>(16);
        HashSet<Long> srcDimmembIds = new HashSet<Long>(16);
        for (DynamicObject entryMember : entryMembers) {
            Long entryId = entryMember.getLong("dimmembentry");
            Long tagDimmembId = entryMember.getLong("tagdimmemb");
            srcDimmembIds.add(entryMember.getLong("srcdimmemb"));
            tagDimmembIds.add(tagDimmembId);
            rowsMap.putIfAbsent(entryId, new ArrayList(10));
            rowsMap.computeIfPresent(entryId, (k, v) -> {
                v.add(entryMember);
                return v;
            });
        }
        for (DynamicObject dimMapping : arrDimMapping) {
            DynamicObjectCollection entry = dimMapping.getDynamicObjectCollection("entryentity");
            int rowCount = entry.size();
            DynamicObject tagdim = dimMapping.getDynamicObject("tagdim");
            String entityName = tagdim.getString("membermodel");
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            DynamicObject[] tagDimmembs = BusinessDataServiceHelper.load((Object[])tagDimmembIds.toArray(), (DynamicObjectType)entity.getDynamicObjectType());
            HashMap<Long, DynamicObject> tagDimmembMap = new HashMap<Long, DynamicObject>(tagDimmembIds.size());
            for (DynamicObject tagDimmemb : tagDimmembs) {
                tagDimmembMap.put(tagDimmemb.getLong("id"), tagDimmemb);
            }
            if ("bcm_fymembertree".equals(entityName)) {
                DynamicObject[] periodDimmembs;
                entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_periodmembertree");
                for (DynamicObject periodDimmemb : periodDimmembs = BusinessDataServiceHelper.load((Object[])tagDimmembIds.toArray(), (DynamicObjectType)entity.getDynamicObjectType())) {
                    tagDimmembMap.put(periodDimmemb.getLong("id"), periodDimmemb);
                }
            }
            DynamicObject srcdim = dimMapping.getDynamicObject("srcdim");
            entityName = srcdim.getString("entitynumber");
            DynamicObjectCollection srcDimmembs = QueryServiceHelper.query((String)entityName, (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "in", srcDimmembIds)});
            for (DynamicObject srcDimmemb : srcDimmembs) {
                this.srcDimmembMap.put(srcDimmemb.getLong("id"), srcDimmemb);
            }
            block29: for (int i = 0; i < rowCount; ++i) {
                String relation;
                DynamicObject entryRowId = (DynamicObject)entry.get(i);
                Long entryId = entryRowId.getLong("id");
                List rowDatas = (List)rowsMap.get(entryId);
                switch (relation = ((DynamicObject)rowDatas.get(0)).getString("relation")) {
                    case "1": {
                        this.setDataByEquals(entryRowId, rowDatas, tagDimmembMap);
                        continue block29;
                    }
                    case "2": {
                        this.setDataByBetween(entryRowId, rowDatas, tagDimmembMap);
                        continue block29;
                    }
                    case "3": {
                        this.setDataByLike(entryRowId, rowDatas, tagDimmembMap);
                        continue block29;
                    }
                    case "4": {
                        this.setDataByIn(entryRowId, rowDatas, tagDimmembMap);
                        continue block29;
                    }
                }
            }
        }
        String json = SerializationUtils.toJsonString((Object)arrDimMapping);
        JSONArray billArr = JSON.parseArray((String)json);
        String fileName = this.genFileName(template, extendData, this.exportPrefix);
        try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                rowIndex += Math.max(offset, 1);
            }
        }
        return this.writeFile(wb, fileName);
    }

    /*
     * WARNING - void declaration
     */
    public String exportDimMemberMappingWelkin(String routeAppId, String formId, Long modelId, Long schemeId, Long template, String extendData) throws IOException {
        this.formId = formId;
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, template, extendData);
        if (format == null) {
            return null;
        }
        int rowIndex = 3;
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter schemeModel = new QFilter("scheme", "=", (Object)schemeId);
        QFilter[] qFilter = null;
        qFilter = new QFilter[]{filterModel, schemeModel};
        StringBuilder selectFields = new StringBuilder(String.join((CharSequence)",", format.fields));
        if (!format.next.isEmpty()) {
            for (ExportWriterFormat entryEntity : format.next) {
                selectFields.append(",entryentity.id,entryentity.tagfieldselect,entryentity.periodselect,entryentity.").append(String.join((CharSequence)",entryentity.", entryEntity.fields));
            }
        } else {
            selectFields.append(",entryentity,entryentity.membermodel ");
        }
        String name = extendData;
        if (!"bcm_dimmembwelkin".equals(extendData)) {
            name = extendData.substring(0, extendData.lastIndexOf("imp"));
        }
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.load((String)name, (String)selectFields.toString(), (QFilter[])qFilter);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        for (DynamicObject dimMapping : arrDimMapping) {
            DynamicObjectCollection entry = dimMapping.getDynamicObjectCollection("entryentity");
            for (Object entryRow : entry) {
                entryIdSet.add(entryRow.getLong("id"));
            }
        }
        QFilter entryIdFilter = new QFilter("dimmembentry", "in", entryIdSet);
        String selectEntryFields = "id,dimmembentry,srcdimmemb,srcdimmembnumber,tagdimmemb,tagdimmembnumber,relation";
        DynamicObjectCollection entryMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)selectEntryFields, (QFilter[])new QFilter[]{entryIdFilter}, (String)"srcdimmembnumber");
        HashMap<Long, List> rowsMap = new HashMap<Long, List>(16);
        HashSet<Long> tagDimmembIds = new HashSet<Long>(16);
        HashSet<Long> srcDimmembIds = new HashSet<Long>(16);
        for (DynamicObject entryMember : entryMembers) {
            Long entryId = entryMember.getLong("dimmembentry");
            Long tagDimmembId = entryMember.getLong("tagdimmemb");
            Long srcDimmembId = entryMember.getLong("srcdimmemb");
            srcDimmembIds.add(srcDimmembId);
            tagDimmembIds.add(tagDimmembId);
            rowsMap.putIfAbsent(entryId, new ArrayList(10));
            rowsMap.computeIfPresent(entryId, (k, v) -> {
                v.add(entryMember);
                return v;
            });
        }
        for (DynamicObject dimMapping : arrDimMapping) {
            void var39_51;
            DynamicObject[] srcDimmembs;
            DynamicObjectCollection entry = dimMapping.getDynamicObjectCollection("entryentity");
            int rowCount = entry.size();
            DynamicObject tagdim = dimMapping.getDynamicObject("tagdim");
            if (tagdim == null) continue;
            String entityName = tagdim.getString("entitynumber");
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            DynamicObject[] tagDimmembs = BusinessDataServiceHelper.load((Object[])tagDimmembIds.toArray(), (DynamicObjectType)entity.getDynamicObjectType());
            HashMap<Long, DynamicObject> tagDimmembMap = new HashMap<Long, DynamicObject>(tagDimmembs.length);
            for (DynamicObject dynamicObject : tagDimmembs) {
                tagDimmembMap.put(dynamicObject.getLong("id"), dynamicObject);
            }
            DynamicObject srcdim = dimMapping.getDynamicObject("srcdim");
            entityName = srcdim.getString("membermodel");
            DynamicObject srcEntity = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            for (DynamicObject srcDimmemb : srcDimmembs = BusinessDataServiceHelper.load((Object[])srcDimmembIds.toArray(), (DynamicObjectType)srcEntity.getDynamicObjectType())) {
                this.srcDimmembMap.put(srcDimmemb.getLong("id"), srcDimmemb);
            }
            boolean bl = false;
            while (var39_51 < rowCount) {
                String relation;
                DynamicObject entryRowId = (DynamicObject)entry.get((int)var39_51);
                Long entryId = entryRowId.getLong("id");
                List rowDatas = (List)rowsMap.get(entryId);
                switch (relation = ((DynamicObject)rowDatas.get(0)).getString("relation")) {
                    case "1": {
                        this.setDataByEquals(entryRowId, rowDatas, tagDimmembMap);
                        break;
                    }
                    case "2": {
                        this.setDataByBetween(entryRowId, rowDatas, tagDimmembMap);
                        break;
                    }
                    case "3": {
                        this.setDataByLike(entryRowId, rowDatas, tagDimmembMap);
                        break;
                    }
                    case "4": {
                        this.setDataByIn(entryRowId, rowDatas, tagDimmembMap);
                        break;
                    }
                }
                ++var39_51;
            }
        }
        String json = SerializationUtils.toJsonString((Object)arrDimMapping);
        JSONArray billArr = JSON.parseArray((String)json);
        String fileName = this.genFileName(template, extendData, this.exportPrefix);
        try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                if (offset > 1) {
                    rowIndex += offset;
                    continue;
                }
                ++rowIndex;
            }
        }
        return this.writeFile(wb, fileName);
    }

    private void setDataByLike(DynamicObject entryRow, List<DynamicObject> rowDatas, Map<Long, DynamicObject> tagDimmembMap) {
        DynamicObject entryMember = rowDatas.get(0);
        String srcdimmembnumber = entryMember.getString("srcdimmembnumber") + "*";
        this.setRowData(entryRow, entryMember, srcdimmembnumber, tagDimmembMap);
    }

    private void setDataByIn(DynamicObject entryRow, List<DynamicObject> rowDatas, Map<Long, DynamicObject> tagDimmembMap) {
        DynamicObject entryMember = rowDatas.get(0);
        StringBuilder srcdimmembnumberBuilder = new StringBuilder();
        for (int i = 0; i < rowDatas.size(); ++i) {
            srcdimmembnumberBuilder.append(rowDatas.get(0).getString("srcdimmembnumber")).append(',');
        }
        String srcdimmembnumber = srcdimmembnumberBuilder.substring(0, srcdimmembnumberBuilder.lastIndexOf(","));
        this.setRowData(entryRow, entryMember, srcdimmembnumber, tagDimmembMap);
    }

    private void setDataByBetween(DynamicObject entryRow, List<DynamicObject> rowDatas, Map<Long, DynamicObject> tagDimmembMap) {
        DynamicObject entryMember = rowDatas.get(0);
        String srcdimmembnumber = rowDatas.get(0).getString("srcdimmembnumber") + ":" + rowDatas.get(1).getString("srcdimmembnumber");
        this.setRowData(entryRow, entryMember, srcdimmembnumber, tagDimmembMap);
    }

    private void setDataByEquals(DynamicObject entryRow, List<DynamicObject> rowDatas, Map<Long, DynamicObject> tagDimmembMap) {
        DynamicObject entryMember = rowDatas.get(0);
        String srcdimmembnumber = entryMember.getString("srcdimmembnumber");
        this.setRowData(entryRow, entryMember, srcdimmembnumber, tagDimmembMap);
        if (rowDatas.size() > 1) {
            DynamicObject otherMember = rowDatas.get(1);
            String tagDimNumber = otherMember.getString("tagdimmembnumber");
            if (tagDimNumber.startsWith("FY") || tagDimNumber.contains("Year")) {
                this.setRowData(entryRow, otherMember, srcdimmembnumber, tagDimmembMap);
                entryRow.set("period", (Object)tagDimmembMap.get(entryMember.getLong("tagdimmemb")));
                entryRow.set("period_Id", (Object)entryMember.getLong("tagdimmemb"));
                entryRow.set("periodnumber", (Object)entryMember.getString("tagdimmembnumber"));
            } else {
                entryRow.set("period", (Object)tagDimmembMap.get(otherMember.getLong("tagdimmemb")));
                entryRow.set("period_Id", (Object)otherMember.getLong("tagdimmemb"));
                entryRow.set("periodnumber", (Object)tagDimNumber);
            }
        }
    }

    private void setRowData(DynamicObject entryRow, DynamicObject entryMember, String srcdimmembnumber, Map<Long, DynamicObject> tagDimmembMap) {
        entryRow.set("relation", (Object)entryMember.getString("relation"));
        DynamicObject srcDyn = this.srcDimmembMap.get(entryMember.getLong("srcdimmemb"));
        if (srcDyn != null) {
            entryRow.set("srcdimmemb", (Object)srcDyn.getString("name"));
            entryRow.set("srcdimmembnumber", (Object)srcDyn.getString("number"));
        } else {
            entryRow.set("srcdimmemb", (Object)srcdimmembnumber);
            entryRow.set("srcdimmembnumber", (Object)srcdimmembnumber);
        }
        if (!"bcm_dimmembwelkin".equals(this.formId)) {
            entryRow.set("tagdimmemb", (Object)tagDimmembMap.get(entryMember.getLong("tagdimmemb")));
            entryRow.set("tagdimmemb_Id", (Object)entryMember.getLong("tagdimmemb"));
        } else {
            entryRow.set("tagdimmemb", tagDimmembMap.get(entryMember.get("tagdimmemb")).get("name"));
        }
        entryRow.set("tagdimmembnumber", (Object)entryMember.getString("tagdimmembnumber"));
    }

    public String genFileName(Long template, String billFormId, String fileNamePrefix) {
        String fileName = fileNamePrefix;
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth()) + ".xlsx";
        return fileName;
    }

    /*
     * Exception decompiling
     */
    private String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DynamicObject getDyobj(long id, String entity) {
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)id);
        if (entity.equals("bcm_model")) {
            return QueryServiceHelper.queryOne((String)entity, (String)"id,name,number,shownumber", (QFilter[])qf.toArray());
        }
        return QueryServiceHelper.queryOne((String)entity, (String)"id,name,number", (QFilter[])qf.toArray());
    }
}

