/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.DispatchServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class NewExportUtil {
    public static final String BOS_IMPORTTEMPLATE = "bos_importtemplate";
    public static final int FLUSH_TIMEOUT_SECOND = 300;

    public static String export(String routeAppId, DynamicObject[] exportDyns, String exportNum, String entityNum, String fileName) throws Exception {
        return NewExportUtil.export(routeAppId, exportDyns, exportNum, entityNum, fileName, null);
    }

    public static String export(String routeAppId, DynamicObject[] exportDyns, String exportNum, String entityNum, String fileName, Consumer<ExportWriterFormat> formateHandler) throws Exception {
        QFilter qFilter = new QFilter("number", "=", (Object)exportNum);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"exportAlgoKey", (String)BOS_IMPORTTEMPLATE, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (CollectionUtils.isEmpty((Collection)pkIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528-\u914d\u7f6e\u5de5\u5177-\u5f15\u5165\u5f15\u51fa\u6a21\u677f\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"NewExportUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String exportJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{entityNum, pkIds.get(0), "", exportNum});
        List formats = JSON.parseArray((String)exportJson, ExportWriterFormat.class);
        if (formateHandler != null) {
            formats.forEach(formateHandler::accept);
        }
        if (exportDyns.length > 0) {
            NewExportUtil.clearChangeTypeAndAuditTrail(exportDyns[0], (ExportWriterFormat)formats.get(0));
        }
        ListDataExporter exporter = new ListDataExporter(entityNum, formats, false);
        JSONArray billArr = JSON.parseArray((String)SerializationUtils.toJsonString((Object)exportDyns));
        DynamicObjectType dataEntityType = (DynamicObjectType)exportDyns[0].getDataEntityType();
        int rowIndex = 4;
        try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                if (bill == null) continue;
                exporter.handleData(bill, dataEntityType, exportDyns[i]);
                NewExportUtil.billFormatConfig(bill);
                int offset = exporter.writeData(bill, rowIndex, (ExportWriterFormat)formats.get(0), false, fileName, false);
                rowIndex += Math.max(offset, 1);
            }
        }
        return exporter.flush(fileName, 300);
    }

    private static void billFormatConfig(JSONObject bill) {
        for (Map.Entry billEntry : bill.entrySet()) {
            if (!(billEntry.getValue() instanceof BigDecimal) || !bill.containsKey(billEntry.getKey())) continue;
            bill.put((String)billEntry.getKey(), (Object)((BigDecimal)billEntry.getValue()).stripTrailingZeros());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private static void clearChangeTypeAndAuditTrail(DynamicObject exportData, ExportWriterFormat format) {
        Long modelId = NewExportUtil.getModelId(exportData);
        NewExportUtil.clearChangeTypeAndAuditTrail(modelId, format);
    }

    private static void clearChangeTypeAndAuditTrail(Long modelId, ExportWriterFormat format) {
        if (modelId != null && modelId != 0L) {
            if (!MemberReader.isExistChangeTypeDimension((long)modelId)) {
                NewExportUtil.clearChangeType(format);
            }
            if (!MemberReader.isExistAuditTrailDimension((long)modelId)) {
                NewExportUtil.clearAuditTrail(format);
            }
        }
    }

    private static Long getModelId(DynamicObject dot) {
        DataEntityPropertyCollection props = dot.getDataEntityType().getProperties();
        String propKey = null;
        if (props.containsKey((Object)"model")) {
            propKey = "model";
        } else if (props.containsKey((Object)"modelid")) {
            propKey = "modelid";
        }
        if (propKey == null) {
            return null;
        }
        Object model = dot.get(propKey);
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        if (model instanceof Long) {
            return LongUtil.toLong((Object)model);
        }
        return null;
    }

    private static void clearChangeType(ExportWriterFormat format) {
        if (format != null) {
            format.flexColumn.keySet().removeIf(e -> e.startsWith("changetype"));
            format.flexColumnDisplay.keySet().removeIf(e -> e.startsWith("changetype"));
            format.flexColumnDesc.keySet().removeIf(e -> e.startsWith("changetype"));
            format.fields.removeIf(e -> e.startsWith("changetype"));
            format.properties.keySet().removeIf(e -> e.startsWith("changetype"));
            if (!format.next.isEmpty()) {
                format.next.forEach(f -> {
                    f.flexColumn.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.flexColumnDisplay.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.flexColumnDesc.keySet().removeIf(e -> e.startsWith("changetype"));
                    f.fields.removeIf(e -> e.startsWith("changetype"));
                    f.properties.keySet().removeIf(e -> e.startsWith("changetype"));
                });
            }
        }
    }

    private static void clearAuditTrail(ExportWriterFormat format) {
        if (format != null) {
            format.flexColumn.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.flexColumnDisplay.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.flexColumnDesc.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.fields.removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            format.properties.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
            if (!format.next.isEmpty()) {
                format.next.forEach(f -> {
                    f.flexColumn.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.flexColumnDisplay.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.flexColumnDesc.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.fields.removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                    f.properties.keySet().removeIf(e -> e.contains("audittrail") || e.contains("audittrial"));
                });
            }
        }
    }
}

