/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.common.util.DataAuthUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AuthExportStrategy
implements IExport {
    private static final String NAME = "name";
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        String selectFiled;
        DynamicObject[] authDatas;
        Long modelId = (Long)outputParams.get("modelId");
        QFBuilder filter = new QFBuilder("model", "=", (Object)modelId);
        Object idList = outputParams.get("idList");
        if (Objects.nonNull(idList)) {
            filter.add("id", "in", idList);
        }
        if ((authDatas = BusinessDataServiceHelper.load((String)entityName, (String)(selectFiled = "model.shownumber,users,username,usertype,authclass.number,data_auth,level1,level2,level3,level4,level5,level6,level7,level8,level9,level10,level11,level12"), (QFilter[])filter.toArray())) == null || authDatas.length == 0) {
            return null;
        }
        DynamicObject[] approvalInfo = DataAuthUtil.getApprovalInfo((Long)modelId);
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, String> showSteptypeNameMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < approvalInfo.length - 2; ++i) {
            sb.append("level");
            sb.append(i + 1);
            sb.append(",");
            showSteptypeNameMap.put("level" + (i + 1) + "step", approvalInfo[i].get(NAME).toString());
        }
        sb.append("level11,");
        sb.append("level12,");
        showSteptypeNameMap.put("level11step", approvalInfo[approvalInfo.length - 2].get(NAME).toString());
        showSteptypeNameMap.put("level12step", approvalInfo[approvalInfo.length - 1].get(NAME).toString());
        ArrayList exportMapList = new ArrayList(10);
        if (sb.length() > 0) {
            sb.substring(0, sb.length() - 1);
            String steptypeFied = String.valueOf(sb);
            String[] steptypeList = steptypeFied.split(",");
            for (DynamicObject authData : authDatas) {
                LinkedHashMap<String, Object> authDataMap = new LinkedHashMap<String, Object>();
                authDataMap.put("model_number", authData.get("model.shownumber"));
                authDataMap.put("users", authData.get("users"));
                DynamicObject users = (DynamicObject)authData.get("users");
                authDataMap.put("username", Objects.nonNull(users) && Objects.nonNull(users.getLocaleString(NAME)) && Objects.nonNull(users.getLocaleString(NAME).getLocaleValue()) ? users.getLocaleString(NAME).getLocaleValue() : "");
                authDataMap.put("usertype", authData.get("usertype"));
                authDataMap.put("data_auth", authData.get("data_auth"));
                authDataMap.put("auth", authData.get("authclass.number"));
                for (int i = 0; i < steptypeList.length; ++i) {
                    Object steptypecalue = authData.get(steptypeList[i]);
                    if (!"".equals(steptypecalue)) {
                        authDataMap.put(steptypeList[i] + "step", "true");
                        continue;
                    }
                    authDataMap.put(steptypeList[i] + "step", "false");
                }
                exportMapList.add(authDataMap);
            }
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle style = new ExportSheetStyle(wb);
        String json = SerializationUtils.toJsonString(exportMapList);
        JSONArray billArr = JSON.parseArray((String)json);
        int rowIndex = 3;
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.getAuthExportWriterFormatAndWriteHead(wb, sheet, style, routeAppId, formId, importTemplateId, entityName, showSteptypeNameMap);
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (JSONObject)bill, (int)(rowIndex + i + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

