/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.export.strategy.helper.UserDefinedDimShortNumAndFieldMapCache;
import kd.fi.bcm.common.cache.MemberReader;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DimDefaultValueExportStrategy
implements IExport {
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        Long modelId = (Long)outputParams.get("modelId");
        String useDinMenu = (String)outputParams.get("useDinMenu");
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("usedinmenu", "=", (Object)useDinMenu);
        qf.and("creatorid", "=", (Object)RequestContext.get().getCurrUserId());
        String selectFields = "id, dimension, usedinmenu, defaultnumber, defaultvalue, defaultvalueid";
        DynamicObjectCollection oldData = QueryServiceHelper.query((String)"bcm_defaultvalue", (String)selectFields, (QFilter[])qf.toArray(), (String)"modifydate");
        ArrayList<DynamicObject> exportList = new ArrayList<DynamicObject>(32);
        if (oldData.size() > 0) {
            this.setData((List<DynamicObject>)oldData, modelId, useDinMenu, exportList);
        }
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, importTemplateId, entityName);
        if (format == null) {
            return null;
        }
        int rowIndex = 3;
        for (DynamicObject dyn : exportList) {
            String f = SerializationUtils.toJsonString((Object)dyn);
            JSONObject jsonObject = (JSONObject)JSON.parse((String)f);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)jsonObject, (int)(++rowIndex), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        ExportUtil.postWriteSheet(wb, sheet);
        UserDefinedDimShortNumAndFieldMapCache.clear();
        return ExportUtil.writeFile(wb, fileName);
    }

    private void setData(List<DynamicObject> oldData, Long modelId, String useDinMenu, List<DynamicObject> exportList) {
        for (DynamicObject oldDatum : oldData) {
            String dimNum = oldDatum.getString("dimension");
            long memId = Long.parseLong(oldDatum.getString("defaultvalueid"));
            DynamicObject dimDy = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum));
            String dimName = dimDy.getString("name");
            String entityName = dimDy.getString("membermodel");
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and("id", "=", (Object)memId);
            DynamicObject memDy = QueryServiceHelper.queryOne((String)entityName, (String)"number, name, longnumber", (QFilter[])qf.toArray());
            String memNum = memDy.getString("number");
            String memName = memDy.getString("name");
            String longnumber = memDy.getString("longnumber");
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_defaultvalue_imp");
            dy.set("dimensionnum", (Object)dimNum);
            dy.set("dimensionname", (Object)dimName);
            dy.set("usedinmenu", (Object)useDinMenu);
            dy.set("defaultnumber", (Object)memNum);
            dy.set("defaultvalue", (Object)memName);
            dy.set("longnumber", (Object)longnumber);
            exportList.add(dy);
        }
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

