/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.export.strategy.helper.DimShortNumAndFieldMap;
import kd.fi.bcm.business.export.strategy.helper.UserDefinedDimShortNumAndFieldMapCache;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.enums.CurrencyScaleEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DimensionMemberExportStrategy
implements IExport {
    protected static final Log LOG = LogFactory.getLog(DimensionMemberExportStrategy.class);
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);
    private String sExtendData;
    private static final String ACCOUNTSCALE = "accountscale";
    private static final int batchSize = 100000;
    public static final Set<String> ENUM_NEED_NAME = Sets.newHashSet((Object[])new String[]{"bcm_accountmembertree", "bcm_changetypemembertree", "bcm_scenemembertree", "bcm_userdefinedmembertree"});
    private List<DynamicObject> exportList = new ArrayList<DynamicObject>(10);

    @Override
    public String export(String routeAppId, long template, String formId, String extendData, Map<String, Object> outputParams) throws IOException {
        Long modelId = (Long)outputParams.get("modelId");
        Long dimId = (Long)outputParams.get("dimId");
        String schemeId = outputParams.get("schemeId") == null ? null : outputParams.get("schemeId").toString();
        Object selectData = outputParams.get("selectData");
        ArrayList<Long> memIds = selectData == null ? new ArrayList() : (List)selectData;
        this.sExtendData = extendData;
        SXSSFWorkbook wb = new SXSSFWorkbook(100000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadCustomized(wb, sheet, styles, routeAppId, formId, template, extendData, modelId, dimId);
        if (format == null) {
            return null;
        }
        String selectFields = this.getSelectedFields(extendData, format, schemeId);
        memIds = this.getMemberIds(modelId, dimId, extendData, schemeId, memIds);
        Map<Long, String> idPropertyMap = this.getIdPropertyMap(extendData, memIds, modelId, dimId);
        HashMap<Long, String> idCurrencyScaleMap = new HashMap<Long, String>();
        this.getIdCurrencyScale(extendData, modelId, idCurrencyScaleMap);
        Map<String, Integer> accountScaleMap = this.getAccountScale(extendData, modelId);
        String fileName = ExportUtil.genFullFileName(template, extendData, this.exportPrefix);
        HashMap schemeParent = new HashMap();
        Map<Long, DynamicObject> id2permClass = this.getThisDimensionMemberPermClass(modelId, extendData);
        Map<String, String> allRuleStrByMembers = this.getThisDimensionMemberShieldDim(modelId, dimId, extendData, memIds);
        DimShortNumAndFieldMap dimShortNumAndFieldMap = new DimShortNumAndFieldMap(modelId);
        this.setHiddenColumn(sheet, dimShortNumAndFieldMap, extendData);
        int starIndex = 3;
        AtomicInteger batch = new AtomicInteger(0);
        BatchProcessHelper.batchConsume(memIds, (int)100000, batchIds -> {
            int rowIndex = starIndex + batch.get() * 100000;
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            qf.and("id", "in", batchIds);
            DynamicObject[] batchDatas = BusinessDataServiceHelper.load((String)extendData, (String)selectFields, (QFilter[])qf.toArray(), (String)"level,dseq");
            this.setDynValue(batchDatas);
            for (DynamicObject dyn : this.exportList) {
                boolean flag;
                JSONObject jsonObject = this.getJsonObject(extendData, idCurrencyScaleMap, accountScaleMap, idPropertyMap, schemeParent, dyn, dimShortNumAndFieldMap, id2permClass, allRuleStrByMembers);
                boolean bl = flag = "bcm_userdefinedmembertree".equals(extendData) && format.properties.containsKey("enumitem");
                if (flag) {
                    ((Map)format.properties.get("enumitem")).put("DataKey", "name");
                }
                ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)jsonObject, (int)(++rowIndex), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                if (rowIndex < 1000000) continue;
                return;
            }
            ExportUtil.postDataToSheet(wb, sheet);
            batch.getAndIncrement();
            this.exportList.clear();
        });
        ExportUtil.setDimensionName(wb, sheet);
        UserDefinedDimShortNumAndFieldMapCache.clear();
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }

    private void getIdCurrencyScale(String extendData, Long modelId, Map<Long, String> idCurrencyScaleMap) {
        if (!"bcm_scenemembertree".equalsIgnoreCase(extendData)) {
            return;
        }
        QFilter sceneFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] sceneObjs = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"id,name,number,scaleentry,scaleentry.currency,scaleentry.scale", (QFilter[])sceneFilter.toArray());
        HashMap<Long, Map> idCurrencyMap = new HashMap<Long, Map>(16);
        Arrays.stream(sceneObjs).forEach(dyn -> {
            LinkedHashMap temp = new LinkedHashMap(16);
            dyn.getDynamicObjectCollection("scaleentry").forEach(e -> temp.put(e.getString("currency.number"), e.getInt("scale")));
            idCurrencyMap.put(dyn.getLong("id"), temp);
        });
        String selectFields = "id,name,number";
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter numberFilter = new QFilter("number", "not in", (Object)new String[]{"Currency", "EC", "PC", "DC"});
        DynamicObjectCollection currencyInfoList = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, numberFilter}, (String)"dseq");
        LinkedHashMap<String, String> curMap = new LinkedHashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)currencyInfoList)) {
            for (DynamicObject currencyInfo : currencyInfoList) {
                String number = currencyInfo.getString("number");
                curMap.put(number, CurrencyScaleEnum.TWOSCALE.getValue());
            }
        }
        idCurrencyMap.forEach((k, v) -> {
            StringBuilder builder = new StringBuilder();
            curMap.forEach((sysNumber, sysScale) -> {
                if (v.containsKey(sysNumber)) {
                    builder.append((String)sysNumber).append(":").append(v.get(sysNumber)).append(",");
                } else {
                    builder.append((String)sysNumber).append(":").append((String)sysScale).append(",");
                }
            });
            idCurrencyScaleMap.put((Long)k, builder.substring(0, builder.length() - 1));
        });
    }

    protected void setHiddenColumn(SXSSFSheet sheet, DimShortNumAndFieldMap dimShortNumAndFieldMap, String entityName) {
        Map<String, String> efStr = dimShortNumAndFieldMap.getShouldHiddenDimShortNumAndFieldMap();
        int num = sheet.getRow(2).getLastCellNum();
        for (int i = 0; i < num; ++i) {
            SXSSFCell cell = sheet.getRow(2).getCell(i);
            if (!efStr.containsValue(cell.getStringCellValue())) continue;
            sheet.setColumnHidden(i, true);
        }
    }

    private void setDynValue(DynamicObject[] dync) {
        if (dync.length > 0) {
            DimensionTree<String, DynamicObject> tree = DimensionTree.createTreeFromDyn(dync);
            DataEntityPropertyCollection properties = dync[0].getDataEntityType().getProperties();
            boolean hasAccPart = properties.containsKey((Object)"accountpart") && properties.containsKey((Object)"isaccountoffset");
            boolean hasEffDate = properties.containsKey((Object)"effdate") && this.sExtendData.equals("bcm_entitymembertree");
            boolean isEntity = this.sExtendData.equals("bcm_entitymembertree");
            if (tree != null) {
                tree.dfs(t -> {
                    DynamicObject data = (DynamicObject)t.getData();
                    this.setExportProperties(data, hasAccPart, hasEffDate, isEntity);
                });
            } else {
                for (DynamicObject dynamicObject : dync) {
                    this.setExportProperties(dynamicObject, hasAccPart, hasEffDate, isEntity);
                }
            }
        }
    }

    private void setExportProperties(DynamicObject data, boolean hasAccPart, boolean hasEffDate, boolean isEntity) {
        DynamicObject accountpart;
        DynamicObject dynamicObject = accountpart = hasAccPart ? data.getDynamicObject("accountpart") : null;
        if (accountpart != null) {
            data.set("isaccountoffset", accountpart.get("isaccountoffset"));
        }
        if (hasEffDate) {
            Date dEffDate = this.getMatchEffDate(data);
            data.set("effdate", (Object)dEffDate);
        }
        if (!(isEntity && "Entity".equals(data.getString("number")) || data.getDynamicObject("parent") == null)) {
            this.exportList.add(data);
        }
    }

    private Map<Long, String> getIdPropertyMap(String entityName, List<Long> ids, long modelId, long dimensionId) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (dimensionId != 0L) {
            qf.and(new QFilter("dimension", "=", (Object)dimensionId));
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.number pnumber", (QFilter[])new QFilter[]{qf});
        HashMap<Long, String[]> propIdValueMap = new HashMap<Long, String[]>(16);
        for (DynamicObject dc : dcs) {
            String[] data = new String[]{dc.getString("pnumber"), dc.getString("number")};
            propIdValueMap.put(dc.getLong("id"), data);
        }
        List properties = DefinedPropertyUtil.getDefinedProperty((Long)dimensionId);
        String selectFields = "id," + properties.stream().collect(Collectors.joining(","));
        QFilter qfd = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dcsd = new DynamicObjectCollection();
        BatchProcessHelper.batchConsume(ids, (int)100000, batchIds -> {
            QFilter qfIds = new QFilter("id", "in", batchIds);
            dcsd.addAll((Collection)QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qfd, qfIds}));
        });
        for (DynamicObject dyn : dcsd) {
            long id = dyn.getLong("id");
            StringBuilder sb = new StringBuilder();
            for (int propIndex = 1; propIndex <= properties.size(); ++propIndex) {
                String[] ss;
                long propId = dyn.getLong(propIndex);
                if (propId == 0L || (ss = (String[])propIdValueMap.get(propId)) == null) continue;
                sb.append(String.format("%s:%s;", ss[0], ss[1]));
            }
            result.put(id, sb.toString());
        }
        return result;
    }

    private JSONObject getJsonObject(String extendData, Map<Long, String> idCurrencyScaleMap, Map<String, Integer> accountScaleMap, Map<Long, String> idPropertyMap, Map<Long, DynamicObject> schemeParent, DynamicObject dyn, DimShortNumAndFieldMap dimShortNumAndFieldMap, Map<Long, DynamicObject> id2permClass, Map<String, String> allRuleStrByMembers) {
        String rule;
        String currencyScale;
        Integer storagetype;
        String idString;
        String strings;
        Map<String, String> definedProps;
        JSONObject json;
        String f = SerializationUtils.toJsonString((Object)dyn);
        JSONObject jsonObject = (JSONObject)JSON.parse((String)f);
        if ("bcm_scenemembertree".equals(extendData)) {
            JSONArray jsonArrayCsl = jsonObject.getJSONArray("scenecslscheme");
            if (jsonArrayCsl != null && !jsonArrayCsl.isEmpty()) {
                jsonArrayCsl.forEach(j -> {
                    JSONObject json = (JSONObject)j;
                    JSONObject baseData = json.getJSONObject("fbasedataid");
                    baseData.put("name", (Object)LocaleString.fromMap((Map)((Map)baseData.get((Object)"name"))).getLocaleValue());
                });
            }
            jsonObject.put("scenecslscheme", (Object)jsonArrayCsl);
            JSONArray jsonArray = jsonObject.getJSONArray("sceneperiod");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                jsonArray.forEach(j -> {
                    JSONObject json = (JSONObject)j;
                    JSONObject baseData = json.getJSONObject("fbasedataid");
                    baseData.put("name", (Object)LocaleString.fromMap((Map)((Map)baseData.get((Object)"name"))).getLocaleValue());
                });
            }
            jsonObject.put("sceneperiod", (Object)jsonArray);
        }
        if (ENUM_NEED_NAME.contains(extendData) && (json = jsonObject.getJSONObject("enumitem")) != null && json.get((Object)"name") != null) {
            Object name = ((JSONObject)json.get((Object)"name")).get((Object)Lang.get().name());
            json.put("name", name == null ? ((JSONObject)json.get((Object)"name")).get((Object)Lang.defaultLang().name()) : name);
            jsonObject.put("enumitem", (Object)json);
        }
        if ("bcm_accountmembertree".equals(extendData)) {
            JSONArray dmEntryArr;
            jsonObject.put("value", (Object)"");
            if (accountScaleMap.get(dyn.getString("number")) != null) {
                jsonObject.put(ACCOUNTSCALE, (Object)accountScaleMap.get(dyn.getString("number")));
            }
            if (!"[]".equals(jsonObject.get((Object)"dm_entry").toString()) && null != (dmEntryArr = (JSONArray)jsonObject.get((Object)"dm_entry")) && !dmEntryArr.isEmpty()) {
                dmEntryArr.forEach(dmEntry -> {
                    String tempJson;
                    JSONObject dmEntryObject = (JSONObject)dmEntry;
                    if (dmEntryObject.size() != 0 && !"".equals(tempJson = (String)dmEntryObject.get((Object)"dm_val"))) {
                        JSONArray dmvalJsom = JSON.parseArray((String)tempJson);
                        String str = this.getCombination(dmvalJsom);
                        JSONObject dmDimObj = (JSONObject)dmEntryObject.get((Object)"dm_dim");
                        String shortNumber = (String)dmDimObj.get((Object)"shortnumber");
                        String colName = dimShortNumAndFieldMap.getColFieldByDimShortNumber(shortNumber);
                        if (colName != null) {
                            jsonObject.put(colName, (Object)str);
                        }
                    }
                });
            }
            JSONArray bizChangeRdsEntryArr = (JSONArray)jsonObject.get((Object)"bizchangerds");
            if (!"[]".equals(jsonObject.get((Object)"bizchangerds").toString())) {
                StringBuilder excelBiz = new StringBuilder();
                if (bizChangeRdsEntryArr != null && !bizChangeRdsEntryArr.isEmpty()) {
                    bizChangeRdsEntryArr.forEach(entry -> {
                        JSONObject bizEntryObject = (JSONObject)entry;
                        if (bizEntryObject.size() != 0) {
                            String bizEffDate = (String)bizEntryObject.get((Object)"bizeffdate");
                            String bizExpDate = (String)bizEntryObject.get((Object)"bizexpdate");
                            if (!StringUtils.isEmpty((String)bizEffDate)) {
                                excelBiz.append(bizEffDate.split(" ")[0]);
                                excelBiz.append("|");
                            }
                            if (!StringUtils.isEmpty((String)bizExpDate)) {
                                excelBiz.append(bizExpDate.split(" ")[0]);
                            }
                            excelBiz.append(";\n");
                        }
                    });
                }
                jsonObject.put("bizchangerds", (Object)excelBiz.toString());
            }
        }
        if ("bcm_entitymembertree".equals(extendData)) {
            DynamicObject entitypart;
            JSONObject cslscheme = (JSONObject)jsonObject.get((Object)"cslscheme");
            if (cslscheme != null) {
                DynamicObject group;
                jsonObject.put("cslscheme", (Object)cslscheme);
                if (schemeParent.get(cslscheme.getLong("id")) == null) {
                    group = BusinessDataServiceHelper.loadSingle((Object)cslscheme.getLong("id"), (String)"bcm_cslscheme");
                    schemeParent.put(cslscheme.getLong("id"), group);
                } else {
                    group = schemeParent.get(cslscheme.getLong("id"));
                }
                jsonObject.put("cslschemegroup", (Object)JSONObjectUtil.parseObjectOrder((String)SerializationUtils.toJsonString((Object)group.get("parent"))));
            }
            if ((entitypart = dyn.getDynamicObject("entitypart")) != null) {
                jsonObject.put("isouterorg", dyn.get("entitypart.isouterorg"));
            }
            JSONArray bizChangeRdsEntryArr = (JSONArray)jsonObject.get((Object)"bizchangerds");
            if (!"[]".equals(jsonObject.get((Object)"bizchangerds").toString())) {
                StringBuilder excelBiz = new StringBuilder();
                if (bizChangeRdsEntryArr != null && !bizChangeRdsEntryArr.isEmpty()) {
                    bizChangeRdsEntryArr.forEach(entry -> {
                        JSONObject bizEntryObject = (JSONObject)entry;
                        if (bizEntryObject.size() != 0) {
                            String changeType = (String)bizEntryObject.get((Object)"changetype");
                            String bizEffDate = (String)bizEntryObject.get((Object)"bizeffdate");
                            String bizExpDate = (String)bizEntryObject.get((Object)"bizexpdate");
                            if (StringUtils.isNotEmpty((String)changeType)) {
                                excelBiz.append(changeType).append("|");
                            }
                            if (StringUtils.isNotEmpty((String)bizEffDate)) {
                                excelBiz.append(bizEffDate.split(" ")[0]).append("|");
                            }
                            if (StringUtils.isNotEmpty((String)bizExpDate)) {
                                excelBiz.append(bizExpDate.split(" ")[0]);
                            }
                            excelBiz.append(";\n");
                        }
                    });
                }
                jsonObject.put("bizchangerds", (Object)excelBiz.toString());
            }
            JSONArray nameChangeRdsEntryArr = (JSONArray)jsonObject.get((Object)"namechangerds");
            if (!"[]".equals(jsonObject.get((Object)"namechangerds").toString())) {
                StringBuilder excelName = new StringBuilder();
                if (nameChangeRdsEntryArr != null && !nameChangeRdsEntryArr.isEmpty()) {
                    nameChangeRdsEntryArr.forEach(entry -> {
                        JSONObject nameEntryObject = (JSONObject)entry;
                        if (nameEntryObject.size() != 0) {
                            Object nameObj = ((JSONObject)nameEntryObject.get((Object)"namerds")).get((Object)Lang.get().name());
                            Object simpleObj = ((JSONObject)nameEntryObject.get((Object)"simplenamerds")).get((Object)Lang.get().name());
                            String nameRd = "";
                            if (nameObj != null) {
                                nameRd = nameObj.toString();
                            }
                            String nameEffDate = (String)nameEntryObject.get((Object)"nameeffdate");
                            String nameExpDate = (String)nameEntryObject.get((Object)"nameexpdate");
                            excelName.append(nameRd);
                            excelName.append("|");
                            excelName.append(simpleObj);
                            excelName.append("|");
                            if (StringUtils.isNotEmpty((String)nameEffDate)) {
                                excelName.append(nameEffDate.split(" ")[0]);
                                excelName.append("|");
                            }
                            if (StringUtils.isNotEmpty((String)nameExpDate)) {
                                excelName.append(nameExpDate.split(" ")[0]);
                            }
                            excelName.append(";\n");
                        }
                    });
                }
                jsonObject.put("namechangerds", (Object)excelName.toString());
            }
            JSONArray currencyChangeRdsEntryArr = (JSONArray)jsonObject.get((Object)"currencychangerds");
            if (!"[]".equals(jsonObject.get((Object)"currencychangerds").toString())) {
                StringBuilder excelCurr = new StringBuilder();
                if (currencyChangeRdsEntryArr != null && currencyChangeRdsEntryArr.size() != 0) {
                    currencyChangeRdsEntryArr.forEach(Entry2 -> {
                        JSONObject currencyEntryObject = (JSONObject)Entry2;
                        if (currencyEntryObject.size() != 0) {
                            String currency;
                            String currEffDate = (String)currencyEntryObject.get((Object)"currencyeffdate");
                            String currExpDate = (String)currencyEntryObject.get((Object)"currencyexpdate");
                            if (currencyEntryObject.get((Object)"currencyrds") != null && StringUtils.isNotEmpty((String)(currency = ((JSONObject)currencyEntryObject.get((Object)"currencyrds")).getString("number")))) {
                                excelCurr.append(currency);
                                excelCurr.append("|");
                            }
                            if (StringUtils.isNotEmpty((String)currEffDate)) {
                                excelCurr.append(currEffDate.split(" ")[0]);
                                excelCurr.append("|");
                            }
                            if (StringUtils.isNotEmpty((String)currExpDate)) {
                                excelCurr.append(currExpDate.split(" ")[0]);
                            }
                            excelCurr.append(";\n");
                        }
                    });
                }
                jsonObject.put("currencychangerds", (Object)excelCurr.toString());
            }
        }
        if (MapUtils.isNotEmpty(definedProps = ExportUtil.convertMultiKeyValuePairString(strings = idPropertyMap.get(Long.valueOf(idString = jsonObject.getString("id")))))) {
            definedProps.forEach((key, value) -> {
                String newColName = ExportUtil.buildDefinedPropertyColumnName(key);
                jsonObject.put(newColName, value);
            });
        }
        if ((storagetype = jsonObject.getInteger("storagetype")) != null && 3 == storagetype) {
            Map tempMap = (Map)jsonObject.get((Object)"copyfrom");
            try {
                idString = Long.toString((Long)tempMap.get("id"));
            }
            catch (Exception e) {
                idString = jsonObject.getString("id");
            }
        }
        if (idCurrencyScaleMap.containsKey(Long.valueOf(idString)) && (currencyScale = idCurrencyScaleMap.get(Long.valueOf(idString))) != null) {
            jsonObject.put("scaletext", (Object)currencyScale);
        }
        if (id2permClass != null) {
            DynamicObject permClass;
            Long memberId = dyn.getLong("id");
            if (StorageTypeEnum.SHARE.index.equals(dyn.getString("storagetype"))) {
                Object copyfrom = dyn.get("copyfrom");
                memberId = copyfrom instanceof DynamicObject ? Long.valueOf(((DynamicObject)copyfrom).getLong("id")) : (Long)copyfrom;
            }
            if ((permClass = id2permClass.get(memberId)) != null) {
                jsonObject.put("sectoryclass", (Object)permClass.getString("number"));
            }
        }
        if (allRuleStrByMembers != null && !allRuleStrByMembers.isEmpty() && (rule = allRuleStrByMembers.get(dyn.getString("number"))) != null) {
            jsonObject.put("shielddim", (Object)rule);
        }
        return jsonObject;
    }

    private String getCombination(JSONArray dmvalJsom) {
        StringBuilder strBu = new StringBuilder();
        dmvalJsom.forEach(o -> {
            if (o != null) {
                JSONObject dObject = (JSONObject)o;
                String number = (String)dObject.get((Object)"number");
                String scope = (String)dObject.get((Object)"scope");
                strBu.append((CharSequence)ExportUtil.creatRangeStr(number, scope));
            }
        });
        return strBu.length() == 0 ? null : strBu.substring(0, strBu.length() - 1);
    }

    private Date getMatchEffDate(DynamicObject data) {
        Date sEffData;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sEffData = data.getString("effdate") == null ? new Date() : format.parse(data.getString("effdate"));
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        if (!this.sExtendData.equals("bcm_entitymembertree")) {
            return sEffData;
        }
        if (data.getDynamicObjectCollection("bizchangerds") != null && !data.getDynamicObjectCollection("bizchangerds").isEmpty()) {
            for (DynamicObject bizchangerd : data.getDynamicObjectCollection("bizchangerds")) {
                try {
                    sEffData = bizchangerd.getString("bizeffdate") == null ? new Date() : format.parse(bizchangerd.getString("bizeffdate"));
                }
                catch (ParseException e) {
                    throw new KDBizException(e.getMessage());
                }
                if (sEffData == null) continue;
                return sEffData;
            }
        } else {
            return sEffData;
        }
        return sEffData;
    }

    private Map<Long, DynamicObject> getThisDimensionMemberPermClass(long modelId, String entityName) {
        if (!"bcm_periodmembertree".equalsIgnoreCase(entityName) && !"bcm_fymembertree".equalsIgnoreCase(entityName)) {
            DynamicObject[] allMemberPermClass = PermClassEntityHelper.getTotalDimensionPermissionClass(modelId, entityName);
            HashMap<Long, DynamicObject> memberId2permClass = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject memberPermClass : allMemberPermClass) {
                memberId2permClass.put(memberPermClass.getLong("entityid"), memberPermClass.getDynamicObject("permclass"));
            }
            return memberId2permClass;
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    private Map<String, String> getThisDimensionMemberShieldDim(long modelId, long dimensionId, String entityName, List<Long> memIds) {
        Collection nodes = MemberReader.getAllNodeByDimNum((String)DimEntityNumEnum.getNumberByEntieyNum((String)entityName), (String)MemberReader.findModelNumberById((Object)modelId));
        if (!"bcm_icmembertree".equals(entityName)) {
            nodes = nodes.stream().filter(m -> m.getStorageType() != StorageTypeEnum.SHARE).collect(Collectors.toSet());
        }
        if (nodes.isEmpty()) {
            return null;
        }
        HashSet<Long> allMemberIds = new HashSet<Long>(nodes.size());
        HashMap id2Nums = new HashMap(16);
        HashSet<Long> memIdsSet = new HashSet<Long>(memIds);
        nodes.stream().filter(x -> memIdsSet.contains(x.getId())).forEach(node -> {
            allMemberIds.add(node.getId());
            id2Nums.put(node.getId(), node.getNumber());
        });
        Map<Long, String> ruleStrByMemList = ShieldRuleBulider.getRuleStrByMemList(modelId, dimensionId, allMemberIds);
        HashMap<String, String> num2Rules = new HashMap<String, String>(16);
        ruleStrByMemList.forEach((k, v) -> num2Rules.put((String)id2Nums.get(k), (String)v));
        return num2Rules;
    }

    private Map<String, Integer> getAccountScale(String entityName, long modelId) {
        if ("bcm_accountmembertree".equalsIgnoreCase(entityName)) {
            return CurrencyScaleHandler.getAccountScale(modelId);
        }
        return new HashMap<String, Integer>(16);
    }

    private String getSelectedFields(String extendData, ExportWriterFormat format, String schemeId) {
        String selectFields = String.join((CharSequence)",", format.fields) + ",copyfrom,dseq";
        if ("bcm_accountmembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ", accountpart, dm_entry, dm_val, dm_dim, dm_entry.seq, bizchangerds, bizchangerds.bizeffdate, bizchangerds.bizexpdate";
        } else if ("bcm_entitymembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ",entitypart,bizchangerds,bizchangerds.changetype,bizchangerds.bizeffdate,bizchangerds.bizexpdate,namechangerds,namechangerds.namerds,namechangerds.simplenamerds,namechangerds.nameeffdate,namechangerds.nameexpdate,currencychangerds,currencychangerds.currencyrds,currencychangerds.currencyrds.number,currencychangerds.currencyeffdate,currencychangerds.currencyexpdate";
            if (schemeId != null && !selectFields.contains("cslscheme")) {
                selectFields = selectFields + ",cslscheme ";
            }
        } else if ("bcm_currencymembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ",parent";
        } else if ("bcm_periodmembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ",parent";
        } else if ("bcm_fymembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ",parent";
        } else if ("bcm_scenemembertree".equals(extendData) && !selectFields.isEmpty()) {
            selectFields = selectFields + ",parent";
        }
        return selectFields;
    }

    private List<Long> getMemberIds(Long modelId, Long dimId, String entityName, String schemeId, List<Long> memIds) {
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        if (CollectionUtils.isEmpty(memIds)) {
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            if ("bcm_entitymembertree".equals(entityName)) {
                filter.and(new QFilter("isexchangerate", "=", (Object)false));
                if (StringUtils.isNotEmpty((String)schemeId)) {
                    QFilter qf = new QFilter("id", "=", (Object)LongUtil.toLong((Object)schemeId));
                    DynamicObject schemeRoot = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"longnumber", (QFilter[])qf.toArray());
                    QFilter cslFilter = new QFilter("longnumber", "like", (Object)(schemeRoot.getString("longnumber") + "%"));
                    DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{cslFilter, filterModel});
                    List schemeIds = schemes.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                    schemeIds.add(LongUtil.toLong((Object)schemeId));
                    filter.and(new QFilter("cslscheme", "in", schemeIds).or(new QFilter("number", "=", (Object)"Entity")));
                }
            }
            memIds = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray()).stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        }
        return memIds;
    }
}

