/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EnumExportStrategy
implements IExport {
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        Long modelId = (Long)outputParams.get("modelId");
        Long dimensionId = (Long)outputParams.get("dimensionId");
        QFilter modelIdFilter = new QFilter("model", "=", (Object)modelId);
        QFilter dimensionFilter = new QFilter("dimension", "=", (Object)dimensionId);
        String selectFiled = "model.shownumber,dimtype,dimension,dimension.number,enumvalue,name,datatype";
        Object authDatas = QueryServiceHelper.query((String)entityName, (String)selectFiled, (QFilter[])new QFilter[]{modelIdFilter, dimensionFilter}, (String)"enumitemid, dseq");
        if (authDatas.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)((DynamicObject)authDatas.get(0)).getString("dimension.number"))) {
            long dimension = ((DynamicObject)authDatas.get(0)).getLong("dimension");
            QFilter qFilter = new QFilter("id", "=", (Object)dimension);
            DynamicObject exts = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"number", (QFilter[])new QFilter[]{qFilter});
            if (exts == null) {
                return null;
            }
            authDatas = authDatas.stream().map(x -> {
                x.set("dimension.number", (Object)exts.getString("number"));
                return x;
            }).collect(Collectors.toList());
        }
        ArrayList exportMapList = new ArrayList(10);
        for (DynamicObject authData : authDatas) {
            LinkedHashMap<String, Object> authDataMap = new LinkedHashMap<String, Object>();
            authDataMap.put("model_shownumber", authData.get("model.shownumber"));
            authDataMap.put("dimension_number", authData.get("dimension.number"));
            authDataMap.put("enumvalue", authData.get("enumvalue"));
            authDataMap.put("name", authData.get("name"));
            authDataMap.put("datatype", authData.get("datatype"));
            exportMapList.add(authDataMap);
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle style = new ExportSheetStyle(wb);
        String json = SerializationUtils.toJsonString(exportMapList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        int rowIndex = 3;
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, style, routeAppId, formId, importTemplateId, entityName);
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (JSONObject)bill, (int)(rowIndex + i + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

