/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EnumNewExportStrategy
implements IExport {
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        List selectData;
        QFilter ids;
        String selectFiled = "number, enumvalue, parent, enumitemid, datatype";
        Long modelId = (Long)outputParams.get("modelId");
        QFilter modelIdFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] authDatas = BusinessDataServiceHelper.load((String)"bcm_enumvalue_new", (String)selectFiled, (QFilter[])new QFilter[]{modelIdFilter, ids = new QFilter("id", "in", (Object)(selectData = (List)outputParams.get("selectData")))}, (String)"level, dseq");
        if (authDatas == null || authDatas.length == 0) {
            return null;
        }
        List<DynamicObject> enumDys = this.encapsulationExpDys(authDatas, modelId);
        String json = SerializationUtils.toJsonString(enumDys);
        JSONArray billArr = JSONArray.parseArray((String)json);
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle style = new ExportSheetStyle(wb);
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadOfEnum(wb, sheet, style, routeAppId, formId, importTemplateId, entityName);
        int rowIndex = 3;
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (JSONObject)bill, (int)(rowIndex + i + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    private List<DynamicObject> encapsulationExpDys(DynamicObject[] authDatas, Long modelId) {
        ArrayList<DynamicObject> enumDys = new ArrayList<DynamicObject>(16);
        long enumitemid = authDatas[0].getLong("enumitemid");
        if (enumitemid == 0L) {
            return enumDys;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("id", "=", (Object)enumitemid);
        DynamicObject enumItem = BusinessDataServiceHelper.loadSingle((String)"bcm_enumitem_new", (String)"id, name, number", (QFilter[])qf.toArray());
        if (enumItem == null) {
            return enumDys;
        }
        for (int i = 0; i < authDatas.length; ++i) {
            DynamicObject authData = authDatas[i];
            DynamicObject enumDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_enum_new_import");
            enumDy.set("number", (Object)authData.getString("number"));
            enumDy.set("enumvalue", (Object)authData.getString("enumvalue"));
            enumDy.set("parent", (Object)authData.getDynamicObject("parent"));
            enumDy.set("enumitemid", (Object)enumItem);
            enumDy.set("datatype", (Object)authData.getString("datatype"));
            enumDys.add(enumDy);
        }
        return enumDys;
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

