/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.business.export.strategy.helper.UserDefinedDimShortNumAndFieldMapCache;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExtendsPropertyExportStrategy
implements IExport {
    protected static final Log LOG = LogFactory.getLog(ExtendsPropertyExportStrategy.class);
    private String dimMetaNumber;
    private List<DynamicObject> exportList = new ArrayList<DynamicObject>(10);
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long template, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        DynamicObject dynamicObject;
        DataEntityPropertyCollection properties;
        DynamicObject[] arrSeq;
        Long modelId = (Long)outputParams.get("modelId");
        String userDimId = outputParams.get("userDimId") == null ? null : outputParams.get("userDimId").toString();
        Object selectData = outputParams.get("selectData");
        List<Long> selectedIds = selectData == null ? new ArrayList() : (List)selectData;
        LOG.info(String.format("export_by_template: modelId=%s, userDimId=%s", modelId, userDimId));
        this.dimMetaNumber = entityName;
        long exportDimensionId = 0L;
        if (StringUtils.isNotEmpty((String)userDimId)) {
            exportDimensionId = Long.parseLong(userDimId);
        } else {
            DynamicObject sampleMemberInfo = QueryServiceHelper.queryOne((String)entityName, (String)"dimension.id dimensionid", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            if (Objects.nonNull(sampleMemberInfo)) {
                exportDimensionId = sampleMemberInfo.getLong("dimensionid");
            }
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHeadCustomized(wb, sheet, styles, routeAppId, formId, template, this.dimMetaNumber, modelId, exportDimensionId);
        if (format == null) {
            return null;
        }
        int rowIndex = 3;
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (userDimId != null) {
            QFilter dimQf = new QFilter("dimension", "=", (Object)Long.parseLong(userDimId));
            filterModel.and(dimQf);
        }
        QFilter[] qFilter = new QFilter[]{filterModel, statusFilter};
        String selectFields = String.join((CharSequence)",", format.fields) + ",copyfrom,dseq";
        if (!selectedIds.isEmpty()) {
            QFilter qF = new QFilter("id", "in", selectedIds);
            qFilter = new QFilter[]{qF};
            arrSeq = BusinessDataServiceHelper.load((String)this.dimMetaNumber, (String)selectFields, (QFilter[])qFilter, (String)" level,dseq");
        } else {
            arrSeq = BusinessDataServiceHelper.load((String)this.dimMetaNumber, (String)selectFields, (QFilter[])qFilter, (String)" parent.id,dseq");
        }
        LOG.info(String.format("export_by_template: exportDimensionId=%s, arrSeq size=%s", exportDimensionId, arrSeq.length));
        this.setDynValue(arrSeq);
        LOG.info(String.format("export_by_template: init exportList size =%s", this.exportList.size()));
        List<Long> ids = this.exportList.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map<Long, Long> shareIdToStorageIdMap = this.getShareToStorageId(this.exportList);
        long dimensionId = 0L;
        if (!this.exportList.isEmpty() && (properties = (dynamicObject = this.exportList.get(0)).getDataEntityType().getProperties()).containsKey((Object)"dimension")) {
            dimensionId = dynamicObject.getLong("dimension_id");
        }
        Map<Long, String> idPropertyMap = this.getId2CustomPropertyMap(this.dimMetaNumber, ids, modelId, dimensionId);
        Map<Long, String> idPermMap = this.getIdPermMap(this.dimMetaNumber, modelId);
        String fileName = ExportUtil.genFullFileName(template, this.dimMetaNumber, this.exportPrefix);
        Map<Long, DynamicObject> id2permClass = this.getThisDimensionMemberPermClass(modelId, this.dimMetaNumber);
        Map<Long, MultiF7Results> multiF7ValueByExtMemIds = ExtDataUtil.getMultiF7ValueByExtMemIds(selectedIds, modelId);
        for (DynamicObject dyn : this.exportList) {
            boolean flag;
            JSONObject jsonObject = this.getJsonObject(idPropertyMap, idPermMap, dyn, id2permClass, shareIdToStorageIdMap, multiF7ValueByExtMemIds);
            boolean bl = flag = ("bcm_accountmembertree".equals(this.dimMetaNumber) || "bcm_changetypemembertree".equals(this.dimMetaNumber) || "bcm_userdefinedmembertree".equals(this.dimMetaNumber) || "bcm_scenemembertree".equals(this.dimMetaNumber) || "bcm_structofextend".equals(this.dimMetaNumber)) && format.properties.containsKey("enumitem");
            if (flag) {
                ((Map)format.properties.get("enumitem")).put("DataKey", "name");
            }
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)jsonObject, (int)(++rowIndex), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        ExportUtil.postWriteSheet(wb, sheet);
        UserDefinedDimShortNumAndFieldMapCache.clear();
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }

    private void setDynValue(DynamicObject[] dync) {
        if (dync.length > 0) {
            DimensionTree<String, DynamicObject> tree = DimensionTree.createTreeFromDyn(dync);
            if (tree != null) {
                tree.dfs(t -> {
                    DynamicObject data = (DynamicObject)t.getData();
                    this.setExportProperties(data);
                });
            } else {
                for (DynamicObject dynamicObject : dync) {
                    this.setExportProperties(dynamicObject);
                }
            }
        }
    }

    private void setExportProperties(DynamicObject data) {
        if (data.getDynamicObject("parent") != null) {
            this.exportList.add(data);
        }
    }

    private Map<Long, String> getId2CustomPropertyMap(String entityName, Collection<Long> ids, long modelId, long dimensionId) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (dimensionId != 0L) {
            QFilter qf1 = new QFilter("dimension", "=", (Object)dimensionId);
            qf = qf.and(qf1);
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.number pnumber", (QFilter[])new QFilter[]{qf});
        HashMap<Long, String[]> propIdValueMap = new HashMap<Long, String[]>(16);
        for (DynamicObject dc : dcs) {
            String[] data = new String[]{dc.getString("pnumber"), dc.getString("number")};
            propIdValueMap.put(dc.getLong("id"), data);
        }
        List properties = DefinedPropertyUtil.getDefinedProperty((Long)dimensionId);
        String selectFields = "id," + properties.stream().collect(Collectors.joining(","));
        QFilter qfd = new QFilter("id", "in", ids);
        QFilter[] qfsd = new QFilter[]{qfd};
        DynamicObjectCollection dcsd = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qfsd);
        for (DynamicObject dyn : dcsd) {
            long id = dyn.getLong("id");
            StringBuilder sb = new StringBuilder();
            for (int propIndex = 1; propIndex <= properties.size(); ++propIndex) {
                String[] ss;
                long propId = dyn.getLong(propIndex);
                if (propId == 0L || (ss = (String[])propIdValueMap.get(propId)) == null) continue;
                sb.append(String.format("%s:%s;", ss[0], ss[1]));
            }
            result.put(id, sb.toString());
        }
        return result;
    }

    private Map<Long, String> getIdPermMap(String extendData, Long modelId) {
        DynamicObject[] load;
        HashMap<Long, StringBuilder> result = new HashMap<Long, StringBuilder>(16);
        String selects = "member,usertype,users,username,range,permission,users.id,users.number";
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter filter1 = new QFilter("membertype", "=", (Object)extendData);
        for (DynamicObject dyo : load = BusinessDataServiceHelper.load((String)"bcm_memberperm", (String)selects, (QFilter[])new QFilter[]{filter, filter1})) {
            long member = dyo.getLong("member_id");
            String usertype = dyo.getString("usertype");
            String number = dyo.getString("users.number");
            String permission = dyo.getString("permission");
            StringBuilder tempStr = new StringBuilder();
            tempStr.append(usertype).append(",").append(number).append(",").append(permission);
            tempStr = this.creatRangeStr(tempStr.toString(), dyo.getString("range"));
            String s = tempStr.toString();
            if (s.length() <= 0) continue;
            result.computeIfAbsent(member, k -> new StringBuilder()).append(s);
        }
        HashMap<Long, String> r = new HashMap<Long, String>(16);
        result.forEach((key, value) -> r.put((Long)key, value.length() == 0 ? "" : value.substring(0, value.length() - 1)));
        return r;
    }

    private StringBuilder creatRangeStr(String value, String range) {
        StringBuilder str1 = new StringBuilder();
        switch (range) {
            case "10": {
                str1.append(value).append(";");
                break;
            }
            case "20": {
                str1.append("Child(").append(value).append(");");
                break;
            }
            case "30": {
                str1.append("Ichild(").append(value).append(");");
                break;
            }
            case "40": {
                str1.append("Descendant(").append(value).append(");");
                break;
            }
            case "50": {
                str1.append("Hierarchy(").append(value).append(");");
                break;
            }
            case "60": {
                str1.append("Sibling(").append(value).append(");");
                break;
            }
            case "70": {
                str1.append("Isibling(").append(value).append(");");
                break;
            }
            case "90": {
                str1.append("Base(").append(value).append(");");
                break;
            }
        }
        return str1;
    }

    private Map<Long, DynamicObject> getThisDimensionMemberPermClass(long modelId, String entityName) {
        DynamicObject[] allMemberPermClass = PermClassEntityHelper.getTotalDimensionPermissionClass(modelId, entityName);
        HashMap<Long, DynamicObject> memberId2permClass = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject memberPermClass : allMemberPermClass) {
            memberId2permClass.put(memberPermClass.getLong("entityid"), memberPermClass.getDynamicObject("permclass"));
        }
        return memberId2permClass;
    }

    private Map<Long, Long> getShareToStorageId(List<DynamicObject> exportList) {
        HashMap<Long, Long> shareIdToStorageId = new HashMap<Long, Long>(16);
        Map<String, List<DynamicObject>> sameNumberDys = exportList.stream().collect(Collectors.groupingBy(x -> x.getString("number")));
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : sameNumberDys.entrySet()) {
            List<DynamicObject> sameGroup = stringListEntry.getValue();
            List storage = sameGroup.stream().filter(x -> !StorageTypeEnum.SHARE.index.equals(x.getString("storagetype"))).collect(Collectors.toList());
            List shares = sameGroup.stream().filter(x -> StorageTypeEnum.SHARE.index.equals(x.getString("storagetype"))).collect(Collectors.toList());
            if (shares.isEmpty() || storage.isEmpty()) continue;
            Long storageId = ((DynamicObject)storage.get(0)).getLong("id");
            for (DynamicObject share : shares) {
                shareIdToStorageId.put(share.getLong("id"), storageId);
            }
        }
        return shareIdToStorageId;
    }

    private JSONObject getJsonObject(Map<Long, String> idPropertyMap, Map<Long, String> idPermMap, DynamicObject dyn, Map<Long, DynamicObject> id2permClass, Map<Long, Long> shareIdToStorageIdMap, Map<Long, MultiF7Results> multiF7ValueByExtMemIds) {
        Long id;
        MultiF7Results multiF7Results;
        String combMember;
        String entryentityasso;
        JSONObject enumitem;
        String s;
        Integer storagetype;
        String f = SerializationUtils.toJsonString((Object)dyn);
        JSONObject jsonObject = (JSONObject)JSON.parse((String)f);
        String idString = jsonObject.getString("id");
        String strings = idPropertyMap.get(Long.valueOf(idString));
        Map<String, String> definedProps = ExportUtil.convertMultiKeyValuePairString(strings);
        if (MapUtils.isNotEmpty(definedProps)) {
            definedProps.forEach((key, value) -> {
                String newColName = ExportUtil.buildDefinedPropertyColumnName(key);
                jsonObject.put(newColName, value);
            });
        }
        if ((storagetype = jsonObject.getInteger("storagetype")) != null && 3 == storagetype) {
            Map tempMap = (Map)jsonObject.get((Object)"copyfrom");
            try {
                idString = Long.toString((Long)tempMap.get("id"));
            }
            catch (Exception e) {
                idString = jsonObject.getString("id");
            }
        }
        if ((s = idPermMap.get(Long.valueOf(idString))) != null) {
            jsonObject.put("memberpermissions", (Object)s);
        }
        if (id2permClass != null) {
            DynamicObject permClass;
            Long memberId = dyn.getLong("id");
            if (StorageTypeEnum.SHARE.index.equals(dyn.getString("storagetype")) && shareIdToStorageIdMap.size() > 0 && shareIdToStorageIdMap.get(memberId) != null) {
                memberId = shareIdToStorageIdMap.get(memberId);
            }
            if ((permClass = id2permClass.get(memberId)) != null) {
                jsonObject.put("permclass", JSON.parse((String)SerializationUtils.toJsonString((Object)permClass)));
            }
        }
        if ((enumitem = JSONObject.parseObject((String)jsonObject.getString("enumitem"))) != null) {
            enumitem.put("name", (Object)dyn.getString("enumitem.name"));
            jsonObject.put("enumitem", (Object)enumitem);
        }
        if ((entryentityasso = jsonObject.getString("entryentityasso")) != null && StringUtils.isNotEmpty((String)(combMember = this.createCombMember(multiF7Results = multiF7ValueByExtMemIds.get(id = jsonObject.getLong("id")))))) {
            jsonObject.put("assomember", (Object)combMember);
            DynamicObject dimDy = multiF7Results.getDimDy();
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("number", dimDy.getString("number"));
            map.put("name", dimDy.getString("name"));
            jsonObject.put("assodimension", (Object)new JSONObject(map));
        }
        return jsonObject;
    }

    private String createCombMember(MultiF7Results multiF7Results) {
        if (multiF7Results == null) {
            return null;
        }
        List<MultiF7Result> list = multiF7Results.getList();
        if (list.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        list.forEach(ele -> {
            int scope = ele.getScope();
            String number = ele.getNumber();
            sb.append((CharSequence)ExportUtil.creatRangeStr(number, String.valueOf(scope)));
        });
        return sb.toString();
    }
}

