/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.web.DispatchServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;

public class MemberlistExportStrategy
implements IExport {
    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        long modelId = (Long)outputParams.get("modelId");
        Object[] ids = (Object[])outputParams.get("ids");
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        String modelNum = model.getString("shownumber");
        String exportJson = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, importTemplateId, "", entityName});
        List format = JSON.parseArray((String)exportJson, ExportWriterFormat.class);
        ListDataExporter exporter = new ListDataExporter("bcm_memberlist", format, false);
        String fileName = ExportUtil.genFileName(importTemplateId, formId, modelNum + "_");
        DynamicObject[] memberList = DimensionServiceHelper.loadMemberList(modelId, ids);
        int rowIndex = 3;
        for (DynamicObject member : memberList) {
            String data2;
            JSONObject jsonObject;
            String dimEntityNum = DimensionServiceHelper.getDimMembEntityNumByDimNum(member.getString("dimensionid.number"));
            Boolean isdyn = member.getBoolean("isdyn");
            String bcmStaticList = null;
            String bcmDynamicList = null;
            if (Objects.equals(isdyn, Boolean.FALSE)) {
                DynamicObjectCollection staticColl = member.getDynamicObjectCollection("bcmstaticlist");
                Object[] staticMembers = (String[])staticColl.stream().map(data -> {
                    Long memberId = data.getLong("memberid");
                    DynamicObject dimMember = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)dimEntityNum);
                    return dimMember.getString("number");
                }).toArray(String[]::new);
                bcmStaticList = Joiner.on((String)"#").join(staticMembers);
            }
            if (Objects.equals(isdyn, Boolean.TRUE)) {
                DynamicObjectCollection dynamicColl = member.getDynamicObjectCollection("bcmdynamiclist");
                Object[] dynamicMembers = (String[])dynamicColl.stream().map(data -> {
                    Long memberId = data.getLong("member");
                    Long baseId = data.getLong("base");
                    String range = data.getString("range");
                    String formulaTag = data.getString("formula_tag");
                    String number = "";
                    if (!Objects.equals(memberId, 0L)) {
                        DynamicObject dimMember = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)dimEntityNum);
                        number = dimMember.getString("number");
                    }
                    String base = "";
                    if (!Objects.equals(baseId, 0L)) {
                        DynamicObject dimMember2 = BusinessDataServiceHelper.loadSingle((Object)baseId, (String)dimEntityNum);
                        base = dimMember2.getString("number");
                    }
                    range = Objects.equals(range, "0") ? "" : range;
                    return Joiner.on((String)"|").join((Object)number, (Object)base, new Object[]{range, formulaTag});
                }).toArray(String[]::new);
                bcmDynamicList = Joiner.on((String)"#").join(dynamicMembers);
            }
            if (!Objects.isNull((jsonObject = JSON.parseObject((String)(data2 = SerializationUtils.toJsonString((Object)member)))).getJSONObject("dimensionid"))) {
                jsonObject.getJSONObject("dimensionid").put("name", (Object)member.getLocaleString("dimensionid.name"));
            }
            if (!Objects.isNull(jsonObject.getJSONObject("creator"))) {
                jsonObject.getJSONObject("creator").put("name", (Object)member.getLocaleString("creator.name"));
            }
            if (!Objects.isNull(jsonObject.getJSONObject("modifier"))) {
                jsonObject.getJSONObject("modifier").put("name", (Object)member.getLocaleString("modifier.name"));
            }
            jsonObject.put("isdyn", (Object)(Objects.equals(isdyn, Boolean.TRUE) ? "1" : "0"));
            jsonObject.put("bcmstaticlist", (Object)bcmStaticList);
            jsonObject.put("bcmdynamiclist", (Object)bcmDynamicList);
            try {
                exporter.writeData(jsonObject, ++rowIndex, (ExportWriterFormat)format.get(0), false, fileName, false);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        String url = exporter.flush(mainEntityType, fileName);
        return UrlService.getAttachmentFullUrl((String)url);
    }
}

