/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class OperLogExportStrategy
implements IExport {
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        DynamicObjectCollection data = (DynamicObjectCollection)outputParams.get("data");
        ArrayList<JSONObject> exportMapList = new ArrayList<JSONObject>(data.size());
        int index = 1;
        for (DynamicObject item : data) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("serialno", (Object)index++);
            jsonObj.put("username", item.get("user.name"));
            jsonObj.put("bizappname", item.get("bizapp.name"));
            jsonObj.put("bizobjname", item.get("bizobj.name"));
            jsonObj.put("optime", (Object)item.get("optime").toString());
            jsonObj.put("clienttype", item.get("clienttype"));
            jsonObj.put("clientip", item.get("clientip"));
            Object time = item.get("archivetime");
            if (time != null) {
                time = time.toString();
            }
            jsonObj.put("archivetime", time);
            jsonObj.put("opnamee", item.get("opnamee"));
            jsonObj.put("clientnamee", item.get("clientnamee"));
            jsonObj.put("opdescriptione", item.get("opdescriptione"));
            jsonObj.put("orgname", item.get("org.name"));
            exportMapList.add(jsonObj);
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(100000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle style = new ExportSheetStyle(wb);
        int rowIndex = 3;
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.buildWriterFormat(routeAppId, formId, importTemplateId, entityName);
        this.addSerialProperty(format);
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (ExportWriterFormat)format);
        int i = 0;
        for (JSONObject jsonObject : exportMapList) {
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (JSONObject)jsonObject, (int)(rowIndex + i++ + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    private void addSerialProperty(ExportWriterFormat format) {
        HashMap<String, String> serrialMap = new HashMap<String, String>();
        serrialMap.put("DisplayName", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"OperLogExportStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        serrialMap.put("propName", "serialno");
        Map properties = format.properties;
        properties.put("serialno", serrialMap);
        format.properties = properties;
        ArrayList<String> fields = new ArrayList<String>(format.fields.size() + 1);
        fields.add("serialno");
        fields.addAll(format.fields);
        format.fields = fields;
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

