/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.business.export.strategy.IExport;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class UserDefinedPropertyExportStrategy
implements IExport {
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"fi-bcm-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        QFilter dimensionQf;
        String modelId = outputParams.get("modelId").toString();
        String dimensionId = outputParams.get("dimensionId").toString();
        String dimTableName = "";
        dimTableName = QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(dimensionId))}) ? "bcm_dimension_ext" : "bcm_dimension";
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)dimTableName);
        String selectFields = "id, number, name, property, parentid, longnumber,propertyid";
        QFilter modelQf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        DynamicObject[] definedPropertyValueArrSeq = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{modelQf, dimensionQf = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimensionId))});
        if (definedPropertyValueArrSeq.length < 1) {
            return null;
        }
        DynamicObjectCollection userDefinedProperty = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,name", (QFilter[])new QFilter[]{modelQf, dimensionQf});
        StringBuilder propertySelectFields = new StringBuilder();
        for (int i = 1; i <= userDefinedProperty.size(); ++i) {
            propertySelectFields.append("dpropertyid");
            propertySelectFields.append(i);
            propertySelectFields.append(",");
        }
        ArrayList<Map<String, Object>> outMapList = new ArrayList<Map<String, Object>>(10);
        this.setSingleMemberUserDefinedProperty(dimension.getString("number"), definedPropertyValueArrSeq, userDefinedProperty, outMapList);
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        String json = SerializationUtils.toJsonString(outMapList);
        JSONArray billArr = JSONArray.parseArray((String)json);
        int rowIndex = 3;
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead(wb, sheet, styles, routeAppId, formId, importTemplateId, entityName);
        Map dimensionfld = (Map)format.properties.get("dimension");
        if (dimensionfld != null) {
            dimensionfld.put("InputType", "varchar");
            dimensionfld.put("InputDesc", ResManager.loadKDString((String)"\u6587\u672c", (String)"UserDefinedPropertyExportStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)(rowIndex + i + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }

    private List<Map<String, Object>> setSingleMemberUserDefinedProperty(String dimensionName, DynamicObject[] arrSeq, DynamicObjectCollection userDefinedProperty, List<Map<String, Object>> mapList) {
        HashMap<String, DynamicObject> idPropertyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : userDefinedProperty) {
            idPropertyMap.put(dynamicObject.getString("id"), dynamicObject);
        }
        for (DynamicObject dyo : arrSeq) {
            HashMap<String, String> singRow = new HashMap<String, String>(16);
            singRow.put("dimension", dimensionName);
            if ("0".equals(dyo.getString("parentid"))) continue;
            singRow.put("number", dyo.getString("number"));
            singRow.put("name", dyo.getString("name"));
            String[] longNumber = dyo.getString("longnumber").split("!");
            if (longNumber.length > 1) {
                String parentNumber = longNumber[longNumber.length - 2];
                singRow.put("parentnumber", parentNumber);
                DynamicObject propertyKey = (DynamicObject)idPropertyMap.get(dyo.getString("propertyid"));
                singRow.put("userdefinedkindnumber", propertyKey.getString("number"));
                singRow.put("userdefinedkindname", propertyKey.getString("name"));
            }
            mapList.add(singRow);
        }
        return mapList;
    }
}

