/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy.helper;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.export.EffectiveDimensionEnum;
import kd.fi.bcm.business.export.strategy.helper.UserDefinedDimShortNumAndFieldMapCache;
import kd.fi.bcm.common.cache.MemberReader;

public class DimShortNumAndFieldMap {
    private long modelId;
    private Map<String, String> fixedDimShortNumAndFieldMap = new HashMap<String, String>(16);
    private Map<String, String> dimShortNumAndFieldMap;
    private int userDefinedDimsSize = 0;
    private int userDefinedDimTotalSize = 6;

    public DimShortNumAndFieldMap(long modelId) {
        this.modelId = modelId;
        this.setFixedDimShortNumFieldMap();
        this.setUserDefinedDimShortNumFieldMap(modelId);
    }

    private void setFixedDimShortNumFieldMap() {
        this.fixedDimShortNumAndFieldMap.put("CT", "effectivecombinationct");
        this.fixedDimShortNumAndFieldMap.put("DS", "effectivecombinationds");
        this.fixedDimShortNumAndFieldMap.put("AT", "effectivecombinationat");
        this.fixedDimShortNumAndFieldMap.put("IC", "effectivecombinationic");
        this.fixedDimShortNumAndFieldMap.put("MG", "effectivecombinationmg");
        this.fixedDimShortNumAndFieldMap.put("A", "effectivecombinationa");
        this.fixedDimShortNumAndFieldMap.put("P", "effectivecombinationp");
    }

    private void setUserDefinedDimShortNumFieldMap(long modelId) {
        Map<String, String> userDefinedDimShortNumAndFieldMap = UserDefinedDimShortNumAndFieldMapCache.getFieldMap(modelId);
        this.userDefinedDimsSize = userDefinedDimShortNumAndFieldMap.size();
        HashMap<String, String> tempMap = new HashMap<String, String>(16);
        if (userDefinedDimShortNumAndFieldMap != null) {
            tempMap.putAll(this.fixedDimShortNumAndFieldMap);
            tempMap.putAll(userDefinedDimShortNumAndFieldMap);
        }
        this.dimShortNumAndFieldMap = ImmutableMap.copyOf(tempMap);
    }

    public String getColFieldByDimShortNumber(String shortNumber) {
        return this.dimShortNumAndFieldMap.get(shortNumber);
    }

    public Map<String, String> getShouldHiddenDimShortNumAndFieldMap() {
        HashSet allShowDims = new HashSet(MemberReader.getDimensionNumber2nameMap((String)MemberReader.findModelNumberById((Object)this.modelId)).keySet());
        HashSet<String> allValidDims = new HashSet<String>(this.dimShortNumAndFieldMap.keySet());
        allValidDims.removeAll(allShowDims);
        Set<String> shouldHiddenUserDefinedDims = this.addShouldHiddenUserDefinedDims();
        allValidDims.addAll(shouldHiddenUserDefinedDims);
        HashMap<String, String> ans = new HashMap<String, String>(allValidDims.size());
        Map<String, String> enumMap = EffectiveDimensionEnum.getAllEnumMap("dimension");
        for (String validDim : allValidDims) {
            ans.put(validDim, enumMap.get(validDim));
        }
        return ans;
    }

    private Set<String> addShouldHiddenUserDefinedDims() {
        int size = this.userDefinedDimTotalSize - this.userDefinedDimsSize;
        HashSet<String> ans = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            ans.add("C" + (this.userDefinedDimTotalSize - i));
        }
        return ans;
    }
}

