/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.strategy.helper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class UserDefinedDimShortNumAndFieldMapCache {
    private static Map<String, Map<String, Cache>> REQUEST_CACHES = Collections.synchronizedMap(new HashMap(10));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RequestContext rq = RequestContext.get();
        Map<String, Map<String, Cache>> map = REQUEST_CACHES;
        synchronized (map) {
            Map<String, Cache> cache = REQUEST_CACHES.get(rq.getRequestId());
            if (Objects.nonNull(cache)) {
                REQUEST_CACHES.remove(rq.getRequestId());
                cache.values().forEach(x -> x.cleanUp());
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Cache<K, V> getOrLoadCache(String cacheName, Supplier<Map<K, V>> dataMapSupplier) {
        Cache cache;
        String requestId = RequestContext.get().getRequestId();
        Map<String, Cache> cacheMap = REQUEST_CACHES.get(requestId);
        if (Objects.isNull(cacheMap)) {
            Map<String, Map<String, Cache>> map = REQUEST_CACHES;
            synchronized (map) {
                if (!REQUEST_CACHES.containsKey(requestId)) {
                    REQUEST_CACHES.put(requestId, new HashMap(3));
                }
            }
            cacheMap = REQUEST_CACHES.get(requestId);
        }
        if (Objects.isNull(cache = cacheMap.get(cacheName))) {
            Map<String, Cache> map = cacheMap;
            synchronized (map) {
                if (!cacheMap.containsKey(cacheName)) {
                    Cache tempCache = CacheBuilder.newBuilder().recordStats().expireAfterAccess(30L, TimeUnit.MINUTES).build();
                    tempCache.putAll(dataMapSupplier.get());
                    cacheMap.put(cacheName, tempCache);
                }
            }
            cache = cacheMap.get(cacheName);
        }
        return cache;
    }

    private static void retireSpecificCache(String cacheName) {
        String requestId = RequestContext.get().getRequestId();
        Map<String, Cache> cacheMap = REQUEST_CACHES.get(requestId);
        if (Objects.nonNull(cacheMap)) {
            cacheMap.remove(cacheName);
        }
    }

    public static Map<String, String> getFieldMap(long modelId) {
        return UserDefinedDimShortNumAndFieldMapCache.getOrLoadCache("userDefined2FieldCache", () -> {
            QFilter modelQf = new QFilter("model", "=", (Object)modelId);
            QFilter entityQf = new QFilter("membermodel", "=", (Object)"bcm_userdefinedmembertree");
            DynamicObjectCollection userDimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,shortnumber", (QFilter[])new QFilter[]{modelQf, entityQf}, (String)"dseq");
            HashMap<String, String> dimensionFieldMap = new HashMap<String, String>();
            int n = 1;
            for (DynamicObject userDimension : userDimensions) {
                StringBuilder value = new StringBuilder("effectivecombinationc");
                dimensionFieldMap.put(userDimension.getString("shortnumber"), value.append(n).toString());
                ++n;
            }
            return dimensionFieldMap;
        }).asMap();
    }

    public static Set<String> getAllDimShortNumber(long modelId) {
        return UserDefinedDimShortNumAndFieldMapCache.getOrLoadCache("allDims", () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelId);
            DynamicObjectCollection dimQuery = QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber", (QFilter[])qfBuilder.toArray());
            HashMap<String, DynamicObject> ans = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dynamicObject : dimQuery) {
                ans.put(dynamicObject.getString("shortnumber"), dynamicObject);
            }
            return ans;
        }).asMap().keySet();
    }
}

