/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.export.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RangeEnum;

public class ExportUtils {
    private static String selectFields = "id,number,name,dimension,dimension.id,dimension.number,longnumber,dimension.membermodel";

    public static Map<String, DynamicObject> getModelCyDys(long modelId) {
        HashMap<String, DynamicObject> cyNumber2Dy = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (DynamicObject value : map.values()) {
            cyNumber2Dy.put(value.getString("number"), value);
        }
        return cyNumber2Dy;
    }

    public static DynamicObject getMemberDy(long modelId, String atNum, String formNumber) {
        QFilter filter = new QFilter("model.id", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)atNum));
        DynamicObject dy = QueryServiceHelper.queryOne((String)formNumber, (String)selectFields, (QFilter[])new QFilter[]{filter});
        return dy;
    }

    public static DynamicObjectCollection getTempDoc(List<String> tmps, long modelId) {
        DynamicObjectType dyType = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportlistmultiexport").getDynamicObjectCollection("reportentry").getDynamicObjectType();
        DynamicObjectCollection tempDoc = new DynamicObjectCollection();
        for (DynamicObject temp : TemplateServiceHelper.getGroupId2LastTempMap(modelId, tmps).values()) {
            DynamicObject dy = new DynamicObject(dyType);
            DynamicObject report_numberDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
            report_numberDy.set("id", (Object)temp.getLong("id"));
            report_numberDy.set("number", (Object)temp.getString("number"));
            dy.set("report_number_id", (Object)temp.getLong("id"));
            dy.set("report_number", (Object)report_numberDy);
            tempDoc.add((Object)dy);
        }
        return tempDoc;
    }

    public static DynamicObjectCollection getTempDoc4AEF(List<String> tmps, long modelId) {
        DynamicObjectType dyType = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportlistmultiexport").getDynamicObjectCollection("reportentry").getDynamicObjectType();
        DynamicObjectCollection tempDoc = new DynamicObjectCollection();
        for (DynamicObject temp : TemplateServiceHelper.getGroupId2LastTempMap4AEF(modelId, tmps).values()) {
            DynamicObject dy = new DynamicObject(dyType);
            DynamicObject report_numberDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateentity");
            report_numberDy.set("id", (Object)temp.getLong("id"));
            report_numberDy.set("number", (Object)temp.getString("number"));
            dy.set("report_number_id", (Object)temp.getLong("id"));
            dy.set("report_number", (Object)report_numberDy);
            tempDoc.add((Object)dy);
        }
        return tempDoc;
    }

    public static DynamicObjectCollection getOrgDoc(List<String> orgs, long modelId) {
        DynamicObjectCollection orgDoc = new DynamicObjectCollection();
        DynamicObjectType dyType = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportlistmultiexport").getDynamicObjectCollection("orgentry").getDynamicObjectType();
        for (DynamicObject org : ExportUtils.getMemberDys(modelId, orgs)) {
            DynamicObject dy = new DynamicObject(dyType);
            dy.set("org_number_id", (Object)org.getLong("id"));
            DynamicObject org_NumberDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            org_NumberDy.set("id", (Object)org.getLong("id"));
            org_NumberDy.set("number", (Object)org.getString("number"));
            dy.set("org_number", (Object)org_NumberDy);
            dy.set("membrange", (Object)RangeEnum.VALUE_10.getValue());
            orgDoc.add((Object)dy);
        }
        return orgDoc;
    }

    protected static DynamicObjectCollection getMemberDys(long modelId, List<String> numbers) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "in", numbers));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return doc;
    }

    public static Map<String, DynamicObject> getDimNum2Items(Map<String, String> dim2Mems, long modelId) {
        HashMap<String, DynamicObject> dimNum2Items = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<String, String> entry : dim2Mems.entrySet()) {
            DynamicObject dy = ExportUtils.getMemberDy(modelId, entry.getValue(), DimEntityNumEnum.getEntieyNumByNumber((String)entry.getKey()));
            dimNum2Items.put(entry.getKey(), dy);
        }
        return dimNum2Items;
    }
}

