/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;

public class ExportExtModelServiceHelper {
    private static final String NUMBER = "XDMCode";
    private static final String NAME = "XDMName";
    private static final String GROUP = "XGroup";
    private static final String DESCRIPTION = "Description";
    private static final String STATUS = "Status";
    private static final String CAN_TRANS = "CanTrans";
    private static final String MODIFIER = "LastUpdateBy";
    private static final String MODIFYTIME = "LastUpdateTime";
    private static final String FIELD_ENTRIES = "Columns";
    private static final String FIELD_NUMBER = "ColCode";
    private static final String FIELD_TYPE = "ColType";
    private static final String IS_NECESARRY = "NotNull";
    private static final String UNIQUE_CHECK = "IsUnique";

    public static JSONArray getModel(List<String> numbers, long modelId) {
        QFilter modelQF = new QFilter("model", "=", (Object)modelId);
        QFilter qf1 = new QFilter("number", "in", numbers);
        DynamicObjectCollection extModels = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{modelQF, qf1});
        JSONArray result = new JSONArray();
        for (DynamicObject extModel : extModels) {
            ExtendsModel extendsModel = new ExtendsModel(extModel.getLong("id"));
            JSONObject modelObj = new JSONObject(new LinkedHashMap(16));
            modelObj.put(NUMBER, (Object)extendsModel.getNumber());
            modelObj.put(NAME, (Object)extendsModel.getName());
            modelObj.put(GROUP, (Object)extendsModel.getExtendsGroupNumber());
            modelObj.put(DESCRIPTION, (Object)extendsModel.getDescription());
            modelObj.put(STATUS, (Object)("1".equals(extendsModel.getEnable()) ? "Valid" : "Invalid"));
            modelObj.put(CAN_TRANS, (Object)(extendsModel.getIsConvert() ? "True" : "False"));
            modelObj.put(MODIFIER, (Object)extendsModel.getModifierName());
            String format = ResManager.getLocaleString((String)"yyyy\u5e74MM\u6708dd\u65e5 hh:mm:ss", (String)"ExportExtModelServiceHelper_2", (String)"fi-bcm-business").getLocaleValue_zh_CN();
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            modelObj.put(MODIFYTIME, (Object)sdf.format(extendsModel.getModifytime()));
            JSONArray fieldEntries = new JSONArray();
            for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
                JSONObject fieldEntryObj = new JSONObject();
                fieldEntryObj.put(FIELD_NUMBER, (Object)fieldEntry.getNumber());
                fieldEntryObj.put(FIELD_TYPE, (Object)FieldTypeEnum.getNumberByType((int)fieldEntry.getFieldType()));
                fieldEntryObj.put(IS_NECESARRY, (Object)(fieldEntry.getIsNecessary() ? "Y" : "N"));
                fieldEntryObj.put(UNIQUE_CHECK, (Object)(fieldEntry.getUniqueCheck() ? "Y" : "N"));
                fieldEntries.add((Object)fieldEntryObj);
            }
            modelObj.put(FIELD_ENTRIES, (Object)fieldEntries);
            result.add((Object)modelObj);
        }
        return result;
    }

    public static String downloadJsonFile(String jsonData) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(jsonData.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        StringBuilder sb = new StringBuilder();
        sb.append(sdf.format(new Date()));
        sb.append(".json");
        String fileName = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5bfc\u51fa\u6587\u4ef6_%s", (String)"ExportExtModelServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), sb.toString());
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
    }

    public static String downloadTxtFile(String message) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(message.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        StringBuilder sb = new StringBuilder();
        sb.append(sdf.format(new Date()));
        sb.append(".log");
        String fileName = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u5bfc\u5165\u65e5\u5fd7_%s", (String)"ExportExtModelServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), sb.toString());
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
    }
}

