/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;

public class ExtDataCheckHelper {
    public static void uniquecheck(EDSaveComInfo saveComInfo) {
        if (!saveComInfo.isUniquecheck()) {
            return;
        }
        QFilter extModelFileter = new QFilter("number", "=", (Object)saveComInfo.getDatamodel());
        extModelFileter.and(new QFilter("model", "=", (Object)saveComInfo.getModelId()));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{extModelFileter});
        ExtendsModel extModel = new ExtendsModel(dy.getLong("id"));
        List<String> uniqueList = extModel.getFieldEntry().stream().filter(f -> f.getUniqueCheck()).map(f -> f.getNumber()).collect(Collectors.toList());
        ArrayList<String> cols = new ArrayList<String>();
        cols.addAll(Lists.newArrayList((Object[])saveComInfo.getCols()));
        cols.addAll(Lists.newArrayList((Object[])saveComInfo.getDims()));
        if (!cols.containsAll(uniqueList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f55\u5165\u6570\u636e\u6ca1\u6709\u5305\u542b\u5168\u90e8\u552f\u4e00\u6027\u6821\u9a8c\u5b57\u6bb5\u3002", (String)"ExtDataCheckHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<Long, String> keys = ExtDataCheckHelper.getKeyFromDB(saveComInfo, uniqueList);
        ExtDataCheckHelper.checkRepair(saveComInfo, uniqueList, cols, keys);
        if (!saveComInfo.getErrorvalues().isEmpty() && saveComInfo.isUniquecheck() && !saveComInfo.isIgnoreuniquevalue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u552f\u4e00\u6027\u6821\u9a8c\u91cd\u590d\u3002", (String)"ExtDataCheckHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), Arrays.toString(saveComInfo.getErrorvalues().get(0))));
        }
    }

    private static Map<Long, String> getKeyFromDB(EDSaveComInfo saveComInfo, List<String> notNumUniques) {
        HashMap<Long, String> keys = new HashMap<Long, String>(16);
        EdQueryComInfo queryCommand = ExtDataCheckHelper.buildQuery(saveComInfo);
        EDResultSet edResultSet = ExtDataServiceHelper.queryData(queryCommand);
        edResultSet.iteratorRows(row -> {
            StringBuilder sb = new StringBuilder();
            if (notNumUniques.size() > 0) {
                for (String unique : notNumUniques) {
                    Object value = row.getOriginalValue(unique);
                    ExtDataCheckHelper.packKey(sb, value);
                }
                keys.put(row.getPkId(), sb.toString());
            }
        });
        return keys;
    }

    private static void checkRepair(EDSaveComInfo saveComInfo, List<String> uniqueList, List<String> cols, Map<Long, String> dbkeys) {
        ArrayList<String> keys = new ArrayList<String>(16);
        Iterator<Object[]> iterator = saveComInfo.getValue().iterator();
        Map<Long, Object[]> updateValues = saveComInfo.getUpdateValues();
        for (Map.Entry<Long, Object[]> entry : updateValues.entrySet()) {
            Object[] row = entry.getValue();
            StringBuilder sb = new StringBuilder();
            if (uniqueList.size() <= 0) continue;
            for (String unique : uniqueList) {
                if (!cols.contains(unique)) continue;
                Object value = row[cols.indexOf(unique)];
                ExtDataCheckHelper.packKey(sb, value);
            }
            if (dbkeys.containsValue(sb.toString()) && !dbkeys.get(entry.getKey()).equals(sb.toString())) {
                saveComInfo.getUpdateValues().remove(entry.getKey());
                saveComInfo.addErrorvalues(row);
                continue;
            }
            dbkeys.put(entry.getKey(), sb.toString());
        }
        while (iterator.hasNext()) {
            Object[] row = iterator.next();
            StringBuilder sb = new StringBuilder();
            if (uniqueList.size() <= 0) continue;
            for (String unique : uniqueList) {
                if (!cols.contains(unique)) continue;
                Object value = row[cols.indexOf(unique)];
                ExtDataCheckHelper.packKey(sb, value);
            }
            if (dbkeys.containsValue(sb.toString()) || keys.contains(sb.toString())) {
                iterator.remove();
                saveComInfo.getValue().remove(row);
                saveComInfo.addErrorvalues(row);
                continue;
            }
            keys.add(sb.toString());
        }
    }

    private static void packKey(StringBuilder sb, Object value) {
        if (value instanceof Integer && EDSaveComInfo.dateError == (Integer)value || value instanceof Number && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
            sb.append("null").append("|");
        } else {
            sb.append(value).append("|");
        }
    }

    public static EdQueryComInfo buildQuery(EDSaveComInfo saveComInfo) {
        EdQueryComInfo edQueryComInfo = new EdQueryComInfo(saveComInfo.getShowNumber(), saveComInfo.getExtGroup(), saveComInfo.getDatamodel());
        for (Map.Entry<String, String> ss : saveComInfo.getfixedDimension().entrySet()) {
            edQueryComInfo.addDimFilter(ss.getKey(), ss.getValue());
        }
        edQueryComInfo.setExtselects(saveComInfo.getCols());
        edQueryComInfo.setDimselects(saveComInfo.getDims());
        return edQueryComInfo;
    }
}

