/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ExtDataLockServiceHelper {
    public static final String SPLIT = "|";
    public static final String ENTITY_NAME = "bcm_extdatalock";

    public static void lockExtData(long modelId, long extendModel, long entity, long scenario, long year, long period, long currency) {
        ExtDataLockServiceHelper.lockMultiExtData(modelId, Collections.singleton(extendModel), entity, scenario, year, period, currency);
    }

    public static void lockMultiExtData(long modelId, Set<Long> extendModels, long entity, long scenario, long year, long period, long currency) {
        boolean exist = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField());
        if (exist) {
            try (TXHandle tx = TX.required();){
                QFBuilder qfBuilder = ExtDataLockServiceHelper.getQfBuilder(modelId, entity, scenario, year, period, currency);
                DynamicObject[] isLocks = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"extmodel,modifier,modifydate,islock", (QFilter[])qfBuilder.toArray());
                HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
                ArrayList<DynamicObject> newInserts = new ArrayList<DynamicObject>();
                for (DynamicObject isLock : isLocks) {
                    long extModel = isLock.getLong("extmodel.id");
                    if (!extendModels.contains(extModel)) continue;
                    map.put(extModel, isLock);
                }
                for (Long extModelId : extendModels) {
                    DynamicObject obj = (DynamicObject)map.get(extModelId);
                    if (obj == null) {
                        DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
                        temp.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        temp.set("model", (Object)modelId);
                        temp.set("extmodel", (Object)extModelId);
                        temp.set("entity", (Object)entity);
                        temp.set("scenario", (Object)scenario);
                        temp.set("year", (Object)year);
                        temp.set("period", (Object)period);
                        temp.set("currency", (Object)currency);
                        temp.set("islock", (Object)"1");
                        newInserts.add(temp);
                        continue;
                    }
                    obj.set("islock", (Object)"1");
                }
                if (!map.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
                }
                if (!newInserts.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])newInserts.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    public static void unlockExtData(long modelId, long extendModel, long entity, long scenario, long year, long period, long currency) {
        ExtDataLockServiceHelper.unlockMulExtData(modelId, Collections.singleton(extendModel), entity, scenario, year, period, currency);
    }

    public static void unlockMulExtData(long modelId, Set<Long> extendModels, long entity, long scenario, long year, long period, long currency) {
        boolean exist = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField());
        if (exist) {
            try (TXHandle tx = TX.required();){
                QFBuilder qfBuilder = ExtDataLockServiceHelper.getQfBuilder(modelId, entity, scenario, year, period, currency);
                DynamicObject[] isLocks = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"extmodel.id,modifier,modifydate,islock", (QFilter[])qfBuilder.toArray());
                HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
                for (DynamicObject isLock : isLocks) {
                    long extModel = isLock.getLong("extmodel.id");
                    if (!extendModels.contains(extModel)) continue;
                    map.put(extModel, isLock);
                }
                for (Long extModelId : extendModels) {
                    DynamicObject obj = (DynamicObject)map.get(extModelId);
                    if (obj == null) continue;
                    obj.set("islock", (Object)"0");
                }
                if (!map.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])map.values().toArray(new DynamicObject[0]));
                }
            }
        }
    }

    public static DynamicObjectCollection isLocked(long modelId, long extendModel, Set<Long> entityIds, Set<Long> scenarioIds, Set<Long> yearIds, Set<Long> periodIds, Set<Long> currencyIds) {
        boolean exist = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField());
        if (!exist) {
            return new DynamicObjectCollection();
        }
        HashMap<Long, Long> storageToShare = new HashMap<Long, Long>(8);
        for (Long entityId : entityIds) {
            IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId);
            if (treeNode.getStorageType() == StorageTypeEnum.SHARE) {
                storageToShare.put(MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)treeNode.getNumber()).getId(), entityId);
                continue;
            }
            storageToShare.put(entityId, entityId);
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and("extmodel", "=", (Object)extendModel);
        if (CollectionUtils.isNotEmpty(storageToShare.keySet())) {
            qfBuilder.add("entity", "in", storageToShare.keySet());
        }
        if (CollectionUtils.isNotEmpty(scenarioIds)) {
            qfBuilder.add("scenario", "in", scenarioIds);
        }
        if (CollectionUtils.isNotEmpty(yearIds)) {
            qfBuilder.add("year", "in", yearIds);
        }
        if (CollectionUtils.isNotEmpty(periodIds)) {
            qfBuilder.add("period", "in", periodIds);
        }
        if (CollectionUtils.isNotEmpty(currencyIds)) {
            qfBuilder.add("currency", "in", currencyIds);
        }
        qfBuilder.add("islock", "=", (Object)"1");
        DynamicObjectCollection res = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,entity,scenario,year,period,currency", (QFilter[])qfBuilder.toArray());
        for (DynamicObject re : res) {
            re.set("entity", (Object)storageToShare.getOrDefault(re.getLong("entity"), re.getLong("entity")));
        }
        return res;
    }

    public static boolean isLocked(long modelId, long extendModel, long entity, long scenario, long year, long period, long currency) {
        StringJoiner sj = new StringJoiner(SPLIT);
        sj.add(String.valueOf(modelId)).add(String.valueOf(extendModel)).add(String.valueOf(entity)).add(String.valueOf(scenario)).add(String.valueOf(year)).add(String.valueOf(period)).add(String.valueOf(currency));
        return (Boolean)ThreadCache.get((Object)sj.toString(), () -> {
            boolean exist = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField());
            if (!exist) {
                return false;
            }
            QFBuilder qfBuilder = ExtDataLockServiceHelper.getQfBuilder(modelId, entity, scenario, year, period, currency);
            qfBuilder.and("extmodel", "=", (Object)extendModel);
            DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_NAME, (String)"entity,currency,islock", (QFilter[])qfBuilder.toArray());
            return !query.isEmpty() && ((DynamicObject)query.get(0)).getBoolean("islock");
        });
    }

    private static QFBuilder getQfBuilder(long modelId, long entity, long scenario, long year, long period, long currency) {
        IDNumberTreeNode treeNode = MemberReader.findEntityMemberById((Long)modelId, (Long)entity);
        if (treeNode.getStorageType() == StorageTypeEnum.SHARE) {
            treeNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)treeNode.getNumber());
        }
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("entity", "=", (Object)treeNode.getId());
        qfBuilder.add("scenario", "=", (Object)scenario);
        qfBuilder.add("year", "=", (Object)year);
        qfBuilder.add("period", "=", (Object)period);
        qfBuilder.add("currency", "=", (Object)currency);
        return qfBuilder;
    }

    public static boolean isLockedFromCache(long modelId, long extendModel, long scenario, long year, long period, long entity, long currency) {
        boolean exist = OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField());
        if (!exist) {
            return false;
        }
        StringJoiner sj = new StringJoiner(SPLIT);
        sj.add(String.valueOf(modelId));
        sj.add(String.valueOf(extendModel));
        sj.add(String.valueOf(scenario));
        sj.add(String.valueOf(year));
        sj.add(String.valueOf(period));
        Map cache = (Map)ThreadCache.get((Object)sj.toString(), () -> {
            HashMap map = new HashMap();
            DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_NAME, (String)"entity,currency,islock", (QFilter[])new QFBuilder("model", "=", (Object)modelId).and("extmodel", "=", (Object)extendModel).and("scenario", "=", (Object)scenario).and("period", "=", (Object)period).toArray());
            for (DynamicObject obj : query) {
                long entityId = obj.getLong("entity");
                map.putIfAbsent(entityId, new HashMap());
                ((Map)map.get(entityId)).put(obj.getLong("currency"), obj.getBoolean("islock"));
            }
            return map;
        });
        Map map = (Map)cache.get(entity);
        if (map == null) {
            return false;
        }
        return map.get(currency) != null && (Boolean)map.get(currency) != false;
    }
}

