/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.extendscript.QueryCommand;
import kd.fi.bcm.business.bizrule.extendscript.extendmodel.ExtendRow;
import kd.fi.bcm.business.bizstatus.BizStatusServer;
import kd.fi.bcm.business.bizstatus.access.BizStatusAccessFactory;
import kd.fi.bcm.business.bizstatus.model.BizStatusContext;
import kd.fi.bcm.business.bizstatus.model.QueryStatusCommandInfo;
import kd.fi.bcm.business.bizstatus.model.StatusResult;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.IExtQueryService;
import kd.fi.bcm.business.extdata.OrderResult;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.SortInfo;
import org.apache.commons.lang3.StringUtils;

public class ExtDataQueryService
implements IExtQueryService {
    protected EDResultSetMetaData metaData;
    public static final Set<String> changeDim = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    public static final Set<String> ctxDim = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    public static final Set<String> INDEX_DIM = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber()});
    public static final String SOURCEENTITY = "SourceEntity";
    private static final String ENTITYSIGNFORDB = "entity";
    public static final Set<String> processByRpt = Sets.newHashSet((Object[])new String[]{"ERpt", "EIRpt", "ERAdj"});
    private Set<Long> orgSetForOrder;
    private Set<String> orgNumSetForOrder;
    protected static final List<String> COMBINE_KEYS = Lists.newArrayList((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
    protected static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ExtDataQueryService.class);

    @Override
    public EDRow[] populate(EDResultSetMetaData metaData, EdQueryComInfo edQueryComInfo) {
        this.metaData = metaData;
        DataSet ds = this.queryDataset(edQueryComInfo);
        return this.transferDSToRows(ds, edQueryComInfo);
    }

    protected EDRow[] transferDSToRows(DataSet ds, EdQueryComInfo edQueryComInfo) {
        String cache = DataSetUtil.cacheDataSet((DataSet)ds);
        EDRow[] result = this.fillRows(DataSetUtil.getAllData((String)cache), edQueryComInfo);
        DataSetUtil.close((String)cache);
        return result;
    }

    public void setMetaData(EDResultSetMetaData metaData) {
        this.metaData = metaData;
    }

    protected void checkQueryInfo(EdQueryComInfo cI) {
        if (cI.isQueryOriData()) {
            return;
        }
        if (!(cI.getDimFilter().containsKey(DimTypesEnum.SCENARIO.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.YEAR.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.PERIOD.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.ENTITY.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.CURRENCY.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.PROCESS.getNumber()) && cI.getDimFilter().containsKey(DimTypesEnum.AUDITTRIAL.getNumber()))) {
            throw new KDBizException("EdCommandInfo dimfilter is Incomplete.");
        }
    }

    public DataSet queryDataset(EdQueryComInfo edQueryComInfo) {
        if (this.orgSetForOrder == null) {
            this.orgSetForOrder = new HashSet<Long>(16);
        }
        this.orgSetForOrder.add(edQueryComInfo.getMainOrgId());
        this.checkQueryInfo(edQueryComInfo);
        QFilter qFilter = this.getQueryFilter(edQueryComInfo);
        boolean needSum = ExtDataQueryService.needSum(edQueryComInfo);
        String selectCols = this.getSelectCols(edQueryComInfo, needSum);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"bcm_ext", (String)ExtDataQueryService.getExtendEntity(edQueryComInfo), (String)selectCols, (QFilter[])new QFilter[]{qFilter}, null);
        if (!needSum) {
            OrderResult ods = this.orderDs(edQueryComInfo, ds, selectCols);
            if (ods != null) {
                ds = ods.getDs();
                ds = this.topDs(edQueryComInfo, ds);
                ds = ds.orderBy(ods.getOrder());
            }
        } else {
            HashSet<String> groupby = new HashSet<String>();
            ArrayList<String> sumfelds = new ArrayList<String>();
            ExtDataQueryService.fixGroupAndSumFileld(edQueryComInfo, groupby, sumfelds);
            OrderResult ods = this.orderDs(edQueryComInfo, ds, this.getSelectCols(edQueryComInfo, true));
            if (ods != null) {
                ds = ods.getDs();
            }
            if (ods != null) {
                groupby.addAll(Arrays.asList(ods.getGroupby()));
            }
            ds = ExtDataQueryService.groupAndSum(ds, groupby, sumfelds);
            ds = this.topDs(edQueryComInfo, ds);
            if (ods != null) {
                ds = ds.orderBy(ods.getOrder());
            }
        }
        ExtDataQueryService.getSumValue(edQueryComInfo, ds);
        return this.filterWholeRowZero(ds, edQueryComInfo);
    }

    @Override
    public DataSet queryNewDataSet(EdQueryComInfo edQueryComInfo) {
        return this.queryDataset(edQueryComInfo);
    }

    private DataSet filterWholeRowZero(DataSet ds, EdQueryComInfo edQueryComInfo) {
        String[] extselects;
        if (!edQueryComInfo.isShowWholeRowZero() && (extselects = edQueryComInfo.getExtselects()) != null) {
            Collection<Object> numberList;
            FilterFunction function = new FilterFunction(){

                public boolean test(Row row) {
                    return false;
                }
            };
            if (edQueryComInfo.getFilterZeroFields().isEmpty() || edQueryComInfo.getFilterZeroFields() == null) {
                Map<String, String> dataTypeMap = ExtDimensionHelper.getExtMemberDataType(edQueryComInfo.getModelId(), edQueryComInfo.getExtGroup(), Arrays.asList(extselects));
                numberList = Lists.newArrayList(dataTypeMap.keySet());
                edQueryComInfo.setFilterZeroFields((List<String>)numberList);
            }
            if (!(edQueryComInfo.getFilterZeroFields().isEmpty() || !edQueryComInfo.isDataUseInQuery() && ExtDataQueryService.isCanEdit(edQueryComInfo, false))) {
                Map<String, String> zeroFields = edQueryComInfo.getFieldMappedForCols(edQueryComInfo.getFilterZeroFields().toArray(new String[0]));
                numberList = zeroFields.values();
                function = new FilterFunction(){

                    public boolean test(Row row) {
                        return numberList.stream().anyMatch(e -> row.getBigDecimal(e).compareTo(BigDecimal.ZERO) != 0);
                    }
                };
                ds = ds.filter(function);
            }
        }
        return ds;
    }

    public static String getExtendEntity(EdQueryComInfo edQueryComInfo) {
        return ExtendDimGroupType.COMMON.getIndex().equals(edQueryComInfo.getGrouptype()) ? "bcm_extenddata" : "bcm_extenddata_bus";
    }

    private static void getSumValue(EdQueryComInfo edQueryComInfo, DataSet ds) {
        block7: {
            try {
                String[] extselects;
                if (edQueryComInfo.getSumcols() == null || edQueryComInfo.getSumcols().isEmpty() || (extselects = edQueryComInfo.getExtselects()) == null) break block7;
                Map<String, String> fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(extselects);
                GroupbyDataSet gds = ds.copy().groupBy();
                for (String sc : edQueryComInfo.getSumcols()) {
                    String fm;
                    if (!fieldMappedForCols.containsKey(sc) || !(fm = fieldMappedForCols.get(sc)).contains("numext")) continue;
                    gds.sum(fm);
                }
                DataSet sds = gds.finish();
                HashMap<String, BigDecimal> re = new HashMap<String, BigDecimal>();
                if (sds.hasNext()) {
                    Row r = sds.next();
                    for (String sc : edQueryComInfo.getSumcols()) {
                        String fm;
                        if (!fieldMappedForCols.containsKey(sc) || !(fm = fieldMappedForCols.get(sc)).contains("numext")) continue;
                        re.put(sc, r.getBigDecimal(fieldMappedForCols.get(sc)));
                    }
                } else {
                    for (String sc : edQueryComInfo.getSumcols()) {
                        re.put(sc, null);
                    }
                }
                edQueryComInfo.setSumValue(re);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u805a\u5408\u516c\u5f0f\u8ba1\u7b97\u9519\u8bef\u3002", (String)"ExtDataQueryService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    private static Map<String, String> getKeytosqlcol(EdQueryComInfo edQueryComInfo) {
        String[] extselects;
        HashMap<String, String> keytosqlcol = new HashMap<String, String>();
        String[] dimselects = edQueryComInfo.getDimselects();
        if (dimselects != null) {
            keytosqlcol.putAll(edQueryComInfo.getFieldMappedForDims(dimselects));
        }
        if ((extselects = edQueryComInfo.getExtselects()) != null) {
            keytosqlcol.putAll(edQueryComInfo.getFieldMappedForCols(extselects));
        }
        return keytosqlcol;
    }

    private OrderResult orderDs(EdQueryComInfo edQueryComInfo, DataSet ds, String select) {
        if (!edQueryComInfo.isUseForOrgSave() && edQueryComInfo.getSortInfo() != null) {
            Map<String, String> keytosqlcol = ExtDataQueryService.getKeytosqlcol(edQueryComInfo);
            ArrayList<String> order = new ArrayList<String>();
            int seqindex = 1;
            ArrayList<String> selects = new ArrayList<String>(Arrays.asList(select.split(",")));
            ArrayList<String> gruopbyAdd = new ArrayList<String>();
            List<SortInfo> sis = edQueryComInfo.getSortInfo().getSortInfos();
            sis.sort(Comparator.comparingInt(SortInfo::getSortpriority));
            for (SortInfo sortInfo : sis) {
                DataSet sort;
                String seqfield;
                IDNumberTreeNode entity;
                boolean sortorg = DimTypesEnum.ENTITY.getNumber().equals(sortInfo.getSortField());
                if (sortorg && edQueryComInfo.getMainOrgId() != 0L && !(entity = MemberReader.findMemberById((long)edQueryComInfo.getModelId(), (String)DimEntityNumEnum.ENTITY.getEntityNum(), (Long)edQueryComInfo.getMainOrgId())).isLeaf()) {
                    Set<Long> notMergeSet = this.getNotMergeSet(edQueryComInfo, entity);
                    this.getAllOrgNums(entity.getChildren(), new HashSet<String>(), notMergeSet);
                }
                if (sortInfo.getSortType() == SortInfo.SortType.MEMB) {
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(sortInfo.getSortField())) {
                        seqfield = "seq" + seqindex++;
                        sort = ExtDataQueryService.getOrderRightData(edQueryComInfo, sortInfo, seqfield, "longnumber");
                        ds = ExtDataQueryService.joinDataSet(ds, sort, keytosqlcol.get(sortInfo.getSortField()), "number", order, selects, gruopbyAdd, seqfield, false);
                        continue;
                    }
                    seqfield = "seq" + seqindex++;
                    QFilter qf = this.getMemberOrderFilter(edQueryComInfo, sortInfo, sortorg);
                    DataSet sort2 = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_memberorder", (String)("dseq as " + seqfield + ",number"), (QFilter[])new QFilter[]{qf}, null);
                    ds = ExtDataQueryService.joinDataSet(ds, sort2, keytosqlcol.get(sortInfo.getSortField()), "number", order, selects, gruopbyAdd, seqfield, false);
                    continue;
                }
                if (PositionInfo.FloatMemDisplayPattern.NAME == edQueryComInfo.getSortInfo().getShowType().get(sortInfo.getSortField())) {
                    seqfield = "seq" + seqindex++;
                    sort = ExtDataQueryService.getOrderRightData(edQueryComInfo, sortInfo, seqfield, "name");
                    ds = ExtDataQueryService.joinDataSet(ds, sort, keytosqlcol.get(sortInfo.getSortField()), "number", order, selects, gruopbyAdd, seqfield, sortInfo.getSortType() == SortInfo.SortType.DESC, true);
                    continue;
                }
                if (PositionInfo.FloatMemDisplayPattern.SIMPLENAME == edQueryComInfo.getSortInfo().getShowType().get(sortInfo.getSortField())) {
                    seqfield = "seq" + seqindex++;
                    sort = ExtDataQueryService.getOrderRightData(edQueryComInfo, sortInfo, seqfield, "simplename");
                    ds = ExtDataQueryService.joinDataSet(ds, sort, keytosqlcol.get(sortInfo.getSortField()), "number", order, selects, gruopbyAdd, seqfield, sortInfo.getSortType() == SortInfo.SortType.DESC, true);
                    seqfield = "seq" + seqindex++;
                    sort = ExtDataQueryService.getOrderRightData(edQueryComInfo, sortInfo, seqfield, "name");
                    ds = ExtDataQueryService.joinDataSet(ds, sort, keytosqlcol.get(sortInfo.getSortField()), "number", order, selects, gruopbyAdd, seqfield, sortInfo.getSortType() == SortInfo.SortType.DESC, true);
                    continue;
                }
                order.add(keytosqlcol.get(sortInfo.getSortField()) + ' ' + (sortInfo.getSortType() == SortInfo.SortType.ASC ? "asc" : "desc"));
            }
            return new OrderResult(ds, order.toArray(new String[0]), gruopbyAdd.toArray(new String[0]));
        }
        return null;
    }

    private QFilter getMemberOrderFilter(EdQueryComInfo edQueryComInfo, SortInfo sortInfo, boolean sortorg) {
        long dimid = MemberReader.getDimensionIdByNum((long)edQueryComInfo.getModelId(), (String)sortInfo.getSortField());
        DimMemberSortUtil.compareTimeOfChangeAndRefresh(edQueryComInfo.getModelId(), sortorg ? edQueryComInfo.getSortInfo().getCslschemeId() : 0L, dimid);
        QFilter qf = new QFilter("model", "=", (Object)edQueryComInfo.getModelId());
        qf.and("dimid", "=", (Object)dimid);
        if (sortorg) {
            qf.and("cslschemeid", "=", (Object)edQueryComInfo.getSortInfo().getCslschemeId());
            if (this.orgSetForOrder != null && !this.orgSetForOrder.isEmpty()) {
                this.orgSetForOrder.add(edQueryComInfo.getMainOrgId());
                qf.and("memberid", "in", this.orgSetForOrder);
            }
        }
        return qf;
    }

    private static DataSet getOrderRightData(EdQueryComInfo edQueryComInfo, SortInfo sortInfo, String seqfield, String select) {
        QFilter qf = ExtDataQueryService.getDimFilter(edQueryComInfo, sortInfo);
        return QueryServiceHelper.queryDataSet((String)"", (String)DimEntityNumEnum.getEntieyNumByNumber((String)sortInfo.getSortField()), (String)(select + " as " + seqfield + ",number"), (QFilter[])new QFilter[]{qf}, null);
    }

    private static QFilter getDimFilter(EdQueryComInfo edQueryComInfo, SortInfo sortInfo) {
        long dimid = MemberReader.getDimensionIdByNum((long)edQueryComInfo.getModelId(), (String)sortInfo.getSortField());
        QFilter qf = new QFilter("model", "=", (Object)edQueryComInfo.getModelId());
        qf.and("dimension", "=", (Object)dimid);
        qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        return qf;
    }

    private static DataSet joinDataSet(DataSet ds, DataSet sort, String onleft, String onright, List<String> order, List<String> selects, List<String> gruopbyAdd, String seqfield, boolean isDesc) {
        return ExtDataQueryService.joinDataSet(ds, sort, onleft, onright, order, selects, gruopbyAdd, seqfield, isDesc, false);
    }

    private static DataSet joinDataSet(DataSet ds, DataSet sort, String onleft, String onright, List<String> order, List<String> selects, List<String> gruopbyAdd, String seqfield, boolean isDesc, boolean sortByPy) {
        ds = ds.leftJoin(sort).on(onleft, onright).select(selects.toArray(new String[0]), new String[]{seqfield}).finish();
        selects.add(seqfield);
        String orderstring = seqfield + (isDesc ? " desc" : " asc");
        if (sortByPy) {
            orderstring = orderstring + " collate zh_cn";
        }
        order.add(orderstring);
        gruopbyAdd.add(seqfield);
        return ds;
    }

    private DataSet topDs(EdQueryComInfo edQueryComInfo, DataSet ds) {
        if (!edQueryComInfo.isUseForOrgSave() && edQueryComInfo.getSortInfo() != null && edQueryComInfo.getSortInfo().getTopField() != null) {
            HashMap<String, String> keytosqlcol = new HashMap<String, String>();
            String[] extselects = edQueryComInfo.getExtselects();
            if (extselects != null) {
                keytosqlcol.putAll(edQueryComInfo.getFieldMappedForCols(extselects));
            }
            ds = ds.topBy(edQueryComInfo.getSortInfo().getTopCount(), new String[]{(String)keytosqlcol.get(edQueryComInfo.getSortInfo().getTopField()) + " desc"});
        }
        return ds;
    }

    protected static void fixGroupAndSumFileld(EdQueryComInfo edQueryComInfo, Set<String> groupby, List<String> sumfelds) {
        String[] extselects = edQueryComInfo.getExtselects();
        String[] dimselects = edQueryComInfo.getDimselects();
        if (dimselects != null && dimselects.length > 0) {
            Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimselects);
            groupby.addAll(fieldMappedForDims.values());
        }
        if (extselects != null && extselects.length > 0) {
            Map<String, String> fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(extselects);
            Set enumNums = (Set)ThreadCache.get((Object)"edqsfgasf.dt", () -> {
                HashSet pns = new HashSet();
                QueryServiceHelper.query((String)DimEntityNumEnum.EXTENDS.getEntityNum(), (String)"number", (QFilter[])new QFilter[]{QFilter.of((String)"model =? and datatype = ?", (Object[])new Object[]{edQueryComInfo.getModelId(), DataTypeEnum.ENUMTP.index})}).forEach(d -> pns.add(d.getString("number")));
                return pns;
            });
            List<String> uniqueList = ExtDataQueryService.getExtModelUniqueFields(edQueryComInfo);
            for (Map.Entry<String, String> map : fieldMappedForCols.entrySet()) {
                if (!map.getValue().startsWith("numext") || enumNums.contains(map.getKey()) || uniqueList.contains(map.getKey())) {
                    groupby.add(map.getValue());
                    continue;
                }
                sumfelds.add(map.getValue());
            }
        }
    }

    private static boolean needSum(EdQueryComInfo edQueryComInfo) {
        if (edQueryComInfo instanceof QueryCommand) {
            return edQueryComInfo.isNeedSum();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> dim2mem : edQueryComInfo.getDimFilter().entrySet()) {
            String[] mems = dim2mem.getValue();
            if (mems == null || mems.length == 0) continue;
            sb.append(mems[0]);
        }
        return (Boolean)ThreadCache.get((Object)("ext.needsum" + sb + edQueryComInfo.getDatamodel()), () -> {
            String orgNumber;
            if (edQueryComInfo.isNeedSum() || edQueryComInfo.isUseForOrgSave()) {
                return true;
            }
            if (edQueryComInfo.isQueryOriData()) {
                return false;
            }
            boolean canedit = ExtDataQueryService.isCanEdit(edQueryComInfo, true);
            if (canedit) {
                return false;
            }
            Map<String, String[]> dimFilter = edQueryComInfo.getDimFilter();
            String processValue = dimFilter.get(DimTypesEnum.PROCESS.getNumber())[0];
            String atValue = dimFilter.get(DimTypesEnum.AUDITTRIAL.getNumber())[0];
            String orgValue = dimFilter.get(DimTypesEnum.ENTITY.getNumber())[0];
            if (edQueryComInfo.getParentOrg() != null) {
                orgNumber = edQueryComInfo.getParentOrg() + "_" + orgValue;
            } else {
                String parentOrgBaseNumber = TreeStructureServiceHelper.getParentOrgBaseNumber(edQueryComInfo.getModelNum(), orgValue);
                orgNumber = parentOrgBaseNumber + "_" + orgValue;
            }
            IDNumberTreeNode entity = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNumber);
            IDNumberTreeNode process = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.PROCESS.getNumber(), (String)processValue);
            IDNumberTreeNode adt = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.AUDITTRIAL.getNumber(), (String)atValue);
            boolean entityneedsum = Boolean.TRUE.toString().equals(edQueryComInfo.getGroupObject().getString("isparticipmerge")) && !entity.isLeaf();
            return entityneedsum || !process.isLeaf() || !adt.isLeaf();
        });
    }

    private static boolean isCanEdit(EdQueryComInfo edQueryComInfo, boolean isFromNeedSum) {
        return (Boolean)ThreadCache.get((Object)("ext.isCanEdit" + edQueryComInfo.getDatamodel()), () -> {
            String orgNumber;
            Map<String, String[]> dimFilter = edQueryComInfo.getDimFilter();
            String processValue = dimFilter.get(DimTypesEnum.PROCESS.getNumber())[0];
            String atValue = dimFilter.get(DimTypesEnum.AUDITTRIAL.getNumber())[0];
            String orgValue = dimFilter.get(DimTypesEnum.ENTITY.getNumber())[0];
            String scValue = dimFilter.get(DimTypesEnum.SCENARIO.getNumber())[0];
            String yearValue = dimFilter.get(DimTypesEnum.YEAR.getNumber())[0];
            String periodValue = dimFilter.get(DimTypesEnum.PERIOD.getNumber())[0];
            String curValue = dimFilter.get(DimTypesEnum.CURRENCY.getNumber())[0];
            if (edQueryComInfo.getParentOrg() != null) {
                orgNumber = edQueryComInfo.getParentOrg() + "_" + orgValue;
            } else {
                String parentOrgBaseNumber = TreeStructureServiceHelper.getParentOrgBaseNumber(edQueryComInfo.getModelNum(), orgValue);
                orgNumber = parentOrgBaseNumber + "_" + orgValue;
            }
            QueryStatusCommandInfo comm = new QueryStatusCommandInfo(edQueryComInfo.getModelNum());
            comm.addFixDimension(DimTypesEnum.ENTITY.getNumber(), orgNumber);
            comm.addFixDimension(DimTypesEnum.CURRENCY.getNumber(), curValue);
            comm.setCrossDimensions(Arrays.asList(DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()));
            comm.addCrossMembers(Arrays.asList(processValue, atValue, scValue, yearValue, periodValue));
            comm.setBizStatusQueryTypes(Collections.singletonList(BizStatusAccessFactory.StatusCodeEnum.ExtBizControl.getCode()));
            comm.setBizGroupInMerge(edQueryComInfo.getGroupObject().getBoolean("isparticipmerge"));
            comm.setFromNeedSum(isFromNeedSum);
            BizStatusContext extCT = new BizStatusContext(comm);
            Map<String, StatusResult> re = BizStatusServer.queryStatus(extCT);
            return re.isEmpty();
        });
    }

    protected boolean isProcessOnEIRpt(String process) {
        return Arrays.asList("Process!CCTotal!CC!PRPT!ARPT!ERpt!EIRpt".split("!")).contains(process) || Arrays.asList("Process!CCTotal!CC!PRPT!ARPT!Rpt!IRpt".split("!")).contains(process);
    }

    protected boolean isAuditTrailOnEntityInput(String process) {
        return Arrays.asList("AuditTrail!ATTotal!RptDS!EntityInput".split("!")).contains(process);
    }

    protected static void setDimfilter(EdQueryComInfo edQueryComInfo, QFilter qFilter, Map<String, String[]> dimFilter, Map<String, String> fieldMappedForDims, boolean setChangeDim) {
        if (fieldMappedForDims.size() != 0) {
            dimFilter.forEach((dimNumber, filterValue) -> {
                boolean canset;
                boolean bl = canset = setChangeDim == changeDim.contains(dimNumber);
                if (canset) {
                    String mapped = (String)fieldMappedForDims.get(dimNumber);
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber) || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNumber)) {
                        Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), (Object)edQueryComInfo.getModelId());
                        int memberSize = allNodeFromCache.size();
                        if (memberSize - ((String[])filterValue).length < ((String[])filterValue).length) {
                            HashSet in_Filter = Sets.newHashSet((Object[])filterValue);
                            Set numbers = allNodeFromCache.values().stream().map(v -> v.getNumber()).collect(Collectors.toSet());
                            numbers.removeAll(in_Filter);
                            qFilter.and(mapped, "not in", numbers);
                        } else {
                            qFilter.and(mapped, "in", filterValue);
                        }
                    } else {
                        qFilter.and(mapped, "in", filterValue);
                    }
                }
            });
        }
    }

    protected Set<String> getAllChildMergeOrg(EdQueryComInfo edQueryComInfo, String orgNum, IDNumberTreeNode entity) {
        Set<Long> notMergeSet = this.getNotMergeSet(edQueryComInfo, entity);
        HashSet allOrgNums = Sets.newHashSet((Object[])new String[]{orgNum});
        if (edQueryComInfo.isUseForOrgSave()) {
            this.getAllOrgNums(entity.getChildren(), allOrgNums, notMergeSet);
        } else {
            this.getAllOrgNums(entity.getAllChildren(), allOrgNums, notMergeSet);
        }
        return allOrgNums;
    }

    private Set<Long> getNotMergeSet(EdQueryComInfo edQueryComInfo, IDNumberTreeNode entity) {
        IDNumberTreeNode scenario = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.SCENARIO.getNumber(), (String)edQueryComInfo.getDimFilter().get(DimTypesEnum.SCENARIO.getNumber())[0]);
        IDNumberTreeNode year = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.YEAR.getNumber(), (String)edQueryComInfo.getDimFilter().get(DimTypesEnum.YEAR.getNumber())[0]);
        IDNumberTreeNode period = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.PERIOD.getNumber(), (String)edQueryComInfo.getDimFilter().get(DimTypesEnum.PERIOD.getNumber())[0]);
        Set<Long> notMergeSet = MergeControlHelper.getNoMergeOrgIdWithChildrenByNumber(edQueryComInfo.getModelId(), scenario.getId(), year.getId(), period.getId(), entity.getLongNumber());
        this.filterNoMergeSet(edQueryComInfo, entity, scenario, year, period, notMergeSet);
        return notMergeSet;
    }

    protected void filterNoMergeSet(EdQueryComInfo edQueryComInfo, IDNumberTreeNode entity, IDNumberTreeNode scenario, IDNumberTreeNode year, IDNumberTreeNode period, Set<Long> notMergeSet) {
        if (!entity.isLeaf() && edQueryComInfo.getGroupObject().getBoolean("isparticipmerge")) {
            Map<Long, String> mdsSourceMap = MergeControlHelper.geAllMergeDs(edQueryComInfo.getModelId(), scenario.getId(), year.getId(), period.getId());
            HashMap<String, String> mdNumberSourceMap = new HashMap<String, String>(mdsSourceMap.size());
            for (Map.Entry<Long, String> entry : mdsSourceMap.entrySet()) {
                mdNumberSourceMap.put(MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)entry.getKey()).getNumber(), entry.getValue());
            }
            this.getNoMergeOrg(mdNumberSourceMap, notMergeSet, entity);
        }
    }

    public void getNoMergeOrg(Map<String, String> mdsSourceMap, Set<Long> notMergeSet, IDNumberTreeNode entity) {
        if (MergeDataSourceEnum.CSTE.getIndex().equals(mdsSourceMap.get(entity.getNumber()))) {
            for (IDNumberTreeNode allChild : entity.getAllChildren()) {
                notMergeSet.add(allChild.getId());
            }
            return;
        }
        for (IDNumberTreeNode child : entity.getChildren()) {
            if (mdsSourceMap.get(child.getNumber()) != null && MergeDataSourceEnum.CSTE.getIndex().equals(mdsSourceMap.get(child.getNumber()))) {
                for (IDNumberTreeNode allChild : child.getAllChildren()) {
                    notMergeSet.add(allChild.getId());
                }
                continue;
            }
            this.getNoMergeOrg(mdsSourceMap, notMergeSet, child);
        }
    }

    protected Map<String, Long> getAllOrgNums(List<IDNumberTreeNode> allChildrens, Set<String> allOrgNums, Set<Long> notMergeSet) {
        HashMap<String, Long> numbertoid = new HashMap<String, Long>();
        if (this.orgNumSetForOrder == null) {
            this.orgNumSetForOrder = new HashSet<String>(16);
        }
        for (IDNumberTreeNode idNumberTreeNode : allChildrens) {
            if (notMergeSet.contains(idNumberTreeNode.getId())) continue;
            String parentNumber = idNumberTreeNode.getParent().getNumber();
            String number = idNumberTreeNode.getNumber();
            allOrgNums.add(number);
            allOrgNums.add(parentNumber + "_" + number);
            if (!this.orgNumSetForOrder.add(number)) continue;
            numbertoid.putIfAbsent(number, idNumberTreeNode.getId());
        }
        if (this.orgSetForOrder == null) {
            this.orgSetForOrder = new HashSet<Long>(16);
        }
        this.orgSetForOrder.addAll(numbertoid.values());
        return numbertoid;
    }

    protected String getSelectCols(EdQueryComInfo edQueryComInfo, boolean needSum) {
        String[] extSelects;
        String[] dimSelects;
        StringJoiner stringJoiner = new StringJoiner(",");
        if (!needSum) {
            stringJoiner.add("id").add("sid");
        }
        if ((dimSelects = edQueryComInfo.getDimselects()) != null) {
            Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimSelects);
            Arrays.stream(dimSelects).forEach(dimSelect -> stringJoiner.add((CharSequence)fieldMappedForDims.get(dimSelect)));
        }
        if ((extSelects = edQueryComInfo.getExtselects()) != null) {
            Map<String, String> fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(extSelects);
            Arrays.stream(extSelects).forEach(extSelect -> stringJoiner.add((CharSequence)fieldMappedForCols.get(extSelect)));
        }
        return stringJoiner.toString();
    }

    public EDRow[] fillRows(List<Row> dynamicObjects, EdQueryComInfo edCommandInfo) {
        if (dynamicObjects.size() == 0) {
            return new EDRow[0];
        }
        EDRow[] rows = new EDRow[dynamicObjects.size()];
        Map<String, String> fieldMappedForCols = this.getFieldMappedForCols(edCommandInfo);
        Map<String, String> fieldMappedForDims = this.getFieldMappedForDims(edCommandInfo);
        boolean needSum = ExtDataQueryService.needSum(edCommandInfo);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            Row dynamicObject = dynamicObjects.get(i);
            EDRow row = this.getEdRow(edCommandInfo, fieldMappedForCols, fieldMappedForDims, dynamicObject);
            if (!needSum) {
                row.setPkId(dynamicObject.getLong("id"));
                row.setSpkId(dynamicObject.getString("sid"));
            }
            rows[i] = row;
        }
        return rows;
    }

    public Map<String, String> getFieldMappedForDims(EdQueryComInfo edCommandInfo) {
        String[] dimSelects = edCommandInfo.getDimselects();
        Map<String, String> fieldMappedForDims = null;
        if (dimSelects != null) {
            fieldMappedForDims = edCommandInfo.getFieldMappedForDims(dimSelects);
        }
        return fieldMappedForDims;
    }

    public Map<String, String> getFieldMappedForCols(EdQueryComInfo edCommandInfo) {
        String[] extSelects = edCommandInfo.getExtselects();
        Map<String, String> fieldMappedForCols = null;
        if (extSelects != null) {
            fieldMappedForCols = edCommandInfo.getFieldMappedForCols(extSelects);
        }
        return fieldMappedForCols;
    }

    protected EDRow getEdRow(EdQueryComInfo comInfo, Map<String, String> mfc, Map<String, String> mfd, Row dbrow) {
        return this.getEdRow(comInfo, mfc, mfd, dbrow, null);
    }

    protected EDRow getEdRow(EdQueryComInfo comInfo, Map<String, String> mfc, Map<String, String> mfd, Row dbrow, BiPredicate<EDRow, String> defaultValue) {
        EDRow row = comInfo instanceof QueryCommand ? new ExtendRow(this.metaData) : new EDRow(this.metaData);
        List<EDColumn> colMetaDatas = this.metaData.getColMetaDatas();
        for (EDColumn edColumn : colMetaDatas) {
            String dimNumber = edColumn.getMdName();
            String mapped = null;
            if (mfc != null) {
                mapped = mfc.get(dimNumber);
            }
            if (StringUtils.isEmpty(mapped) && mfd != null) {
                mapped = mfd.get(dimNumber);
            }
            if (mapped == null || defaultValue != null && defaultValue.test(row, dimNumber)) continue;
            Object v = mfd != null && comInfo.isExternal() && dimNumber.equals(SOURCEENTITY) ? dbrow.get(ENTITYSIGNFORDB) : dbrow.get(mapped);
            if (comInfo.isTransDate() && v instanceof Date) {
                row.addValue(DateTimeUtils.convertToOADate((Date)dbrow.getDate(mapped)));
                continue;
            }
            row.addValue(v);
        }
        return row;
    }

    protected Set<String> getAllAddChildrenNumbers(String modelNumber, String dimNumber, String memberNumber) {
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memberNumber);
        List allChildren = memberByNumber.getAllChildren();
        HashSet numbers = Sets.newHashSet();
        for (IDNumberTreeNode idNumberTreeNode : allChildren) {
            if (!AggOprtEnum.ADD.name.equals(idNumberTreeNode.getAggOprt())) continue;
            numbers.add(idNumberTreeNode.getNumber());
        }
        if (AggOprtEnum.ADD.name.equals(memberByNumber.getAggOprt())) {
            numbers.add(memberByNumber.getNumber());
        }
        return numbers;
    }

    public static String getSwitchProcess(String process) {
        if (processByRpt.contains(process)) {
            switch (process) {
                case "ERpt": {
                    return "Rpt";
                }
                case "EIRpt": {
                    return "IRpt";
                }
                case "ERAdj": {
                    return "RAdj";
                }
            }
            return "Rpt";
        }
        return process;
    }

    public static List<String> getExtModelUniqueFields(EdQueryComInfo edQueryComInfo) {
        return (List)GlobalCacheServiceHelper.getOrLoadNode((String)("edqs" + edQueryComInfo.getModelId() + edQueryComInfo.getDatamodel()), () -> {
            QFilter extModelFileter = new QFilter("number", "=", (Object)edQueryComInfo.getDatamodel());
            extModelFileter.and(new QFilter("model", "=", (Object)edQueryComInfo.getModelId()));
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{extModelFileter});
            ExtendsModel extModel = new ExtendsModel(dy.getLong("id"));
            List<FieldEntry> fieldList = extModel.getFieldEntry();
            List uniqueList = fieldList.stream().filter(f -> f.getUniqueCheck()).map(f -> f.getNumber()).collect(Collectors.toList());
            return uniqueList;
        });
    }

    private QFilter getQueryFilter(EdQueryComInfo edQueryComInfo) {
        QFilter lastFilter = new QFilter("modelnumber", "=", (Object)edQueryComInfo.getShowNumber());
        if (edQueryComInfo.isQueryOriData()) {
            QFilter qFilter = new QFilter("modelnumber", "=", (Object)edQueryComInfo.getShowNumber()).and("datamodel", "=", (Object)edQueryComInfo.getDatamodel());
            Map<String, String[]> dimFilter = edQueryComInfo.getDimFilter();
            Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(dimFilter.keySet().toArray(new String[0]));
            ExtDataQueryService.setDimfilter(edQueryComInfo, qFilter, dimFilter, fieldMappedForDims, true);
            ExtDataQueryService.setDimfilter(edQueryComInfo, qFilter, dimFilter, fieldMappedForDims, false);
            if (edQueryComInfo.getCustomFilter() != null) {
                qFilter.and(edQueryComInfo.getCustomFilter());
            }
            return qFilter;
        }
        HashMap pairs = new HashMap();
        HashMap<String, List<Object>> ctxDimMap = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String[]> filter : edQueryComInfo.getDimFilter().entrySet()) {
            if (!changeDim.contains(filter.getKey())) continue;
            List<Object> values = Arrays.asList((Object[])filter.getValue());
            ctxDimMap.put(filter.getKey(), values);
        }
        ((List)ctxDimMap.get(DimTypesEnum.ENTITY.getNumber())).forEach(entity -> {
            ArrayList list = new ArrayList();
            ((List)ctxDimMap.get(DimTypesEnum.PROCESS.getNumber())).forEach(process -> ((List)ctxDimMap.get(DimTypesEnum.AUDITTRIAL.getNumber())).forEach(auditTrail -> list.add(Pair.onePair((Object)process, (Object)auditTrail))));
            pairs.put(entity, list);
        });
        QFilter tempFilter = null;
        HashMap<String, Map<String, Set<String>>> mapping = new HashMap<String, Map<String, Set<String>>>(16);
        for (Map.Entry entry : pairs.entrySet()) {
            String entity2 = (String)entry.getKey();
            IDNumberTreeNode entityNode = ExtDataQueryService.getSourceEntityMember(entity2, edQueryComInfo);
            for (Pair pair : (List)entry.getValue()) {
                String process = ExtDataQueryService.getSwitchProcess((String)pair.p1);
                String aduittrial = (String)pair.p2;
                Map<String, Map<String, Set<String>>> mappingFilter = this.getMappingFilter(entityNode, process, aduittrial, edQueryComInfo);
                for (Map.Entry<String, Map<String, Set<String>>> mapEntry : mappingFilter.entrySet()) {
                    if (mapping.containsKey(mapEntry.getKey())) {
                        Map map = (Map)mapping.get(mapEntry.getKey());
                        for (Map.Entry<String, Set<String>> entry2 : mapEntry.getValue().entrySet()) {
                            Set strings = (Set)map.get(entry2.getKey());
                            if (strings != null) {
                                strings.addAll((Collection)entry2.getValue());
                                continue;
                            }
                            map.put(entry2.getKey(), entry2.getValue());
                        }
                        continue;
                    }
                    mapping.put(mapEntry.getKey(), mapEntry.getValue());
                }
            }
        }
        if (mapping.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        List<Pair<Set<String>, Pair<Set<String>, Set<String>>>> list = this.reorganizeMapping(mapping);
        for (Pair<Set<String>, Pair<Set<String>, Set<String>>> pairPair : list) {
            if (tempFilter == null) {
                tempFilter = this.mappingToFilter((Set)pairPair.p1, (Set)((Pair)pairPair.p2).p1, (Set)((Pair)pairPair.p2).p2, edQueryComInfo);
                continue;
            }
            tempFilter.or(this.mappingToFilter((Set)pairPair.p1, (Set)((Pair)pairPair.p2).p1, (Set)((Pair)pairPair.p2).p2, edQueryComInfo));
        }
        this.addOtherFilter(edQueryComInfo, lastFilter.and(tempFilter));
        return lastFilter;
    }

    private QFilter mappingToFilter(Set<String> org, Set<String> process, Set<String> auditTrail, EdQueryComInfo edQueryComInfo) {
        if (org.isEmpty()) {
            return new QFilter("1", "=", (Object)1);
        }
        QFilter filter = new QFilter("org", "in", org);
        filter.and("process", "in", process).and("audittrail", "in", auditTrail);
        return filter;
    }

    protected void addOtherFilter(EdQueryComInfo edQueryComInfo, QFilter filter) {
        Map<String, String> fieldMappedForCols;
        Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims(edQueryComInfo.getDimFilter().keySet().toArray(new String[0]));
        filter.and("datamodel", "=", (Object)edQueryComInfo.getDatamodel());
        if (edQueryComInfo instanceof QueryCommand) {
            if (fieldMappedForDims.size() != 0) {
                for (Map.Entry<String, String[]> entry : edQueryComInfo.getDimFilter().entrySet()) {
                    String dimNumber = entry.getKey();
                    String[] filterValue2 = entry.getValue();
                    if (!INDEX_DIM.contains(dimNumber)) continue;
                    String mapped = fieldMappedForDims.get(dimNumber);
                    String qcp = ((QueryCommand)edQueryComInfo).getDimQcpMap().get(dimNumber);
                    if (filterValue2 == null) continue;
                    if (filterValue2[0].contains(",")) {
                        filter.and(mapped, qcp, (Object)filterValue2[0].split(","));
                        continue;
                    }
                    filter.and(mapped, qcp, (Object)filterValue2);
                }
            }
        } else {
            String mapped;
            Object[] filterValue3;
            String dimNumber;
            for (Map.Entry<String, String[]> entry : edQueryComInfo.getDimFilter().entrySet()) {
                dimNumber = entry.getKey();
                filterValue3 = entry.getValue();
                if (!INDEX_DIM.contains(dimNumber)) continue;
                mapped = fieldMappedForDims.get(dimNumber);
                if (DimTypesEnum.CURRENCY.getNumber().equals(dimNumber)) {
                    filterValue3 = this.transferCurrency(edQueryComInfo);
                }
                filter.and(mapped, "in", (Object)filterValue3);
            }
            for (Map.Entry<String, String[]> entry : edQueryComInfo.getDimFilter().entrySet()) {
                dimNumber = entry.getKey();
                filterValue3 = entry.getValue();
                if (ctxDim.contains(dimNumber)) continue;
                mapped = fieldMappedForDims.get(dimNumber);
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNumber) || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNumber)) {
                    Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), (Object)edQueryComInfo.getModelId());
                    int memberSize = allNodeFromCache.size();
                    if (memberSize - filterValue3.length < filterValue3.length) {
                        HashSet in_Filter = Sets.newHashSet((Object[])filterValue3);
                        Set numbers = allNodeFromCache.values().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                        numbers.removeAll(in_Filter);
                        filter.and(mapped, "not in", numbers);
                        continue;
                    }
                    filter.and(mapped, "in", (Object)filterValue3);
                    continue;
                }
                filter.and(mapped, "in", (Object)filterValue3);
            }
        }
        if ((fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(edQueryComInfo.getFilter().keySet().toArray(new String[0]))).size() != 0) {
            edQueryComInfo.getFilter().forEach((colNumber, filterValue) -> {
                String mapped = (String)fieldMappedForCols.get(colNumber);
                filter.and(mapped, "in", filterValue);
            });
        }
        if (edQueryComInfo.getCustomFilter() != null) {
            filter.and(edQueryComInfo.getCustomFilter());
        }
    }

    private String[] transferCurrency(EdQueryComInfo edQueryComInfo) {
        String[] curs = edQueryComInfo.getDimFilter().get(DimTypesEnum.CURRENCY.getNumber());
        if (this.considerCurrency(edQueryComInfo)) {
            String[] entities;
            HashSet<String> newCurs = new HashSet<String>(16);
            for (String entity : entities = edQueryComInfo.getDimFilter().get(DimTypesEnum.ENTITY.getNumber())) {
                newCurs.addAll(this.getCurrencyByEntity(edQueryComInfo, entity));
            }
            return newCurs.toArray(new String[0]);
        }
        return curs;
    }

    public Set<String> getCurrencyByEntity(EdQueryComInfo edQueryComInfo, String entity) {
        long mainOrgId = edQueryComInfo.getMainOrgId();
        String parentOrg = edQueryComInfo.getParentOrg();
        Map<String, List<Long>> mulOrgNumMap = edQueryComInfo.getMulOrgNumMap();
        ArrayList<IDNumberTreeNode> entityNodes = new ArrayList<IDNumberTreeNode>(10);
        String[] process = edQueryComInfo.getDimFilter().get(DimTypesEnum.PROCESS.getNumber());
        HashSet<String> newCurs = new HashSet<String>(16);
        String[] curs = edQueryComInfo.getDimFilter().get(DimTypesEnum.CURRENCY.getNumber());
        if (edQueryComInfo.isMultiOrg() && mulOrgNumMap.containsKey(entity)) {
            mulOrgNumMap.get(entity).forEach(id -> entityNodes.add(MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)id)));
        } else if (mainOrgId != 0L) {
            entityNodes.add(MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)mainOrgId));
        } else if (StringUtils.isNotEmpty((CharSequence)parentOrg)) {
            entityNodes.add(MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)(parentOrg + "_" + entity)));
        } else {
            entityNodes.add(MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)entity));
        }
        for (IDNumberTreeNode entityNode : entityNodes) {
            for (String pro : process) {
                for (String cur : curs) {
                    newCurs.add((String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)entityNode, (long)edQueryComInfo.getModelId().longValue(), (String)pro, (String)cur).p2);
                }
            }
        }
        return newCurs;
    }

    protected boolean considerCurrency(EdQueryComInfo edQueryComInfo) {
        HashSet curSet = Sets.newHashSet((Object[])edQueryComInfo.getDimFilter().get(DimTypesEnum.CURRENCY.getNumber()));
        return curSet.contains(CurrencyEnum.DC.getNumber()) || curSet.contains(CurrencyEnum.EC.getNumber()) || curSet.contains(CurrencyEnum.PC.getNumber());
    }

    private List<Pair<Set<String>, Pair<Set<String>, Set<String>>>> reorganizeMapping(Map<String, Map<String, Set<String>>> map) {
        HashMap first = new HashMap(8);
        for (Map.Entry<String, Map<String, Set<String>>> entry : map.entrySet()) {
            LinkedList<Pair> list = new LinkedList<Pair>();
            for (Map.Entry<String, Set<String>> pair : entry.getValue().entrySet()) {
                Set src = null;
                for (Pair tarPair : list) {
                    if (((Set)tarPair.p2).size() != pair.getValue().size() || !((Set)tarPair.p2).containsAll((Collection)pair.getValue())) continue;
                    src = (Set)tarPair.p1;
                    ((Set)tarPair.p1).add(pair.getKey());
                    break;
                }
                if (src != null) continue;
                list.add(Pair.onePair(new HashSet<String>(Collections.singletonList(pair.getKey())), new HashSet(pair.getValue())));
            }
            first.put(entry.getKey(), list);
        }
        ArrayList<Pair<Set<String>, Pair<Set<String>, Set<String>>>> second = new ArrayList<Pair<Set<String>, Pair<Set<String>, Set<String>>>>();
        for (Map.Entry entry : first.entrySet()) {
            List val = (List)entry.getValue();
            for (Pair setSetPair : val) {
                Set src = null;
                for (Pair pair : second) {
                    if (((Set)((Pair)pair.p2).p1).size() != ((Set)setSetPair.p1).size() || !((Set)((Pair)pair.p2).p1).containsAll((Collection)setSetPair.p1) || ((Set)((Pair)pair.p2).p2).size() != ((Set)setSetPair.p2).size() || !((Set)((Pair)pair.p2).p2).containsAll((Collection)setSetPair.p2)) continue;
                    src = (Set)pair.p1;
                    ((Set)pair.p1).add(entry.getKey());
                    break;
                }
                if (src != null) continue;
                second.add((Pair<Set<String>, Pair<Set<String>, Set<String>>>)Pair.onePair(new HashSet(Collections.singletonList(entry.getKey())), (Object)setSetPair));
            }
        }
        return second;
    }

    public Map<String, Map<String, Set<String>>> getMappingFilter(IDNumberTreeNode entityNode, String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        List<IDNumberTreeNode> bpProcessAndSelf;
        Map<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>();
        if (entityNode.isLeaf()) {
            map.put(entityNode.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
        } else if (edQueryComInfo.getGroupObject().getBoolean("isparticipmerge") || edQueryComInfo.isUseForOrgSave()) {
            bpProcessAndSelf = this.getBPProcessAndSelf(MemberReader.findProcessMemberByNum((String)edQueryComInfo.getModelNum(), (String)"CCTotal"));
            if (bpProcessAndSelf.stream().anyMatch(pro -> process.equals(pro.getNumber()))) {
                map = this.getCCTotalMap(entityNode, process, auditTrail, edQueryComInfo);
            } else {
                bpProcessAndSelf = this.getBPProcessAndSelf(MemberReader.findProcessMemberByNum((String)edQueryComInfo.getModelNum(), (String)"CT"));
                if (bpProcessAndSelf.stream().anyMatch(pro -> process.equals(pro.getNumber())) && !"CSTE".equals(process)) {
                    map = this.getCTMap(entityNode, process, auditTrail, edQueryComInfo);
                } else {
                    map.put(entityNode.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
                }
            }
        } else {
            bpProcessAndSelf = this.getBPProcessAndSelf(MemberReader.findProcessMemberByNum((String)edQueryComInfo.getModelNum(), (String)"CT"));
            if (bpProcessAndSelf.stream().anyMatch(pro -> process.equals(pro.getNumber())) && !"CSTE".equals(process)) {
                map = this.getCTDirectMap(entityNode, process, auditTrail, edQueryComInfo);
            } else {
                map.put(entityNode.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
            }
        }
        if (OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            if (edQueryComInfo.getMulOrgNumMap().containsKey(entityNode.getNumber())) {
                List<Long> mems = edQueryComInfo.getMulOrgNumMap().get(entityNode.getNumber());
                for (Long mem : mems) {
                    String entity = MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)mem).getParent_SonNumber();
                    map.put(entity, this.getSimpleMap(process, auditTrail, edQueryComInfo));
                }
            } else {
                map.put(entityNode.getParent_SonNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
            }
        }
        return map;
    }

    private Map<String, Map<String, Set<String>>> getCCTotalMap(IDNumberTreeNode entityNode, String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        LinkedHashMap<String, Map<String, Set<String>>> map = new LinkedHashMap<String, Map<String, Set<String>>>(16);
        if (this.isProcessOnEIRpt(process)) {
            if (this.isAuditTrailOnEntityInput(auditTrail)) {
                map = this.getMergeOrgIrptEntityInput(entityNode, process, auditTrail, edQueryComInfo);
            } else {
                map.put(entityNode.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
            }
        } else {
            map.put(entityNode.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
        }
        return map;
    }

    private Map<String, Map<String, Set<String>>> getCTDirectMap(IDNumberTreeNode entityMem, String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        LinkedHashMap<String, Map<String, Set<String>>> map = new LinkedHashMap<String, Map<String, Set<String>>>(16);
        Set<String> allOrgNums = this.getAllChildMergeOrg(edQueryComInfo, entityMem.getNumber(), entityMem);
        ArrayList<IDNumberTreeNode> children = new ArrayList<IDNumberTreeNode>(entityMem.getChildren());
        children.removeIf(child -> !allOrgNums.contains(child.getNumber()));
        List<String> bps = this.getCommonBps(process);
        switch (process) {
            case "CT": {
                if ("ATTotal".equals(auditTrail)) {
                    for (String bp : bps) {
                        this.getCommonNoMergeModel(entityMem.getNumber(), auditTrail, edQueryComInfo, map, children, bp);
                    }
                } else if ("RptDS".equals(auditTrail)) {
                    for (IDNumberTreeNode child2 : children) {
                        map.putIfAbsent(child2.getNumber(), new HashMap(16));
                        ((Map)map.get(child2.getNumber())).putAll(this.getSimpleMap("IRpt", "ATTotal", edQueryComInfo));
                    }
                } else if ("EntityInput".equals(auditTrail) || "DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                    for (IDNumberTreeNode child3 : children) {
                        map.putIfAbsent(child3.getNumber(), new HashMap(16));
                        ((Map)map.get(child3.getNumber())).putAll(this.getSimpleMap("IRpt", auditTrail, edQueryComInfo));
                    }
                } else {
                    for (String bp : bps) {
                        if ("IRpt".equals(bp)) continue;
                        String tempAT = "ADJE".equals(auditTrail) ? "ATTotal" : auditTrail;
                        this.getCommonNoMergeModel(entityMem.getNumber(), tempAT, edQueryComInfo, map, children, bp);
                    }
                }
                break;
            }
            case "SRPT": {
                if ("ATTotal".equals(auditTrail)) {
                    for (String bp : bps) {
                        this.getCommonNoMergeModel(entityMem.getNumber(), auditTrail, edQueryComInfo, map, children, bp);
                    }
                    break;
                }
                if ("RptDS".equals(auditTrail)) {
                    for (IDNumberTreeNode child4 : children) {
                        map.putIfAbsent(child4.getNumber(), new HashMap(16));
                        ((Map)map.get(child4.getNumber())).putAll(this.getSimpleMap("IRpt", "ATTotal", edQueryComInfo));
                    }
                    break;
                }
                if ("EntityInput".equals(auditTrail) || "DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                    for (IDNumberTreeNode child5 : children) {
                        map.putIfAbsent(child5.getNumber(), new HashMap(16));
                        ((Map)map.get(child5.getNumber())).putAll(this.getSimpleMap("IRpt", auditTrail, edQueryComInfo));
                    }
                    break;
                }
                this.getCommonNoMergeModel(entityMem.getNumber(), auditTrail, edQueryComInfo, map, children, "RAdj");
                break;
            }
            case "ADJT": 
            case "SADJ": 
            case "SCADJ": 
            case "SCCADJ": 
            case "EJET": 
            case "SEJE": {
                if ("RptDS".equals(auditTrail) || "EntityInput".equals(auditTrail) || "DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                    return map;
                }
                for (String bp : bps) {
                    String tempAT = "ATTotal".equals(auditTrail) ? "ADJE" : auditTrail;
                    this.getCommonNoMergeModel(entityMem.getNumber(), tempAT, edQueryComInfo, map, children, bp);
                }
                break;
            }
            case "DEJE": 
            case "DADJ": {
                Map<String, Set<String>> simpleMap = this.getSimpleMap(process, auditTrail, edQueryComInfo);
                for (Set<String> value : simpleMap.values()) {
                    IDNumberTreeNode node = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)SysDimensionEnum.AuditTrail.getNumber(), (String)"RptDS");
                    value.remove(node.getNumber());
                    if (node.isLeaf()) continue;
                    for (IDNumberTreeNode child6 : node.getChildren()) {
                        value.remove(child6.getNumber());
                    }
                }
                map.put(entityMem.getNumber(), simpleMap);
                break;
            }
            default: {
                map.put(entityMem.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
            }
        }
        return map;
    }

    private void getCommonNoMergeModel(String entity, String auditTrail, EdQueryComInfo edQueryComInfo, Map<String, Map<String, Set<String>>> map, List<IDNumberTreeNode> children, String bp) {
        if ("DADJ".equals(bp) || "DEJE".equals(bp)) {
            map.putIfAbsent(entity, new HashMap(16));
            map.get(entity).putAll(this.getSimpleMap(bp, auditTrail, edQueryComInfo));
        } else {
            for (IDNumberTreeNode child : children) {
                String key = child.getNumber();
                if (OrgRelaProcessMembPool.isRelaProcess((String)bp)) {
                    key = entity + "_" + child.getNumber();
                }
                map.putIfAbsent(key, new HashMap(16));
                map.get(key).putAll(this.getSimpleMap(bp, auditTrail, edQueryComInfo));
            }
        }
    }

    private Map<String, Map<String, Set<String>>> getCTMap(IDNumberTreeNode entityMem, String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        LinkedHashMap<String, Map<String, Set<String>>> map = new LinkedHashMap<String, Map<String, Set<String>>>(8);
        Set<String> allOrgNums = this.getAllChildMergeOrg(edQueryComInfo, entityMem.getNumber(), entityMem);
        allOrgNums.remove(entityMem.getNumber());
        allOrgNums.removeIf(org -> org.contains("_") && entityMem.getNumber().equals(org.split("_")[0]));
        HashSet<String> partOrgNums = new HashSet<String>(allOrgNums);
        partOrgNums.removeIf(num -> num.contains("_"));
        List<String> bps = this.getCommonBps(process);
        switch (process) {
            case "CT": {
                if ("ATTotal".equals(auditTrail)) {
                    map.put(entityMem.getNumber(), this.getSimpleMap("DADJ", "ATTotal", edQueryComInfo));
                    ((Map)map.get(entityMem.getNumber())).putAll(this.getSimpleMap("DEJE", "ATTotal", edQueryComInfo));
                    this.getAllChildEirpt(edQueryComInfo, map, partOrgNums, "CCTotal");
                    for (IDNumberTreeNode child : entityMem.getChildren()) {
                        if (!allOrgNums.contains(child.getNumber())) continue;
                        for (String bp : bps) {
                            if (child.isLeaf() && !OrgRelaProcessMembPool.isRelaProcess((String)bp)) continue;
                            String key = OrgRelaProcessMembPool.isRelaProcess((String)bp) ? entityMem.getNumber() + "_" + child.getNumber() : child.getNumber();
                            map.putIfAbsent(key, new HashMap(16));
                            ((Map)map.get(key)).putAll(this.getSimpleMap(bp, auditTrail, edQueryComInfo));
                        }
                    }
                } else {
                    if ("RptDS".equals(auditTrail)) {
                        this.getAllChildEirpt(edQueryComInfo, map, partOrgNums, "IRpt");
                        break;
                    }
                    if ("EntityInput".equals(auditTrail)) {
                        for (String allOrgNum : partOrgNums) {
                            IDNumberTreeNode allOrgNode = MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)allOrgNum);
                            if (!allOrgNode.isLeaf()) {
                                map.putAll(this.getMergeOrgIrptEntityInput(allOrgNode, "Rpt", "ATTotal", edQueryComInfo));
                                continue;
                            }
                            map.put(allOrgNum, this.getSimpleMap("IRpt", "ATTotal", edQueryComInfo));
                        }
                    } else if ("DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                        for (IDNumberTreeNode child : entityMem.getChildren()) {
                            if (!allOrgNums.contains(child.getNumber())) continue;
                            map.put(child.getNumber(), this.getSimpleMap("IRpt", auditTrail, edQueryComInfo));
                        }
                    } else {
                        Set<String> allProcessNumbers = this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.PROCESS.getNumber(), "CCTotal");
                        allProcessNumbers.remove("IRpt");
                        allProcessNumbers.remove("EIRpt");
                        allProcessNumbers.add("DEJE");
                        allProcessNumbers.add("DADJ");
                        Set<String> totalAuditTails = "ADJE".equals(auditTrail) ? this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.AUDITTRIAL.getNumber(), "ADJE") : Collections.singleton(auditTrail);
                        Set<String> mergeOrgs = this.getAllChildMergeOrg(edQueryComInfo, entityMem.getNumber(), entityMem);
                        for (String tempProcess : allProcessNumbers) {
                            for (String allOrgNum : mergeOrgs) {
                                map.putIfAbsent(allOrgNum, new HashMap(16));
                                if (allOrgNum.contains("_") && OrgRelaProcessMembPool.isRelaProcess((String)tempProcess)) {
                                    ((Map)map.get(allOrgNum)).put(tempProcess, totalAuditTails);
                                    continue;
                                }
                                if (allOrgNum.contains("_") || OrgRelaProcessMembPool.isRelaProcess((String)tempProcess)) continue;
                                ((Map)map.get(allOrgNum)).put(tempProcess, totalAuditTails);
                            }
                        }
                    }
                }
                break;
            }
            case "SRPT": {
                if ("ATTotal".equals(auditTrail)) {
                    this.getAllChildEirpt(edQueryComInfo, map, allOrgNums, "ERpt");
                    break;
                }
                if ("RptDS".equals(auditTrail)) {
                    this.getAllChildEirpt(edQueryComInfo, map, allOrgNums, "IRpt");
                    break;
                }
                if ("EntityInput".equals(auditTrail)) {
                    for (String allOrgNum : partOrgNums) {
                        IDNumberTreeNode allOrgNumNode = MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)allOrgNum);
                        if (!allOrgNumNode.isLeaf()) {
                            map.putAll(this.getMergeOrgIrptEntityInput(allOrgNumNode, "Rpt", "ATTotal", edQueryComInfo));
                            continue;
                        }
                        map.put(allOrgNum, this.getSimpleMap("IRpt", "ATTotal", edQueryComInfo));
                    }
                } else if ("DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                    for (IDNumberTreeNode child : entityMem.getChildren()) {
                        if (!allOrgNums.contains(child.getNumber())) continue;
                        map.put(child.getNumber(), this.getSimpleMap("IRpt", auditTrail, edQueryComInfo));
                    }
                } else if ("ADJE".equals(auditTrail)) {
                    for (IDNumberTreeNode child : entityMem.getChildren()) {
                        if (!allOrgNums.contains(child.getNumber())) continue;
                        map.put(child.getNumber(), this.getSimpleMap("RAdj", "ADJE", edQueryComInfo));
                    }
                } else {
                    for (IDNumberTreeNode child : entityMem.getChildren()) {
                        if (!allOrgNums.contains(child.getNumber())) continue;
                        map.put(child.getNumber(), this.getSimpleMap("RAdj", auditTrail, edQueryComInfo));
                    }
                }
                break;
            }
            case "ADJT": 
            case "SADJ": 
            case "SCADJ": 
            case "SCCADJ": 
            case "EJET": 
            case "SEJE": {
                if ("RptDS".equals(auditTrail) || "EntityInput".equals(auditTrail) || "DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail)) {
                    return Collections.emptyMap();
                }
                for (IDNumberTreeNode child : entityMem.getChildren()) {
                    if (!allOrgNums.contains(child.getNumber())) continue;
                    for (String bp : bps) {
                        if (child.isLeaf() && !OrgRelaProcessMembPool.isRelaProcess((String)bp)) continue;
                        String key = OrgRelaProcessMembPool.isRelaProcess((String)bp) ? entityMem.getNumber() + "_" + child.getNumber() : child.getNumber();
                        map.putIfAbsent(key, new HashMap(16));
                        ((Map)map.get(key)).putAll(this.getSimpleMap(bp, auditTrail, edQueryComInfo));
                    }
                }
                if (!"ADJT".equals(process) && !"EJET".equals(process)) break;
                map.put(entityMem.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
                break;
            }
            default: {
                if (("DADJ".equals(process) || "DEJE".equals(process)) && ("RptDS".equals(auditTrail) || "EntityInput".equals(auditTrail) || "DataCollection".equals(auditTrail) || "TraDif".equals(auditTrail))) {
                    return Collections.emptyMap();
                }
                map.put(entityMem.getNumber(), this.getSimpleMap(process, auditTrail, edQueryComInfo));
            }
        }
        return map;
    }

    private void getAllChildEirpt(EdQueryComInfo edQueryComInfo, Map<String, Map<String, Set<String>>> map, Set<String> allOrgNums, String process) {
        for (String allOrgNum : allOrgNums) {
            IDNumberTreeNode allOrgNumNode = MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)allOrgNum);
            if (!allOrgNumNode.isLeaf()) {
                map.putAll(this.getMergeOrgIrptEntityInput(allOrgNumNode, ExtDataQueryService.getSwitchProcess(process), "ATTotal", edQueryComInfo));
                continue;
            }
            map.put(allOrgNum, this.getSimpleMap(ExtDataQueryService.getSwitchProcess(process), "ATTotal", edQueryComInfo));
        }
    }

    private Map<String, Map<String, Set<String>>> getMergeOrgIrptEntityInput(IDNumberTreeNode entityMem, String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        LinkedHashMap<String, Map<String, Set<String>>> map = new LinkedHashMap<String, Map<String, Set<String>>>(8);
        Set<String> totalProcess = this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.PROCESS.getNumber(), "CCTotal");
        Set<String> totalAuditTails = this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.AUDITTRIAL.getNumber(), "ATTotal");
        LinkedHashMap<String, Set<String>> all = new LinkedHashMap<String, Set<String>>(16);
        all.putAll(this.getSimpleMap(process, auditTrail, edQueryComInfo));
        all.putAll(this.getSimpleMap("DADJ", "ATTotal", edQueryComInfo));
        all.putAll(this.getSimpleMap("DEJE", "ATTotal", edQueryComInfo));
        map.put(entityMem.getNumber(), all);
        Set<String> allOrgNums = this.getAllChildMergeOrg(edQueryComInfo, entityMem.getNumber(), entityMem);
        allOrgNums.remove(entityMem.getNumber());
        for (String mergeOrg : allOrgNums) {
            LinkedHashMap<String, Set<String>> tem = new LinkedHashMap<String, Set<String>>();
            for (String processNumber : totalProcess) {
                if (mergeOrg.contains("_") && OrgRelaProcessMembPool.isRelaProcess((String)processNumber) || !mergeOrg.contains("_") && !OrgRelaProcessMembPool.isRelaProcess((String)processNumber)) {
                    tem.put(processNumber, totalAuditTails);
                }
                if (mergeOrg.contains("_") || MemberReader.findEntityMemberByNum((String)edQueryComInfo.getModelNum(), (String)mergeOrg).isLeaf()) continue;
                tem.put("DADJ", totalAuditTails);
                tem.put("DEJE", totalAuditTails);
            }
            map.put(mergeOrg, tem);
        }
        return map;
    }

    public static IDNumberTreeNode getSourceEntityMember(String entity, EdQueryComInfo edQueryComInfo) {
        IDNumberTreeNode tempEntity;
        IDNumberTreeNode entityMem = MemberReader.findMemberByNumber((String)edQueryComInfo.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)entity);
        if (entity.contains("_")) {
            return entityMem;
        }
        if (edQueryComInfo.getMainOrgId() != 0L && entity.equals((tempEntity = MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)edQueryComInfo.getMainOrgId())).getNumber())) {
            entityMem = tempEntity;
        }
        if (edQueryComInfo.getMulOrgNumMap().containsKey(entity)) {
            entityMem = MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)edQueryComInfo.getMulOrgNumMap().get(entity).get(0));
        }
        return entityMem;
    }

    private List<String> getCommonBps(String bp) {
        List<String> bps;
        switch (bp) {
            case "CT": {
                bps = Arrays.asList("IRpt", "RAdj", "ADJ", "CADJ", "CCADJ", "DADJ", "EJE", "DEJE");
                break;
            }
            case "SRPT": {
                bps = Arrays.asList("IRpt", "RAdj");
                break;
            }
            case "ADJT": {
                bps = Arrays.asList("ADJ", "CADJ", "CCADJ", "DADJ");
                break;
            }
            case "SADJ": {
                bps = Collections.singletonList("ADJ");
                break;
            }
            case "SCADJ": {
                bps = Collections.singletonList("CADJ");
                break;
            }
            case "SCCADJ": {
                bps = Collections.singletonList("CCADJ");
                break;
            }
            case "DADJ": {
                bps = Collections.singletonList("DADJ");
                break;
            }
            case "EJET": {
                bps = Arrays.asList("EJE", "DEJE");
                break;
            }
            case "SEJE": {
                bps = Collections.singletonList("EJE");
                break;
            }
            case "DEJE": {
                bps = Collections.singletonList("DEJE");
                break;
            }
            default: {
                bps = Collections.singletonList(bp);
            }
        }
        return bps;
    }

    protected Map<String, Set<String>> getSimpleMap(String process, String auditTrail, EdQueryComInfo edQueryComInfo) {
        Set<String> allAuditTrailNumbers;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        Set<String> allProcessNumbers = this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.PROCESS.getNumber(), process);
        if (allProcessNumbers.isEmpty()) {
            allProcessNumbers.add(process);
        }
        if ((allAuditTrailNumbers = this.getAllAddChildrenNumbers(edQueryComInfo.getModelNum(), DimTypesEnum.AUDITTRIAL.getNumber(), auditTrail)).isEmpty()) {
            allAuditTrailNumbers.add(auditTrail);
        }
        for (String processNumber : allProcessNumbers) {
            map.put(processNumber, allAuditTrailNumbers);
        }
        return map;
    }

    protected List<IDNumberTreeNode> getBPProcessAndSelf(IDNumberTreeNode processMem) {
        ArrayList<IDNumberTreeNode> allChildren = new ArrayList<IDNumberTreeNode>(processMem.getAllChildren());
        allChildren.add(processMem);
        return allChildren;
    }

    protected static DataSet groupAndSum(DataSet ds, Set<String> groupby, List<String> sumfelds) {
        GroupbyDataSet gds = ds.groupBy(groupby.isEmpty() ? null : groupby.toArray(new String[0]));
        if (!sumfelds.isEmpty()) {
            for (String sumfeld : sumfelds) {
                gds = gds.sum(sumfeld, sumfeld);
            }
        }
        ds = gds.finish();
        return ds;
    }

    public Set<Long> getOrgSetForOrder() {
        if (this.orgSetForOrder == null) {
            this.orgSetForOrder = new HashSet<Long>(16);
        }
        return this.orgSetForOrder;
    }

    public void setOrgSetForOrder(Set<Long> orgSetForOrder) {
        this.orgSetForOrder = orgSetForOrder;
    }

    public Set<String> getOrgNumSetForOrder() {
        if (this.orgNumSetForOrder == null) {
            this.orgNumSetForOrder = new HashSet<String>(16);
        }
        return this.orgNumSetForOrder;
    }

    public void setOrgNumSetForOrder(Set<String> orgNumSetForOrder) {
        this.orgNumSetForOrder = orgNumSetForOrder;
    }
}

