/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.StbSaveComInfo;
import kd.fi.bcm.business.extdata.sql.exception.EDSaveException;
import kd.fi.bcm.business.innertrade.report.IntrBizRuleHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.datasource.IOutline;
import org.apache.commons.lang3.StringUtils;

public class ExtDataSaveService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExtDataSaveService.class);
    public static final List<String> processByAdj = Lists.newArrayList((Object[])new String[]{"ADJ", "CADJ", "CCADJ", "EJE"});

    public long[] saveData(EDSaveComInfo saveComInfo) {
        String extendEntity = this.getExtendEntity(saveComInfo);
        List<Object[]> saveComInfoValues = saveComInfo.getValue();
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)saveComInfoValues.size());
        List<DynamicObject> extendDatas = this.prepareSaveData(saveComInfo, extendEntity, ids);
        this.save(extendEntity, extendDatas.toArray(new DynamicObject[0]));
        return ids;
    }

    private void copyMergeOrgCSTE2IRPT(EDSaveComInfo saveComInfo, List<DynamicObject> extendDatas, String extendEntity) {
        Map<String, String> fixDimMems = saveComInfo.getfixedDimension();
        if (!(fixDimMems.containsKey(DimTypesEnum.ENTITY.getNumber()) && fixDimMems.containsKey(DimTypesEnum.SCENARIO.getNumber()) && fixDimMems.containsKey(DimTypesEnum.YEAR.getNumber()) && fixDimMems.containsKey(DimTypesEnum.PERIOD.getNumber()) && fixDimMems.containsKey(DimTypesEnum.CURRENCY.getNumber()) && fixDimMems.containsKey(DimTypesEnum.PROCESS.getNumber()) && fixDimMems.containsKey(DimTypesEnum.AUDITTRIAL.getNumber()))) {
            return;
        }
        IDNumberTreeNode orgNode = MemberReader.findMemberByNumber((String)saveComInfo.getModelNum(), (String)DimTypesEnum.ENTITY.getNumber(), (String)fixDimMems.get(DimTypesEnum.ENTITY.getNumber()));
        IDNumberTreeNode sceneNode = MemberReader.findMemberByNumber((String)saveComInfo.getModelNum(), (String)DimTypesEnum.SCENARIO.getNumber(), (String)fixDimMems.get(DimTypesEnum.SCENARIO.getNumber()));
        IDNumberTreeNode yearNode = MemberReader.findMemberByNumber((String)saveComInfo.getModelNum(), (String)DimTypesEnum.YEAR.getNumber(), (String)fixDimMems.get(DimTypesEnum.YEAR.getNumber()));
        IDNumberTreeNode periodNode = MemberReader.findMemberByNumber((String)saveComInfo.getModelNum(), (String)DimTypesEnum.PERIOD.getNumber(), (String)fixDimMems.get(DimTypesEnum.PERIOD.getNumber()));
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode || IDNumberTreeNode.NotFoundTreeNode == sceneNode || IDNumberTreeNode.NotFoundTreeNode == yearNode || IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            return;
        }
        Map<Long, String> mdsMap = MergeControlHelper.geAllMergeDs(saveComInfo.getModelId(), sceneNode.getId(), yearNode.getId(), periodNode.getId());
        String mdSource = mdsMap.get(orgNode.getId());
        if (!orgNode.isLeaf() && MergeDataSourceEnum.CSTE.getIndex().equals(mdSource) && fixDimMems.get(DimTypesEnum.CURRENCY.getNumber()).equals(orgNode.getCurrency()) && "CSTE".equals(fixDimMems.get(DimTypesEnum.PROCESS.getNumber())) && "EntityInput".equals(fixDimMems.get(DimTypesEnum.AUDITTRIAL.getNumber()))) {
            ArrayList<DynamicObject> copyDys = new ArrayList<DynamicObject>(extendDatas.size());
            for (DynamicObject extendData : extendDatas) {
                DynamicObject newData = (DynamicObject)OrmUtils.clone((IDataEntityBase)extendData, (boolean)true, (boolean)true);
                copyDys.add(newData);
            }
            this.save(extendEntity, copyDys.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> prepareSaveData(EDSaveComInfo saveComInfo, String extendEntity, long[] ids) {
        Map<Long, Object[]> updateValues = saveComInfo.getUpdateValues();
        List<DynamicObject> extendDatas = new ArrayList<DynamicObject>(saveComInfo.getValue().size());
        String ownedOrg = ExtDataSaveService.getOwnedOrg(saveComInfo);
        long userID = RequestContext.getOrCreate().getCurrUserId();
        Date currentTime = TimeServiceHelper.now();
        for (int i = 0; i < saveComInfo.getValue().size(); ++i) {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)extendEntity);
            data.set("id", (Object)ids[i]);
            data.set("sid", (Object)(saveComInfo.getSrcStr() + "_" + ids[i]));
            data.set("modelnumber", (Object)saveComInfo.getShowNumber());
            data.set("extendsgroup", (Object)saveComInfo.getExtGroup());
            data.set("datamodel", (Object)saveComInfo.getDatamodel());
            data.set("org", (Object)ownedOrg);
            data.set("modifierid", (Object)userID);
            data.set("modifydate", (Object)currentTime);
            this.fillDimsData(data, saveComInfo, i);
            this.fillFixedDimensionData(data, saveComInfo);
            boolean isfillColsSuccess = this.fillColsData(data, saveComInfo, i);
            if (!isfillColsSuccess) continue;
            extendDatas.add(data);
        }
        DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])updateValues.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)extendEntity));
        if (dys != null && dys.length > 0) {
            Map<Long, DynamicObject> id2Dys = Arrays.stream(dys).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (Map.Entry<Long, Object[]> rowEntry : updateValues.entrySet()) {
                DynamicObject data = id2Dys.get(rowEntry.getKey());
                if (data == null) continue;
                data.set("modelnumber", (Object)saveComInfo.getShowNumber());
                data.set("extendsgroup", (Object)saveComInfo.getExtGroup());
                data.set("datamodel", (Object)saveComInfo.getDatamodel());
                data.set("org", (Object)ownedOrg);
                if (saveComInfo.isBizRule2InTrade() && data.get("sid") != null) {
                    if (!data.getString("sid").contains(saveComInfo.getSrcStr())) {
                        data.set("sid", (Object)(saveComInfo.getSrcStr() + "_" + data.get("sid")));
                    }
                } else {
                    data.set("sid", (Object)(saveComInfo.getSrcStr() + "_" + rowEntry.getKey()));
                }
                data.set("modifierid", (Object)userID);
                data.set("modifydate", (Object)currentTime);
                if (saveComInfo instanceof StbSaveComInfo) {
                    this.fillFixedDimensionData(data, saveComInfo);
                    String process = saveComInfo.getfixedDimension().get(DimTypesEnum.PROCESS.getNumber());
                    data.set("process", (Object)ExtDataQueryService.getSwitchProcess(process));
                }
                this.fillDimsData(data, saveComInfo, rowEntry.getValue());
                boolean isfillColsSuccess = this.fillColsData(data, saveComInfo, rowEntry.getValue());
                if (!isfillColsSuccess) continue;
                extendDatas.add(data);
            }
            ExtDataSaveService.handleCurrency(saveComInfo, extendDatas.toArray(new DynamicObject[0]));
        }
        if (saveComInfo.isBizRule2InTrade()) {
            extendDatas = IntrBizRuleHelper.processIntrData(extendDatas, saveComInfo.getModelId(), saveComInfo.getfixedDimension(), saveComInfo.getDatamodel(), saveComInfo.getPaperTemplateId());
        }
        return extendDatas;
    }

    public int deleteDataBySaveInfo(EDSaveComInfo saveComInfo) {
        String extendEntity = this.getExtendEntity(saveComInfo);
        String process = saveComInfo.getfixedDimension().get(DimTypesEnum.PROCESS.getNumber());
        String ownedOrg = ExtDataSaveService.getOwnedOrg(saveComInfo);
        QFilter qFilter = new QFilter("modelnumber", "=", (Object)saveComInfo.getShowNumber()).and("datamodel", "=", (Object)saveComInfo.getDatamodel()).and("org", "=", (Object)ownedOrg);
        saveComInfo.getfixedDimension().put(DimTypesEnum.PROCESS.getNumber(), ExtDataQueryService.getSwitchProcess(process));
        saveComInfo.getfixedDimension().forEach((number, value) -> {
            if (!DimTypesEnum.ENTITY.getNumber().equals(number)) {
                qFilter.and(SysDimensionEnum.getEnumByNumber((String)number).getSign(), "=", value);
            }
        });
        return this.delete(extendEntity, new QFilter[]{qFilter});
    }

    public int deleteDataBySaveInfo(Collection<Long> pkIds, EDSaveComInfo saveComInfo) {
        String extendEntity = this.getExtendEntity(saveComInfo);
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return this.delete(extendEntity, new QFilter[]{qFilter});
    }

    private String getExtendEntity(EDSaveComInfo saveComInfo) {
        String extendEntity = ExtendDimGroupType.COMMON.getIndex().equals(saveComInfo.getGrouptype()) ? "bcm_extenddata" : "bcm_extenddata_bus";
        return extendEntity;
    }

    public static String getOwnedOrg(EDSaveComInfo saveComInfo) {
        String process = saveComInfo.getfixedDimension().get(DimTypesEnum.PROCESS.getNumber());
        String org = saveComInfo.getfixedDimension().get(DimTypesEnum.ENTITY.getNumber());
        if ("Entity".equals(org)) {
            throw new EDSaveException("org is can not be Entity!");
        }
        if (saveComInfo.isBizRule2InTrade()) {
            return org;
        }
        if (OrgRelaProcessMembPool.isRelaProcess((String)process) && !org.contains("_")) {
            if (saveComInfo.getParentOrg() != null) {
                return saveComInfo.getParentOrg() + "_" + org;
            }
            String parentOrgBaseNumber = TreeStructureServiceHelper.getParentOrgBaseNumber(saveComInfo.getModelNum(), org);
            return parentOrgBaseNumber + "_" + org;
        }
        return org;
    }

    private void fillFixedDimensionData(DynamicObject data, EDSaveComInfo saveComInfo) {
        saveComInfo.getfixedDimension().forEach((number, value) -> {
            String sign = SysDimensionEnum.getEnumByNumber((String)number).getSign();
            if (SysDimensionEnum.Process == SysDimensionEnum.getEnumByNumber((String)number)) {
                data.set(sign, (Object)ExtDataQueryService.getSwitchProcess(value));
            } else if (!DimTypesEnum.ENTITY.getNumber().equals(number) || !saveComInfo.isKeepEntity()) {
                data.set(sign, value);
            }
        });
    }

    private void fillDimsData(DynamicObject data, EDSaveComInfo saveComInfo, int valueIndex) {
        Object[] values = saveComInfo.getValue().get(valueIndex);
        this.fillDimsData(data, saveComInfo, values);
    }

    private void fillDimsData(DynamicObject data, EDSaveComInfo saveComInfo, Object[] values) {
        if (saveComInfo.getDims() != null && saveComInfo.getDims().length != 0) {
            Map<String, String> fieldMapped = saveComInfo.getFieldMappedForDims(saveComInfo.getDims());
            int i = saveComInfo.getCols().length;
            if (i >= values.length) {
                return;
            }
            for (Map.Entry<String, String> entity : fieldMapped.entrySet()) {
                data.set(entity.getValue(), values[i++]);
            }
        }
    }

    private boolean fillColsData(DynamicObject data, EDSaveComInfo saveComInfo, int valueIndex) {
        Object[] values = saveComInfo.getValue().get(valueIndex);
        boolean fillSuccess = this.fillColsData(data, saveComInfo, values);
        return fillSuccess;
    }

    private boolean fillColsData(DynamicObject data, EDSaveComInfo saveComInfo, Object[] values) {
        boolean fillSuccess = Boolean.FALSE;
        if (saveComInfo.getCols() != null && saveComInfo.getCols().length != 0) {
            Map<String, String> fieldMapped = saveComInfo.getFieldMappedForCols(saveComInfo.getCols());
            int i = 0;
            for (Map.Entry<String, String> entity : fieldMapped.entrySet()) {
                Object value = values[i++];
                if (entity.getValue().contains("dateext") && value instanceof Integer) {
                    value = null;
                }
                if (value != null && StringUtils.isNotEmpty((CharSequence)value.toString())) {
                    fillSuccess = Boolean.TRUE;
                }
                data.set(entity.getValue(), value);
            }
        }
        return fillSuccess;
    }

    private void save(String extendEntity, DynamicObject[] extendDatas) {
        try (TXHandle th = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)extendEntity).getDynamicObjectType(), (Object[])extendDatas);
            }
            catch (Exception e) {
                th.markRollback();
                String message = "Extend Data Save Error.";
                logger.error(message, (Throwable)e);
                throw new EDSaveException(new ErrorCode("", String.join((CharSequence)"\n", ThrowableHelper.generatekernelMessage((Throwable)e, (int)2))), new Object[0]);
            }
        }
    }

    public static void handleCurrency(EDSaveComInfo saveComInfo, DynamicObject[] extendDatas) {
        if (extendDatas == null || extendDatas.length == 0) {
            return;
        }
        Map<String, DynamicObject> dataAndTypes = ExtDimensionHelper.getExtMemberByNumbers(saveComInfo.getModelId(), saveComInfo.getExtGroup(), Arrays.asList(saveComInfo.getCols()));
        Set<String> cols = dataAndTypes.values().stream().filter(s -> DataTypeEnum.CURRENCY.getOIndex().equals(s.getString("datatype")) || DataTypeEnum.DEFAULT.getOIndex().equals(s.getString("datatype"))).map(v -> v.getString("number")).collect(Collectors.toSet());
        Map<String, String> mappedCols = saveComInfo.getFieldMappedForCols(cols.toArray(new String[0]));
        String modelNum = saveComInfo.getModelNum();
        ConvertUtil.handleCurrency(modelNum, extendDatas, Sets.newHashSet(mappedCols.values()));
    }

    private int delete(String extendEntity, QFilter[] qFilters) {
        Throwable throwable = null;
        try (TXHandle th = TX.requiresNew();){
            int n = BusinessDataWriter.delete((String)extendEntity, (QFilter[])qFilters);
            return n;
        }
        catch (Exception e) {
            try {
                th.markRollback();
                String message = "Extend Data Delete Error.";
                logger.error(message, (Throwable)e);
                throw new EDSaveException(new ErrorCode("", "Extend Data Delete Error."), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void overwrite(IOutline outline, Pair<List<Long>, SaveCommand> delParms, SaveCommand saveCommand) {
        String extendEntity = this.getExtendEntity(saveCommand);
        QFilter qFilter = new QFilter("id", "in", delParms.p1);
        Map<Long, Object[]> updateValues = saveCommand.getUpdateValues();
        for (Map.Entry<Long, Object[]> entry : updateValues.entrySet()) {
            if (!((List)delParms.p1).contains(entry.getKey())) continue;
            saveCommand.getValue().add(entry.getValue());
        }
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)saveCommand.getValue().size());
        List<DynamicObject> extendDatas = this.prepareSaveData(saveCommand, extendEntity, ids);
        try (TXHandle th = TX.requiresNew();){
            try {
                BusinessDataWriter.delete((String)extendEntity, (QFilter[])qFilter.toArray());
                BusinessDataWriter.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)extendEntity).getDynamicObjectType(), (Object[])extendDatas.toArray());
            }
            catch (Exception e) {
                th.markRollback();
                String message = "Extend Data delAndSave Error.";
                logger.error(message, (Throwable)e);
                throw new EDSaveException(new ErrorCode("", "Extend Data delAndSave Error."), new Object[0]);
            }
        }
    }
}

