/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.extendscript.SaveCommand;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.extdata.ConvertExtParam;
import kd.fi.bcm.business.extdata.ExtDataCheckHelper;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.ExtDataSaveService;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.datasource.IOutline;

public class ExtDataServiceHelper {
    public static DataSet queryDataset(EdQueryComInfo edCommandInfo) {
        ExtDataQueryService extDataQueryService = new ExtDataQueryService();
        return extDataQueryService.queryDataset(edCommandInfo);
    }

    public static EDResultSet fillRows(List<Row> dynamicObjects, EdQueryComInfo edCommandInfo) {
        EDResultSet re = new EDResultSet();
        re.populate(dynamicObjects, edCommandInfo);
        return re;
    }

    public static EDResultSet queryData(EdQueryComInfo edCommandInfo) {
        EDResultSet re = new EDResultSet();
        re.populate(edCommandInfo);
        return re;
    }

    public static long[] saveData(EDSaveComInfo saveComInfo) {
        if (!ExtDataServiceHelper.checkDataLocked(saveComInfo)) {
            ExtDataSaveService extDataSaveService = new ExtDataSaveService();
            ExtDataCheckHelper.uniquecheck(saveComInfo);
            return extDataSaveService.saveData(saveComInfo);
        }
        return new long[0];
    }

    public static Map<String, Map<String, Set<String>>> getQueryMappingFilter(EdQueryComInfo edQueryComInfo) {
        ExtDataQueryService extDataSaveService = new ExtDataQueryService();
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)edQueryComInfo.getModelId(), (Long)edQueryComInfo.getMainOrgId());
        return extDataSaveService.getMappingFilter(entityNode, edQueryComInfo.getDimFilter().get(DimTypesEnum.PROCESS.getNumber())[0], edQueryComInfo.getDimFilter().get(DimTypesEnum.AUDITTRIAL.getNumber())[0], edQueryComInfo);
    }

    public static int deleteDataBySaveInfo(EDSaveComInfo saveComInfo) {
        if (!ExtDataServiceHelper.checkDataLocked(saveComInfo)) {
            ExtDataSaveService extDataSaveService = new ExtDataSaveService();
            return extDataSaveService.deleteDataBySaveInfo(saveComInfo);
        }
        return 0;
    }

    public static int deleteDataBySaveInfo(Collection<Long> pkIds, EDSaveComInfo saveComInfo) {
        if (!ExtDataServiceHelper.checkDataLocked(saveComInfo)) {
            ExtDataSaveService extDataSaveService = new ExtDataSaveService();
            return extDataSaveService.deleteDataBySaveInfo(pkIds, saveComInfo);
        }
        return 0;
    }

    public static Boolean isExtModelExistData(String modelNum, List<String> extModelNums) {
        QFBuilder qb = new QFBuilder("modelnumber", "=", (Object)modelNum).add("datamodel", "in", extModelNums);
        return QueryServiceHelper.exists((String)"bcm_extenddata", (QFilter[])qb.toArray()) || QueryServiceHelper.exists((String)"bcm_extenddata_bus", (QFilter[])qb.toArray());
    }

    public static Boolean isExtModelUsed(long modelid, List<Long> extModelIds) {
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelid).add("extmodel", "in", extModelIds);
        QFBuilder qf = new QFBuilder("extdimid", "in", extModelIds);
        qf.or("seller", "in", extModelIds);
        qf.or("purchaser", "in", extModelIds);
        qf.or("mergenode", "in", extModelIds);
        return QueryServiceHelper.exists((String)"bcm_extmodelref", (QFilter[])qb.toArray()) || QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])qf.toArray());
    }

    public static Boolean isExistDataOfExtMem(String modelNum, List<Long> extFieldMemIds) {
        QFilter qb = new QFilter("extfield", "in", extFieldMemIds);
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extmodelid", (QFilter[])new QFilter[]{qb});
        List fieldmapped = dynamicObject.stream().map(x -> x.getLong("extmodelid")).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", fieldmapped);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"number", (QFilter[])new QFilter[]{qf});
        List<String> number = dys.stream().map(x -> x.getString("number")).collect(Collectors.toList());
        return ExtDataServiceHelper.isExtModelExistData(modelNum, number);
    }

    public static Boolean isExistDataOfExtMemSpecific(String modelNumber, String extendsModelNumber, List<Long> extFieldMemIds, String grouptype) {
        QFBuilder qb = new QFBuilder("id", "in", extFieldMemIds);
        DynamicObjectCollection extFields = QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped,grouptype", (QFilter[])qb.toArray());
        QFilter mQf = new QFilter("modelnumber", "=", (Object)modelNumber);
        QFilter nQf = new QFilter("datamodel", "=", (Object)extendsModelNumber);
        for (DynamicObject extField : extFields) {
            String fieldmapped = extField.getString("fieldmapped");
            QFilter qFilter = null;
            if (fieldmapped.startsWith("textext")) {
                qFilter = new QFilter(fieldmapped, "!=", (Object)"");
            } else if (fieldmapped.startsWith("numext")) {
                qFilter = new QFilter(fieldmapped, "!=", (Object)0);
            } else if (fieldmapped.startsWith("dateext")) {
                qFilter = new QFilter(fieldmapped, "is not null", null);
            }
            if (!("1".equals(grouptype) ? QueryServiceHelper.exists((String)"bcm_extenddata", (QFilter[])new QFilter[]{mQf, nQf, qFilter}) : QueryServiceHelper.exists((String)"bcm_extenddata_bus", (QFilter[])new QFilter[]{mQf, nQf, qFilter}))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistDataOfDimMemSpecific(String modelNumber, String extendsModelNumber, List<String> oriDimFieldNums, String grouptype) {
        QFilter mQf = new QFilter("modelnumber", "=", (Object)modelNumber);
        QFilter nQf = new QFilter("datamodel", "=", (Object)extendsModelNumber);
        for (String oriDimFieldNum : oriDimFieldNums) {
            QFilter qFilter;
            if ("bcm_userdefinedmembertree".equals(DimEntityNumEnum.getEntieyNumByNumber((String)oriDimFieldNum))) {
                QFilter modelQf = new QFilter("model", "=", (Object)MemberReader.findModelIdByShowNum((String)modelNumber));
                QFilter numberQf = new QFilter("number", "=", (Object)oriDimFieldNum);
                DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"fieldmapped", (QFilter[])new QFilter[]{modelQf, numberQf});
                qFilter = new QFilter(dim.getString("fieldmapped"), "!=", (Object)"");
            } else {
                qFilter = new QFilter(oriDimFieldNum.toLowerCase(), "!=", (Object)"");
            }
            if (!("1".equals(grouptype) ? QueryServiceHelper.exists((String)"bcm_extenddata", (QFilter[])new QFilter[]{mQf, nQf, qFilter}) : QueryServiceHelper.exists((String)"bcm_extenddata_bus", (QFilter[])new QFilter[]{mQf, nQf, qFilter}))) continue;
            return true;
        }
        return false;
    }

    public static Boolean isExistReportQuoteOfExtMem(Long modelId, List<Long> extFieldMemIds) {
        QFilter qb = new QFilter("extfield", "in", extFieldMemIds);
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extmodelid", (QFilter[])new QFilter[]{qb});
        if (dynamicObject != null && dynamicObject.size() > 0) {
            List<Long> extmodelid = dynamicObject.stream().map(x -> x.getLong("extmodelid")).collect(Collectors.toList());
            return ExtDataServiceHelper.isExtModelUsed(modelId, extmodelid);
        }
        return false;
    }

    public static Map<String, Map<String, BigDecimal>> getmemberRateMap(ConvertExtParam param) {
        HashMap<String, String> orgCurrencyMap = param.getOrgCurrencyMap();
        HashMap<String, Map<String, BigDecimal>> orgMemberRateMap = new HashMap<String, Map<String, BigDecimal>>(orgCurrencyMap.size());
        StringBuilder errorMsg = new StringBuilder();
        BaseData baseData = new BaseData((Long)param.getModel().p1, param.getScene(), param.getFy(), param.getPeriod());
        for (Map.Entry<String, String> org : orgCurrencyMap.entrySet()) {
            String originCurrency = org.getValue();
            String orgNumber = org.getKey();
            try {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)param.getModel().p1), (String)orgNumber);
                if (IDNumberTreeNode.NotFoundTreeNode != orgNode) {
                    RateModel rate = ExchangeQueryHelper.getRateData(baseData, SimpleVo.newOne(orgNode), originCurrency, param.getTargetCurrency());
                    Map<String, String> numericcols = param.getNumericcols();
                    HashMap<String, BigDecimal> memberRateMap = new HashMap<String, BigDecimal>(numericcols.size());
                    HashSet ratestr = Sets.newHashSet((Object[])new String[]{"1", "2"});
                    for (Map.Entry<String, String> member : numericcols.entrySet()) {
                        if (StringUtils.isEmpty((String)member.getValue()) || !ratestr.contains(member.getValue())) continue;
                        switch (member.getValue()) {
                            case "1": {
                                BigDecimal periodendRate = rate.getPeriodendRate();
                                BigDecimal myrate = BigDecimal.ZERO.compareTo(periodendRate) == 0 ? periodendRate : (rate.isMultiply() ? periodendRate : BigDecimal.ONE.divide(periodendRate, 15, 4));
                                memberRateMap.put(member.getKey(), myrate);
                                break;
                            }
                            case "2": {
                                BigDecimal averageRate = rate.getAverageRate();
                                BigDecimal myrate = BigDecimal.ZERO.compareTo(averageRate) == 0 ? averageRate : (rate.isMultiply() ? averageRate : BigDecimal.ONE.divide(averageRate, 15, 4));
                                memberRateMap.put(member.getKey(), myrate);
                                break;
                            }
                        }
                    }
                    orgMemberRateMap.put(org.getKey(), memberRateMap);
                }
            }
            catch (Exception e) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u62d3\u5c55\u7ef4\u6298\u7b97\uff1a %2$s \n", (String)"ExtDataServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), orgNumber, e.getMessage()));
            }
            if (!StringUtils.isNotEmpty((String)errorMsg.toString())) continue;
            throw new KDBizException(errorMsg.toString());
        }
        return orgMemberRateMap;
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal val;
        block7: {
            val = null;
            if (value != null) {
                try {
                    if (value instanceof BigDecimal) {
                        val = (BigDecimal)value;
                        break block7;
                    }
                    if (value instanceof String) {
                        val = new BigDecimal((String)value);
                        break block7;
                    }
                    if (value instanceof BigInteger) {
                        val = new BigDecimal(String.valueOf(value));
                        break block7;
                    }
                    if (value instanceof Number) {
                        val = new BigDecimal(String.valueOf(value));
                        break block7;
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return val;
    }

    public static List<String> getSQLFieldArray(String prefix, int num) {
        ArrayList<String> res = new ArrayList<String>(32);
        if (num == 0) {
            return new ArrayList<String>();
        }
        for (int i = 1; i <= num; ++i) {
            res.add(prefix + "" + i);
        }
        return res;
    }

    public static Boolean isExistModelOfExtGroup(Long extGroupId) {
        QFilter qf = new QFilter("extendsgroup", "in", (Object)extGroupId);
        if (QueryServiceHelper.exists((String)"bcm_extendsmodel", (QFilter[])new QFilter[]{qf})) {
            return true;
        }
        return false;
    }

    public static boolean isExistQuoteOfExtModel(List<Long> extFieldMemIds) {
        QFilter qb = new QFilter("extfield", "in", extFieldMemIds);
        return QueryServiceHelper.exists((String)"bcm_extmodelfield", (QFilter[])new QFilter[]{qb});
    }

    public static boolean isExistDataOfExt(String modelNumber, List<Long> extFieldMemIds, DynamicObject group) {
        QFBuilder qb = new QFBuilder("id", "in", extFieldMemIds);
        DynamicObjectCollection extFields = QueryServiceHelper.query((String)"bcm_structofextend", (String)"fieldmapped,grouptype", (QFilter[])qb.toArray());
        QFilter mQf = new QFilter("modelnumber", "=", (Object)modelNumber);
        QFilter nQf = new QFilter("extendsgroup", "=", (Object)group.getString("number"));
        for (DynamicObject extField : extFields) {
            String fieldmapped = extField.getString("fieldmapped");
            QFilter qFilter = null;
            qFilter = fieldmapped.startsWith("textext") ? new QFilter(fieldmapped, "!=", (Object)"") : (fieldmapped.startsWith("numext") ? new QFilter(fieldmapped, "!=", (Object)0) : (fieldmapped.startsWith("dateext") ? new QFilter(fieldmapped, "is not null", null) : new QFilter("1", "=", (Object)2)));
            if (!("1".equals(group.getString("grouptype")) ? QueryServiceHelper.exists((String)"bcm_extenddata", (QFilter[])new QFilter[]{mQf, nQf, qFilter}) : "2".equals(group.getString("grouptype")) && QueryServiceHelper.exists((String)"bcm_extenddata_bus", (QFilter[])new QFilter[]{mQf, nQf, qFilter}))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistDataOfInvestExtMem(String modelNumber, String extModelNumber, List<String> extFieldNums) {
        QFilter qf = new QFilter("modelnumber", "=", (Object)modelNumber);
        if (StringUtils.isNotEmpty((String)extModelNumber)) {
            qf.and("datamodel", "=", (Object)extModelNumber);
        }
        qf.and("account", "in", extFieldNums);
        return QueryServiceHelper.exists((String)"bcm_extenddata_inv", (QFilter[])qf.toArray());
    }

    public static boolean isExistDataOfInvestExtModel(String modelNumber, List<String> extModelNumbers) {
        if (extModelNumbers == null || extModelNumbers.size() == 0) {
            return false;
        }
        QFilter qf = new QFilter("modelnumber", "=", (Object)modelNumber);
        qf.and("datamodel", "in", extModelNumbers);
        return QueryServiceHelper.exists((String)"bcm_extenddata_inv", (QFilter[])qf.toArray());
    }

    public static DynamicObject[] queryDataOfMem(String modelNumber, String fieldmapped, DynamicObject group, String newFieldMapped) {
        QFilter mQf = new QFilter("modelnumber", "=", (Object)modelNumber);
        QFilter nQf = new QFilter("extendsgroup", "=", (Object)group.getString("number"));
        QFilter qFilter = null;
        if (fieldmapped.startsWith("textext")) {
            qFilter = new QFilter(fieldmapped, "!=", (Object)"");
        } else if (fieldmapped.startsWith("numext")) {
            qFilter = new QFilter(fieldmapped, "!=", (Object)0);
        } else if (fieldmapped.startsWith("dateext")) {
            qFilter = new QFilter(fieldmapped, "is not null", null);
        }
        String selected = "id," + fieldmapped + "," + newFieldMapped;
        if ("1".equals(group.getString("grouptype"))) {
            return BusinessDataServiceHelper.load((String)"bcm_extenddata", (String)selected, (QFilter[])new QFilter[]{mQf, nQf, qFilter});
        }
        return BusinessDataServiceHelper.load((String)"bcm_extenddata_bus", (String)selected, (QFilter[])new QFilter[]{mQf, nQf, qFilter});
    }

    public static void overwrite(IOutline outline, Pair<List<Long>, SaveCommand> delParms, SaveCommand saveCommand) {
        if (!ExtDataServiceHelper.checkDataLocked(saveCommand)) {
            ExtDataSaveService extDataSaveService = new ExtDataSaveService();
            extDataSaveService.overwrite(outline, delParms, saveCommand);
        }
    }

    public static boolean checkDataLocked(EDSaveComInfo edSaveComInfo) {
        String modelNum = edSaveComInfo.getModelNum();
        Long extModelId = (Long)ThreadCache.get((Object)(modelNum + "|" + edSaveComInfo.getDatamodel() + "|checkDataLocked"), () -> {
            QFBuilder qfBuilder = new QFBuilder("model.id", "=", (Object)edSaveComInfo.getModelId());
            qfBuilder.add("number", "=", (Object)edSaveComInfo.getDatamodel());
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id", (QFilter[])qfBuilder.toArray());
            return objs.isEmpty() ? 0L : ((DynamicObject)objs.get(0)).getLong("id");
        });
        if (extModelId == 0L) {
            return false;
        }
        if (edSaveComInfo.isBizRule2InTrade() && edSaveComInfo.getPaperTemplateId() == null) {
            return false;
        }
        Map<String, String> dimFilter = edSaveComInfo.getfixedDimension();
        String entityNum = dimFilter.get(DimTypesEnum.ENTITY.getNumber());
        String scenarioNum = dimFilter.get(DimTypesEnum.SCENARIO.getNumber());
        String yearNum = dimFilter.get(DimTypesEnum.YEAR.getNumber());
        String periodNum = dimFilter.get(DimTypesEnum.PERIOD.getNumber());
        String currencyNum = dimFilter.get(DimTypesEnum.CURRENCY.getNumber());
        String processNum = dimFilter.get(DimTypesEnum.PROCESS.getNumber());
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)scenarioNum) || StringUtils.isEmpty((String)yearNum) || StringUtils.isEmpty((String)periodNum) || StringUtils.isEmpty((String)currencyNum) || StringUtils.isEmpty((String)processNum)) {
            return false;
        }
        IDNumberTreeNode entityNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)entityNum);
        if (OrgRelaProcessMembPool.isRelaProcess((String)processNum)) {
            entityNode = entityNode.getParent();
        }
        IDNumberTreeNode scenarioNode = MemberReader.findScenaMemberByNum((String)modelNum, (String)scenarioNum);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum);
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)currencyNum);
        return ExtDataLockServiceHelper.isLocked((long)edSaveComInfo.getModelId(), (long)extModelId, entityNode.getId(), scenarioNode.getId(), yearNode.getId(), periodNode.getId(), currencyNode.getId());
    }
}

