/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class ExtDataUtil {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ExtDataUtil.class);
    public static final List<String> fixDims = new ArrayList<String>(10);
    public static final List<String> exceptDims;

    public static Map<String, String> getAllDisableEXTModel(long modelid) {
        HashMap<String, String> num2Names = new HashMap<String, String>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelid);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"number,name,enable", (QFilter[])qfBuilder.toArray());
        for (DynamicObject extModel : doc) {
            if (extModel.getBoolean("enable")) continue;
            num2Names.put(extModel.getString("number"), extModel.getString("name"));
        }
        return num2Names;
    }

    public static List<String> getExtInMergeGroups(long modelid) {
        ArrayList<String> extInMergeGroups = new ArrayList<String>(16);
        QFilter modelQF = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,isparticipmerge", (QFilter[])new QFilter[]{modelQF});
        for (DynamicObject extModel : doc) {
            if (!extModel.getBoolean("isparticipmerge")) continue;
            extInMergeGroups.add(extModel.getString("number"));
        }
        return extInMergeGroups;
    }

    public static Map<Long, ExtendsModel> initExtendsModels(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, ExtendsModel>();
        }
        HashMap<Long, ExtendsModel> map = new HashMap<Long, ExtendsModel>(ids.size());
        DynamicObject[] extendsmodels = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_extendsmodel"));
        DynamicObject[] extmodelfield = BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "in", ids)}, (String)"sequence,extfield.number");
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "in", ids)}, (String)"sequence");
        Map<Long, List<DynamicObject>> groupFields = Arrays.stream(extmodelfield).collect(Collectors.groupingBy(s -> s.getLong("extmodelid")));
        Map<Long, List<DynamicObject>> groupDims = Arrays.stream(extmodeldim).collect(Collectors.groupingBy(s -> s.getLong("extmodelid")));
        for (DynamicObject extendsmodel : extendsmodels) {
            ExtendsModel extendsModel = new ExtendsModel();
            Long extModelId = extendsmodel.getLong("id");
            extendsModel.initData(extendsmodel, (List<DynamicObject>)(groupFields.get(extModelId) == null ? Lists.newArrayList() : groupFields.get(extModelId)), (List<DynamicObject>)(groupDims.get(extModelId) == null ? Lists.newArrayList() : groupDims.get(extModelId)));
            map.put(extModelId, extendsModel);
        }
        return map;
    }

    public static MultiF7Results getMultiF7Value(DynamicObject dy, long modelId) {
        MultiF7Results results = new MultiF7Results();
        if (dy == null) {
            return results;
        }
        DynamicObjectCollection entryDys = dy.getDynamicObjectCollection("entryentityasso");
        if (entryDys.size() == 0) {
            return results;
        }
        ExtDataUtil.combMultiF7ByEntrys(entryDys, modelId, results);
        return results;
    }

    public static Map<Long, MultiF7Results> getMultiF7ValueByExtMemIds(List<Long> extMemberIds, long modelId) {
        HashMap<Long, MultiF7Results> results = new HashMap<Long, MultiF7Results>(16);
        if (CollectionUtils.isEmpty(extMemberIds) || modelId == 0L) {
            LOG.error(String.format("param is error, extMember: %s; modelId\uff1a%s", extMemberIds, modelId));
            return results;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofextend");
        DynamicObject[] extMemDys = BusinessDataServiceHelper.load((Object[])extMemberIds.toArray(), (DynamicObjectType)dynamicObject.getDynamicObjectType());
        if (extMemDys.length == 0) {
            return results;
        }
        for (DynamicObject extMemDy : extMemDys) {
            MultiF7Results multiF7Results = new MultiF7Results();
            DynamicObjectCollection entryDys = extMemDy.getDynamicObjectCollection("entryentityasso");
            if (CollectionUtils.isEmpty((Collection)entryDys)) continue;
            ExtDataUtil.combMultiF7ByEntrys(entryDys, modelId, multiF7Results);
            multiF7Results.setDimDy(((DynamicObject)entryDys.get(0)).getDynamicObject("assodim"));
            results.put(extMemDy.getLong("id"), multiF7Results);
        }
        return results;
    }

    public static Map<String, MultiF7Results> getMultiF7ValueByExtMems(List<String> extMembers, long modelId) {
        HashMap<String, MultiF7Results> results = new HashMap<String, MultiF7Results>(16);
        if (CollectionUtils.isEmpty(extMembers) || modelId == 0L) {
            LOG.error(String.format("param is error, extMember: %s; modelId\uff1a%s", extMembers, modelId));
            return results;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("number", "in", extMembers);
        DynamicObject[] extMemDys = BusinessDataServiceHelper.load((String)"bcm_structofextend", (String)"number, entryentityasso, entryentityasso.assodim, entryentityasso.assomem, entryentityasso.dproperty, entryentityasso.scope, entryentityasso.subtype", (QFilter[])qf.toArray());
        if (extMemDys.length == 0) {
            return results;
        }
        for (DynamicObject extMemDy : extMemDys) {
            MultiF7Results multiF7Results = new MultiF7Results();
            DynamicObjectCollection entryDys = extMemDy.getDynamicObjectCollection("entryentityasso");
            if (CollectionUtils.isEmpty((Collection)entryDys)) continue;
            ExtDataUtil.combMultiF7ByEntrys(entryDys, modelId, multiF7Results);
            multiF7Results.setDimDy(((DynamicObject)entryDys.get(0)).getDynamicObject("assodim"));
            results.put(extMemDy.getString("number"), multiF7Results);
        }
        return results;
    }

    public static MultiF7Results getMultiF7ValueByExtMem(String extMember, long modelId) {
        MultiF7Results results = new MultiF7Results();
        if (extMember == null || modelId == 0L) {
            LOG.error(String.format("param is error, extMember: %s; modelId\uff1a%s", extMember, modelId));
            return results;
        }
        IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)extMember);
        if (memberByNumber == IDNumberTreeNode.NotFoundTreeNode) {
            LOG.error("the member was not found");
            return results;
        }
        DynamicObject extMemDy = BusinessDataServiceHelper.loadSingle((Object)memberByNumber.getId(), (String)"bcm_structofextend");
        DynamicObjectCollection entryDys = extMemDy.getDynamicObjectCollection("entryentityasso");
        if (CollectionUtils.isEmpty((Collection)entryDys)) {
            return results;
        }
        ExtDataUtil.combMultiF7ByEntrys(entryDys, modelId, results);
        results.setDimDy(((DynamicObject)entryDys.get(0)).getDynamicObject("assodim"));
        return results;
    }

    public static void combMultiF7ByEntrys(DynamicObjectCollection entryDys, long modelId, MultiF7Results results) {
        QFilter qf;
        String entityName = ((DynamicObject)entryDys.get(0)).getDynamicObject("assodim").getString("membermodel");
        Map<String, List<DynamicObject>> type2Mems = entryDys.stream().collect(Collectors.groupingBy(x -> x.getString("subtype")));
        List<DynamicObject> memDys = type2Mems.get("0");
        List<DynamicObject> dproDys = type2Mems.get("1");
        HashMap id2Dy = new HashMap(16);
        if (CollectionUtils.isNotEmpty(memDys)) {
            Set assomem = memDys.stream().map(x -> x.getLong("assomem")).collect(Collectors.toSet());
            qf = new QFilter("model", "=", (Object)modelId);
            qf.and("id", "in", assomem);
            DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)"id, name, number", (QFilter[])qf.toArray());
            members.forEach(ele -> id2Dy.put(ele.getLong("id"), ele));
        }
        if (CollectionUtils.isNotEmpty(dproDys)) {
            Set assodproId = dproDys.stream().map(x -> x.getLong("assomem")).collect(Collectors.toSet());
            qf = new QFilter("model", "=", (Object)modelId);
            qf.and("id", "in", assodproId);
            DynamicObjectCollection proDys = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id, name, number", (QFilter[])qf.toArray());
            proDys.forEach(ele -> id2Dy.put(ele.getLong("id"), ele));
        }
        List<MultiF7Result> list = results.getList();
        for (DynamicObject entryDy : entryDys) {
            MultiF7Result multiF7 = new MultiF7Result();
            String subtype = entryDy.getString("subtype");
            long assomemId = entryDy.getLong("assomem");
            multiF7.setId(assomemId);
            multiF7.setScope(entryDy.getInt("scope"));
            String name = ((DynamicObject)id2Dy.get(assomemId)).getString("name");
            String number = ((DynamicObject)id2Dy.get(assomemId)).getString("number");
            if ("1".equals(subtype)) {
                multiF7.setPid(entryDy.getDynamicObject("dproperty").getLong("id"));
                multiF7.setName(entryDy.getDynamicObject("dproperty").getString("name") + ":" + name);
                multiF7.setNumber(entryDy.getDynamicObject("dproperty").getString("number") + ":" + number);
            } else {
                multiF7.setName(name);
                multiF7.setNumber(number);
            }
            list.add(multiF7);
        }
    }

    public static boolean compareAssoDimMembers(List<Map<String, String>> newAssos, DynamicObject oldMem) {
        DynamicObjectCollection entryAssos = oldMem.getDynamicObjectCollection("entryentityasso");
        if (!(entryAssos != null && entryAssos.size() != 0 || newAssos != null && newAssos.size() != 0)) {
            return Boolean.FALSE;
        }
        if (entryAssos == null && newAssos != null || entryAssos != null && newAssos == null || entryAssos != null && newAssos != null && entryAssos.size() != newAssos.size()) {
            return Boolean.TRUE;
        }
        if (entryAssos != null) {
            for (DynamicObject ele : entryAssos) {
                String dimId = ele.getDynamicObject("assodim").getString("id");
                if (StringUtils.equals((CharSequence)newAssos.get(0).get("dimId"), (CharSequence)dimId)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    static {
        fixDims.add(DimTypesEnum.ENTITY.getNumber());
        fixDims.add(DimTypesEnum.SCENARIO.getNumber());
        fixDims.add(DimTypesEnum.YEAR.getNumber());
        fixDims.add(DimTypesEnum.PERIOD.getNumber());
        fixDims.add(DimTypesEnum.CURRENCY.getNumber());
        fixDims.add(DimTypesEnum.PROCESS.getNumber());
        fixDims.add(DimTypesEnum.AUDITTRIAL.getNumber());
        exceptDims = new ArrayList<String>(5);
        exceptDims.add(DimTypesEnum.SCENARIO.getNumber());
        exceptDims.add(DimTypesEnum.YEAR.getNumber());
        exceptDims.add(DimTypesEnum.PERIOD.getNumber());
        exceptDims.add(DimTypesEnum.CURRENCY.getNumber());
        exceptDims.add(DimTypesEnum.PROCESS.getNumber());
        exceptDims.add(DimTypesEnum.AUDITTRIAL.getNumber());
    }
}

