/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.UserUtils;

public class ExtDimModelServiceHelper {
    private static final List<String> DEFAULT_MODEL_NUM = Arrays.asList("INTR_SALE", "INTR_PURCHASE", "INTR_CONSOL");
    private static final Map<String, Pair<Boolean, Boolean>> INTR_SALE = Maps.newLinkedHashMapWithExpectedSize((int)3);
    private static final Map<String, Pair<Boolean, Boolean>> INTR_PURCHASE;
    private static final Map<String, Pair<Boolean, Boolean>> INTR_CONSOL;
    private static final List<String> numbers;

    public static void createDefaultExtDimModel(long modelId, DynamicObject[] extDimBizGroupMem) {
        DynamicObject field;
        HashMap extFieldMap = Maps.newHashMapWithExpectedSize((int)extDimBizGroupMem.length);
        for (DynamicObject obj : extDimBizGroupMem) {
            extFieldMap.put(obj.getString("number"), obj);
        }
        DynamicObject extmodel1 = ExtDimModelServiceHelper.generateNewExtDimModelDynaObj(modelId, extDimBizGroupMem[0]);
        extmodel1.set("number", (Object)"INTR_SALE");
        extmodel1.set("name", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u9500\u552e\u6570\u636e\u6a21\u578b", (String)"ExtDimModelServiceHelper_0", (String)"fi-bcm-business"));
        DynamicObject extmodel2 = ExtDimModelServiceHelper.generateNewExtDimModelDynaObj(modelId, extDimBizGroupMem[0]);
        extmodel2.set("number", (Object)"INTR_PURCHASE");
        extmodel2.set("name", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u91c7\u8d2d\u6570\u636e\u6a21\u578b", (String)"ExtDimModelServiceHelper_1", (String)"fi-bcm-business"));
        DynamicObject extmodel3 = ExtDimModelServiceHelper.generateNewExtDimModelDynaObj(modelId, extDimBizGroupMem[0]);
        extmodel3.set("number", (Object)"INTR_CONSOL");
        extmodel3.set("name", (Object)ResManager.getLocaleString((String)"\u5185\u90e8\u672a\u5b9e\u73b0\u6570\u636e\u6a21\u578b", (String)"ExtDimModelServiceHelper_2", (String)"fi-bcm-business"));
        DynamicObject extmodel4 = ExtDimModelServiceHelper.generateNewExtDimModelDynaObj(modelId, extDimBizGroupMem[extDimBizGroupMem.length - 1]);
        extmodel4.set("number", (Object)"INVEST");
        extmodel4.set("isconvert", (Object)false);
        extmodel4.set("name", (Object)ResManager.getLocaleString((String)"\u6743\u76ca\u62b5\u9500\u4e1a\u52a1\u6570\u636e\u6a21\u578b", (String)"ExtDimModelServiceHelper_4", (String)"fi-bcm-business"));
        DynamicObject[] extmodels = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{extmodel1, extmodel2, extmodel3, extmodel4});
        HashMap extModelMap = Maps.newHashMapWithExpectedSize((int)4);
        for (DynamicObject extmodel : extmodels) {
            extModelMap.put(extmodel.getString("number"), extmodel.getLong("id"));
        }
        ArrayList<DynamicObject> extfieldmembers = new ArrayList<DynamicObject>(32);
        int index = 1;
        for (Map.Entry<String, Pair<Boolean, Boolean>> entry : INTR_SALE.entrySet()) {
            field = ExtDimModelServiceHelper.generateNewExtModelFieldDynaObj((Long)extModelMap.get("INTR_SALE"));
            field.set("extfield", extFieldMap.get(entry.getKey()));
            field.set("sequence", (Object)index);
            field.set("isnecessary", entry.getValue().p1);
            field.set("uniquecheck", entry.getValue().p2);
            ++index;
            extfieldmembers.add(field);
        }
        index = 1;
        for (Map.Entry<String, Pair<Boolean, Boolean>> entry : INTR_PURCHASE.entrySet()) {
            field = ExtDimModelServiceHelper.generateNewExtModelFieldDynaObj((Long)extModelMap.get("INTR_PURCHASE"));
            field.set("extfield", extFieldMap.get(entry.getKey()));
            field.set("sequence", (Object)index);
            field.set("isnecessary", entry.getValue().p1);
            field.set("uniquecheck", entry.getValue().p2);
            ++index;
            extfieldmembers.add(field);
        }
        index = 1;
        for (Map.Entry<String, Pair<Boolean, Boolean>> entry : INTR_CONSOL.entrySet()) {
            field = ExtDimModelServiceHelper.generateNewExtModelFieldDynaObj((Long)extModelMap.get("INTR_CONSOL"));
            field.set("extfield", extFieldMap.get(entry.getKey()));
            field.set("sequence", (Object)index);
            field.set("isnecessary", entry.getValue().p1);
            field.set("uniquecheck", entry.getValue().p2);
            ++index;
            extfieldmembers.add(field);
        }
        index = 1;
        for (String num : numbers) {
            field = ExtDimModelServiceHelper.generateNewExtModelFieldDynaObj((Long)extModelMap.get("INVEST"));
            field.set("extfield", extFieldMap.get(num));
            field.set("sequence", (Object)index);
            field.set("isnecessary", (Object)Boolean.FALSE);
            field.set("uniquecheck", (Object)Boolean.FALSE);
            ++index;
            extfieldmembers.add(field);
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)extfieldmembers.get(0)).getDynamicObjectType(), (Object[])extfieldmembers.toArray());
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("number", "=", (Object)"InternalCompany");
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
        ArrayList dimfieldmembers = Lists.newArrayListWithExpectedSize((int)3);
        for (String model : DEFAULT_MODEL_NUM) {
            DynamicObject dim = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodeldim");
            dim.set("extmodelid", extModelMap.get(model));
            dim.set("dimension", (Object)dimension.getLong("id"));
            if (!model.equalsIgnoreCase("INTR_CONSOL")) {
                dim.set("isnecessary", (Object)Boolean.TRUE);
                dim.set("uniquecheck", (Object)Boolean.TRUE);
            } else {
                dim.set("isnecessary", (Object)Boolean.TRUE);
                dim.set("uniquecheck", (Object)Boolean.FALSE);
            }
            dimfieldmembers.add(dim);
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)dimfieldmembers.get(0)).getDynamicObjectType(), (Object[])dimfieldmembers.toArray());
    }

    private static DynamicObject generateNewExtModelFieldDynaObj(Long extModelId) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extmodelfield");
        object.set("extmodelid", (Object)extModelId);
        return object;
    }

    private static DynamicObject generateNewExtDimModelDynaObj(long modelId, DynamicObject obj) {
        DynamicObject extmodel = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extendsmodel");
        extmodel.set("model", (Object)modelId);
        extmodel.set("extendsgroup", (Object)obj.getLong("parent"));
        extmodel.set("description", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e", (String)"ExtDimModelServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        extmodel.set("status", (Object)"C");
        extmodel.set("enable", (Object)"1");
        extmodel.set("creator", (Object)UserUtils.getUserId());
        extmodel.set("modifier", (Object)UserUtils.getUserId());
        extmodel.set("createtime", (Object)new Date());
        extmodel.set("modifytime", (Object)new Date());
        return extmodel;
    }

    static {
        INTR_SALE.put("INTR_003", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.FALSE));
        INTR_SALE.put("INTR_004", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_SALE.put("INTR_005", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_PURCHASE = Maps.newLinkedHashMapWithExpectedSize((int)10);
        INTR_PURCHASE.put("INTR_001", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_002", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.FALSE));
        INTR_PURCHASE.put("INTR_011", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_015", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_016", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_017", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_018", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_019", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_020", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_PURCHASE.put("INTR_021", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.TRUE));
        INTR_CONSOL = Maps.newLinkedHashMapWithExpectedSize((int)22);
        INTR_CONSOL.put("INTR_000", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_001", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_002", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_003", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.TRUE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_004", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_005", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_006", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_007", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_008", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_009", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_010", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_011", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_012", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_013", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_014", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_015", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_016", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_017", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_018", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_019", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_020", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        INTR_CONSOL.put("INTR_021", (Pair<Boolean, Boolean>)Pair.onePair((Object)Boolean.FALSE, (Object)Boolean.FALSE));
        numbers = Arrays.asList("INV_001", "INV_002", "INV_003", "INV_004", "INV_005", "INV_006", "INV_007", "INV_008", "INV_009", "INV_010", "INV_011", "INV_012", "INV_013", "INV_014", "INV_015", "INV_016", "INV_017", "INV_018", "INV_019", "INV_020", "INV_021", "INV_022", "INV_023", "INV_024", "INV_025", "INV_026", "INV_027", "INV_028", "INV_029", "INV_030", "INV_031", "INV_032", "INV_033", "INV_034", "INV_035", "INV_036", "INV_037", "INV_038");
    }
}

