/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import org.apache.commons.lang3.StringUtils;

public class ExtFieldMappedService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long modelId;
    private String extGroup;
    private Map<String, String> dimsLoadMap;
    private Map<String, String> colsLoadMap;

    public ExtFieldMappedService(Long modelId, String extGroup) {
        this.modelId = modelId;
        this.extGroup = extGroup;
    }

    public Map<String, String> getColsFieldMapped(String[] cols) {
        LinkedHashMap fieldMapped = Maps.newLinkedHashMap();
        if (cols.length == 0) {
            return fieldMapped;
        }
        QFilter modelfilter = new QFilter("model", "=", (Object)this.modelId);
        DynamicObject parentObject = this.getParentObject();
        QFilter mappedfilter = new QFilter("parent", "=", (Object)parentObject.getLong("id"));
        if (this.colsLoadMap == null) {
            this.colsLoadMap = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number, fieldmapped", (QFilter[])new QFilter[]{modelfilter, mappedfilter}).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
        }
        for (int i = 0; i < cols.length; ++i) {
            String col = cols[i];
            fieldMapped.put(col, this.colsLoadMap.get(col));
        }
        return fieldMapped;
    }

    public DynamicObject getParentObject() {
        QFilter qfilter = new QFilter("model", "=", (Object)this.modelId).and("number", "=", (Object)this.extGroup);
        DynamicObject parentObject = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, grouptype, isparticipmerge", (QFilter[])new QFilter[]{qfilter});
        return parentObject;
    }

    public Map<String, String> getDimsFieldMapped(String[] dims) {
        LinkedHashMap fieldMapped = Maps.newLinkedHashMap();
        if (dims.length == 0) {
            return fieldMapped;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        if (this.dimsLoadMap == null) {
            this.dimsLoadMap = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, fieldmapped", (QFilter[])new QFilter[]{filter}).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
        }
        for (int i = 0; i < dims.length; ++i) {
            String dim = dims[i];
            String mapped = this.dimsLoadMap.get(dim);
            if (StringUtils.isEmpty((CharSequence)mapped)) {
                mapped = SysDimensionEnum.getEnumByNumber((String)dim) == null ? dim : SysDimensionEnum.getEnumByNumber((String)dim).getSign();
            }
            fieldMapped.put(dim, mapped);
        }
        return fieldMapped;
    }
}

