/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtFieldEntry;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.util.ISupportGZip;

public class ExtendsModel
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;

    public ExtendsModel() {
        this.put("extfieldentry", (Object)new ArrayList(16));
        this.put("dimfieldentry", (Object)new ArrayList(16));
        this.put("fieldentry", (Object)new ArrayList(16));
    }

    public ExtendsModel getExtendsModel(Long id) {
        return new ExtendsModel(id);
    }

    public void removeCache(Long id) {
    }

    public ExtendsModel(Long id) {
        DynamicObject extendsmodel = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_extendsmodel");
        DynamicObject[] extmodelfield = BusinessDataServiceHelper.load((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)id)}, (String)"sequence,extfield.number");
        DynamicObject[] extmodeldim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)id)}, (String)"sequence");
        this.initData(extendsmodel, Arrays.stream(extmodelfield).collect(Collectors.toList()), Arrays.stream(extmodeldim).collect(Collectors.toList()));
    }

    public final void initData(DynamicObject extendsmodel, List<DynamicObject> extmodelfield, List<DynamicObject> extmodeldim) {
        FieldEntry fieldEntry2;
        Long id = extendsmodel.getLong("id");
        this.setId(id);
        this.setModelId(extendsmodel.getLong("model.id"));
        this.setModelShowNumber(extendsmodel.getString("model.shownumber"));
        this.setNumber(extendsmodel.getString("number"));
        this.setName(extendsmodel.getLocaleString("name").getLocaleValue());
        this.setExtendsGroup(extendsmodel.getLong("extendsgroup.id"));
        this.setExtendsGroupNumber(extendsmodel.getString("extendsgroup.number"));
        this.setExtendsGroupType(extendsmodel.getString("extendsgroup.grouptype"));
        this.setDescription(extendsmodel.getString("description"));
        this.setStaus(extendsmodel.getString("status"));
        this.setEnable(extendsmodel.getString("enable"));
        this.setCreator(extendsmodel.getLong("creator.id"));
        this.setCreatetime(extendsmodel.getDate("createtime"));
        this.setModifier(extendsmodel.getLong("modifier.id"));
        this.setModifierName(extendsmodel.getString("modifier.name"));
        this.setModifytime(extendsmodel.getDate("modifytime"));
        this.setDisabler(extendsmodel.getLong("disabler.id"));
        this.setDisableDate(extendsmodel.getDate("disabledate"));
        this.setIsConvert(extendsmodel.getBoolean("isconvert"));
        if (extmodelfield != null && !extmodelfield.isEmpty()) {
            ArrayList<ExtFieldEntry> extFieldEntries = new ArrayList<ExtFieldEntry>(16);
            for (DynamicObject field : extmodelfield) {
                ExtFieldEntry extFieldEntry = new ExtFieldEntry();
                extFieldEntry.setId(field.getLong("id"));
                extFieldEntry.setExtModelId(field.getLong("extmodelid"));
                ExtField extField = new ExtField(field.getLong("extfield.id"), field.getString("extfield.number"), field.getLocaleString("extfield.name").getLocaleValue());
                extField.setMapped(field.getString("extfield.fieldmapped"));
                String dataType = field.getString("extfield.datatype");
                if (DataTypeEnum.ENUMTP.getOIndex().equals(dataType)) {
                    extField.setEnumItemId(field.getLong("extfield.enumitem.id"));
                }
                extField.setDataType(dataType);
                extFieldEntry.setExtField(extField);
                extFieldEntry.setSeq(field.getInt("sequence"));
                extFieldEntry.setIsNecessary(field.getBoolean("isnecessary"));
                extFieldEntry.setUniqueCheck(field.getBoolean("uniquecheck"));
                extFieldEntries.add(extFieldEntry);
            }
            this.put("extfieldentry", (Object)extFieldEntries);
        }
        if (extmodelfield != null && !extmodelfield.isEmpty()) {
            ArrayList<DimFieldEntry> dimFieldEntries = new ArrayList<DimFieldEntry>(16);
            for (DynamicObject dim : extmodeldim) {
                DimFieldEntry dimFieldEntry = new DimFieldEntry();
                dimFieldEntry.setId(dim.getLong("id"));
                dimFieldEntry.setExtModelId(dim.getLong("extmodelid"));
                dimFieldEntry.setDimension(this.generateDimension(dim.getLong("dimension.id"), dim.getString("dimension.number"), dim.getLocaleString("dimension.name").getLocaleValue()));
                dimFieldEntry.setSeq(dim.getInt("sequence"));
                dimFieldEntry.setIsNecessary(dim.getBoolean("isnecessary"));
                dimFieldEntry.setUniqueCheck(dim.getBoolean("uniquecheck"));
                dimFieldEntries.add(dimFieldEntry);
            }
            this.put("dimfieldentry", (Object)dimFieldEntries);
        }
        ArrayList fieldEntries = Lists.newArrayListWithExpectedSize((int)16);
        if (this.getExtFieldEntry() != null) {
            for (ExtFieldEntry extFieldEntry : this.getExtFieldEntry()) {
                fieldEntry2 = new FieldEntry();
                fieldEntry2.setFieldType(FieldTypeEnum.EXT_FIELD.getType());
                fieldEntry2.setName(extFieldEntry.getExtField().getName());
                fieldEntry2.setNumber(extFieldEntry.getExtField().getNumber());
                fieldEntry2.setExtField(extFieldEntry.getExtField());
                fieldEntry2.setId(extFieldEntry.getId());
                fieldEntry2.setSeq(extFieldEntry.getSeq());
                fieldEntry2.setIsNecessary(extFieldEntry.getIsNecessary());
                fieldEntry2.setUniqueCheck(extFieldEntry.getUniqueCheck());
                fieldEntries.add(fieldEntry2);
            }
        }
        if (this.getDimFieldEntry() != null) {
            for (DimFieldEntry dimFieldEntry : this.getDimFieldEntry()) {
                fieldEntry2 = new FieldEntry();
                fieldEntry2.setFieldType(FieldTypeEnum.DIM_FIELD.getType());
                fieldEntry2.setName(dimFieldEntry.getDimension().getName());
                fieldEntry2.setNumber(dimFieldEntry.getDimension().getNumber());
                fieldEntry2.setDimension(dimFieldEntry.getDimension());
                fieldEntry2.setId(dimFieldEntry.getId());
                fieldEntry2.setSeq(dimFieldEntry.getSeq());
                fieldEntry2.setIsNecessary(dimFieldEntry.getIsNecessary());
                fieldEntry2.setUniqueCheck(dimFieldEntry.getUniqueCheck());
                fieldEntries.add(fieldEntry2);
            }
        }
        if (!fieldEntries.isEmpty()) {
            fieldEntries.sort(Comparator.comparing(FieldEntry::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
            int seq = 0;
            for (FieldEntry fieldEntry2 : fieldEntries) {
                fieldEntry2.setSeq(seq);
                ++seq;
            }
            this.setFieldEntry(fieldEntries);
        }
    }

    private Dimension generateDimension(long id, String number, String name) {
        Dimension dimension = new Dimension();
        dimension.setId(id);
        dimension.setModelId(String.valueOf(this.getModelId()));
        dimension.setNumber(number);
        dimension.setName(name);
        dimension.setMemberEntityNumber(DimEntityNumEnum.getEntieyNumByNumber((String)number));
        return dimension;
    }

    public List<ExtFieldEntry> getExtFieldEntry() {
        return (List)this.get("extfieldentry");
    }

    public List<DimFieldEntry> getDimFieldEntry() {
        return (List)this.get("dimfieldentry");
    }

    public List<FieldEntry> getFieldEntry() {
        return (List)this.get("fieldentry");
    }

    public final void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return (Long)this.get("model");
    }

    public final void setModelShowNumber(String modelNumber) {
        this.put("modelNumber", (Object)modelNumber);
    }

    public String getModelShowNumber() {
        return (String)this.get("modelNumber");
    }

    public final void setExtendsGroup(long id) {
        this.put("extendsGroup", (Object)id);
    }

    public long getExtendsGroup() {
        return (Long)this.get("extendsGroup");
    }

    public final void setExtendsGroupNumber(String number) {
        this.put("extendsGroupNumber", (Object)number);
    }

    public String getExtendsGroupNumber() {
        return (String)this.get("extendsGroupNumber");
    }

    public final void setExtendsGroupType(String type) {
        this.put("extendsGroupType", (Object)type);
    }

    public String getExtendsGroupType() {
        return (String)this.get("extendsGroupType");
    }

    public final void setDescription(String text) {
        this.put("description", (Object)text);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public final void setStaus(String status) {
        this.put("status", (Object)status);
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    public final void setEnable(String enable) {
        this.put("enable", (Object)enable);
    }

    public String getEnable() {
        return (String)this.get("enable");
    }

    public final void setDisabler(Long disabler) {
        this.put("disabler", (Object)disabler);
    }

    public Long getDisabler() {
        return (Long)this.get("disabler");
    }

    public final void setDisableDate(Date date) {
        this.put("disabledate", (Object)date);
    }

    public Date getDisableDate() {
        return (Date)this.get("disabledate");
    }

    public final void setCreator(Long creator) {
        this.put("creator", (Object)creator);
    }

    public Long getCreator() {
        return (Long)this.get("creator");
    }

    public final void setCreatetime(Date date) {
        this.put("createtime", (Object)date);
    }

    public Date getCreatetime() {
        return (Date)this.get("createtime");
    }

    public final void setModifier(Long modifier) {
        this.put("modifier", (Object)modifier);
    }

    public Long getModifier() {
        return (Long)this.get("modifier");
    }

    private void setModifierName(String modifierName) {
        this.put("modifiername", (Object)modifierName);
    }

    public String getModifierName() {
        return (String)this.get("modifiername");
    }

    public final void setModifytime(Date date) {
        this.put("modifytime", (Object)date);
    }

    public Date getModifytime() {
        return (Date)this.get("modifytime");
    }

    public final void setIsConvert(boolean isconvert) {
        this.put("isconvert", (Object)isconvert);
    }

    public boolean getIsConvert() {
        return (Boolean)this.get("isconvert");
    }

    public void addField(FieldEntry fieldEntry) {
        this.getFieldEntry().add(fieldEntry);
    }

    public void removeFieldByIndexes(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            this.getFieldEntry().remove(indexes[i] - i);
        }
    }

    public DimFieldEntry getDimEntryById(long id) {
        for (DimFieldEntry dimFieldEntry : this.getDimFieldEntry()) {
            if (dimFieldEntry.getId() != id) continue;
            return dimFieldEntry;
        }
        return null;
    }

    public void setFieldEntry(List<FieldEntry> fieldEntries) {
        this.put("fieldentry", (Object)fieldEntries);
    }

    public void setExtFieldEntry(List<ExtFieldEntry> extfieldentries) {
        this.put("extfieldentry", (Object)extfieldentries);
    }

    public void setDimFieldEntry(List<DimFieldEntry> dimfieldentries) {
        this.put("dimfieldentry", (Object)dimfieldentries);
    }

    public void updateFieldByIndex(int index, FieldEntry fieldEntry) {
        this.getFieldEntry().remove(index);
        this.getFieldEntry().add(index, fieldEntry);
    }

    public FieldEntry getFieldEntryByNumber(String number) {
        for (FieldEntry fieldEntry : this.getFieldEntry()) {
            if (!number.equals(fieldEntry.getNumber())) continue;
            return fieldEntry;
        }
        return null;
    }

    public List<String> getColsByExtendModel(List<String> typeEnums) {
        ArrayList<String> extCols = new ArrayList<String>(16);
        for (ExtFieldEntry entry : this.getExtFieldEntry()) {
            if (entry.getExtField() == null) continue;
            if (typeEnums == null) {
                extCols.add(entry.getExtField().getNumber());
                continue;
            }
            if (!typeEnums.contains(entry.getExtField().getDataType())) continue;
            extCols.add(entry.getExtField().getNumber());
        }
        return extCols;
    }
}

