/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.common.util.ISupportGZip;

public class SynSetting
implements Serializable,
ISupportGZip {
    private static final long serialVersionUID = 1L;
    private List<Member> memberList = new ArrayList<Member>(16);

    public void addMember(Member member) {
        this.memberList.add(member);
    }

    public void clear() {
        this.memberList = new ArrayList<Member>(16);
    }

    public List<Member> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<Member> memberList) {
        this.memberList = memberList;
    }

    public String getShowText() {
        StringBuilder sb = new StringBuilder();
        if (this.memberList.size() > 0) {
            for (Member member : this.memberList) {
                sb.append(member.getDimension().getName()).append("@").append(member.getName()).append(";");
            }
            sb.deleteCharAt(sb.lastIndexOf(";"));
        }
        return sb.toString();
    }

    public Member getMemberByDimNumber(String number) {
        for (Member member : this.memberList) {
            if (!member.getDimension().getNumber().equalsIgnoreCase(number)) continue;
            return member;
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            this.memberList.sort(Comparator.comparing(o -> o.getNumber()));
            ((SynSetting)obj).getMemberList().sort(Comparator.comparing(o -> o.getNumber()));
            if (this.getShowText().equals(((SynSetting)obj).getShowText())) {
                return true;
            }
        }
        return false;
    }
}

