/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.special;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.ExtendDataCustomizedInput;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class ExtMultiOrgQueryService
extends ExtDataQueryService {
    private static final String ORG_LABEL = "org";
    private static final String ALGO_KEY = "bcm_extmulorg";
    private final Map<String, Map<String, Map<String, Set<String>>>> mappingList = new HashMap<String, Map<String, Map<String, Set<String>>>>(16);
    private final Map<String, Set<String>> orgCurMap = new HashMap<String, Set<String>>(16);

    @Override
    protected EDRow[] transferDSToRows(DataSet ds, EdQueryComInfo edQueryComInfo) {
        if (this.isSingle(edQueryComInfo)) {
            return super.transferDSToRows(ds, edQueryComInfo);
        }
        final Map<String, Map<String, Set<String>>> bothMapping = this.getBothMappingList(edQueryComInfo);
        ds = ds.filter(new FilterFunction(){

            public boolean test(Row row) {
                String entityNum = row.getString(ExtMultiOrgQueryService.ORG_LABEL);
                String processNum = row.getString(SysDimensionEnum.Process.getSign());
                String auditTrail = row.getString(SysDimensionEnum.AuditTrail.getSign());
                Map mapping = (Map)bothMapping.get(entityNum);
                return mapping != null && mapping.get(processNum) != null && ((Set)mapping.get(processNum)).contains(auditTrail);
            }
        });
        LinkedList<EDRow> edRows = new LinkedList<EDRow>();
        Map<String, String> fieldMappedForDims = this.getFieldMappedForDims(edQueryComInfo);
        Map<String, String> fieldMappedForCols = this.getFieldMappedForCols(edQueryComInfo);
        boolean considerCurrency = this.considerCurrency(edQueryComInfo);
        if (fieldMappedForDims != null && (fieldMappedForDims.containsKey(ORG_LABEL) || edQueryComInfo.isExternal() && fieldMappedForDims.containsKey(DimTypesEnum.ENTITY.getNumber()))) {
            Set<String> orgs = this.mappingList.keySet();
            for (String org : orgs) {
                DataSet tempDs = ds.copy();
                for (Row row : tempDs) {
                    String entity = row.getString(ORG_LABEL);
                    String process = ExtMultiOrgQueryService.getSwitchProcess(row.getString(SysDimensionEnum.Process.getSign()));
                    String auditTrail = row.getString(SysDimensionEnum.AuditTrail.getSign());
                    String currency = row.getString(SysDimensionEnum.Currency.getSign());
                    boolean isRight = this.checkRowIsRight(org, entity, ExtMultiOrgQueryService.getSwitchProcess(process), auditTrail, currency, considerCurrency);
                    if (!isRight) continue;
                    edRows.add(this.getEdRow(edQueryComInfo, fieldMappedForCols, fieldMappedForDims, row, (edRow, field) -> {
                        if (ORG_LABEL.equals(field)) {
                            String newOrg = org;
                            if (!OrgRelaProcessMembPool.isRelaProcess((String)process) && newOrg.contains("_")) {
                                newOrg = newOrg.split("_")[1];
                            }
                            edRow.addValue(newOrg);
                            return true;
                        }
                        if (edQueryComInfo.isExternal() && DimTypesEnum.ENTITY.getNumber().equals(field)) {
                            edRow.addValue(org);
                            return true;
                        }
                        return false;
                    }));
                }
            }
        } else {
            for (Row row : ds) {
                String currency;
                String auditTrail;
                String process;
                String entity = row.getString(ORG_LABEL);
                boolean isRight = this.checkRowIsRight(entity, process = ExtMultiOrgQueryService.getSwitchProcess(row.getString(SysDimensionEnum.Process.getSign())), auditTrail = row.getString(SysDimensionEnum.AuditTrail.getSign()), currency = row.getString(SysDimensionEnum.Currency.getSign()), considerCurrency);
                if (!isRight) continue;
                edRows.add(this.getEdRow(edQueryComInfo, fieldMappedForCols, fieldMappedForDims, row, null));
            }
        }
        return edRows.toArray(new EDRow[0]);
    }

    private boolean checkRowIsRight(String org, String entity, String process, String auditTrail, String currency, boolean considerCurrency) {
        if (considerCurrency) {
            Set<String> curs;
            String childOrg = org;
            if (childOrg.contains("_")) {
                childOrg = childOrg.substring(org.indexOf("_") + 1);
            }
            if ((curs = this.orgCurMap.get(childOrg)) == null || !curs.contains(currency)) {
                return false;
            }
        }
        return this.mappingList.containsKey(org) && this.mappingList.get(org).containsKey(entity) && this.mappingList.get(org).get(entity).containsKey(process) && this.mappingList.get(org).get(entity).get(process).contains(auditTrail);
    }

    private boolean checkRowIsRight(String entity, String process, String auditTrail, String currency, boolean considerCurrency) {
        boolean result = false;
        if (considerCurrency) {
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> map : this.mappingList.entrySet()) {
                Set<String> curs;
                String childOrg = map.getKey();
                if (childOrg.contains("_")) {
                    childOrg = childOrg.substring(childOrg.indexOf("_") + 1);
                }
                if ((curs = this.orgCurMap.get(childOrg)) == null || !curs.contains(currency) || !map.getValue().containsKey(entity) || !map.getValue().get(entity).containsKey(process) || !map.getValue().get(entity).get(process).contains(auditTrail)) continue;
                result = true;
                break;
            }
        } else {
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> map : this.mappingList.entrySet()) {
                if (!map.getValue().containsKey(entity) || !map.getValue().get(entity).containsKey(process) || !map.getValue().get(entity).get(process).contains(auditTrail)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public DataSet queryDataset(EdQueryComInfo edQueryComInfo) {
        if (this.isSingle(edQueryComInfo)) {
            return super.queryDataset(edQueryComInfo);
        }
        this.checkQueryInfo(edQueryComInfo);
        String selectCols = this.getSelectCols(edQueryComInfo, false);
        HashSet selectDim = edQueryComInfo.getDimselects() == null ? Collections.emptySet() : Sets.newHashSet((Object[])edQueryComInfo.getDimselects());
        StringJoiner sj = new StringJoiner(",");
        ctxDim.stream().filter(dim -> !selectDim.contains(dim)).forEach(dim -> sj.add(dim.toLowerCase()));
        if (sj.length() > 0) {
            selectCols = selectCols + "," + sj;
        }
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)ExtMultiOrgQueryService.getExtendEntity(edQueryComInfo), (String)selectCols, (QFilter[])new QFilter[]{this.getFilter(edQueryComInfo)}, null);
    }

    @Override
    protected String getSelectCols(EdQueryComInfo edQueryComInfo, boolean needSum) {
        String[] extSelects;
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("id").add("sid");
        Object[] dimSelects = edQueryComInfo.getDimselects();
        if (dimSelects != null) {
            Map<String, String> fieldMappedForDims = edQueryComInfo.getFieldMappedForDims((String[])dimSelects);
            for (Object dim : dimSelects) {
                if (edQueryComInfo.isExternal() && "SourceEntity".equals(dim)) continue;
                stringJoiner.add(fieldMappedForDims.get(dim));
            }
        }
        if (dimSelects == null || dimSelects.length == 0 || !Sets.newHashSet((Object[])dimSelects).contains(ORG_LABEL)) {
            stringJoiner.add(ORG_LABEL);
        }
        if ((extSelects = edQueryComInfo.getExtselects()) != null) {
            Map<String, String> fieldMappedForCols = edQueryComInfo.getFieldMappedForCols(extSelects);
            Arrays.stream(extSelects).forEach(extSelect -> stringJoiner.add((CharSequence)fieldMappedForCols.get(extSelect)));
        }
        return stringJoiner.toString();
    }

    @Override
    public DataSet queryNewDataSet(EdQueryComInfo edQueryComInfo) {
        String[] dimSelects = edQueryComInfo.getDimselects();
        String[] extSelects = edQueryComInfo.getExtselects();
        if (this.metaData == null) {
            this.metaData = new EDResultSetMetaData();
            if (dimSelects != null) {
                Arrays.stream(dimSelects).forEach(colName -> this.metaData.addColumnMeta((String)colName));
            }
            if (extSelects != null) {
                Arrays.stream(extSelects).forEach(colName -> this.metaData.addColumnMeta((String)colName));
            }
        }
        DataSet ds = this.queryDataset(edQueryComInfo);
        if (this.isSingle(edQueryComInfo)) {
            return ds;
        }
        EDRow[] edRows = this.transferDSToRows(ds, edQueryComInfo);
        RowMeta rowMeta = ds.getRowMeta();
        Map<String, String> fieldMappedForDims = this.getFieldMappedForDims(edQueryComInfo);
        ArrayList<Field> fieldList = new ArrayList<Field>(10);
        if (fieldMappedForDims != null && fieldMappedForDims.containsKey(ORG_LABEL)) {
            IntStream.range(0, this.metaData.getColMetaDatas().size()).forEach(index -> fieldList.add(rowMeta.getField(index + 2)));
        } else {
            List<EDColumn> colMetaDatas = this.metaData.getColMetaDatas();
            Map<String, String> mappedForDims = this.getFieldMappedForDims(edQueryComInfo);
            Map<String, String> mappedForCols = this.getFieldMappedForCols(edQueryComInfo);
            for (EDColumn column : colMetaDatas) {
                if (mappedForDims != null && mappedForDims.containsKey(column.getMdName())) {
                    fieldList.add(rowMeta.getField(mappedForDims.get(column.getMdName())));
                    continue;
                }
                if (mappedForCols != null && mappedForCols.containsKey(column.getMdName())) {
                    fieldList.add(rowMeta.getField(mappedForCols.get(column.getMdName())));
                    continue;
                }
                fieldList.add(rowMeta.getField(column.getMdName()));
            }
        }
        ds.close();
        return this.creatNewDataSet(edQueryComInfo, new RowMeta(fieldList.toArray(new Field[0])), edRows);
    }

    private DataSet creatNewDataSet(EdQueryComInfo edQueryComInfo, RowMeta rowMeta, EDRow[] edRows) {
        DataSet ds = Algo.create((String)"bcm_extDataSet").createDataSet(new Input[]{new ExtendDataCustomizedInput(Arrays.asList(edRows), rowMeta)});
        HashSet<String> groupBy = new HashSet<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        ExtMultiOrgQueryService.fixGroupAndSumFileld(edQueryComInfo, groupBy, sumFields);
        ds = ExtMultiOrgQueryService.groupAndSum(ds, groupBy, sumFields);
        return ds;
    }

    protected boolean isSingle(EdQueryComInfo edQueryComInfo) {
        return !edQueryComInfo.isExternal() && COMBINE_KEYS.stream().noneMatch(key -> edQueryComInfo.getDimFilter().get(key).length > 1) && edQueryComInfo.getDimselects() != null && !Arrays.asList(edQueryComInfo.getDimselects()).contains(ORG_LABEL);
    }

    @Override
    protected void checkQueryInfo(EdQueryComInfo cI) {
        super.checkQueryInfo(cI);
        if (cI.getDimFilter().get(DimTypesEnum.PROCESS.getNumber()).length > 1 || cI.getDimFilter().get(DimTypesEnum.AUDITTRIAL.getNumber()).length > 1) {
            throw new KDBizException("EdCommandInfo dimfilter is Overflow.");
        }
    }

    private QFilter getFilter(EdQueryComInfo cI) {
        QFilter qFilter = new QFilter("modelnumber", "=", (Object)cI.getShowNumber());
        List combines = Lists.cartesianProduct(COMBINE_KEYS.stream().map(key -> Arrays.asList((Object[])cI.getDimFilter().get(key))).collect(Collectors.toList()));
        List<Map<String, Map<String, Set<String>>>> mappingList = this.getListMappingFilter(combines, cI);
        if (mappingList.isEmpty()) {
            return new QFilter("1", "!=", (Object)1);
        }
        HashSet<String> orgSet = new HashSet<String>(16);
        HashSet<String> processSet = new HashSet<String>(16);
        HashSet audittrailSet = new HashSet(16);
        for (Map<String, Map<String, Set<String>>> map : mappingList) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : map.entrySet()) {
                orgSet.add(entry.getKey());
                for (Map.Entry<String, Set<String>> setEntry : entry.getValue().entrySet()) {
                    processSet.add(ExtMultiOrgQueryService.getSwitchProcess(setEntry.getKey()));
                    audittrailSet.addAll(setEntry.getValue());
                }
            }
        }
        QFilter filter = new QFilter(ORG_LABEL, "in", orgSet);
        filter.and("process", "in", processSet).and("audittrail", "in", audittrailSet);
        this.addOtherFilter(cI, qFilter.and(filter));
        LOG.info(qFilter.toString());
        return qFilter;
    }

    private List<Map<String, Map<String, Set<String>>>> getListMappingFilter(List<List<String>> combines, EdQueryComInfo edQueryComInfo) {
        String process = edQueryComInfo.getDimFilter().get(DimTypesEnum.PROCESS.getNumber())[0];
        String auditTrail = edQueryComInfo.getDimFilter().get(DimTypesEnum.AUDITTRIAL.getNumber())[0];
        ArrayList<Map<String, Map<String, Set<String>>>> res = new ArrayList<Map<String, Map<String, Set<String>>>>(10);
        boolean considerCurrency = this.considerCurrency(edQueryComInfo);
        HashMap<String, String[]> initMap = new HashMap<String, String[]>(edQueryComInfo.getDimFilter());
        for (List<String> combine : combines) {
            Map<String, Map<String, Set<String>>> mappingFilter;
            String entityNum = combine.get(0);
            IDNumberTreeNode entityNode = ExtMultiOrgQueryService.getSourceEntityMember(entityNum, edQueryComInfo);
            HashMap<String, String[]> tempMap = new HashMap<String, String[]>(initMap);
            this.mappingList.putIfAbsent(entityNode.getParent_SonNumber(), new HashMap(16));
            edQueryComInfo.setDimFilter(tempMap);
            tempMap.put(DimTypesEnum.ENTITY.getNumber(), new String[]{entityNum});
            tempMap.put(DimTypesEnum.SCENARIO.getNumber(), new String[]{combine.get(1)});
            tempMap.put(DimTypesEnum.YEAR.getNumber(), new String[]{combine.get(2)});
            tempMap.put(DimTypesEnum.PERIOD.getNumber(), new String[]{combine.get(3)});
            if (considerCurrency) {
                this.orgCurMap.put(entityNode.getNumber(), this.getCurrencyByEntity(edQueryComInfo, entityNum));
            }
            if (!(mappingFilter = this.getMappingFilter(entityNode, ExtMultiOrgQueryService.getSwitchProcess(process), auditTrail, edQueryComInfo)).isEmpty()) {
                this.mappingList.get(entityNode.getParent_SonNumber()).putAll(mappingFilter);
            }
            res.add(mappingFilter);
        }
        edQueryComInfo.setDimFilter(initMap);
        return res;
    }

    public Map<String, Map<String, Map<String, Set<String>>>> getMappingList(EdQueryComInfo edQueryComInfo) {
        if (this.mappingList.isEmpty()) {
            List combines = Lists.cartesianProduct(COMBINE_KEYS.stream().map(key -> Arrays.asList((Object[])edQueryComInfo.getDimFilter().get(key))).collect(Collectors.toList()));
            this.getListMappingFilter(combines, edQueryComInfo);
        }
        return this.mappingList;
    }

    public Map<String, Map<String, Set<String>>> getBothMappingList(EdQueryComInfo edQueryComInfo) {
        if (this.mappingList.isEmpty()) {
            this.getMappingList(edQueryComInfo);
        }
        HashMap<String, Map<String, Set<String>>> bothFilter = new HashMap<String, Map<String, Set<String>>>(16);
        for (Map<String, Map<String, Set<String>>> value : this.mappingList.values()) {
            for (Map.Entry<String, Map<String, Set<String>>> entry : value.entrySet()) {
                for (Map.Entry<String, Set<String>> setEntry : entry.getValue().entrySet()) {
                    String entity = entry.getKey();
                    String process = ExtMultiOrgQueryService.getSwitchProcess(setEntry.getKey());
                    Set<String> audit = setEntry.getValue();
                    bothFilter.putIfAbsent(entity, new HashMap(16));
                    Map map = (Map)bothFilter.get(entity);
                    ((Map)bothFilter.get(entity)).putIfAbsent(process, new HashSet(16));
                    Set old = (Set)((Map)bothFilter.get(entity)).get(process);
                    if (old != null) {
                        old.addAll(audit);
                        continue;
                    }
                    map.put(process, audit);
                }
            }
        }
        return bothFilter;
    }
}

