/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.sql;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.algo.Row;
import kd.fi.bcm.business.extdata.ExtDataQueryFactory;
import kd.fi.bcm.business.extdata.ExtDataQueryService;
import kd.fi.bcm.business.extdata.IExtQueryService;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.extdata.sql.IEDResultSet;
import kd.fi.bcm.business.extdata.sql.exception.EDQueryException;

public class EDResultSet
implements IEDResultSet {
    private int cursorPos = 0;
    private int numRows = 0;
    private EDRow[] rows;
    private EDResultSetMetaData metaData;

    @Override
    public boolean next() {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new EDQueryException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    private boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    @Override
    public void beforeFirst() {
        this.cursorPos = 0;
    }

    @Override
    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    protected void checkCursor() {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new EDQueryException("Invalid cursor position");
        }
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public String getString(String colName) {
        this.checkCursor();
        return this.getRow().getString(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkCursor();
        return this.getRow().getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkCursor();
        return this.getRow().getBigDecimal(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkCursor();
        return this.getRow().getOriginalValue(colName);
    }

    @Override
    public EDRow getRow() {
        return this.rows[this.cursorPos - 1];
    }

    public EDRow[] getRows() {
        return this.rows;
    }

    public void setRows(EDRow[] rows) {
        this.rows = rows;
    }

    @Override
    public void close() {
        this.rows = null;
    }

    @Override
    public EDResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == null || this.rows.length == 0;
    }

    @Override
    public void populate(EdQueryComInfo edQueryComInfo) {
        this.setMetaData(edQueryComInfo);
        IExtQueryService extDataQueryService = ExtDataQueryFactory.getQueryService(edQueryComInfo);
        this.rows = extDataQueryService.populate(this.metaData, edQueryComInfo);
        this.numRows = this.rows.length;
    }

    public void populate(List<Row> dynamicObjects, EdQueryComInfo edCommandInfo) {
        this.setMetaData(edCommandInfo);
        ExtDataQueryService extDataQueryService = new ExtDataQueryService();
        extDataQueryService.setMetaData(this.metaData);
        this.rows = extDataQueryService.fillRows(dynamicObjects, edCommandInfo);
        this.numRows = this.rows.length;
    }

    public void iteratorRows(Consumer<EDRow> consumer) {
        this.beforeFirst();
        while (this.next()) {
            consumer.accept(this.getRow());
        }
        this.beforeFirst();
    }

    protected void setMetaData(EdQueryComInfo edQueryComInfo) {
        this.metaData = new EDResultSetMetaData();
        String[] dimselects = edQueryComInfo.getDimselects();
        String[] extselects = edQueryComInfo.getExtselects();
        Arrays.stream(dimselects).forEach(colName -> this.metaData.addColumnMeta((String)colName));
        Arrays.stream(extselects).forEach(colName -> this.metaData.addColumnMeta((String)colName));
    }
}

