/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.fi.bcm.business.extdata.sql.EDResultSetMetaData;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;

public class EDRow {
    protected long pkId;
    protected String spkId;
    protected List<Object> values;
    protected EDResultSetMetaData metaData;

    public EDRow(EDResultSetMetaData metaData) {
        this.metaData = metaData;
        this.values = new ArrayList<Object>(metaData.getColumCount());
    }

    public boolean addValue(Object val) {
        return this.values.add(val);
    }

    public String getString(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToString(obj);
    }

    public Date getDate(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToDate(obj);
    }

    public BigDecimal getBigDecimal(String colName) {
        Object obj = this.getValue(this.metaData.getColIndex(colName));
        return TypeConversionUtils.objToBigDecimal(obj);
    }

    public Object getOriginalValue(String colName) {
        return this.getValue(this.metaData.getColIndex(colName));
    }

    public Object getValue(int index) {
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    public long getPkId() {
        return this.pkId;
    }

    public void setPkId(long pkId) {
        this.pkId = pkId;
    }

    public String getSpkId() {
        return this.spkId;
    }

    public void setSpkId(String spkId) {
        this.spkId = spkId;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public EDResultSetMetaData getMetaData() {
        return this.metaData;
    }
}

