/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.extdata.sql.EdComInfo;
import kd.fi.bcm.business.extdata.sql.exception.EDSaveException;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class EDSaveComInfo
extends EdComInfo {
    public static int dateError = -1;
    private int scale = 15;
    public static final String NUM_PREX = "num";
    private String[] cols;
    private String[] dims;
    private List<Object[]> values = new ArrayList<Object[]>();
    private Map<Long, Object[]> updateValues = new HashMap<Long, Object[]>(16);
    private List<Object[]> allValues = new ArrayList<Object[]>();
    private Map<String, String> fixDim = new HashMap<String, String>();
    private boolean uniquecheck;
    private boolean ignoreuniquevalue;
    private boolean keepEntity = false;
    private boolean isBizRule2InTrade = false;
    private Long paperTemplateId;
    private List<Object[]> errorvalues = new ArrayList<Object[]>();

    public EDSaveComInfo(String modelNumer, String extGroup, String datamodel) {
        super(modelNumer, extGroup, datamodel);
    }

    public String[] getCols() {
        return this.cols;
    }

    public void setCols(String[] cols) {
        this.cols = cols;
    }

    public String[] getDims() {
        return this.dims;
    }

    public void setDims(String[] dims) {
        this.dims = dims;
    }

    public void addfixedDimension(String dim, String value) {
        this.fixDim.put(dim, value);
    }

    public void setFixDim(Map<String, String> fixDim) {
        this.fixDim = fixDim;
    }

    public Map<String, String> getfixedDimension() {
        return this.fixDim;
    }

    public Object[] addValue(Object[] value, String[] dimValues) {
        if (this.checkSize(value, dimValues) && this.checkValue(value)) {
            int valueLength = dimValues == null ? value.length : value.length + dimValues.length;
            Object[] allva = new Object[valueLength];
            System.arraycopy(value, 0, allva, 0, value.length);
            if (dimValues != null && valueLength > value.length) {
                System.arraycopy(dimValues, 0, allva, value.length, dimValues.length);
            }
            if (this.values.add(allva)) {
                this.allValues.add(allva);
                return allva;
            }
        }
        return null;
    }

    public Object[] getRowValue(Object[] value, String[] dimValues) {
        if (this.checkSize(value, dimValues) && this.checkValue(value)) {
            int valueLength = dimValues == null ? value.length : value.length + dimValues.length;
            Object[] allva = new Object[valueLength];
            System.arraycopy(value, 0, allva, 0, value.length);
            if (dimValues != null && valueLength > value.length) {
                System.arraycopy(dimValues, 0, allva, value.length, dimValues.length);
            }
            return allva;
        }
        return null;
    }

    public List<Object[]> getValue() {
        return this.values;
    }

    protected boolean checkSize(Object[] value, String[] dimValues) {
        if (value == null || value.length != this.cols.length) {
            throw new EDSaveException(ResManager.loadKDString((String)"\u7f3a\u5c11\u62d3\u5c55\u7ef4\u53c2\u6570", (String)"EDSaveComInfo_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (dimValues != null && dimValues.length != this.dims.length) {
            throw new EDSaveException(ResManager.loadKDString((String)"\u7f3a\u5c11\u591a\u7ef4\u53c2\u6570", (String)"EDSaveComInfo_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean checkValue(Object[] values) {
        if (this.cols == null) {
            throw new EDSaveException(" extend cols is null");
        }
        Map<String, String> fieldMappedForCols = this.getFieldMappedForCols(this.cols);
        Object[] mappeds = fieldMappedForCols.values().toArray();
        Object[] mappedKey = fieldMappedForCols.keySet().toArray();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            String mapped = (String)mappeds[i];
            if (value == null || mapped.contains("dateext") && value instanceof Date) continue;
            if (mapped.contains("dateext")) {
                try {
                    Date date = DateTimeUtils.parseStrDate((String)value.toString());
                    values[i] = date;
                }
                catch (Exception e) {
                    values[i] = dateError;
                }
                continue;
            }
            if (mapped.contains("textext")) {
                values[i] = value.toString();
                continue;
            }
            if (mapped.contains("numext")) {
                try {
                    values[i] = new BigDecimal(value.toString()).setScale(this.scale, 4);
                    continue;
                }
                catch (Exception e) {
                    values[i] = null;
                    try {
                        value = DateTimeUtils.parseUTC((String)value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u9519\u8bef:%1$s:%2$s\u3002", (String)"EDSaveComInfo_2", (String)"fi-bcm-business", (Object[])new Object[0]), mappedKey[i], value));
                }
            }
            throw new EDSaveException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u9519\u8bef:%1$s:%2$s\u3002", (String)"EDSaveComInfo_2", (String)"fi-bcm-business", (Object[])new Object[0]), mappedKey[i], value));
        }
        return true;
    }

    public void putUpdateValues(long id, Object[] value, String[] dimValues) {
        Object[] row = this.getRowValue(value, dimValues);
        this.allValues.add(row);
        this.updateValues.put(id, row);
    }

    public Map<Long, Object[]> getUpdateValues() {
        return this.updateValues;
    }

    public void setUpdateValues(Map<Long, Object[]> updateValues) {
        this.updateValues = updateValues;
    }

    public List<Object[]> getAllValues() {
        return this.allValues;
    }

    public boolean isUniquecheck() {
        return this.uniquecheck || this.ignoreuniquevalue;
    }

    public void setUniquecheck(boolean uniquecheck) {
        this.uniquecheck = uniquecheck;
    }

    public void setIgnoreuniquevalue(boolean ignoreuniquevalue) {
        this.ignoreuniquevalue = ignoreuniquevalue;
    }

    public boolean isIgnoreuniquevalue() {
        return this.ignoreuniquevalue;
    }

    public List<Object[]> getErrorvalues() {
        return this.errorvalues;
    }

    public void addErrorvalues(Object[] error) {
        this.errorvalues.add(error);
    }

    public boolean isKeepEntity() {
        return this.keepEntity;
    }

    public void setKeepEntity(boolean keepEntity) {
        this.keepEntity = keepEntity;
    }

    public boolean isBizRule2InTrade() {
        return this.isBizRule2InTrade;
    }

    public void setBizRule2InTrade(boolean bizRule2InTrade) {
        this.isBizRule2InTrade = bizRule2InTrade;
    }

    public Long getPaperTemplateId() {
        return this.paperTemplateId;
    }

    public void setPaperTemplateId(Long paperTemplateId) {
        this.paperTemplateId = paperTemplateId;
    }
}

