/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.extdata.sql;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.extdata.ExtFieldMappedService;
import kd.fi.bcm.common.cache.MemberReader;

public class EdComInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String showNumber;
    private String extGroup;
    private String datamodel;
    private String parentOrg;
    private DynamicObject groupObject;
    private String modelNumer;
    private Long modelId;
    private String srcStr = "";
    private long mainOrgId;
    private boolean isExternal;
    private Map<String, List<Long>> mulOrgNumMap = new HashMap<String, List<Long>>(16);
    private Map<Integer, Map<String, String>> fieldMappedMap = new HashMap<Integer, Map<String, String>>(2);
    private ExtFieldMappedService fieldMappedService;

    public EdComInfo() {
    }

    public EdComInfo(String showNumber, String extGroup, String datamodel) {
        this.showNumber = showNumber;
        this.extGroup = extGroup;
        this.datamodel = datamodel;
    }

    public EdComInfo(String showNumber, String extGroup, String datamodel, String srcStr) {
        this.showNumber = showNumber;
        this.extGroup = extGroup;
        this.datamodel = datamodel;
        this.srcStr = srcStr;
    }

    public String getSrcStr() {
        return this.srcStr;
    }

    public void setSrcStr(String srcStr) {
        this.srcStr = srcStr;
    }

    public String getShowNumber() {
        return this.showNumber;
    }

    public String getExtGroup() {
        return this.extGroup;
    }

    public String getDatamodel() {
        return this.datamodel;
    }

    public String getParentOrg() {
        return this.parentOrg;
    }

    public void setParentOrg(String parentOrg) {
        this.parentOrg = parentOrg;
    }

    public String getGrouptype() {
        if (this.groupObject == null) {
            DynamicObject groupObject = this.getGroupObject();
            return groupObject.getString("grouptype");
        }
        return this.groupObject.getString("grouptype");
    }

    public DynamicObject getGroupObject() {
        if (this.groupObject == null) {
            if (this.fieldMappedService == null) {
                this.fieldMappedService = new ExtFieldMappedService(this.getModelId(), this.extGroup);
            }
            this.groupObject = this.fieldMappedService.getParentObject();
        }
        return this.groupObject;
    }

    private void initModel() {
        this.modelId = MemberReader.findModelIdByShowNum((String)this.getShowNumber());
        this.modelNumer = MemberReader.findModelNumberById((Object)this.modelId);
    }

    public Long getModelId() {
        if (this.modelId == null) {
            this.initModel();
        }
        return this.modelId;
    }

    public String getModelNum() {
        if (this.modelNumer == null) {
            this.initModel();
        }
        return this.modelNumer;
    }

    public Map<String, String> getFieldMappedForCols(String[] cols) {
        Map<String, String> fieldMapped = this.fieldMappedMap.getOrDefault(Arrays.hashCode(cols), Maps.newLinkedHashMap());
        if (cols.length != 0 && fieldMapped.isEmpty()) {
            if (this.fieldMappedService == null) {
                this.fieldMappedService = new ExtFieldMappedService(this.getModelId(), this.extGroup);
            }
            Map<String, String> colsFieldMapped = this.fieldMappedService.getColsFieldMapped(cols);
            this.fieldMappedMap.put(Arrays.hashCode(cols), colsFieldMapped);
            return colsFieldMapped;
        }
        return fieldMapped;
    }

    public Map<String, String> getFieldMappedForDims(String[] dims) {
        Map<String, String> fieldMapped = this.fieldMappedMap.getOrDefault(Arrays.hashCode(dims), Maps.newLinkedHashMap());
        if (dims.length != 0 && fieldMapped.isEmpty()) {
            if (this.fieldMappedService == null) {
                this.fieldMappedService = new ExtFieldMappedService(this.getModelId(), this.extGroup);
            }
            Map<String, String> dimsFieldMapped = this.fieldMappedService.getDimsFieldMapped(dims);
            this.fieldMappedMap.put(Arrays.hashCode(dims), dimsFieldMapped);
            return dimsFieldMapped;
        }
        return fieldMapped;
    }

    public long getMainOrgId() {
        return this.mainOrgId;
    }

    public void setMainOrgId(long mainOrgId) {
        this.mainOrgId = mainOrgId;
    }

    public Map<String, List<Long>> getMulOrgNumMap() {
        return this.mulOrgNumMap;
    }

    public void setMulOrgNumMap(Map<String, List<Long>> mulOrgNumMap) {
        if (mulOrgNumMap != null) {
            this.mulOrgNumMap = mulOrgNumMap;
        }
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean external) {
        this.isExternal = external;
    }
}

