/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.enums.DataSourceTypeEnum;
import kd.fi.bcm.business.vo.EPMDataVo;
import kd.fi.bcm.business.vo.EbDimVo;
import kd.fi.bcm.common.util.QFBuilder;

public class VDataFormulaServiceHelper {
    public static final String DIM_CACHE = "DIM_CACHE";
    public static final String MEM_CACHE = "MEM_CACHE";
    public static final String EPMDATAMODEL_CACHE = "getEPMDataModel";

    public static List<EbDimVo> getDim(String modelNum, String datasetNum) {
        return (List)ThreadCache.get((Object)(DIM_CACHE + modelNum + datasetNum), () -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("modelNumber", modelNum);
            map.put("datasetNumber", datasetNum);
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"DimensionService", (String)"query", (Object[])new Object[]{map});
                return (List)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<List<EbDimVo>>(){}, (Feature[])new Feature[0]);
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u7ef4\u5ea6\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        });
    }

    public static List<String> getDimMember(String modelNum, String datasetNum, String dimNum) {
        return (List)ThreadCache.get((Object)(MEM_CACHE + modelNum + datasetNum + dimNum), () -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("modelNumber", modelNum);
            map.put("datasetNumber", datasetNum);
            map.put("dimNumber", dimNum);
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberService", (String)"queryByDataset", (Object[])new Object[]{map});
                JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)returnValue));
                return array.stream().map(ar -> ar instanceof JSONObject ? ((JSONObject)ar).getString("number") : "").collect(Collectors.toList());
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u7ef4\u5ea6\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        });
    }

    public static EPMDataVo getEPMDataModel(String number, String type) {
        return (EPMDataVo)ThreadCache.get((Object)(EPMDATAMODEL_CACHE + number + type), () -> {
            String[] splits = number.split(",");
            if (splits.length == 2) {
                QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)splits[0]);
                qfBuilder.add("catalog.number", "=", (Object)splits[1]);
                DynamicObject one = QueryServiceHelper.queryOne((String)DataSourceTypeEnum.EPM_DATAMANAGE.getFormId(), (String)"id,number", (QFilter[])qfBuilder.toArray());
                if (one != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    Object id = one.get("id");
                    Object newNum = one.get("number");
                    map.put("id", id);
                    map.put("number", newNum);
                    map.put("type", "DataModel." + type);
                    try {
                        Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"query", (Object[])new Object[]{map});
                        if (returnValue != null) {
                            return (EPMDataVo)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<EPMDataVo>(){}, (Feature[])new Feature[0]);
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6EPM\u6570\u636e\u6a21\u578b\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    catch (KDBizException e) {
                        throw new KDBizException(e.getMessage());
                    }
                    catch (Exception e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6EPM\u6570\u636e\u6a21\u578b\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6EPM\u6570\u636e\u6a21\u578b\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6EPM\u6570\u636e\u6a21\u578b\u5f02\u5e38\u3002", (String)"VDataFormulaServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        });
    }
}

