/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.calculate.ICalculateHandle;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.excelformula.IFFormula;
import kd.fi.bcm.business.formula.model.value.Value;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.ICustomerFormat;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.Functional;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;

public abstract class AbstractCalculate<T extends Formula>
implements ICalculateHandle<T> {
    protected ICalContext _ctx;
    protected List<T> originalFormulas;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractCalculate.class);
    protected FelCalculateEngine engine;
    protected Boolean cellCal;

    @Override
    public void initEvn(ICalContext ctx, List<T> formulas) {
        this._ctx = ctx;
        this.originalFormulas = formulas;
        this.cellCal = this._ctx.getProperty("cellCal") == null ? Boolean.valueOf(true) : (Boolean)this._ctx.getProperty("cellCal");
        this.handleNestParam();
    }

    @Override
    public void calculate() {
        try {
            this.originalFormulas.forEach(f -> {
                if (!f.hasException() && this.cellCal.booleanValue()) {
                    for (int i = 0; i < f.getParamList().size(); ++i) {
                        ParamItem item = (ParamItem)f.getParamList().get(i);
                        if (!(item.getParam() instanceof BinaryOperationExpr)) continue;
                        Object va = this.getFelEngine().calculate(item.getParam().toString());
                        if (va instanceof Exception && !f.iSParamCanAccExp(i)) {
                            this.log.error(String.format("[%s][%s] calculate error!", f, item.getParam()), (Throwable)va);
                            f.setException((Exception)va);
                            break;
                        }
                        item.fixParam(va);
                    }
                }
                if (this._ctx.getDefaultParamHandle() != null) {
                    this._ctx.getDefaultParamHandle().handle((IFormula)f);
                }
            });
            this.initFormula();
        }
        catch (Exception e) {
            this.originalFormulas.forEach(f -> {
                f.setException(e);
                this.log.error(String.format(this.getClass().getSimpleName() + "::initFormula() error:%s", f.toString()), (Throwable)e);
            });
        }
        ArrayList execFormulas = new ArrayList();
        boolean hasDcSize = this._ctx.getProperty("dcsize") != null;
        int dcsize = hasDcSize ? (Integer)this._ctx.getProperty("dcsize") : 10000;
        this.originalFormulas.forEach(f -> {
            if (!f.hasException() || f instanceof IFFormula) {
                execFormulas.add(f);
                if (hasDcSize && execFormulas.size() >= dcsize) {
                    this.doCaculate(execFormulas);
                }
            }
        });
        if (!execFormulas.isEmpty()) {
            this.doCaculate(execFormulas);
        }
    }

    private void doCaculate(List<T> execFormulas) {
        try {
            this.execCalculate(execFormulas);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            execFormulas.forEach(f -> f.setException(e));
        }
        finally {
            execFormulas.clear();
        }
    }

    protected void handleNestParam() {
        if (this._ctx.getNestDataProvider() == null) {
            return;
        }
        if (this.originalFormulas != null) {
            this.originalFormulas.forEach(f -> this.walkFormulaParam((Formula)f));
        }
    }

    private void walkFormulaParam(Formula f) {
        if (f.getParamList() != null) {
            int pIndex = -1;
            for (ParamItem p : f.getParamList()) {
                ++pIndex;
                if (!(p.getParam() instanceof Expression) || f.hasException()) continue;
                this.walkFormulaExpress(f, (Expression)p.getParam(), p, pIndex);
            }
        }
    }

    private void walkFormulaExpress(final Formula f, Expression exprs, final ParamItem p, int pIndex) {
        if (Functional.class.isAssignableFrom(exprs.getClass())) {
            String uuid = exprs.getUUID();
            if (!f.hasHandleParamItemBySelf(p, pIndex)) {
                Object refValue = this.getRefValue(uuid, p);
                if (refValue instanceof Exception) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(exprs);
                    msg.append(':');
                    msg.append(((Exception)refValue).getMessage());
                    if (this._ctx.getProperty("rptignorerror") == null) {
                        p.setErrorMsg(msg);
                        if (f.getException() == null) {
                            f.setException((Exception)refValue);
                        }
                        return;
                    }
                    f.setExceptionMsg(msg.toString());
                    refValue = BCMConstant.Zero;
                } else if (this._ctx.getProperty("rptignorerror") != null && this._ctx.getCalculateService().getErrorMsg().containsKey(uuid)) {
                    f.setExceptionMsg(this._ctx.getCalculateService().getErrorMsg().get(uuid));
                }
                p.fixParam(refValue);
            }
        } else if (exprs instanceof BinaryOperationExpr || p.getParam() instanceof UnaryOperationExpr) {
            StringBuffer buffer = new StringBuffer();
            exprs.output(buffer, new ICustomerFormat(){

                public void beforeOutput(Expression ex, StringBuffer sb) {
                }

                public void afterOutput(Expression ex, StringBuffer sb) {
                }

                public String formatOP(String op) {
                    return op;
                }

                public boolean isOutputValueExpress() {
                    return true;
                }

                public void outputValueOnNestExpress(Expression ex, StringBuffer sb) {
                    if (ex instanceof Functional) {
                        Object re = AbstractCalculate.this._ctx.getNestDataProvider().get(ex.getUUID());
                        if (re instanceof Exception) {
                            StringBuilder msg = new StringBuilder();
                            if (f.getException() != null) {
                                msg.append(f.getException().getMessage());
                                msg.append(';');
                            }
                            msg.append(ex);
                            msg.append(':');
                            msg.append(((Exception)re).getMessage());
                            if (AbstractCalculate.this._ctx.getProperty("rptignorerror") == null) {
                                p.setErrorMsg(msg);
                                if (f.getException() == null) {
                                    f.setException((Exception)re);
                                }
                            } else {
                                sb.append(BigDecimal.ZERO);
                                f.setExceptionMsg(msg.toString());
                            }
                        } else {
                            if (AbstractCalculate.this._ctx.getProperty("rptignorerror") != null && AbstractCalculate.this._ctx.getCalculateService().getErrorMsg().containsKey(ex.getUUID())) {
                                f.setExceptionMsg(AbstractCalculate.this._ctx.getCalculateService().getErrorMsg().get(ex.getUUID()));
                            }
                            if (re instanceof BigDecimal) {
                                sb.append(((BigDecimal)re).toPlainString());
                            } else if (re instanceof String) {
                                sb.append('\"').append(re).append('\"');
                            } else {
                                sb.append(re);
                            }
                        }
                    }
                }
            });
            if (f.hasException() || p.getErrorMsg() != null) {
                return;
            }
            try {
                p.fixParam(ExcelFormulaPaserHelper.parse((String)buffer.toString()));
            }
            catch (Exception e) {
                f.setException(e);
            }
        }
    }

    protected Object getRefValue(String uuid, ParamItem p) {
        String param = p.getParam().toString();
        if (param.contains("$")) {
            param = param.replace("$", "");
        }
        if (this.isExistOnNestDataProvider(uuid)) {
            return this._ctx.getNestDataProvider().get(uuid);
        }
        if (this.isExistOnNestDataProvider(param)) {
            return this._ctx.getNestDataProvider().get(param);
        }
        if (this.isExistOnExternalDataProvider(uuid)) {
            return this._ctx.getExternalDataProvider().get(uuid);
        }
        if (this.isExistOnExternalDataProvider(param)) {
            return this._ctx.getExternalDataProvider().get(param);
        }
        throw new RuntimeException(String.format("not fount relation param[%s] value in NestDataProvider.", param));
    }

    private boolean isExistOnNestDataProvider(String uuid) {
        return this._ctx.getNestDataProvider() != null && this._ctx.getNestDataProvider().containsKey(uuid);
    }

    private boolean isExistOnExternalDataProvider(String uuid) {
        return this._ctx.getExternalDataProvider() != null && this._ctx.getExternalDataProvider().containsKey(uuid);
    }

    protected abstract void execCalculate(List<T> var1);

    protected abstract void initFormula();

    protected FelCalculateEngine getFelEngine() {
        if (this.engine == null) {
            this.engine = FelCalculateEngine.engine(name -> {
                if ("rptignorerror".equalsIgnoreCase(name)) {
                    return this._ctx.getProperty("rptignorerror") != null ? new Value(true) : null;
                }
                return new Value(this.getRefValue(name, new ParamItem(name)));
            });
        }
        return this.engine;
    }
}

