/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.formula.calculate.CollectCalculate;
import kd.fi.bcm.business.formula.calculate.FelCalculateEngine;
import kd.fi.bcm.business.formula.calculate.ICalculateHandle;
import kd.fi.bcm.business.formula.calculate.IExternalDataProvider;
import kd.fi.bcm.business.formula.calculate.NestDataProvider;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.refrence.CalcQueue;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.factory.FormulaCalculateFactory;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.excelformula.ReferenceFormula;
import kd.fi.bcm.business.formula.model.value.NotExistValue;
import kd.fi.bcm.business.formula.model.value.Value;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.NameExpr;
import kd.fi.bcm.spread.formula.expr.OperationExpr;
import kd.fi.bcm.spread.formula.expr.OperationType;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import kd.fi.bcm.spread.util.CollectCalculateHelp;

public class CalculateService {
    private ICalContext _ctx;
    private FormulaPoolManager poolMng;
    private static ExpressParser parser = new ExpressParser();
    private EncoderService coder;
    private final Map<String, Object> resultMap;
    private final Map<String, String> errorMsg;
    private final Map<String, String> logMsg;
    private final Map<String, String> tipLogMsg;
    private FelCalculateEngine engine;
    private Map<String, IFormula> uuid2FormalaMap;
    private Map<ExpressStatus, CalcQueue> calcQueuePool = new HashMap<ExpressStatus, CalcQueue>();
    private final NotExistValue notExistValue = new NotExistValue(null);
    private final Value trueValue = new Value(true);
    private WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());
    private boolean ignoreError;
    private boolean openTrace;
    private Multimap<ExpressStatus, IFormula> traceMap = HashMultimap.create();
    protected static Set<String> batchSupportFormulas = new HashSet<String>(16);
    private boolean isLog = Boolean.TRUE;
    private boolean isCollectChildParseExpr = Boolean.FALSE;

    public CalculateService(ICalContext ctx) {
        this();
        this._ctx = ctx;
        if (this._ctx != null) {
            this._ctx.setProperty("calculateService", this);
            if (this._ctx.getNestDataProvider() == null) {
                this._ctx.setNestDataProvider(new NestDataProvider(this));
            }
        }
    }

    public CalculateService() {
        this.poolMng = new FormulaPoolManager();
        this.coder = new EncoderService();
        this.resultMap = new HashMap<String, Object>();
        this.errorMsg = new HashMap<String, String>(16);
        batchSupportFormulas = DataCollectUtil.getCanBatchFormulaNums();
        this.logMsg = new HashMap<String, String>(16);
        this.tipLogMsg = new HashMap<String, String>(16);
        this.engine = FelCalculateEngine.engine(name -> {
            if (name.equalsIgnoreCase("rptignorerror")) {
                return this._ctx.getProperty("rptignorerror") != null ? this.trueValue : null;
            }
            if (this.resultMap.containsKey(name)) {
                return new Value(this.transVal(this.resultMap.get(name)));
            }
            if (this._ctx != null && this._ctx.getExternalDataProvider() != null && this._ctx.getExternalDataProvider().get(name) != null) {
                return new Value(this._ctx.getExternalDataProvider().get(name));
            }
            return this.notExistValue;
        });
    }

    public Object transVal(Object v) {
        if (v instanceof CalcQueue) {
            return ((CalcQueue)CalcQueue.class.cast(v)).getValue();
        }
        return v;
    }

    public FelCalculateEngine getCalculateEngine() {
        return this.engine;
    }

    public ExpressStatus addCalculateExpress(String express) {
        return this.addCalculateExpress4Book(express, null);
    }

    public ExpressStatus addCalculateExpress4Book(String express, String cellReference) {
        return this.addCalculateExpress4Book(express, cellReference, true);
    }

    public ExpressStatus addCalculateExpress4Book(String express, String cellReference, boolean isRealCellReference) {
        try {
            Pair<String, List<IFormula>> pair = parser.parse(express, this.coder);
            this.poolMng.push((List)pair.p2);
            ExpressStatus es = new ExpressStatus((String)pair.p1);
            CalcQueue cq = new CalcQueue(es, (List)pair.p2, this._ctx);
            if (!((List)pair.p2).isEmpty()) {
                this.calcQueuePool.put(es, cq);
                this.setChildParseExpr(pair, es);
            } else {
                cq.setHasCalc(true);
            }
            if (isRealCellReference) {
                this.resultMap.put(cellReference, cq);
            }
            ((List)pair.p2).forEach(f -> {
                f.setCellReference(cellReference);
                if (this._ctx.getFormulaHandle() != null) {
                    this._ctx.getFormulaHandle().handle((IFormula)f);
                }
            });
            if (this.openTrace) {
                this.traceMap.putAll((Object)es, (Iterable)pair.p2);
                es.setFormula(express);
            }
            return es;
        }
        catch (Exception e) {
            this.log.error("formula parse error", (Throwable)e);
            return new ExpressStatus(express, e);
        }
    }

    private void setChildParseExpr(Pair<String, List<IFormula>> pair, ExpressStatus es) {
        es.setChildParseExpr(((List)pair.p2).stream().filter(e -> (batchSupportFormulas.contains(e.getName().toLowerCase(Locale.ENGLISH)) || CollectCalculateHelp.batchSupportFormulas4bcm.contains(e.getName().toLowerCase(Locale.ENGLISH))) && e.toString().indexOf("@") != -1 || this.isCollectChildParseExpr).map(e -> e.getUUID()).collect(Collectors.toList()));
    }

    public Map<String, String> getFormulaOldString2UUID() {
        HashMap<String, String> oldString2UUID = new HashMap<String, String>();
        this.poolMng.forEach(e -> ((List)e.getValue()).forEach(f -> oldString2UUID.put(f.toString(), f.getUUID())));
        return oldString2UUID;
    }

    public void batchCalculate() {
        if (this.isLog()) {
            this.log.startWatch();
        }
        int calcTotal = 0;
        FormulaPoolManager singleCalPool = new FormulaPoolManager();
        ArrayList<CalcQueue> finishCalcQueue = new ArrayList<CalcQueue>();
        boolean isCycleRefrenceCalc = false;
        while (!this.calcQueuePool.isEmpty()) {
            Iterator<Map.Entry<ExpressStatus, CalcQueue>> it = this.calcQueuePool.entrySet().iterator();
            CalcQueue cq = null;
            List<IFormula> fq = null;
            singleCalPool.clear();
            finishCalcQueue.clear();
            while (it.hasNext()) {
                Map.Entry<ExpressStatus, CalcQueue> entry = it.next();
                cq = entry.getValue();
                if (cq != null && (fq = cq.getNextCalcFormulas()) != null) {
                    singleCalPool.push(fq);
                }
                if (cq == null || cq.getCurrentCalcLevel() != -1) continue;
                it.remove();
                finishCalcQueue.add(cq);
            }
            calcTotal += this.builtinBatchCalculate(singleCalPool);
            finishCalcQueue.forEach(q -> q.setHasCalc(true));
            if (!singleCalPool.isEmpty()) continue;
            isCycleRefrenceCalc = true;
            break;
        }
        if (isCycleRefrenceCalc && !this.calcQueuePool.isEmpty()) {
            Exception cycleException = new Exception(ResManager.loadKDString((String)"\u516c\u5f0f\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"CalculateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            this.calcQueuePool.values().forEach(c -> c.setCycleRefrenceCalcException(cycleException));
        }
        if (this.isLog()) {
            this.log.infoEnd(String.format("\u8ba1\u7b97[%d]\u4e2a\u516c\u5f0f\u603b\u8017\u65f6-->", calcTotal));
        }
    }

    public void batchCalculate(boolean isBatch) {
        if (isBatch) {
            this.batchCalculate();
            return;
        }
        this.setLog(false);
        this.log.startWatch();
        int calcTotal = 0;
        FormulaPoolManager singleCalPool = new FormulaPoolManager();
        ArrayList<CalcQueue> finishCalcQueue = new ArrayList<CalcQueue>();
        boolean isCycleRefrenceCalc = false;
        while (!this.calcQueuePool.isEmpty()) {
            Iterator<Map.Entry<ExpressStatus, CalcQueue>> it = this.calcQueuePool.entrySet().iterator();
            CalcQueue cq = null;
            List<IFormula> fq = null;
            while (it.hasNext()) {
                singleCalPool.clear();
                finishCalcQueue.clear();
                Map.Entry<ExpressStatus, CalcQueue> entry = it.next();
                cq = entry.getValue();
                if (cq != null && (fq = cq.getNextCalcFormulas()) != null) {
                    singleCalPool.push(fq);
                }
                if (cq != null && cq.getCurrentCalcLevel() == -1) {
                    it.remove();
                    finishCalcQueue.add(cq);
                }
                calcTotal += this.builtinBatchCalculate(singleCalPool);
                finishCalcQueue.forEach(q -> q.setHasCalc(true));
            }
            if (!singleCalPool.isEmpty()) continue;
            isCycleRefrenceCalc = true;
            break;
        }
        if (isCycleRefrenceCalc && !this.calcQueuePool.isEmpty()) {
            Exception cycleException = new Exception(ResManager.loadKDString((String)"\u516c\u5f0f\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"CalculateService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            this.calcQueuePool.values().forEach(c -> c.setCycleRefrenceCalcException(cycleException));
        }
        this.log.infoEnd(String.format("\u5b8c\u6210\u8ba1\u7b97[%d]\u4e2a\u516c\u5f0f", calcTotal));
    }

    protected Map<ExpressStatus, CalcQueue> getCalcQueuePool() {
        return this.calcQueuePool;
    }

    protected int builtinBatchCalculate(FormulaPoolManager poolMng) {
        Recorder subtotal = new Recorder((Object)0);
        poolMng.forEach(e -> {
            if (this.isLog()) {
                this.log.startWatch();
            }
            Object calculate = this.getCalculateHandle((String)e.getKey());
            calculate.initEvn(this._ctx, (List)e.getValue());
            calculate.calculate();
            subtotal.setRecord((Object)((Integer)subtotal.getRecord() + ((List)e.getValue()).size()));
            if (this.isLog()) {
                this.log.info(String.format("[%d]\u4e2a[%s]\u516c\u5f0f\u8ba1\u7b97\u8017\u65f6-->", ((List)e.getValue()).size(), e.getKey()));
            }
        });
        this.toMapResult(poolMng);
        return (Integer)subtotal.getRecord();
    }

    private <T extends ICalculateHandle<?>> T getCalculateHandle(String formulaName) {
        Boolean isCalcSingleCollect = (Boolean)this._ctx.getProperty("is_calc_collect_single");
        if (isCalcSingleCollect != null && isCalcSingleCollect.booleanValue() && (batchSupportFormulas.contains(formulaName.toLowerCase(Locale.ENGLISH)) || CollectCalculateHelp.batchSupportFormulas4bcm.contains(formulaName.toLowerCase(Locale.ENGLISH)))) {
            try {
                return (T)((ICalculateHandle)CollectCalculate.class.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KDBizException(String.format("new instance class %s fail,cause:%s", CollectCalculate.class.getName(), e.getMessage()));
            }
        }
        return FormulaCalculateFactory.getCalculateHandle(formulaName);
    }

    public <T> T singleCalculate(String express) {
        ExpressStatus status = this.addCalculateExpress(express);
        this.batchCalculate();
        return this.evalExpress(status);
    }

    public <T> T evalExpress(ExpressStatus expr) {
        boolean isDis;
        ThreadCache.put((Object)"allnull", (Object)true);
        Exception v = expr.hasException() ? expr.getException() : this.engine.calculate(expr.getParseExpr());
        boolean isnull = ThreadCache.exists((Object)"allnull");
        ThreadCache.remove((Object)"allnull");
        if (v instanceof Exception) {
            return (T)v;
        }
        boolean bl = isDis = this._ctx.getProperty("isDistinguish0AndNull") != null && (Boolean)this._ctx.getProperty("isDistinguish0AndNull") != false;
        if (isDis && isnull) {
            return null;
        }
        return (T)v;
    }

    public String trans2EvalExpress(ExpressStatus status) {
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)status.getParseExpr());
            StringBuffer buffer = new StringBuffer();
            this.walk(buffer, expr, true);
            return buffer.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String trans2FormulaEexprss(ExpressStatus status) {
        this.initUUID2FormulaMap();
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)status.getParseExpr());
            StringBuffer buffer = new StringBuffer();
            this.walk(buffer, expr, false);
            return buffer.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void initUUID2FormulaMap() {
        if (this.uuid2FormalaMap == null) {
            this.uuid2FormalaMap = new HashMap<String, IFormula>();
            this.poolMng.iterator().forEachRemaining(e -> ((List)e.getValue()).forEach(f -> this.uuid2FormalaMap.put(f.getUUID(), (IFormula)f)));
        }
    }

    public String trans2FormulaEexprssByHandler(ExpressStatus status) {
        if (this.uuid2FormalaMap == null) {
            this.uuid2FormalaMap = new HashMap<String, IFormula>();
            this.poolMng.iterator().forEachRemaining(e -> ((List)e.getValue()).forEach(f -> {
                if (this._ctx.getDefaultParamHandle() != null) {
                    this._ctx.getDefaultParamHandle().handle((IFormula)f);
                }
                if (f instanceof ReferenceFormula) {
                    this.uuid2FormalaMap.put(f.getUUID(), ((ReferenceFormula)f).clone(true));
                } else {
                    this.uuid2FormalaMap.put(f.getUUID(), (IFormula)f);
                }
            }));
        }
        return this.trans2FormulaEexprss(status);
    }

    private void walk(StringBuffer buffer, Expression expr, boolean isOutVal) {
        if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr boexpr = (BinaryOperationExpr)expr;
            boolean isLowPriority = this.isLowPriorityOprt((OperationExpr)boexpr);
            if (boexpr.getLeft() instanceof OperationExpr) {
                this.packOperationExprWalk(buffer, (OperationExpr)boexpr.getLeft(), isOutVal, isLowPriority);
            } else {
                this.walk(buffer, boexpr.getLeft(), isOutVal);
            }
            buffer.append(boexpr.getOperation());
            if (boexpr.getRight() instanceof OperationExpr) {
                isLowPriority = OperationType.comparePRI((int)boexpr.getOperationType(), (int)((OperationExpr)boexpr.getRight()).getOperationType()) < 0 || OperationType.comparePRI((int)boexpr.getOperationType(), (int)((OperationExpr)boexpr.getRight()).getOperationType()) == 0 && boexpr.getOperationType() < ((OperationExpr)boexpr.getRight()).getOperationType();
                this.packOperationExprWalk(buffer, (OperationExpr)boexpr.getRight(), isOutVal, isLowPriority);
            } else {
                this.walk(buffer, boexpr.getRight(), isOutVal);
            }
        } else if (expr instanceof NameExpr) {
            if (isOutVal) {
                buffer.append(this.resultMap.get(expr.toString()) == null ? "0" : this.transVal(this.resultMap.get(expr.toString())));
            } else {
                buffer.append(this.uuid2FormalaMap.get(expr.toString()));
            }
        } else if (expr instanceof UnaryOperationExpr) {
            buffer.append(((UnaryOperationExpr)expr).getOperation());
            buffer.append('(');
            this.walk(buffer, ((UnaryOperationExpr)expr).getOperand(), isOutVal);
            buffer.append(')');
        } else {
            expr.output(buffer);
        }
    }

    private void packOperationExprWalk(StringBuffer buffer, OperationExpr boexpr, boolean isOutVal, boolean isLowPriorityOnSuperior) {
        boolean isLowPriority;
        boolean bl = isLowPriority = this.isLowPriorityOprt(boexpr) && !isLowPriorityOnSuperior;
        if (!isLowPriority && boexpr instanceof BinaryOperationExpr && ThreadCache.get((Object)"calculateSpreadManagerFormulas") == null) {
            boolean bl2 = isLowPriority = !this.isLowPriorityOprt(boexpr) == !isLowPriorityOnSuperior;
        }
        if (isLowPriority) {
            buffer.append('(');
        }
        this.walk(buffer, (Expression)boexpr, isOutVal);
        if (isLowPriority) {
            buffer.append(')');
        }
    }

    private boolean isLowPriorityOprt(OperationExpr oprt) {
        return !oprt.getOperation().equals("/") && !oprt.getOperation().equals("*");
    }

    private void toMapResult(FormulaPoolManager poolMng) {
        poolMng.forEach(e -> ((List)e.getValue()).forEach(f -> {
            this.resultMap.put(f.getUUID(), f.getValue());
            if (f.getExceptionMsg() != null) {
                this.errorMsg.put(f.getUUID(), f.getExceptionMsg());
            }
            if (f.getLogMsg() != null) {
                this.logMsg.put(f.getUUID(), f.getLogMsg());
            }
            if (f.getTipLogMsg() != null) {
                this.tipLogMsg.put(f.getUUID(), f.getTipLogMsg());
            }
        }));
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public ICalContext get_ctx() {
        return this._ctx;
    }

    public void resetCalcCtx(ICalContext newCtx) {
        this.clear();
        this._ctx = newCtx;
        if (this._ctx != null && this._ctx.getProperty("calculateService") == null) {
            this._ctx.setProperty("calculateService", this);
        }
    }

    public void clear() {
        this.poolMng.clear();
        this.coder.reset();
        this.resultMap.clear();
        this.calcQueuePool.clear();
        this.errorMsg.clear();
        this.tipLogMsg.clear();
        if (this.uuid2FormalaMap != null) {
            this.uuid2FormalaMap.clear();
        }
    }

    public FormulaPoolManager getPoolMng() {
        return this.poolMng;
    }

    public static void main(String[] args) {
        CalculateService.testCellRefNestFormulaCalc();
    }

    protected static void normalFormulaCalc() {
        CalContext ctx = new CalContext("CUBEweiy0314581578804632254464", "013", "FY2018", "M_M10", "Actual", "CNY");
        ctx.setProperty("BP", "IRpt");
        CalculateService service = new CalculateService(ctx);
        service.resultMap.put("A", 1);
        service.resultMap.put("B", 2);
        service.resultMap.put("C", 3);
        service.resultMap.put("D", 4);
        service.resultMap.put("E", 5);
        String express = "(-(V(V(\"A.R3011\"),\"FY.FY2099\",V(\"A.R3012\",V(\"A.R3013\")),\"AT.EntityInput\",\"CT.YTD\",\"IC.ICNone\")+V(\"A.R3012\",\"FY.FY2018\",\"P.M_M10\",\"AT.EntityInput\",\"CT.YTD\",\"IC.ICNone\")))*V(\"A.R3013\",\"FY.FY2018\",\"P.M_M10\",\"AT.EntityInput\",\"CT.YTD\",\"IC.ICNone\")/V(\"A.R3014\",\"FY.FY2018\",\"P.M_M10\",\"AT.EntityInput\",\"CT.YTD\",\"IC.ICNone\")";
        express = "IF(and(or(8+0.5>=9,10>20),11>9),50,if(2<3,3,2))";
        express = "IF(and(or(abs(-1-0.5)>=-1,10>20),11>9),50,60)";
        express = "aBs(-8-abs(0.5-3))>11";
        express = "IF(and(or(abs(-1-0.5)>=-1,10>20),11>9),\"true\",60)";
        express = "IF(10=10,40,66)";
        express = "IF(and(or(8+0.5>=9,10>20),11>9),50,if(2>3,3,2))";
        express = "IF(and(or(abs(-1-0.5)>=-1,10>20),11>9),2>1,60)";
        express = "if(1>-1,  1>=0,false) ";
        ExpressStatus status = service.addCalculateExpress(express);
        service.batchCalculate();
        String evalExpress = service.trans2EvalExpress(status);
    }

    protected static void testCellRefNestFormulaCalc() {
        CalContext ctx = new CalContext();
        final HashMap<String, Integer> externalValues = new HashMap<String, Integer>();
        externalValues.put("B1", 100);
        externalValues.put("B2", 200);
        externalValues.put("B3", 300);
        ctx.setExternalDataProvider(new IExternalDataProvider(){

            @Override
            public Object get(String key) {
                return externalValues.get(key);
            }

            @Override
            public boolean containsKey(String key) {
                return externalValues.containsKey(key);
            }
        });
        CalculateService service = new CalculateService(ctx);
        service.addCalculateExpress4Book("100*50%", "A5");
        service.batchCalculate();
        StringBuilder sb = new StringBuilder();
        service.resultMap.entrySet().forEach(v -> sb.append(String.format("%s->%s\n", v.getKey(), v.getValue() instanceof CalcQueue ? ((CalcQueue)CalcQueue.class.cast(v.getValue())).getValue() : v.getValue())));
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public Map<String, String> getErrorMsg() {
        return this.errorMsg;
    }

    public Map<String, String> getLogMsg() {
        return this.logMsg;
    }

    public Map<String, String> getTipLogMsg() {
        return this.tipLogMsg;
    }

    public void setOpenTrace(boolean openTrace) {
        this.openTrace = openTrace;
    }

    public DataTraceFrom getFormulaForTrace(ExpressStatus status) {
        if (this.openTrace) {
            if (this.evalExpress(status) instanceof Exception) {
                return null;
            }
            DataTraceFrom dc = new DataTraceFrom();
            Object v = this.evalExpress(status);
            dc.setM(v == null ? null : v.toString());
            dc.setD(status.getFormula());
            ArrayList<DataTraceFromItem> ld = new ArrayList<DataTraceFromItem>();
            dc.setDf(ld);
            AtomicInteger i = new AtomicInteger();
            this.traceMap.get((Object)status).forEach(f -> {
                DataTraceFromItem dci = new DataTraceFromItem();
                dci.setS(i.getAndIncrement());
                dci.setD(f.toString());
                dci.setV(f.getValue() != null ? f.getValue().toString() : null);
                ld.add(dci);
            });
            return dc;
        }
        return null;
    }

    public DataTraceFrom getCollectFormulaForTrace(ExpressStatus status, List<String> rowcols, List<String> rowcolMemNum, Pair<Map<String, List<String>>, List<String>> formulaGlDims, Map<String, String> glDimToBcmDim, HashMultimap<String, String> glDimBcmMem2GlMems, boolean isIntegrate, Table<String, String, String> param2BcmDim) {
        if (this.openTrace) {
            if (this.evalExpress(status) instanceof Exception) {
                return null;
            }
            DataTraceFrom dc = new DataTraceFrom();
            Object v = this.evalExpress(status);
            dc.setM(v == null ? null : v.toString());
            Map<String, String> acctParamMap = CalculateService.getAcctParamMap(rowcols, rowcolMemNum, formulaGlDims, glDimToBcmDim, glDimBcmMem2GlMems, isIntegrate);
            String formula = status.getFormula();
            Table<String, String, String> floatParam2mem = CalculateService.getFloatParam2mem(rowcols, rowcolMemNum, (Map)formulaGlDims.p1, param2BcmDim, isIntegrate);
            formula = CalculateService.replaceAcctParamFormula(acctParamMap, formula);
            formula = CalculateService.replceFloatParam(formula, floatParam2mem);
            dc.setD(formula);
            ArrayList<DataTraceFromItem> ld = new ArrayList<DataTraceFromItem>();
            dc.setDf(ld);
            AtomicInteger i = new AtomicInteger();
            this.traceMap.get((Object)status).forEach(f -> {
                DataTraceFromItem dci = new DataTraceFromItem();
                dci.setS(i.getAndIncrement());
                String formulastr = f.toString();
                if (formulastr.contains("@")) {
                    formulastr = CalculateService.replaceAcctParamFormula(acctParamMap, formulastr);
                }
                if (formulastr.contains("@")) {
                    formulastr = CalculateService.replceFloatParam(formulastr, floatParam2mem);
                }
                dci.setD(formulastr);
                dci.setV(f.getValue() != null ? f.getValue().toString() : null);
                ld.add(dci);
            });
            return dc;
        }
        return null;
    }

    private static String replceFloatParam(String formula, Table<String, String, String> floatParam2mem) {
        if (!floatParam2mem.isEmpty()) {
            Map<String, List<String>> formulaParamMap = FormulaConfig.getInstance().getFormulaParamMap();
            Expression expression = AnalysisFormulaUtil.parseExpression(formula);
            AnalysisFormulaUtil.handleExpression(expression, e -> {
                FunctionExpr functionExpr = (FunctionExpr)e;
                String funcionName = functionExpr.getFuncionName().toLowerCase();
                List paramLists = (List)formulaParamMap.get(funcionName);
                if (DataCollectUtil.getCanBatchFormulaNums().contains(funcionName) && functionExpr.toString().contains("@")) {
                    for (int i = 0; i < functionExpr.getParameters().size(); ++i) {
                        Object param = functionExpr.getParameters().get(i);
                        if (!param.toString().contains("@")) continue;
                        String mem = (String)floatParam2mem.get((Object)funcionName, paramLists.get(i));
                        StringExpr stringExpr = new StringExpr(mem);
                        functionExpr.getParameters().set(i, stringExpr);
                    }
                }
            });
            formula = expression.toString();
        }
        return formula;
    }

    private static Map<String, String> getAcctParamMap(List<String> rowcols, List<String> rowcolMemNum, Pair<Map<String, List<String>>, List<String>> formulaGlDims, Map<String, String> glDimToBcmDim, HashMultimap<String, String> glDimBcmMem2GlMems, boolean isIntegrate) {
        HashMap<String, String> floatParamMap = new HashMap<String, String>(5);
        for (int i = 0; i < ((List)formulaGlDims.p2).size(); ++i) {
            String glDim = (String)((List)formulaGlDims.p2).get(i);
            String bcmDim = glDimToBcmDim.get(glDim);
            Set glMemSet = glDimBcmMem2GlMems.get((Object)(glDim + "_-" + rowcolMemNum.get(rowcols.indexOf(bcmDim))));
            int size = glMemSet.size();
            StringBuilder sb = new StringBuilder();
            sb.append(glDim).append("|");
            if (isIntegrate && size > 1) {
                sb.append("@");
            } else {
                int index = 0;
                for (String mem : glMemSet) {
                    sb.append(mem);
                    if (size == ++index) continue;
                    sb.append(",");
                }
            }
            floatParamMap.put((String)((List)formulaGlDims.p2).get(i) + "|@", sb.toString());
        }
        return floatParamMap;
    }

    private static Table<String, String, String> getFloatParam2mem(List<String> rowcols, List<String> rowcolMemNum, Map<String, List<String>> formula2floatParam, Table<String, String, String> param2BcmDim, boolean isIntegrate) {
        HashBasedTable table = HashBasedTable.create();
        if (param2BcmDim == null || param2BcmDim.isEmpty()) {
            return table;
        }
        for (Map.Entry<String, List<String>> formula2param : formula2floatParam.entrySet()) {
            String formula = formula2param.getKey();
            List<String> params = formula2param.getValue();
            for (String param : params) {
                String bcmDim = (String)param2BcmDim.get((Object)formula, (Object)param);
                table.put((Object)formula, (Object)param, (Object)rowcolMemNum.get(rowcols.indexOf(bcmDim)));
            }
        }
        return table;
    }

    private static String replaceAcctParamFormula(Map<String, String> floatParamMap, String formula) {
        for (Map.Entry<String, String> entry : floatParamMap.entrySet()) {
            formula = formula.replace("|" + entry.getKey(), "|" + entry.getValue());
        }
        return formula;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public void setLog(boolean log) {
        this.isLog = log;
    }

    public boolean isCollectChildParseExpr() {
        return this.isCollectChildParseExpr;
    }

    public void setCollectChildParseExpr(boolean collectChildParseExpr) {
        this.isCollectChildParseExpr = collectChildParseExpr;
    }
}

