/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.calculate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.exception.KDException;
import kd.fi.bcm.business.formula.calculate.AbstractCalculate;
import kd.fi.bcm.business.formula.factory.FormulaCalculateFactory;
import kd.fi.bcm.business.formula.model.Formula;
import kd.fi.bcm.business.formula.model.IFormula;

public class CollectCalculate
extends AbstractCalculate<Formula> {
    @Override
    protected void execCalculate(List<Formula> formulas) {
        if (this._ctx.getCollectResultHandle() != null) {
            ArrayList<IFormula> formulaList = new ArrayList<IFormula>(16);
            for (Formula formula : formulas) {
                if (formula.toString().indexOf("@") != -1) {
                    this._ctx.getCollectResultHandle().handle(formula, this._ctx);
                    continue;
                }
                formulaList.add(formula);
            }
            if (!formulaList.isEmpty()) {
                Predicate checkFormulaHandle = this._ctx.getCheckFormulaHandle();
                if (checkFormulaHandle != null) {
                    Iterator iterator = formulaList.iterator();
                    while (iterator.hasNext()) {
                        IFormula formula = (IFormula)iterator.next();
                        if (!checkFormulaHandle.test(formula)) continue;
                        iterator.remove();
                    }
                }
                if (formulaList.isEmpty()) {
                    return;
                }
                IFormula calculateHandle = FormulaCalculateFactory.getCalculateHandle(((IFormula)formulaList.get(0)).getName());
                calculateHandle.initEvn(this._ctx, formulaList);
                calculateHandle.calculate();
                if (this._ctx.getCollectStableResultHandle() != null) {
                    this._ctx.getCollectStableResultHandle().handle(formulaList);
                }
            }
            return;
        }
        throw new KDException("please provide CollectResultHandle implement.");
    }

    @Override
    protected void initFormula() {
    }
}

